-- MySQL dump 10.13  Distrib 5.7.42, for Linux (x86_64)
--
-- Host: 127.0.0.1    Database: alislamiah_stocky5
-- ------------------------------------------------------
-- Server version	5.7.42-cll-lve

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `accounts`
--

DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_num` varchar(192) NOT NULL,
  `account_name` varchar(192) NOT NULL,
  `initial_balance` double NOT NULL,
  `balance` double NOT NULL,
  `note` text,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adjustment_details`
--

DROP TABLE IF EXISTS `adjustment_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `adjustment_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `adjustment_id` int(11) NOT NULL,
  `product_variant_id` int(11) DEFAULT NULL,
  `quantity` double NOT NULL,
  `type` varchar(192) NOT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `adjust_product_id` (`product_id`),
  KEY `adjust_adjustment_id` (`adjustment_id`),
  KEY `adjust_product_variant` (`product_variant_id`),
  CONSTRAINT `adjust_adjustment_id` FOREIGN KEY (`adjustment_id`) REFERENCES `adjustments` (`id`),
  CONSTRAINT `adjust_product_id` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`),
  CONSTRAINT `adjust_product_variant` FOREIGN KEY (`product_variant_id`) REFERENCES `product_variants` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adjustment_details`
--

LOCK TABLES `adjustment_details` WRITE;
/*!40000 ALTER TABLE `adjustment_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `adjustment_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `adjustments`
--

DROP TABLE IF EXISTS `adjustments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `adjustments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `time` time DEFAULT NULL,
  `Ref` varchar(192) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `items` double DEFAULT '0',
  `notes` text,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id_adjustment` (`user_id`),
  KEY `warehouse_id_adjustment` (`warehouse_id`),
  CONSTRAINT `user_id_adjustment` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  CONSTRAINT `warehouse_id_adjustment` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `adjustments`
--

LOCK TABLES `adjustments` WRITE;
/*!40000 ALTER TABLE `adjustments` DISABLE KEYS */;
/*!40000 ALTER TABLE `adjustments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `attendances`
--

DROP TABLE IF EXISTS `attendances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `attendances` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `company_id` int(11) NOT NULL,
  `employee_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `clock_in` varchar(191) NOT NULL,
  `clock_in_ip` varchar(45) NOT NULL,
  `clock_out` varchar(191) NOT NULL,
  `clock_out_ip` varchar(191) NOT NULL,
  `clock_in_out` tinyint(1) NOT NULL,
  `depart_early` varchar(191) NOT NULL DEFAULT '00:00',
  `late_time` varchar(191) NOT NULL DEFAULT '00:00',
  `overtime` varchar(191) NOT NULL DEFAULT '00:00',
  `total_work` varchar(191) NOT NULL DEFAULT '00:00',
  `total_rest` varchar(191) NOT NULL DEFAULT '00:00',
  `status` varchar(191) NOT NULL DEFAULT 'present',
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `attendances_user_id` (`user_id`),
  KEY `attendances_company_id` (`company_id`),
  KEY `attendances_employee_id` (`employee_id`),
  CONSTRAINT `attendances_company_id` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`),
  CONSTRAINT `attendances_employee_id` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`),
  CONSTRAINT `attendances_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `attendances`
--

LOCK TABLES `attendances` WRITE;
/*!40000 ALTER TABLE `attendances` DISABLE KEYS */;
/*!40000 ALTER TABLE `attendances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `brands`
--

DROP TABLE IF EXISTS `brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `brands` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(192) NOT NULL,
  `description` varchar(192) DEFAULT NULL,
  `image` varchar(192) DEFAULT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `brands`
--

LOCK TABLES `brands` WRITE;
/*!40000 ALTER TABLE `brands` DISABLE KEYS */;
/*!40000 ALTER TABLE `brands` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(192) NOT NULL,
  `name` varchar(192) NOT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `clients`
--

DROP TABLE IF EXISTS `clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `clients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `code` int(11) NOT NULL,
  `email` varchar(191) DEFAULT NULL,
  `country` varchar(191) DEFAULT NULL,
  `city` varchar(191) DEFAULT NULL,
  `phone` varchar(191) DEFAULT NULL,
  `tax_number` varchar(192) DEFAULT NULL,
  `adresse` varchar(191) DEFAULT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `clients`
--

LOCK TABLES `clients` WRITE;
/*!40000 ALTER TABLE `clients` DISABLE KEYS */;
INSERT INTO `clients` VALUES (1,'walk-in-customer',1,'walk-in-customer@example.com','bangladesh','dhaka','123456780',NULL,'N45 , Dhaka',NULL,NULL,NULL);
/*!40000 ALTER TABLE `clients` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `combined_products`
--

DROP TABLE IF EXISTS `combined_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `combined_products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `combined_product_id` int(11) NOT NULL,
  `quantity` double NOT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `combined_products_product_id` (`product_id`),
  KEY `combined_products_combined_product_id` (`combined_product_id`),
  CONSTRAINT `combined_products_combined_product_id` FOREIGN KEY (`combined_product_id`) REFERENCES `products` (`id`),
  CONSTRAINT `combined_products_product_id` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `combined_products`
--

LOCK TABLES `combined_products` WRITE;
/*!40000 ALTER TABLE `combined_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `combined_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `companies`
--

DROP TABLE IF EXISTS `companies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `companies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `email` varchar(191) DEFAULT NULL,
  `phone` varchar(191) DEFAULT NULL,
  `country` varchar(191) DEFAULT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `companies`
--

LOCK TABLES `companies` WRITE;
/*!40000 ALTER TABLE `companies` DISABLE KEYS */;
/*!40000 ALTER TABLE `companies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `count_stock`
--

DROP TABLE IF EXISTS `count_stock`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `count_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `category_id` int(11) DEFAULT NULL,
  `file_stock` varchar(192) NOT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `count_stock_user_id` (`user_id`),
  KEY `count_stock_warehouse_id` (`warehouse_id`),
  KEY `count_stock_category_id` (`category_id`),
  CONSTRAINT `count_stock_category_id` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`),
  CONSTRAINT `count_stock_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  CONSTRAINT `count_stock_warehouse_id` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `count_stock`
--

LOCK TABLES `count_stock` WRITE;
/*!40000 ALTER TABLE `count_stock` DISABLE KEYS */;
/*!40000 ALTER TABLE `count_stock` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `currencies`
--

DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currencies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(192) NOT NULL,
  `name` varchar(192) NOT NULL,
  `symbol` varchar(192) NOT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `currencies`
--

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES (1,'BDT','BDT','৳',NULL,'2025-06-18 03:53:27.000000',NULL);
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `departments`
--

DROP TABLE IF EXISTS `departments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `departments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `department` varchar(191) NOT NULL,
  `company_id` int(11) NOT NULL,
  `department_head` int(11) DEFAULT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `department_company_id` (`company_id`),
  KEY `department_department_head` (`department_head`),
  CONSTRAINT `department_company_id` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`),
  CONSTRAINT `department_department_head` FOREIGN KEY (`department_head`) REFERENCES `employees` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `departments`
--

LOCK TABLES `departments` WRITE;
/*!40000 ALTER TABLE `departments` DISABLE KEYS */;
/*!40000 ALTER TABLE `departments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `deposit_categories`
--

DROP TABLE IF EXISTS `deposit_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `deposit_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(192) NOT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `deposit_categories`
--

LOCK TABLES `deposit_categories` WRITE;
/*!40000 ALTER TABLE `deposit_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `deposit_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `deposits`
--

DROP TABLE IF EXISTS `deposits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `deposits` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `deposit_ref` varchar(192) NOT NULL,
  `account_id` int(11) DEFAULT NULL,
  `deposit_category_id` int(11) NOT NULL,
  `amount` double NOT NULL,
  `description` text,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `deposit_user_id` (`user_id`),
  KEY `deposit_account_id` (`account_id`),
  KEY `deposit_category_id` (`deposit_category_id`),
  CONSTRAINT `deposit_account_id` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`),
  CONSTRAINT `deposit_category_id` FOREIGN KEY (`deposit_category_id`) REFERENCES `deposit_categories` (`id`),
  CONSTRAINT `deposit_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `deposits`
--

LOCK TABLES `deposits` WRITE;
/*!40000 ALTER TABLE `deposits` DISABLE KEYS */;
/*!40000 ALTER TABLE `deposits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `designations`
--

DROP TABLE IF EXISTS `designations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `designations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  `designation` varchar(192) NOT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `designation_company_id` (`company_id`),
  KEY `designation_departement_id` (`department_id`),
  CONSTRAINT `designation_company_id` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`),
  CONSTRAINT `designation_departement_id` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `designations`
--

LOCK TABLES `designations` WRITE;
/*!40000 ALTER TABLE `designations` DISABLE KEYS */;
/*!40000 ALTER TABLE `designations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `draft_sale_details`
--

DROP TABLE IF EXISTS `draft_sale_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `draft_sale_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `draft_sale_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_variant_id` int(11) DEFAULT NULL,
  `imei_number` text,
  `price` double NOT NULL,
  `sale_unit_id` int(11) DEFAULT NULL,
  `TaxNet` double DEFAULT NULL,
  `tax_method` varchar(192) DEFAULT '1',
  `discount` double DEFAULT NULL,
  `discount_method` varchar(192) DEFAULT '1',
  `total` double NOT NULL,
  `quantity` double NOT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `draft_sale_details_draft_sale_id` (`draft_sale_id`),
  KEY `draft_sale_details_product_id` (`product_id`),
  KEY `draft_sale_details_product_variant_id` (`product_variant_id`),
  KEY `draft_sale_details_sale_unit_id` (`sale_unit_id`),
  CONSTRAINT `draft_sale_details_draft_sale_id` FOREIGN KEY (`draft_sale_id`) REFERENCES `draft_sales` (`id`),
  CONSTRAINT `draft_sale_details_product_id` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`),
  CONSTRAINT `draft_sale_details_product_variant_id` FOREIGN KEY (`product_variant_id`) REFERENCES `product_variants` (`id`),
  CONSTRAINT `draft_sale_details_sale_unit_id` FOREIGN KEY (`sale_unit_id`) REFERENCES `units` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `draft_sale_details`
--

LOCK TABLES `draft_sale_details` WRITE;
/*!40000 ALTER TABLE `draft_sale_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `draft_sale_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `draft_sales`
--

DROP TABLE IF EXISTS `draft_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `draft_sales` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `Ref` varchar(192) NOT NULL,
  `client_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `tax_rate` double DEFAULT '0',
  `TaxNet` double DEFAULT '0',
  `discount` double DEFAULT '0',
  `shipping` double DEFAULT '0',
  `GrandTotal` double NOT NULL DEFAULT '0',
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `draft_sales_user_id` (`user_id`),
  KEY `draft_sales_client_id` (`client_id`),
  KEY `draft_sales_warehouse_id` (`warehouse_id`),
  CONSTRAINT `draft_sales_client_id` FOREIGN KEY (`client_id`) REFERENCES `clients` (`id`),
  CONSTRAINT `draft_sales_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  CONSTRAINT `draft_sales_warehouse_id` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `draft_sales`
--

LOCK TABLES `draft_sales` WRITE;
/*!40000 ALTER TABLE `draft_sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `draft_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ecommerce_clients`
--

DROP TABLE IF EXISTS `ecommerce_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ecommerce_clients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `username` varchar(192) NOT NULL,
  `email` varchar(192) NOT NULL,
  `email_verified_at` datetime DEFAULT NULL,
  `password` varchar(191) NOT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ecommerce_clients_client_id` (`client_id`),
  CONSTRAINT `ecommerce_clients_client_id` FOREIGN KEY (`client_id`) REFERENCES `clients` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ecommerce_clients`
--

LOCK TABLES `ecommerce_clients` WRITE;
/*!40000 ALTER TABLE `ecommerce_clients` DISABLE KEYS */;
/*!40000 ALTER TABLE `ecommerce_clients` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `email_messages`
--

DROP TABLE IF EXISTS `email_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `email_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text,
  `subject` text,
  `body` text,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `email_messages`
--

LOCK TABLES `email_messages` WRITE;
/*!40000 ALTER TABLE `email_messages` DISABLE KEYS */;
INSERT INTO `email_messages` VALUES (1,'sale','Thank you for your purchase!','<h1><b><span style=\'font-size:14px;\'>Dear</span><span style=\'font-size:14px;\'>  </span></b><span style=\'font-size:14px;\'><b>{contact_name},</b></span></h1><p><span style=\'font-size:14px;\'>Thank you for your purchase! Your invoice number is {invoice_number}.</span></p><p><span style=\'font-size:14px;\'>If you have any questions or concerns, please don\'t hesitate to reach out to us. We are here to help!</span></p><p><span style=\'font-size:14px;\'>Best regards,</span></p><p><b>{business_name}</b></p>',NULL,NULL,NULL),(2,'quotation','Thank you for your interest in our products !','<p><b><span style=\"font-size:14px;\">Dear {contact_name},</span></b></p><p>Thank you for your interest in our products. Your quotation number is {quotation_number}.</p><p>Please let us know if you have any questions or concerns regarding your quotation. We are here to assist you.</p><p>Best regards,</p><p><b><span style=\"font-size:14px;\">{business_name}</span></b></p>',NULL,NULL,NULL),(3,'payment_received','Payment Received - Thank You','<p><b><span style=\"font-size:14px;\">Dear {contact_name},</span></b></p><p>Thank you for making your payment. We have received it and it has been processed successfully.</p><p>If you have any further questions or concerns, please don\'t hesitate to reach out to us. We are always here to help.</p><p>Best regards,</p><p><b><span style=\"font-size:14px;\">{business_name}</span></b></p>',NULL,NULL,NULL),(4,'purchase','Thank You for Your Cooperation and Service','<p><b><span style=\"font-size:14px;\">Dear {contact_name},</span></b></p><p>I recently made a purchase from your company and I wanted to thank you for your cooperation and service. My invoice number is {invoice_number} .</p><p>If you have any questions or concerns regarding my purchase, please don\'t hesitate to contact me. I am here to make sure I have a positive experience with your company.</p><p>Best regards,</p><p><b><span style=\"font-size:14px;\">{business_name}</span></b></p>',NULL,NULL,NULL),(5,'payment_sent','Payment Sent - Thank You for Your Service','<p><b><span style=\"font-size:14px;\">Dear {contact_name},</span></b></p><p>We have just sent the payment . We appreciate your prompt attention to this matter and the high level of service you provide.</p><p>If you need any further information or clarification, please do not hesitate to reach out to us. We are here to help.</p><p>Best regards,</p><p><b><span style=\"font-size:14px;\">{business_name}</span></b></p>',NULL,NULL,NULL);
/*!40000 ALTER TABLE `email_messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `employee_accounts`
--

DROP TABLE IF EXISTS `employee_accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `employee_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` int(11) NOT NULL,
  `bank_name` varchar(192) NOT NULL,
  `bank_branch` varchar(192) NOT NULL,
  `account_no` varchar(192) NOT NULL,
  `note` text,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_accounts_employee_id` (`employee_id`),
  CONSTRAINT `employee_accounts_employee_id` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `employee_accounts`
--

LOCK TABLES `employee_accounts` WRITE;
/*!40000 ALTER TABLE `employee_accounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `employee_experiences`
--

DROP TABLE IF EXISTS `employee_experiences`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `employee_experiences` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` int(11) NOT NULL,
  `title` varchar(192) NOT NULL,
  `company_name` varchar(192) NOT NULL,
  `location` varchar(192) DEFAULT NULL,
  `employment_type` varchar(192) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `description` text,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_experience_employee_id` (`employee_id`),
  CONSTRAINT `employee_experience_employee_id` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `employee_experiences`
--

LOCK TABLES `employee_experiences` WRITE;
/*!40000 ALTER TABLE `employee_experiences` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_experiences` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `employee_project`
--

DROP TABLE IF EXISTS `employee_project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `employee_project` (
  `employee_id` int(11) NOT NULL,
  `project_id` int(11) NOT NULL,
  KEY `employee_project_employee_id` (`employee_id`),
  KEY `employee_project_project_id` (`project_id`),
  CONSTRAINT `employee_project_employee_id` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`),
  CONSTRAINT `employee_project_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `employee_project`
--

LOCK TABLES `employee_project` WRITE;
/*!40000 ALTER TABLE `employee_project` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `employee_task`
--

DROP TABLE IF EXISTS `employee_task`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `employee_task` (
  `employee_id` int(11) NOT NULL,
  `task_id` int(11) NOT NULL,
  KEY `employee_task_employee_id` (`employee_id`),
  KEY `employee_task_task_id` (`task_id`),
  CONSTRAINT `employee_task_employee_id` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`),
  CONSTRAINT `employee_task_task_id` FOREIGN KEY (`task_id`) REFERENCES `tasks` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `employee_task`
--

LOCK TABLES `employee_task` WRITE;
/*!40000 ALTER TABLE `employee_task` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_task` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `employees`
--

DROP TABLE IF EXISTS `employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `employees` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `firstname` varchar(192) NOT NULL,
  `lastname` varchar(192) NOT NULL,
  `username` varchar(191) NOT NULL,
  `email` varchar(192) DEFAULT NULL,
  `phone` varchar(192) DEFAULT NULL,
  `country` varchar(192) DEFAULT NULL,
  `city` varchar(192) DEFAULT NULL,
  `province` varchar(192) DEFAULT NULL,
  `zipcode` varchar(192) DEFAULT NULL,
  `address` varchar(192) DEFAULT NULL,
  `gender` varchar(192) NOT NULL,
  `resume` varchar(192) DEFAULT NULL,
  `avatar` varchar(192) DEFAULT 'no_avatar.png',
  `document` varchar(192) DEFAULT NULL,
  `birth_date` date DEFAULT NULL,
  `joining_date` date DEFAULT NULL,
  `company_id` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  `designation_id` int(11) NOT NULL,
  `office_shift_id` int(11) NOT NULL,
  `remaining_leave` tinyint(1) DEFAULT '0',
  `total_leave` tinyint(1) DEFAULT '0',
  `hourly_rate` decimal(10,2) DEFAULT '0.00',
  `basic_salary` decimal(10,2) DEFAULT '0.00',
  `employment_type` varchar(192) DEFAULT 'full_time',
  `leaving_date` date DEFAULT NULL,
  `marital_status` varchar(192) DEFAULT 'single',
  `facebook` varchar(192) DEFAULT NULL,
  `skype` varchar(192) DEFAULT NULL,
  `whatsapp` varchar(192) DEFAULT NULL,
  `twitter` varchar(192) DEFAULT NULL,
  `linkedin` varchar(192) DEFAULT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employees_company_id` (`company_id`),
  KEY `employees_department_id` (`department_id`),
  KEY `employees_designation_id` (`designation_id`),
  KEY `employees_office_shift_id` (`office_shift_id`),
  CONSTRAINT `employees_company_id` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`),
  CONSTRAINT `employees_department_id` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`),
  CONSTRAINT `employees_designation_id` FOREIGN KEY (`designation_id`) REFERENCES `designations` (`id`),
  CONSTRAINT `employees_office_shift_id` FOREIGN KEY (`office_shift_id`) REFERENCES `office_shifts` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `employees`
--

LOCK TABLES `employees` WRITE;
/*!40000 ALTER TABLE `employees` DISABLE KEYS */;
/*!40000 ALTER TABLE `employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `error_logs`
--

DROP TABLE IF EXISTS `error_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `error_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `context` varchar(191) DEFAULT NULL,
  `message` text NOT NULL,
  `details` longtext,
  `occurred_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `error_logs`
--

LOCK TABLES `error_logs` WRITE;
/*!40000 ALTER TABLE `error_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `error_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expense_categories`
--

DROP TABLE IF EXISTS `expense_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expense_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `name` varchar(192) NOT NULL,
  `description` text,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_category_user_id` (`user_id`),
  CONSTRAINT `expense_category_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expense_categories`
--

LOCK TABLES `expense_categories` WRITE;
/*!40000 ALTER TABLE `expense_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `expense_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `expenses`
--

DROP TABLE IF EXISTS `expenses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `Ref` varchar(192) NOT NULL,
  `user_id` int(11) NOT NULL,
  `expense_category_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `account_id` int(11) DEFAULT NULL,
  `details` varchar(192) NOT NULL,
  `amount` double NOT NULL,
  `payment_method_id` int(11) DEFAULT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_user_id` (`user_id`),
  KEY `expense_category_id` (`expense_category_id`),
  KEY `expense_warehouse_id` (`warehouse_id`),
  KEY `expense_account_id` (`account_id`),
  KEY `expenses_payment_method_id_foreign` (`payment_method_id`),
  CONSTRAINT `expense_account_id` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`),
  CONSTRAINT `expense_category_id` FOREIGN KEY (`expense_category_id`) REFERENCES `expense_categories` (`id`),
  CONSTRAINT `expense_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  CONSTRAINT `expense_warehouse_id` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`),
  CONSTRAINT `expenses_payment_method_id_foreign` FOREIGN KEY (`payment_method_id`) REFERENCES `payment_methods` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expenses`
--

LOCK TABLES `expenses` WRITE;
/*!40000 ALTER TABLE `expenses` DISABLE KEYS */;
/*!40000 ALTER TABLE `expenses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `holidays`
--

DROP TABLE IF EXISTS `holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `holidays` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(192) NOT NULL,
  `company_id` int(11) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `description` text,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `holidays_company_id` (`company_id`),
  CONSTRAINT `holidays_company_id` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `holidays`
--

LOCK TABLES `holidays` WRITE;
/*!40000 ALTER TABLE `holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `holidays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `locale` varchar(191) NOT NULL,
  `flag` varchar(191) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `languages_locale_unique` (`locale`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en','gb.svg',1,1,NULL,NULL),(2,'Français','fr','fr.svg',1,0,NULL,NULL),(3,'العربية','ar','sa.svg',1,0,NULL,NULL),(4,'Turkish','tur','tr.svg',1,0,NULL,NULL),(5,'Thaï','thai','th.svg',1,0,NULL,NULL),(6,'Hindi','hn','in.svg',1,0,NULL,NULL),(7,'German','de','de.svg',1,0,NULL,NULL),(8,'Spanish','es','es.svg',1,0,NULL,NULL),(9,'Italien','it','it.svg',1,0,NULL,NULL),(10,'Indonesian','Ind','id.svg',1,0,NULL,NULL),(11,'Simplified Chinese','sm_ch','cn.svg',1,0,NULL,NULL),(12,'Traditional Chinese','tr_ch','cn.svg',1,0,NULL,NULL),(13,'Russian','ru','ru.svg',1,0,NULL,NULL),(14,'Vietnamese','vn','vn.svg',1,0,NULL,NULL),(15,'Korean','kr','kr.svg',1,0,NULL,NULL),(16,'Bangla','ba','bd.svg',1,0,NULL,NULL),(17,'Portuguese','br','pt.svg',1,0,NULL,NULL),(18,'Danish','da','dk.svg',1,0,NULL,NULL),(19,'Japanese','ja','jp.svg',1,0,NULL,NULL),(20,'Polish','pl','pl.svg',1,0,NULL,NULL),(21,'Swahili','sw','ke.svg',1,0,NULL,NULL),(22,'Hausa','ha','ng.svg',1,0,NULL,NULL),(23,'Yoruba','yo','ng.svg',1,0,NULL,NULL),(24,'Amharic','am','et.svg',1,0,NULL,NULL);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `leave_types`
--

DROP TABLE IF EXISTS `leave_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `leave_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(192) NOT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `leave_types`
--

LOCK TABLES `leave_types` WRITE;
/*!40000 ALTER TABLE `leave_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `leave_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `leaves`
--

DROP TABLE IF EXISTS `leaves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `leaves` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` int(11) NOT NULL,
  `company_id` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  `leave_type_id` int(11) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `days` varchar(192) NOT NULL,
  `reason` text,
  `attachment` varchar(192) DEFAULT NULL,
  `half_day` tinyint(1) DEFAULT NULL,
  `status` varchar(192) NOT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `leave_employee_id` (`employee_id`),
  KEY `leave_company_id` (`company_id`),
  KEY `leave_department_id` (`department_id`),
  KEY `leave_leave_type_id` (`leave_type_id`),
  CONSTRAINT `leave_company_id` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`),
  CONSTRAINT `leave_department_id` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`),
  CONSTRAINT `leave_employee_id` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`),
  CONSTRAINT `leave_leave_type_id` FOREIGN KEY (`leave_type_id`) REFERENCES `leave_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `leaves`
--

LOCK TABLES `leaves` WRITE;
/*!40000 ALTER TABLE `leaves` DISABLE KEYS */;
/*!40000 ALTER TABLE `leaves` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=199 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2016_06_01_000001_create_oauth_auth_codes_table',1),(2,'2016_06_01_000002_create_oauth_access_tokens_table',1),(3,'2016_06_01_000003_create_oauth_refresh_tokens_table',1),(4,'2016_06_01_000004_create_oauth_clients_table',1),(5,'2016_06_01_000005_create_oauth_personal_access_clients_table',1),(6,'2021_03_08_020247_create_adjustment_details_table',1),(7,'2021_03_08_020247_create_adjustments_table',1),(8,'2021_03_08_020247_create_brands_table',1),(9,'2021_03_08_020247_create_categories_table',1),(10,'2021_03_08_020247_create_clients_table',1),(11,'2021_03_08_020247_create_currencies_table',1),(12,'2021_03_08_020247_create_expense_categories_table',1),(13,'2021_03_08_020247_create_expenses_table',1),(14,'2021_03_08_020247_create_password_resets_table',1),(15,'2021_03_08_020247_create_payment_purchase_returns_table',1),(16,'2021_03_08_020247_create_payment_purchases_table',1),(17,'2021_03_08_020247_create_payment_sale_returns_table',1),(18,'2021_03_08_020247_create_payment_sales_table',1),(19,'2021_03_08_020247_create_payment_with_credit_card_table',1),(20,'2021_03_08_020247_create_permission_role_table',1),(21,'2021_03_08_020247_create_permissions_table',1),(22,'2021_03_08_020247_create_product_variants_table',1),(23,'2021_03_08_020247_create_product_warehouse_table',1),(24,'2021_03_08_020247_create_products_table',1),(25,'2021_03_08_020247_create_providers_table',1),(26,'2021_03_08_020247_create_purchase_details_table',1),(27,'2021_03_08_020247_create_purchase_return_details_table',1),(28,'2021_03_08_020247_create_purchase_returns_table',1),(29,'2021_03_08_020247_create_purchases_table',1),(30,'2021_03_08_020247_create_quotation_details_table',1),(31,'2021_03_08_020247_create_quotations_table',1),(32,'2021_03_08_020247_create_role_user_table',1),(33,'2021_03_08_020247_create_roles_table',1),(34,'2021_03_08_020247_create_sale_details_table',1),(35,'2021_03_08_020247_create_sale_return_details_table',1),(36,'2021_03_08_020247_create_sale_returns_table',1),(37,'2021_03_08_020247_create_sales_table',1),(38,'2021_03_08_020247_create_serveurs_table',1),(39,'2021_03_08_020247_create_settings_table',1),(40,'2021_03_08_020247_create_transfer_details_table',1),(41,'2021_03_08_020247_create_transfers_table',1),(42,'2021_03_08_020247_create_units_table',1),(43,'2021_03_08_020247_create_users_table',1),(44,'2021_03_08_020247_create_warehouses_table',1),(45,'2021_03_08_020248_add_status_to_roles_table',1),(46,'2021_03_08_020251_add_foreign_keys_to_adjustment_details_table',1),(47,'2021_03_08_020251_add_foreign_keys_to_adjustments_table',1),(48,'2021_03_08_020251_add_foreign_keys_to_expense_categories_table',1),(49,'2021_03_08_020251_add_foreign_keys_to_expenses_table',1),(50,'2021_03_08_020251_add_foreign_keys_to_payment_purchase_returns_table',1),(51,'2021_03_08_020251_add_foreign_keys_to_payment_purchases_table',1),(52,'2021_03_08_020251_add_foreign_keys_to_payment_sale_returns_table',1),(53,'2021_03_08_020251_add_foreign_keys_to_payment_sales_table',1),(54,'2021_03_08_020251_add_foreign_keys_to_permission_role_table',1),(55,'2021_03_08_020251_add_foreign_keys_to_product_variants_table',1),(56,'2021_03_08_020251_add_foreign_keys_to_product_warehouse_table',1),(57,'2021_03_08_020251_add_foreign_keys_to_products_table',1),(58,'2021_03_08_020251_add_foreign_keys_to_purchase_details_table',1),(59,'2021_03_08_020251_add_foreign_keys_to_purchase_return_details_table',1),(60,'2021_03_08_020251_add_foreign_keys_to_purchase_returns_table',1),(61,'2021_03_08_020251_add_foreign_keys_to_purchases_table',1),(62,'2021_03_08_020251_add_foreign_keys_to_quotation_details_table',1),(63,'2021_03_08_020251_add_foreign_keys_to_quotations_table',1),(64,'2021_03_08_020251_add_foreign_keys_to_role_user_table',1),(65,'2021_03_08_020251_add_foreign_keys_to_sale_details_table',1),(66,'2021_03_08_020251_add_foreign_keys_to_sale_return_details_table',1),(67,'2021_03_08_020251_add_foreign_keys_to_sale_returns_table',1),(68,'2021_03_08_020251_add_foreign_keys_to_sales_table',1),(69,'2021_03_08_020251_add_foreign_keys_to_settings_table',1),(70,'2021_03_08_020251_add_foreign_keys_to_transfer_details_table',1),(71,'2021_03_08_020251_add_foreign_keys_to_transfers_table',1),(72,'2021_03_08_020251_add_foreign_keys_to_units_table',1),(73,'2021_04_11_221536_add_footer_to_settings_table',1),(74,'2021_04_30_040505_add_devopped_by_to_settings',1),(75,'2021_05_07_140933_add_client_id_to_settings_table',1),(76,'2021_05_07_141034_add_warehouse_id_to_settings_table',1),(77,'2021_05_07_141303_add_foreign_keys_clients_to_settings',1),(78,'2021_07_19_141906_add_sale_unit_id_to_sale_details',1),(79,'2021_07_22_013045_add_sale_unit_id_to_quotation_details_table',1),(80,'2021_07_22_032512_add_purchase_unit_id_to_purchase_details_table',1),(81,'2021_07_22_052330_add_sale_unit_id_to_sale_return_details_table',1),(82,'2021_07_22_052447_add_purchase_unit_id_to_purchase_return_details_table',1),(83,'2021_07_22_052713_add_purchase_unit_id_to_transfer_details_table',1),(84,'2021_07_26_155038_change_cost_column_type_return_details',1),(85,'2021_07_30_142441_add_change_to_payment_sales',1),(86,'2021_07_31_122946_add_change_to_payment_purchases_table',1),(87,'2021_07_31_123105_add_change_to_payment_sale_returns_table',1),(88,'2021_07_31_123135_add_change_to_payment_purchase_returns_table',1),(89,'2021_09_23_003640_add_default_language_to_settings_table',1),(90,'2021_09_24_000547_create_pos_settings',1),(91,'2022_02_18_161351_create_attendances_table',1),(92,'2022_02_18_161351_create_companies_table',1),(93,'2022_02_18_161351_create_departments_table',1),(94,'2022_02_18_161351_create_designations_table',1),(95,'2022_02_18_161351_create_employee_accounts_table',1),(96,'2022_02_18_161351_create_employee_experiences_table',1),(97,'2022_02_18_161351_create_employees_table',1),(98,'2022_02_18_161351_create_holidays_table',1),(99,'2022_02_18_161351_create_leave_types_table',1),(100,'2022_02_18_161351_create_leaves_table',1),(101,'2022_02_18_161351_create_office_shifts_table',1),(102,'2022_02_18_161355_add_foreign_keys_to_attendances_table',1),(103,'2022_02_18_161355_add_foreign_keys_to_departments_table',1),(104,'2022_02_18_161355_add_foreign_keys_to_designations_table',1),(105,'2022_02_18_161355_add_foreign_keys_to_employee_accounts_table',1),(106,'2022_02_18_161355_add_foreign_keys_to_employee_experiences_table',1),(107,'2022_02_18_161355_add_foreign_keys_to_employees_table',1),(108,'2022_02_18_161355_add_foreign_keys_to_holidays_table',1),(109,'2022_02_18_161355_add_foreign_keys_to_leaves_table',1),(110,'2022_02_18_161355_add_foreign_keys_to_office_shifts_table',1),(111,'2022_04_06_155633_create_user_warehouse_table',1),(112,'2022_04_06_155635_add_foreign_keys_to_user_warehouse_table',1),(113,'2022_04_08_001056_change_type_of_columns__clients__table',1),(114,'2022_04_08_002126_change_type_of_columns__providers__table',1),(115,'2022_04_26_163039_add_imei_to_product_table',1),(116,'2022_04_26_163314_add_imei_number_to_purchase_details',1),(117,'2022_04_26_163516_add_imei_number_to_quotation_details',1),(118,'2022_04_26_163600_add_imei_number_to_sale_details',1),(119,'2022_04_26_163653_add_imei_number_to_sale_return_details',1),(120,'2022_04_26_163741_add_imei_number_to_purchase_return_details',1),(121,'2022_05_01_005644_add_shipping_status_to_sales',1),(122,'2022_05_11_010241_add_is_all_warehouses_to_users',1),(123,'2022_05_14_191716_create_shipments_table',1),(124,'2022_05_14_191718_add_foreign_keys_to_shipments_table',1),(125,'2022_06_15_021609_create_sms_gateway_table',1),(126,'2022_06_15_023409_add_sms_gateway_to_settings',1),(127,'2022_06_18_145901_add_not_selling_to_product_table',1),(128,'2022_06_19_011630_add_sale_id_to_sale__return_table',1),(129,'2022_06_19_125137_add_sender_name_to_servers_table',1),(130,'2022_06_19_131645_add_purchase_id_to_purchase_return_table',1),(131,'2022_06_23_000019_add_invoice_footer_to_settings_table',1),(132,'2022_08_04_172721_add_tax_number_to_clients_table',1),(133,'2022_08_04_172905_add_tax_number_to_providers_table',1),(134,'2023_01_04_140439_make_email_clients_nullable',1),(135,'2023_01_04_140547_make_email_providers_nullable',1),(136,'2023_01_21_100532_add_is_printable_topos_settings_table',1),(137,'2023_02_04_213317_show_warehouse_to_table_pos_settings',1),(138,'2023_02_07_001309_create_sms_messages_table',1),(139,'2023_04_03_164423_create_table_email_messages',1),(140,'2023_04_12_141222_add_option_create_quotation_in_settings',1),(141,'2023_04_13_142815_add_fileds_to_product_variants',1),(142,'2023_04_13_155131_add_type_to_products',1),(143,'2023_04_14_150505_add_column_manage_stock',1),(144,'2023_09_02_010523_create_ecommerce_clients_table',1),(145,'2023_09_02_010524_add_foreign_keys_to_ecommerce_clients_table',1),(146,'2023_12_12_235150_create_count_stock_table',1),(147,'2023_12_12_235152_add_foreign_keys_to_count_stock_table',1),(148,'2023_12_14_001459_create_accounts_table',1),(149,'2023_12_14_001459_create_deposit_categories_table',1),(150,'2023_12_14_001459_create_deposits_table',1),(151,'2023_12_14_001501_add_foreign_keys_to_deposits_table',1),(152,'2023_12_14_232125_create_account_id_to_expenses',1),(153,'2023_12_15_203807_add_account_id_to_payment_sales',1),(154,'2023_12_15_203914_add_account_id_to_payment_purchases',1),(155,'2023_12_15_204046_add_account_id_to_payment_purchase_returns',1),(156,'2023_12_15_204302_add_account_id_to_payment_sale_returns',1),(157,'2023_12_16_193712_create_draft_sale_details_table',1),(158,'2023_12_16_193712_create_draft_sales_table',1),(159,'2023_12_16_193713_add_foreign_keys_to_draft_sale_details_table',1),(160,'2023_12_16_193713_add_foreign_keys_to_draft_sales_table',1),(161,'2024_02_01_001414_create_transfer_money_table',1),(162,'2024_02_01_001416_add_foreign_keys_to_transfer_money_table',1),(163,'2024_02_02_143558_create_payrolls_table',1),(164,'2024_02_02_143600_add_foreign_keys_to_payrolls_table',1),(165,'2024_06_19_141607_create_combined_products_table',1),(166,'2024_07_11_141607_create_employee_project_table',1),(167,'2024_07_11_141607_create_employee_task_table',1),(168,'2024_07_11_141607_create_projects_table',1),(169,'2024_07_11_141607_create_tasks_table',1),(170,'2024_07_11_141608_add_foreign_keys_to_employee_project_table',1),(171,'2024_07_11_141608_add_foreign_keys_to_employee_task_table',1),(172,'2024_07_11_141608_add_foreign_keys_to_projects_table',1),(173,'2024_07_11_141608_add_foreign_keys_to_tasks_table',1),(174,'2024_07_26_161112_add_show_language_to_settings_table',1),(175,'2024_07_26_164248_add_products_per_page_to_pos_settings_table',1),(176,'2025_03_13_181602_add_sale_time_to_sales_table',1),(177,'2025_03_14_014445_add_quotation_time_to_quotations_table',1),(178,'2025_03_14_014541_add_purchase_time_to_purchases_table',1),(179,'2025_03_14_014630_add_transfer_time_to_transfers_table',1),(180,'2025_03_14_014816_add_sale_return_time_to_sale_returns_table',1),(181,'2025_03_14_015012_add_purchase_return_time_to_purchase_returns_table',1),(182,'2025_03_14_015052_add_adjustment_time_to_adjustements_table',1),(183,'2025_04_22_165419_add_warranty_fields_to_products_table',1),(184,'2025_05_09_153613_add_logo_favicon_title_to_settings_table',1),(185,'2025_05_10_132709_create_languages_table',1),(186,'2025_05_10_165036_create_translations_table',1),(187,'2025_05_15_163803_create_subscriptions_table',1),(188,'2025_05_15_163806_add_foreign_keys_to_subscriptions_table',1),(189,'2025_05_16_224329_add_subscription_id_to_sales_table',1),(190,'2025_05_17_163803_create_error_logs_table',1),(191,'2025_05_20_130151_create_payment_methods_table',1),(192,'2025_05_21_234329_update_payment_purchases_add_payment_method_id',1),(193,'2025_05_22_135537_update_payment_sales_add_payment_method_id',1),(194,'2025_05_22_135557_update_payment_purchase_returns_add_payment_method_id',1),(195,'2025_05_22_135613_update_payment_sale_returns_add_payment_method_id',1),(196,'2025_05_22_135639_update_expenses_add_payment_method_id',1),(197,'2025_05_22_135718_update_payrolls_add_payment_method_id',1),(198,'2025_05_31_013235_add_category_id_to_count_stock_table',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oauth_access_tokens`
--

DROP TABLE IF EXISTS `oauth_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_access_tokens` (
  `id` varchar(100) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `client_id` bigint(20) unsigned NOT NULL,
  `name` varchar(191) DEFAULT NULL,
  `scopes` text,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_access_tokens_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oauth_access_tokens`
--

LOCK TABLES `oauth_access_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oauth_auth_codes`
--

DROP TABLE IF EXISTS `oauth_auth_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_auth_codes` (
  `id` varchar(100) NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `client_id` bigint(20) unsigned NOT NULL,
  `scopes` text,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_auth_codes_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oauth_auth_codes`
--

LOCK TABLES `oauth_auth_codes` WRITE;
/*!40000 ALTER TABLE `oauth_auth_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_auth_codes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oauth_clients`
--

DROP TABLE IF EXISTS `oauth_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_clients` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `secret` varchar(100) DEFAULT NULL,
  `provider` varchar(191) DEFAULT NULL,
  `redirect` text NOT NULL,
  `personal_access_client` tinyint(1) NOT NULL,
  `password_client` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_clients_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oauth_clients`
--

LOCK TABLES `oauth_clients` WRITE;
/*!40000 ALTER TABLE `oauth_clients` DISABLE KEYS */;
INSERT INTO `oauth_clients` VALUES (1,NULL,'Stocky Personal Access Client','zpNiXPR2ygD0dT73XNUbkISgwrhJyjFvxcLqlpgY',NULL,'http://localhost',1,0,0,'2025-06-18 01:52:32','2025-06-18 01:52:32'),(2,NULL,'Stocky Password Grant Client','0FQdMoMaNkWd9qbAGonpauoQDGdODQnU6eIi6B2s','users','http://localhost',0,1,0,'2025-06-18 01:52:32','2025-06-18 01:52:32');
/*!40000 ALTER TABLE `oauth_clients` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oauth_personal_access_clients`
--

DROP TABLE IF EXISTS `oauth_personal_access_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_personal_access_clients` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `client_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oauth_personal_access_clients`
--

LOCK TABLES `oauth_personal_access_clients` WRITE;
/*!40000 ALTER TABLE `oauth_personal_access_clients` DISABLE KEYS */;
INSERT INTO `oauth_personal_access_clients` VALUES (1,1,'2025-06-18 01:52:32','2025-06-18 01:52:32');
/*!40000 ALTER TABLE `oauth_personal_access_clients` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oauth_refresh_tokens`
--

DROP TABLE IF EXISTS `oauth_refresh_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_refresh_tokens` (
  `id` varchar(100) NOT NULL,
  `access_token_id` varchar(100) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_refresh_tokens_access_token_id_index` (`access_token_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oauth_refresh_tokens`
--

LOCK TABLES `oauth_refresh_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_refresh_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_refresh_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `office_shifts`
--

DROP TABLE IF EXISTS `office_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `office_shifts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `monday_in` varchar(191) DEFAULT NULL,
  `monday_out` varchar(191) DEFAULT NULL,
  `tuesday_in` varchar(191) DEFAULT NULL,
  `tuesday_out` varchar(191) DEFAULT NULL,
  `wednesday_in` varchar(191) DEFAULT NULL,
  `wednesday_out` varchar(191) DEFAULT NULL,
  `thursday_in` varchar(191) DEFAULT NULL,
  `thursday_out` varchar(191) DEFAULT NULL,
  `friday_in` varchar(191) DEFAULT NULL,
  `friday_out` varchar(191) DEFAULT NULL,
  `saturday_in` varchar(191) DEFAULT NULL,
  `saturday_out` varchar(191) DEFAULT NULL,
  `sunday_in` varchar(191) DEFAULT NULL,
  `sunday_out` varchar(191) DEFAULT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `office_shift_company_id` (`company_id`),
  CONSTRAINT `office_shift_company_id` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `office_shifts`
--

LOCK TABLES `office_shifts` WRITE;
/*!40000 ALTER TABLE `office_shifts` DISABLE KEYS */;
/*!40000 ALTER TABLE `office_shifts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_resets`
--

DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(191) NOT NULL,
  `token` varchar(191) NOT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `email` (`email`),
  KEY `token` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_resets`
--

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payment_methods`
--

DROP TABLE IF EXISTS `payment_methods`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `payment_methods` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(192) NOT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp(6) NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payment_methods`
--

LOCK TABLES `payment_methods` WRITE;
/*!40000 ALTER TABLE `payment_methods` DISABLE KEYS */;
INSERT INTO `payment_methods` VALUES (1,'Credit Card',NULL,NULL,NULL),(2,'Cash',NULL,NULL,NULL),(3,'Cheque',NULL,NULL,NULL),(4,'TPE',NULL,NULL,NULL),(5,'Western Union',NULL,NULL,NULL),(6,'bank transfer',NULL,NULL,NULL),(7,'other',NULL,NULL,NULL);
/*!40000 ALTER TABLE `payment_methods` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payment_purchase_returns`
--

DROP TABLE IF EXISTS `payment_purchase_returns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `payment_purchase_returns` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `Ref` varchar(192) NOT NULL,
  `purchase_return_id` int(11) NOT NULL,
  `account_id` int(11) DEFAULT NULL,
  `montant` double NOT NULL,
  `change` double NOT NULL DEFAULT '0',
  `payment_method_id` int(11) DEFAULT NULL,
  `notes` text,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id_payment_return_purchase` (`user_id`),
  KEY `supplier_id_payment_return_purchase` (`purchase_return_id`),
  KEY `payment_purchase_returns_account_id` (`account_id`),
  KEY `payment_purchase_returns_payment_method_id_foreign` (`payment_method_id`),
  CONSTRAINT `payment_purchase_returns_account_id` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`),
  CONSTRAINT `payment_purchase_returns_payment_method_id_foreign` FOREIGN KEY (`payment_method_id`) REFERENCES `payment_methods` (`id`),
  CONSTRAINT `supplier_id_payment_return_purchase` FOREIGN KEY (`purchase_return_id`) REFERENCES `purchase_returns` (`id`),
  CONSTRAINT `user_id_payment_return_purchase` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payment_purchase_returns`
--

LOCK TABLES `payment_purchase_returns` WRITE;
/*!40000 ALTER TABLE `payment_purchase_returns` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_purchase_returns` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payment_purchases`
--

DROP TABLE IF EXISTS `payment_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `payment_purchases` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `Ref` varchar(192) NOT NULL,
  `purchase_id` int(11) NOT NULL,
  `account_id` int(11) DEFAULT NULL,
  `montant` double NOT NULL,
  `change` double NOT NULL DEFAULT '0',
  `payment_method_id` int(11) DEFAULT NULL,
  `notes` text,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id_payment_purchases` (`user_id`),
  KEY `payments_purchase_id` (`purchase_id`),
  KEY `payment_purchases_account_id` (`account_id`),
  KEY `payment_purchases_payment_method_id_foreign` (`payment_method_id`),
  CONSTRAINT `factures_purchase_id` FOREIGN KEY (`purchase_id`) REFERENCES `purchases` (`id`),
  CONSTRAINT `payment_purchases_account_id` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`),
  CONSTRAINT `payment_purchases_payment_method_id_foreign` FOREIGN KEY (`payment_method_id`) REFERENCES `payment_methods` (`id`),
  CONSTRAINT `user_id_factures_achat` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payment_purchases`
--

LOCK TABLES `payment_purchases` WRITE;
/*!40000 ALTER TABLE `payment_purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payment_sale_returns`
--

DROP TABLE IF EXISTS `payment_sale_returns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `payment_sale_returns` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `Ref` varchar(192) NOT NULL,
  `sale_return_id` int(11) NOT NULL,
  `account_id` int(11) DEFAULT NULL,
  `montant` double NOT NULL,
  `change` double NOT NULL DEFAULT '0',
  `payment_method_id` int(11) DEFAULT NULL,
  `notes` text,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `factures_sale_return_user_id` (`user_id`),
  KEY `factures_sale_return` (`sale_return_id`),
  KEY `payment_sale_returns_account_id` (`account_id`),
  KEY `payment_sale_returns_payment_method_id_foreign` (`payment_method_id`),
  CONSTRAINT `factures_sale_return` FOREIGN KEY (`sale_return_id`) REFERENCES `sale_returns` (`id`),
  CONSTRAINT `factures_sale_return_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  CONSTRAINT `payment_sale_returns_account_id` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`),
  CONSTRAINT `payment_sale_returns_payment_method_id_foreign` FOREIGN KEY (`payment_method_id`) REFERENCES `payment_methods` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payment_sale_returns`
--

LOCK TABLES `payment_sale_returns` WRITE;
/*!40000 ALTER TABLE `payment_sale_returns` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_sale_returns` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payment_sales`
--

DROP TABLE IF EXISTS `payment_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `payment_sales` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `Ref` varchar(192) NOT NULL,
  `sale_id` int(11) NOT NULL,
  `account_id` int(11) DEFAULT NULL,
  `montant` double NOT NULL,
  `change` double NOT NULL DEFAULT '0',
  `payment_method_id` int(11) DEFAULT NULL,
  `notes` text,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id_payments_sale` (`user_id`),
  KEY `payment_sale_id` (`sale_id`),
  KEY `payment_sales_account_id` (`account_id`),
  KEY `payment_sales_payment_method_id_foreign` (`payment_method_id`),
  CONSTRAINT `facture_sale_id` FOREIGN KEY (`sale_id`) REFERENCES `sales` (`id`),
  CONSTRAINT `payment_sales_account_id` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`),
  CONSTRAINT `payment_sales_payment_method_id_foreign` FOREIGN KEY (`payment_method_id`) REFERENCES `payment_methods` (`id`),
  CONSTRAINT `user_id_factures_ventes` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payment_sales`
--

LOCK TABLES `payment_sales` WRITE;
/*!40000 ALTER TABLE `payment_sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payment_with_credit_card`
--

DROP TABLE IF EXISTS `payment_with_credit_card`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `payment_with_credit_card` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_id` int(11) NOT NULL,
  `customer_id` int(11) NOT NULL,
  `customer_stripe_id` varchar(192) NOT NULL,
  `charge_id` varchar(192) NOT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payment_with_credit_card`
--

LOCK TABLES `payment_with_credit_card` WRITE;
/*!40000 ALTER TABLE `payment_with_credit_card` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_with_credit_card` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payrolls`
--

DROP TABLE IF EXISTS `payrolls`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `payrolls` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `Ref` varchar(192) NOT NULL,
  `date` date NOT NULL,
  `employee_id` int(11) NOT NULL,
  `account_id` int(11) DEFAULT NULL,
  `amount` double NOT NULL,
  `payment_method_id` int(11) DEFAULT NULL,
  `payment_status` varchar(192) NOT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `payrolls_user_id` (`user_id`),
  KEY `payrolls_employee_id` (`employee_id`),
  KEY `payrolls_account_id` (`account_id`),
  KEY `payrolls_payment_method_id_foreign` (`payment_method_id`),
  CONSTRAINT `payrolls_account_id` FOREIGN KEY (`account_id`) REFERENCES `accounts` (`id`),
  CONSTRAINT `payrolls_employee_id` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`),
  CONSTRAINT `payrolls_payment_method_id_foreign` FOREIGN KEY (`payment_method_id`) REFERENCES `payment_methods` (`id`),
  CONSTRAINT `payrolls_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payrolls`
--

LOCK TABLES `payrolls` WRITE;
/*!40000 ALTER TABLE `payrolls` DISABLE KEYS */;
/*!40000 ALTER TABLE `payrolls` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `permission_role`
--

DROP TABLE IF EXISTS `permission_role`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permission_role` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `permission_id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `permission_role_permission_id` (`permission_id`),
  KEY `permission_role_role_id` (`role_id`),
  CONSTRAINT `permission_role_permission_id` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`),
  CONSTRAINT `permission_role_role_id` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=251 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `permission_role`
--

LOCK TABLES `permission_role` WRITE;
/*!40000 ALTER TABLE `permission_role` DISABLE KEYS */;
INSERT INTO `permission_role` VALUES (1,1,1),(2,2,1),(3,3,1),(4,4,1),(5,5,1),(6,6,1),(7,7,1),(8,8,1),(9,9,1),(10,10,1),(11,11,1),(12,12,1),(13,13,1),(14,14,1),(15,15,1),(16,16,1),(17,17,1),(18,18,1),(19,19,1),(20,20,1),(21,21,1),(22,22,1),(23,23,1),(24,24,1),(25,25,1),(26,26,1),(27,27,1),(28,28,1),(29,29,1),(30,30,1),(31,31,1),(32,32,1),(33,33,1),(34,34,1),(35,35,1),(36,36,1),(37,37,1),(38,38,1),(39,39,1),(40,40,1),(41,41,1),(42,42,1),(43,43,1),(44,44,1),(45,45,1),(46,46,1),(47,47,1),(48,48,1),(49,49,1),(50,50,1),(51,51,1),(52,52,1),(53,53,1),(54,54,1),(55,55,1),(56,56,1),(57,57,1),(58,58,1),(59,59,1),(60,60,1),(61,61,1),(62,62,1),(63,63,1),(64,64,1),(65,65,1),(66,66,1),(67,67,1),(68,68,1),(69,69,1),(70,70,1),(72,72,1),(73,73,1),(74,74,1),(75,75,1),(76,76,1),(77,77,1),(78,78,1),(79,79,1),(80,80,1),(81,81,1),(82,82,1),(83,83,1),(84,84,1),(85,85,1),(86,86,1),(87,87,1),(88,88,1),(89,89,1),(90,90,1),(91,91,1),(92,92,1),(93,93,1),(94,94,1),(95,95,1),(96,96,1),(97,97,1),(98,98,1),(99,99,1),(100,100,1),(101,101,1),(102,102,1),(103,103,1),(104,104,1),(105,105,1),(106,106,1),(107,107,1),(108,108,1),(109,109,1),(110,110,1),(111,111,1),(112,112,1),(113,113,1),(114,114,1),(115,115,1),(116,116,1),(117,117,1),(118,118,1),(119,119,1),(120,120,1),(121,121,1),(122,122,1),(123,123,1),(124,124,1),(125,125,1),(126,126,1),(127,127,1),(128,128,1),(129,129,1),(130,130,1),(131,131,1),(132,132,1),(133,133,1),(134,134,1),(135,135,1),(136,136,1),(137,137,1),(138,138,1),(139,139,1),(140,140,1),(141,141,1),(142,142,1),(143,143,1),(144,144,1),(145,145,1),(146,146,1),(147,147,1),(148,110,2),(149,2,2),(150,3,2),(151,1,2),(152,5,2),(153,4,2),(154,11,2),(155,13,2),(156,12,2),(157,63,2),(158,65,2),(159,141,2),(160,147,2),(161,126,2),(162,68,2),(163,87,2),(164,10,2),(165,14,2),(166,26,2),(167,25,2),(168,23,2),(169,24,2),(170,28,2),(171,27,2),(172,86,2),(173,103,2),(174,119,2),(175,122,2),(176,29,2),(177,30,2),(178,32,2),(179,31,2),(180,120,2),(181,123,2),(182,33,2),(183,34,2),(184,45,2),(185,46,2),(186,43,2),(187,44,2),(188,48,2),(189,47,2),(190,49,2),(191,50,2),(192,42,2),(193,41,2),(194,39,2),(195,40,2),(196,52,2),(197,51,2),(198,53,2),(199,54,2),(200,56,2),(201,55,2),(202,57,2),(203,58,2),(204,60,2),(205,59,2),(206,88,2),(207,111,2),(208,112,2),(209,62,2),(210,61,2),(211,85,2),(212,84,2),(213,89,2),(214,113,2),(215,114,2),(216,82,2),(217,83,2),(218,15,2),(219,16,2),(220,18,2),(221,17,2),(222,131,2),(223,81,2),(224,80,2),(225,79,2),(226,78,2),(227,132,2),(228,144,2),(229,145,2),(230,133,2),(231,77,2),(232,76,2),(233,75,2),(234,74,2),(235,73,2),(236,72,2),(237,70,2),(238,101,2),(239,102,2),(240,104,2),(241,105,2),(242,115,2),(243,116,2),(244,117,2),(245,142,2),(246,107,2),(247,108,2),(248,66,2),(249,67,2),(250,109,2);
/*!40000 ALTER TABLE `permission_role` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `permissions`
--

DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(192) NOT NULL,
  `label` varchar(192) DEFAULT NULL,
  `description` text,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=148 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `permissions`
--

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (1,'users_view',NULL,NULL,NULL,NULL,NULL),(2,'users_edit',NULL,NULL,NULL,NULL,NULL),(3,'record_view',NULL,NULL,NULL,NULL,NULL),(4,'users_delete',NULL,NULL,NULL,NULL,NULL),(5,'users_add',NULL,NULL,NULL,NULL,NULL),(6,'permissions_edit',NULL,NULL,NULL,NULL,NULL),(7,'permissions_view',NULL,NULL,NULL,NULL,NULL),(8,'permissions_delete',NULL,NULL,NULL,NULL,NULL),(9,'permissions_add',NULL,NULL,NULL,NULL,NULL),(10,'products_delete',NULL,NULL,NULL,NULL,NULL),(11,'products_view',NULL,NULL,NULL,NULL,NULL),(12,'barcode_view',NULL,NULL,NULL,NULL,NULL),(13,'products_edit',NULL,NULL,NULL,NULL,NULL),(14,'products_add',NULL,NULL,NULL,NULL,NULL),(15,'expense_add',NULL,NULL,NULL,NULL,NULL),(16,'expense_delete',NULL,NULL,NULL,NULL,NULL),(17,'expense_edit',NULL,NULL,NULL,NULL,NULL),(18,'expense_view',NULL,NULL,NULL,NULL,NULL),(19,'transfer_delete',NULL,NULL,NULL,NULL,NULL),(20,'transfer_add',NULL,NULL,NULL,NULL,NULL),(21,'transfer_view',NULL,NULL,NULL,NULL,NULL),(22,'transfer_edit',NULL,NULL,NULL,NULL,NULL),(23,'adjustment_delete',NULL,NULL,NULL,NULL,NULL),(24,'adjustment_add',NULL,NULL,NULL,NULL,NULL),(25,'adjustment_edit',NULL,NULL,NULL,NULL,NULL),(26,'adjustment_view',NULL,NULL,NULL,NULL,NULL),(27,'Sales_edit',NULL,NULL,NULL,NULL,NULL),(28,'Sales_view',NULL,NULL,NULL,NULL,NULL),(29,'Sales_delete',NULL,NULL,NULL,NULL,NULL),(30,'Sales_add',NULL,NULL,NULL,NULL,NULL),(31,'Purchases_edit',NULL,NULL,NULL,NULL,NULL),(32,'Purchases_view',NULL,NULL,NULL,NULL,NULL),(33,'Purchases_delete',NULL,NULL,NULL,NULL,NULL),(34,'Purchases_add',NULL,NULL,NULL,NULL,NULL),(35,'Quotations_edit',NULL,NULL,NULL,NULL,NULL),(36,'Quotations_delete',NULL,NULL,NULL,NULL,NULL),(37,'Quotations_add',NULL,NULL,NULL,NULL,NULL),(38,'Quotations_view',NULL,NULL,NULL,NULL,NULL),(39,'payment_sales_delete',NULL,NULL,NULL,NULL,NULL),(40,'payment_sales_add',NULL,NULL,NULL,NULL,NULL),(41,'payment_sales_edit',NULL,NULL,NULL,NULL,NULL),(42,'payment_sales_view',NULL,NULL,NULL,NULL,NULL),(43,'Purchase_Returns_delete',NULL,NULL,NULL,NULL,NULL),(44,'Purchase_Returns_add',NULL,NULL,NULL,NULL,NULL),(45,'Purchase_Returns_view',NULL,NULL,NULL,NULL,NULL),(46,'Purchase_Returns_edit',NULL,NULL,NULL,NULL,NULL),(47,'Sale_Returns_delete',NULL,NULL,NULL,NULL,NULL),(48,'Sale_Returns_add',NULL,NULL,NULL,NULL,NULL),(49,'Sale_Returns_edit',NULL,NULL,NULL,NULL,NULL),(50,'Sale_Returns_view',NULL,NULL,NULL,NULL,NULL),(51,'payment_purchases_edit',NULL,NULL,NULL,NULL,NULL),(52,'payment_purchases_view',NULL,NULL,NULL,NULL,NULL),(53,'payment_purchases_delete',NULL,NULL,NULL,NULL,NULL),(54,'payment_purchases_add',NULL,NULL,NULL,NULL,NULL),(55,'payment_returns_edit',NULL,NULL,NULL,NULL,NULL),(56,'payment_returns_view',NULL,NULL,NULL,NULL,NULL),(57,'payment_returns_delete',NULL,NULL,NULL,NULL,NULL),(58,'payment_returns_add',NULL,NULL,NULL,NULL,NULL),(59,'Customers_edit',NULL,NULL,NULL,NULL,NULL),(60,'Customers_view',NULL,NULL,NULL,NULL,NULL),(61,'Customers_delete',NULL,NULL,NULL,NULL,NULL),(62,'Customers_add',NULL,NULL,NULL,NULL,NULL),(63,'unit',NULL,NULL,NULL,NULL,NULL),(64,'currency',NULL,NULL,NULL,NULL,NULL),(65,'category',NULL,NULL,NULL,NULL,NULL),(66,'backup',NULL,NULL,NULL,NULL,NULL),(67,'warehouse',NULL,NULL,NULL,NULL,NULL),(68,'brand',NULL,NULL,NULL,NULL,NULL),(69,'setting_system',NULL,NULL,NULL,NULL,NULL),(70,'Warehouse_report',NULL,NULL,NULL,NULL,NULL),(72,'Reports_quantity_alerts',NULL,NULL,NULL,NULL,NULL),(73,'Reports_profit',NULL,NULL,NULL,NULL,NULL),(74,'Reports_suppliers',NULL,NULL,NULL,NULL,NULL),(75,'Reports_customers',NULL,NULL,NULL,NULL,NULL),(76,'Reports_purchase',NULL,NULL,NULL,NULL,NULL),(77,'Reports_sales',NULL,NULL,NULL,NULL,NULL),(78,'Reports_payments_purchase_Return',NULL,NULL,NULL,NULL,NULL),(79,'Reports_payments_Sale_Returns',NULL,NULL,NULL,NULL,NULL),(80,'Reports_payments_Purchases',NULL,NULL,NULL,NULL,NULL),(81,'Reports_payments_Sales',NULL,NULL,NULL,NULL,NULL),(82,'Suppliers_delete',NULL,NULL,NULL,NULL,NULL),(83,'Suppliers_add',NULL,NULL,NULL,NULL,NULL),(84,'Suppliers_edit',NULL,NULL,NULL,NULL,NULL),(85,'Suppliers_view',NULL,NULL,NULL,NULL,NULL),(86,'Pos_view',NULL,NULL,NULL,NULL,NULL),(87,'product_import',NULL,NULL,NULL,NULL,NULL),(88,'customers_import',NULL,NULL,NULL,NULL,NULL),(89,'Suppliers_import',NULL,NULL,NULL,NULL,NULL),(90,'view_employee',NULL,NULL,NULL,NULL,NULL),(91,'add_employee',NULL,NULL,NULL,NULL,NULL),(92,'edit_employee',NULL,NULL,NULL,NULL,NULL),(93,'delete_employee',NULL,NULL,NULL,NULL,NULL),(94,'company',NULL,NULL,NULL,NULL,NULL),(95,'department',NULL,NULL,NULL,NULL,NULL),(96,'designation',NULL,NULL,NULL,NULL,NULL),(97,'office_shift',NULL,NULL,NULL,NULL,NULL),(98,'attendance',NULL,NULL,NULL,NULL,NULL),(99,'leave',NULL,NULL,NULL,NULL,NULL),(100,'holiday',NULL,NULL,NULL,NULL,NULL),(101,'Top_products',NULL,NULL,NULL,NULL,NULL),(102,'Top_customers',NULL,NULL,NULL,NULL,NULL),(103,'shipment',NULL,NULL,NULL,NULL,NULL),(104,'users_report',NULL,NULL,NULL,NULL,NULL),(105,'stock_report',NULL,NULL,NULL,NULL,NULL),(106,'sms_settings',NULL,NULL,NULL,NULL,NULL),(107,'pos_settings',NULL,NULL,NULL,NULL,NULL),(108,'payment_gateway',NULL,NULL,NULL,NULL,NULL),(109,'mail_settings',NULL,NULL,NULL,NULL,NULL),(110,'dashboard',NULL,NULL,NULL,NULL,NULL),(111,'pay_due',NULL,NULL,NULL,NULL,NULL),(112,'pay_sale_return_due',NULL,NULL,NULL,NULL,NULL),(113,'pay_supplier_due',NULL,NULL,NULL,NULL,NULL),(114,'pay_purchase_return_due',NULL,NULL,NULL,NULL,NULL),(115,'product_report',NULL,NULL,NULL,NULL,NULL),(116,'product_sales_report',NULL,NULL,NULL,NULL,NULL),(117,'product_purchases_report',NULL,NULL,NULL,NULL,NULL),(118,'notification_template',NULL,NULL,NULL,NULL,NULL),(119,'edit_product_sale',NULL,NULL,NULL,NULL,NULL),(120,'edit_product_purchase',NULL,NULL,NULL,NULL,NULL),(121,'edit_product_quotation',NULL,NULL,NULL,NULL,NULL),(122,'edit_tax_discount_shipping_sale',NULL,NULL,NULL,NULL,NULL),(123,'edit_tax_discount_shipping_purchase',NULL,NULL,NULL,NULL,NULL),(124,'edit_tax_discount_shipping_quotation',NULL,NULL,NULL,NULL,NULL),(125,'module_settings',NULL,NULL,NULL,NULL,NULL),(126,'count_stock',NULL,NULL,NULL,NULL,NULL),(127,'deposit_add',NULL,NULL,NULL,NULL,NULL),(128,'deposit_delete',NULL,NULL,NULL,NULL,NULL),(129,'deposit_edit',NULL,NULL,NULL,NULL,NULL),(130,'deposit_view',NULL,NULL,NULL,NULL,NULL),(131,'account',NULL,NULL,NULL,NULL,NULL),(132,'inventory_valuation',NULL,NULL,NULL,NULL,NULL),(133,'expenses_report',NULL,NULL,NULL,NULL,NULL),(134,'deposits_report',NULL,NULL,NULL,NULL,NULL),(135,'transfer_money',NULL,NULL,NULL,NULL,NULL),(136,'payroll',NULL,NULL,NULL,NULL,NULL),(137,'projects',NULL,NULL,NULL,NULL,NULL),(138,'tasks',NULL,NULL,NULL,NULL,NULL),(139,'appearance_settings',NULL,NULL,NULL,NULL,NULL),(140,'translations_settings',NULL,NULL,NULL,NULL,NULL),(141,'subscription_product',NULL,NULL,NULL,NULL,NULL),(142,'report_error_logs',NULL,NULL,NULL,NULL,NULL),(143,'payment_methods',NULL,NULL,NULL,NULL,NULL),(144,'report_transactions',NULL,NULL,NULL,NULL,NULL),(145,'report_sales_by_category',NULL,NULL,NULL,NULL,NULL),(146,'report_sales_by_brand',NULL,NULL,NULL,NULL,NULL),(147,'opening_stock_import',NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pos_settings`
--

DROP TABLE IF EXISTS `pos_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pos_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `note_customer` varchar(192) NOT NULL DEFAULT 'Thank You For Shopping With Us . Please Come Again',
  `show_note` tinyint(1) NOT NULL DEFAULT '1',
  `show_barcode` tinyint(1) NOT NULL DEFAULT '1',
  `show_discount` tinyint(1) NOT NULL DEFAULT '1',
  `show_customer` tinyint(1) NOT NULL DEFAULT '1',
  `show_email` tinyint(1) NOT NULL DEFAULT '1',
  `show_phone` tinyint(1) NOT NULL DEFAULT '1',
  `show_address` tinyint(1) NOT NULL DEFAULT '1',
  `products_per_page` int(11) NOT NULL DEFAULT '8',
  `is_printable` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `show_Warehouse` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pos_settings`
--

LOCK TABLES `pos_settings` WRITE;
/*!40000 ALTER TABLE `pos_settings` DISABLE KEYS */;
INSERT INTO `pos_settings` VALUES (1,'Thank You For Shopping With Us . Please Come Again',1,1,1,1,1,1,1,8,1,NULL,NULL,NULL,1);
/*!40000 ALTER TABLE `pos_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_variants`
--

DROP TABLE IF EXISTS `product_variants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_variants` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) DEFAULT NULL,
  `name` varchar(192) DEFAULT NULL,
  `cost` double NOT NULL,
  `price` double NOT NULL,
  `code` varchar(192) NOT NULL,
  `image` varchar(191) NOT NULL DEFAULT 'no-image.png',
  `qty` decimal(8,2) DEFAULT '0.00',
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id_variant` (`product_id`),
  CONSTRAINT `product_id_variant` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_variants`
--

LOCK TABLES `product_variants` WRITE;
/*!40000 ALTER TABLE `product_variants` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_variants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `product_warehouse`
--

DROP TABLE IF EXISTS `product_warehouse`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `product_warehouse` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `product_variant_id` int(11) DEFAULT NULL,
  `qte` double NOT NULL,
  `manage_stock` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_warehouse_id` (`product_id`),
  KEY `warehouse_id` (`warehouse_id`),
  KEY `product_variant_id` (`product_variant_id`),
  CONSTRAINT `art_id` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`),
  CONSTRAINT `mag_id` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`),
  CONSTRAINT `product_variant_id` FOREIGN KEY (`product_variant_id`) REFERENCES `product_variants` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `product_warehouse`
--

LOCK TABLES `product_warehouse` WRITE;
/*!40000 ALTER TABLE `product_warehouse` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_warehouse` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `products`
--

DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(191) NOT NULL,
  `warranty_period` int(11) DEFAULT NULL,
  `warranty_unit` varchar(191) DEFAULT NULL,
  `warranty_terms` text,
  `has_guarantee` tinyint(1) NOT NULL DEFAULT '0',
  `guarantee_period` int(11) DEFAULT NULL,
  `guarantee_unit` varchar(191) DEFAULT NULL,
  `code` varchar(192) NOT NULL,
  `Type_barcode` varchar(192) NOT NULL,
  `name` varchar(192) NOT NULL,
  `cost` double NOT NULL,
  `price` double NOT NULL,
  `category_id` int(11) NOT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `unit_id` int(11) DEFAULT NULL,
  `unit_sale_id` int(11) DEFAULT NULL,
  `unit_purchase_id` int(11) DEFAULT NULL,
  `TaxNet` double DEFAULT '0',
  `tax_method` varchar(192) DEFAULT '1',
  `image` text,
  `note` text,
  `stock_alert` double DEFAULT '0',
  `is_variant` tinyint(1) NOT NULL DEFAULT '0',
  `is_imei` tinyint(1) NOT NULL DEFAULT '0',
  `not_selling` tinyint(1) NOT NULL DEFAULT '0',
  `is_active` tinyint(1) DEFAULT '1',
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`),
  KEY `brand_id_products` (`brand_id`),
  KEY `unit_id_products` (`unit_id`),
  KEY `unit_id_sales` (`unit_sale_id`),
  KEY `unit_purchase_products` (`unit_purchase_id`),
  CONSTRAINT `brand_id_products` FOREIGN KEY (`brand_id`) REFERENCES `brands` (`id`),
  CONSTRAINT `category_id` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`),
  CONSTRAINT `unit_id_products` FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`),
  CONSTRAINT `unit_id_sales` FOREIGN KEY (`unit_sale_id`) REFERENCES `units` (`id`),
  CONSTRAINT `unit_purchase_products` FOREIGN KEY (`unit_purchase_id`) REFERENCES `units` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `products`
--

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
/*!40000 ALTER TABLE `products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `projects`
--

DROP TABLE IF EXISTS `projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(191) NOT NULL,
  `client_id` int(11) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `description` text,
  `company_id` int(11) NOT NULL,
  `status` varchar(191) NOT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `projects_client_id` (`client_id`),
  KEY `projects_company_id` (`company_id`),
  CONSTRAINT `projects_client_id` FOREIGN KEY (`client_id`) REFERENCES `clients` (`id`),
  CONSTRAINT `projects_company_id` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `projects`
--

LOCK TABLES `projects` WRITE;
/*!40000 ALTER TABLE `projects` DISABLE KEYS */;
/*!40000 ALTER TABLE `projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `providers`
--

DROP TABLE IF EXISTS `providers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `providers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `code` int(11) NOT NULL,
  `email` varchar(191) DEFAULT NULL,
  `phone` varchar(191) DEFAULT NULL,
  `tax_number` varchar(192) DEFAULT NULL,
  `country` varchar(191) DEFAULT NULL,
  `city` varchar(191) DEFAULT NULL,
  `adresse` varchar(191) DEFAULT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `providers`
--

LOCK TABLES `providers` WRITE;
/*!40000 ALTER TABLE `providers` DISABLE KEYS */;
/*!40000 ALTER TABLE `providers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchase_details`
--

DROP TABLE IF EXISTS `purchase_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchase_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cost` double NOT NULL,
  `purchase_unit_id` int(11) DEFAULT NULL,
  `TaxNet` double DEFAULT '0',
  `tax_method` varchar(192) DEFAULT '1',
  `discount` double DEFAULT '0',
  `discount_method` varchar(192) DEFAULT '1',
  `purchase_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_variant_id` int(11) DEFAULT NULL,
  `imei_number` text,
  `total` double NOT NULL,
  `quantity` double NOT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purchase_id` (`purchase_id`),
  KEY `product_id` (`product_id`),
  KEY `purchase_product_variant_id` (`product_variant_id`),
  KEY `purchase_unit_id_purchase` (`purchase_unit_id`),
  CONSTRAINT `product_id` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `purchase_id` FOREIGN KEY (`purchase_id`) REFERENCES `purchases` (`id`),
  CONSTRAINT `purchase_product_variant_id` FOREIGN KEY (`product_variant_id`) REFERENCES `product_variants` (`id`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  CONSTRAINT `purchase_unit_id_purchase` FOREIGN KEY (`purchase_unit_id`) REFERENCES `units` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchase_details`
--

LOCK TABLES `purchase_details` WRITE;
/*!40000 ALTER TABLE `purchase_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `purchase_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchase_return_details`
--

DROP TABLE IF EXISTS `purchase_return_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchase_return_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cost` decimal(16,3) NOT NULL,
  `purchase_unit_id` int(11) DEFAULT NULL,
  `TaxNet` double DEFAULT '0',
  `tax_method` varchar(192) DEFAULT '1',
  `discount` double DEFAULT '0',
  `discount_method` varchar(192) DEFAULT '1',
  `total` double NOT NULL,
  `quantity` double NOT NULL,
  `purchase_return_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_variant_id` int(11) DEFAULT NULL,
  `imei_number` text,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purchase_return_id_return` (`purchase_return_id`),
  KEY `product_id_details_purchase_return` (`product_id`),
  KEY `purchase_return_product_variant_id` (`product_variant_id`),
  KEY `unit_id_purchase_return_details` (`purchase_unit_id`),
  CONSTRAINT `product_id_details_purchase_return` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`),
  CONSTRAINT `purchase_return_id_return` FOREIGN KEY (`purchase_return_id`) REFERENCES `purchase_returns` (`id`),
  CONSTRAINT `purchase_return_product_variant_id` FOREIGN KEY (`product_variant_id`) REFERENCES `product_variants` (`id`),
  CONSTRAINT `unit_id_purchase_return_details` FOREIGN KEY (`purchase_unit_id`) REFERENCES `units` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchase_return_details`
--

LOCK TABLES `purchase_return_details` WRITE;
/*!40000 ALTER TABLE `purchase_return_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `purchase_return_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchase_returns`
--

DROP TABLE IF EXISTS `purchase_returns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchase_returns` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `time` time DEFAULT NULL,
  `Ref` varchar(192) NOT NULL,
  `purchase_id` int(11) DEFAULT NULL,
  `provider_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `tax_rate` double DEFAULT '0',
  `TaxNet` double DEFAULT '0',
  `discount` double DEFAULT '0',
  `shipping` double DEFAULT '0',
  `GrandTotal` double NOT NULL,
  `paid_amount` double NOT NULL DEFAULT '0',
  `payment_statut` varchar(192) NOT NULL,
  `statut` varchar(192) NOT NULL,
  `notes` text,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id_returns` (`user_id`),
  KEY `provider_id_return` (`provider_id`),
  KEY `purchase_return_warehouse_id` (`warehouse_id`),
  KEY `purchase_id_purchase_returns` (`purchase_id`),
  CONSTRAINT `provider_id_return` FOREIGN KEY (`provider_id`) REFERENCES `providers` (`id`),
  CONSTRAINT `purchase_id_purchase_returns` FOREIGN KEY (`purchase_id`) REFERENCES `purchases` (`id`),
  CONSTRAINT `purchase_return_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  CONSTRAINT `purchase_return_warehouse_id` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchase_returns`
--

LOCK TABLES `purchase_returns` WRITE;
/*!40000 ALTER TABLE `purchase_returns` DISABLE KEYS */;
/*!40000 ALTER TABLE `purchase_returns` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `purchases`
--

DROP TABLE IF EXISTS `purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `purchases` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `Ref` varchar(192) NOT NULL,
  `date` date NOT NULL,
  `time` time DEFAULT NULL,
  `provider_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `tax_rate` double DEFAULT '0',
  `TaxNet` double DEFAULT '0',
  `discount` double DEFAULT '0',
  `shipping` double DEFAULT '0',
  `GrandTotal` double NOT NULL,
  `paid_amount` double NOT NULL DEFAULT '0',
  `statut` varchar(191) NOT NULL,
  `payment_statut` varchar(192) NOT NULL,
  `notes` text,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id_purchases` (`user_id`),
  KEY `provider_id` (`provider_id`),
  KEY `warehouse_id_purchase` (`warehouse_id`),
  CONSTRAINT `provider_id` FOREIGN KEY (`provider_id`) REFERENCES `providers` (`id`),
  CONSTRAINT `user_id_purchases` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  CONSTRAINT `warehouse_id_purchase` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `purchases`
--

LOCK TABLES `purchases` WRITE;
/*!40000 ALTER TABLE `purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotation_details`
--

DROP TABLE IF EXISTS `quotation_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `quotation_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `price` double NOT NULL,
  `sale_unit_id` int(11) DEFAULT NULL,
  `TaxNet` double DEFAULT '0',
  `tax_method` varchar(192) DEFAULT '1',
  `discount` double DEFAULT '0',
  `discount_method` varchar(192) DEFAULT '1',
  `total` double NOT NULL,
  `quantity` double NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_variant_id` int(11) DEFAULT NULL,
  `imei_number` text,
  `quotation_id` int(11) NOT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id_quotation_details` (`product_id`),
  KEY `quote_product_variant_id` (`product_variant_id`),
  KEY `quotation_id` (`quotation_id`),
  KEY `sale_unit_id_quotation` (`sale_unit_id`),
  CONSTRAINT `product_id_quotation_details` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`),
  CONSTRAINT `quotation_id` FOREIGN KEY (`quotation_id`) REFERENCES `quotations` (`id`),
  CONSTRAINT `quote_product_variant_id` FOREIGN KEY (`product_variant_id`) REFERENCES `product_variants` (`id`),
  CONSTRAINT `sale_unit_id_quotation` FOREIGN KEY (`sale_unit_id`) REFERENCES `units` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotation_details`
--

LOCK TABLES `quotation_details` WRITE;
/*!40000 ALTER TABLE `quotation_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotation_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `quotations`
--

DROP TABLE IF EXISTS `quotations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `quotations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `time` time DEFAULT NULL,
  `Ref` varchar(192) NOT NULL,
  `client_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `tax_rate` double DEFAULT '0',
  `TaxNet` double DEFAULT '0',
  `discount` double DEFAULT '0',
  `shipping` double DEFAULT '0',
  `GrandTotal` double NOT NULL,
  `statut` varchar(192) NOT NULL,
  `notes` text,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id_quotation` (`user_id`),
  KEY `client_id_quotation` (`client_id`),
  KEY `warehouse_id_quotation` (`warehouse_id`),
  CONSTRAINT `client_id _quotation` FOREIGN KEY (`client_id`) REFERENCES `clients` (`id`),
  CONSTRAINT `user_id_quotation` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  CONSTRAINT `warehouse_id_quotation` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `quotations`
--

LOCK TABLES `quotations` WRITE;
/*!40000 ALTER TABLE `quotations` DISABLE KEYS */;
/*!40000 ALTER TABLE `quotations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_user`
--

DROP TABLE IF EXISTS `role_user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `role_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `role_id` int(11) NOT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `role_user_user_id` (`user_id`),
  KEY `role_user_role_id` (`role_id`),
  CONSTRAINT `role_user_role_id` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`),
  CONSTRAINT `role_user_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_user`
--

LOCK TABLES `role_user` WRITE;
/*!40000 ALTER TABLE `role_user` DISABLE KEYS */;
INSERT INTO `role_user` VALUES (1,1,1,NULL,NULL),(2,2,2,'2025-06-18 16:30:08.000000','2025-06-18 16:30:08.000000');
/*!40000 ALTER TABLE `role_user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(192) NOT NULL,
  `label` varchar(192) DEFAULT NULL,
  `description` text,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'Owner','Owner','Owner',NULL,NULL,NULL,1),(2,'Admin','Admin',NULL,'2025-06-18 16:26:12.000000','2025-06-18 16:26:12.000000',NULL,0);
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sale_details`
--

DROP TABLE IF EXISTS `sale_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sale_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `sale_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_variant_id` int(11) DEFAULT NULL,
  `imei_number` text,
  `price` double NOT NULL,
  `sale_unit_id` int(11) DEFAULT NULL,
  `TaxNet` double DEFAULT NULL,
  `tax_method` varchar(192) DEFAULT '1',
  `discount` double DEFAULT NULL,
  `discount_method` varchar(192) DEFAULT '1',
  `total` double NOT NULL,
  `quantity` double NOT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Details_Sale_id` (`sale_id`),
  KEY `sale_product_id` (`product_id`),
  KEY `sale_product_variant_id` (`product_variant_id`),
  KEY `sales_sale_unit_id` (`sale_unit_id`),
  CONSTRAINT `Details_Sale_id` FOREIGN KEY (`sale_id`) REFERENCES `sales` (`id`),
  CONSTRAINT `sale_product_id` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`),
  CONSTRAINT `sale_product_variant_id` FOREIGN KEY (`product_variant_id`) REFERENCES `product_variants` (`id`),
  CONSTRAINT `sales_sale_unit_id` FOREIGN KEY (`sale_unit_id`) REFERENCES `units` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sale_details`
--

LOCK TABLES `sale_details` WRITE;
/*!40000 ALTER TABLE `sale_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `sale_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sale_return_details`
--

DROP TABLE IF EXISTS `sale_return_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sale_return_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sale_return_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `price` double NOT NULL,
  `sale_unit_id` int(11) DEFAULT NULL,
  `TaxNet` double DEFAULT '0',
  `tax_method` varchar(192) DEFAULT '1',
  `discount` double DEFAULT '0',
  `discount_method` varchar(192) DEFAULT '1',
  `product_variant_id` int(11) DEFAULT NULL,
  `imei_number` text,
  `quantity` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `return_id` (`sale_return_id`),
  KEY `product_id_details_returns` (`product_id`),
  KEY `sale_return_id_product_variant_id` (`product_variant_id`),
  KEY `sale_unit_id_return_details` (`sale_unit_id`),
  CONSTRAINT `product_id_details_returns` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`),
  CONSTRAINT `sale_return_id` FOREIGN KEY (`sale_return_id`) REFERENCES `sale_returns` (`id`),
  CONSTRAINT `sale_return_id_product_variant_id` FOREIGN KEY (`product_variant_id`) REFERENCES `product_variants` (`id`),
  CONSTRAINT `sale_unit_id_return_details` FOREIGN KEY (`sale_unit_id`) REFERENCES `units` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sale_return_details`
--

LOCK TABLES `sale_return_details` WRITE;
/*!40000 ALTER TABLE `sale_return_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `sale_return_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sale_returns`
--

DROP TABLE IF EXISTS `sale_returns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sale_returns` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `time` time DEFAULT NULL,
  `Ref` varchar(192) NOT NULL,
  `sale_id` int(11) DEFAULT NULL,
  `client_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `tax_rate` double DEFAULT '0',
  `TaxNet` double DEFAULT '0',
  `discount` double DEFAULT '0',
  `shipping` double DEFAULT '0',
  `GrandTotal` double NOT NULL,
  `paid_amount` double NOT NULL DEFAULT '0',
  `payment_statut` varchar(192) NOT NULL,
  `statut` varchar(192) NOT NULL,
  `notes` text,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id_returns` (`user_id`),
  KEY `client_id_returns` (`client_id`),
  KEY `warehouse_id_sale_return_id` (`warehouse_id`),
  KEY `sale_id_return_sales` (`sale_id`),
  CONSTRAINT `client_id_returns` FOREIGN KEY (`client_id`) REFERENCES `clients` (`id`),
  CONSTRAINT `sale_id_return_sales` FOREIGN KEY (`sale_id`) REFERENCES `sales` (`id`),
  CONSTRAINT `user_id_returns` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  CONSTRAINT `warehouse_id_sale_return_id` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sale_returns`
--

LOCK TABLES `sale_returns` WRITE;
/*!40000 ALTER TABLE `sale_returns` DISABLE KEYS */;
/*!40000 ALTER TABLE `sale_returns` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sales`
--

DROP TABLE IF EXISTS `sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sales` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `time` time DEFAULT NULL,
  `Ref` varchar(192) NOT NULL,
  `is_pos` tinyint(1) DEFAULT '0',
  `client_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `subscription_id` int(11) DEFAULT NULL,
  `tax_rate` double DEFAULT '0',
  `TaxNet` double DEFAULT '0',
  `discount` double DEFAULT '0',
  `shipping` double DEFAULT '0',
  `GrandTotal` double NOT NULL DEFAULT '0',
  `paid_amount` double NOT NULL DEFAULT '0',
  `payment_statut` varchar(192) NOT NULL,
  `statut` varchar(191) NOT NULL,
  `shipping_status` varchar(191) DEFAULT NULL,
  `notes` text,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id_sales` (`user_id`),
  KEY `sale_client_id` (`client_id`),
  KEY `warehouse_id_sale` (`warehouse_id`),
  KEY `subscription_id` (`subscription_id`),
  CONSTRAINT `sale_client_id` FOREIGN KEY (`client_id`) REFERENCES `clients` (`id`),
  CONSTRAINT `sales_subscription_id_foreign` FOREIGN KEY (`subscription_id`) REFERENCES `subscriptions` (`id`),
  CONSTRAINT `user_id_sales` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  CONSTRAINT `warehouse_id_sale` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sales`
--

LOCK TABLES `sales` WRITE;
/*!40000 ALTER TABLE `sales` DISABLE KEYS */;
/*!40000 ALTER TABLE `sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `servers`
--

DROP TABLE IF EXISTS `servers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `servers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mail_mailer` varchar(191) NOT NULL DEFAULT 'smtp',
  `host` varchar(191) NOT NULL,
  `port` int(11) NOT NULL,
  `sender_name` varchar(191) NOT NULL DEFAULT 'Admin',
  `username` varchar(191) NOT NULL,
  `password` varchar(191) NOT NULL,
  `encryption` varchar(191) NOT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `servers`
--

LOCK TABLES `servers` WRITE;
/*!40000 ALTER TABLE `servers` DISABLE KEYS */;
INSERT INTO `servers` VALUES (1,'smtp','mailtrap.io',2525,'Admin','test','test','tls',NULL,NULL,NULL);
/*!40000 ALTER TABLE `servers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(191) NOT NULL,
  `currency_id` int(11) DEFAULT NULL,
  `CompanyName` varchar(191) NOT NULL,
  `CompanyPhone` varchar(191) NOT NULL,
  `CompanyAdress` varchar(191) NOT NULL,
  `logo` varchar(191) DEFAULT NULL,
  `favicon` varchar(191) DEFAULT 'favicon.ico',
  `is_invoice_footer` tinyint(1) NOT NULL DEFAULT '0',
  `invoice_footer` varchar(192) DEFAULT NULL,
  `footer` varchar(192) NOT NULL DEFAULT 'Stocky - Ultimate Inventory With POS',
  `developed_by` varchar(192) NOT NULL DEFAULT 'Stocky',
  `client_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `default_language` varchar(192) NOT NULL DEFAULT 'en',
  `sms_gateway` int(11) DEFAULT '1',
  `show_language` tinyint(1) NOT NULL DEFAULT '1',
  `quotation_with_stock` tinyint(1) NOT NULL DEFAULT '1',
  `app_name` varchar(191) DEFAULT 'Stocky | Ultimate Inventory With POS',
  `page_title_suffix` varchar(191) DEFAULT 'Ultimate Inventory With POS',
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `currency_id` (`currency_id`),
  KEY `client_id` (`client_id`),
  KEY `warehouse_id` (`warehouse_id`),
  CONSTRAINT `currency_id` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`),
  CONSTRAINT `settings_client_id` FOREIGN KEY (`client_id`) REFERENCES `clients` (`id`),
  CONSTRAINT `settings_warehouse_id` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (1,'admin@example.com',1,'Alislamiah','6315996770','Sector 13, Uttara , Dhaka, Bangladesh','logo-default.png','favicon.ico',0,'null','Alislamiah Inventory With POS','Steadhost IT',1,1,'en',1,0,1,'Alislamiah Inventory With POS','Alislamiah Inventory With POS',NULL,'2025-06-18 16:19:07.000000',NULL);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `shipments`
--

DROP TABLE IF EXISTS `shipments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `shipments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `Ref` varchar(192) NOT NULL,
  `sale_id` int(11) NOT NULL,
  `delivered_to` varchar(192) DEFAULT NULL,
  `shipping_address` text,
  `status` varchar(192) NOT NULL,
  `shipping_details` text,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `shipment_user_id` (`user_id`),
  KEY `shipment_sale_id` (`sale_id`),
  CONSTRAINT `shipment_sale_id` FOREIGN KEY (`sale_id`) REFERENCES `sales` (`id`),
  CONSTRAINT `shipment_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `shipments`
--

LOCK TABLES `shipments` WRITE;
/*!40000 ALTER TABLE `shipments` DISABLE KEYS */;
/*!40000 ALTER TABLE `shipments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sms_gateway`
--

DROP TABLE IF EXISTS `sms_gateway`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sms_gateway` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(192) NOT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sms_gateway`
--

LOCK TABLES `sms_gateway` WRITE;
/*!40000 ALTER TABLE `sms_gateway` DISABLE KEYS */;
INSERT INTO `sms_gateway` VALUES (1,'twilio',NULL,NULL,NULL),(3,'infobip',NULL,NULL,NULL),(4,'termii',NULL,NULL,NULL);
/*!40000 ALTER TABLE `sms_gateway` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sms_messages`
--

DROP TABLE IF EXISTS `sms_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sms_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text,
  `text` text,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sms_messages`
--

LOCK TABLES `sms_messages` WRITE;
/*!40000 ALTER TABLE `sms_messages` DISABLE KEYS */;
INSERT INTO `sms_messages` VALUES (1,'sale','Dear {contact_name},\nThank you for your purchase! Your invoice number is {invoice_number}.\nIf you have any questions or concerns, please don\'t hesitate to reach out to us. We are here to help!\nBest regards,\n{business_name}',NULL,NULL,NULL),(2,'purchase','Dear {contact_name},\nI recently made a purchase from your company and I wanted to thank you for your cooperation and service. My invoice number is {invoice_number} .\nIf you have any questions or concerns regarding my purchase, please don\'t hesitate to contact me. I am here to make sure I have a positive experience with your company.\nBest regards,\n{business_name}',NULL,NULL,NULL),(3,'quotation','Dear {contact_name},\nThank you for your interest in our products. Your quotation number is {quotation_number}.\nPlease let us know if you have any questions or concerns regarding your quotation. We are here to assist you.\nBest regards,\n{business_name}',NULL,NULL,NULL),(4,'payment_received','Dear {contact_name},\nThank you for making your payment. We have received it and it has been processed successfully.\nIf you have any further questions or concerns, please don\'t hesitate to reach out to us. We are always here to help.\nBest regards,\n{business_name}',NULL,NULL,NULL),(5,'payment_sent','Dear {contact_name},\nWe have just sent the payment . We appreciate your prompt attention to this matter and the high level of service you provide.\nIf you need any further information or clarification, please do not hesitate to reach out to us. We are here to help.\nBest regards,\n{business_name}',NULL,NULL,NULL),(6,'subscription_reminder','Hello {client_name},\nThis is a reminder from {business_name} that your subscription will renew automatically on {next_billing_date}. \nPlease ensure your payment method is up-to-date to avoid interruptions.\nThank you!',NULL,NULL,NULL);
/*!40000 ALTER TABLE `sms_messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `subscriptions`
--

DROP TABLE IF EXISTS `subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `subscriptions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `user_id` int(11) NOT NULL,
  `client_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `cycle_type` varchar(192) NOT NULL,
  `total_cycles` int(11) NOT NULL,
  `billing_cycle` varchar(50) NOT NULL,
  `remaining_cycles` int(11) NOT NULL,
  `price_per_cycle` double NOT NULL,
  `price_per_unit` double NOT NULL,
  `quantity` double NOT NULL,
  `next_billing_date` date NOT NULL,
  `status` varchar(192) NOT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp(6) NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `client_id` (`client_id`),
  KEY `product_id` (`product_id`),
  KEY `warehouse_id` (`warehouse_id`),
  CONSTRAINT `sub_client_id` FOREIGN KEY (`client_id`) REFERENCES `clients` (`id`),
  CONSTRAINT `sub_product_id` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`),
  CONSTRAINT `sub_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  CONSTRAINT `sub_warehouse_id` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `subscriptions`
--

LOCK TABLES `subscriptions` WRITE;
/*!40000 ALTER TABLE `subscriptions` DISABLE KEYS */;
/*!40000 ALTER TABLE `subscriptions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tasks`
--

DROP TABLE IF EXISTS `tasks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tasks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(192) NOT NULL,
  `project_id` int(11) NOT NULL,
  `company_id` int(11) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `estimated_hour` varchar(192) DEFAULT NULL,
  `task_progress` varchar(192) DEFAULT NULL,
  `summary` varchar(191) NOT NULL,
  `description` text,
  `status` varchar(192) NOT NULL,
  `priority` varchar(191) NOT NULL,
  `note` text,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `Tasks_project_id` (`project_id`),
  KEY `Tasks_company_id` (`company_id`),
  CONSTRAINT `Tasks_company_id` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`),
  CONSTRAINT `Tasks_project_id` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tasks`
--

LOCK TABLES `tasks` WRITE;
/*!40000 ALTER TABLE `tasks` DISABLE KEYS */;
/*!40000 ALTER TABLE `tasks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfer_details`
--

DROP TABLE IF EXISTS `transfer_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transfer_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_variant_id` int(11) DEFAULT NULL,
  `cost` double NOT NULL,
  `purchase_unit_id` int(11) DEFAULT NULL,
  `TaxNet` double DEFAULT NULL,
  `tax_method` varchar(192) DEFAULT '1',
  `discount` double DEFAULT NULL,
  `discount_method` varchar(192) DEFAULT '1',
  `quantity` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transfer_id` (`transfer_id`),
  KEY `product_id_transfers` (`product_id`),
  KEY `product_variant_id_transfer` (`product_variant_id`),
  KEY `unit_sale_id_transfer` (`purchase_unit_id`),
  CONSTRAINT `product_id_transfers` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`),
  CONSTRAINT `product_variant_id_transfer` FOREIGN KEY (`product_variant_id`) REFERENCES `product_variants` (`id`),
  CONSTRAINT `transfer_id` FOREIGN KEY (`transfer_id`) REFERENCES `transfers` (`id`),
  CONSTRAINT `unit_sale_id_transfer` FOREIGN KEY (`purchase_unit_id`) REFERENCES `units` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfer_details`
--

LOCK TABLES `transfer_details` WRITE;
/*!40000 ALTER TABLE `transfer_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfer_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfer_money`
--

DROP TABLE IF EXISTS `transfer_money`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transfer_money` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `from_account_id` int(11) NOT NULL,
  `to_account_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `amount` double NOT NULL,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `from_account_id` (`from_account_id`),
  KEY `to_account_id` (`to_account_id`),
  CONSTRAINT `from_account_id` FOREIGN KEY (`from_account_id`) REFERENCES `accounts` (`id`),
  CONSTRAINT `to_account_id` FOREIGN KEY (`to_account_id`) REFERENCES `accounts` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfer_money`
--

LOCK TABLES `transfer_money` WRITE;
/*!40000 ALTER TABLE `transfer_money` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfer_money` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transfers`
--

DROP TABLE IF EXISTS `transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `Ref` varchar(192) NOT NULL,
  `date` date NOT NULL,
  `time` time DEFAULT NULL,
  `from_warehouse_id` int(11) NOT NULL,
  `to_warehouse_id` int(11) NOT NULL,
  `items` double NOT NULL,
  `tax_rate` double DEFAULT '0',
  `TaxNet` double DEFAULT '0',
  `discount` double DEFAULT '0',
  `shipping` double DEFAULT '0',
  `GrandTotal` double NOT NULL DEFAULT '0',
  `statut` varchar(192) NOT NULL,
  `notes` text,
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id_transfers` (`user_id`),
  KEY `from_warehouse_id` (`from_warehouse_id`),
  KEY `to_warehouse_id` (`to_warehouse_id`),
  CONSTRAINT `from_warehouse_id` FOREIGN KEY (`from_warehouse_id`) REFERENCES `warehouses` (`id`),
  CONSTRAINT `to_warehouse_id` FOREIGN KEY (`to_warehouse_id`) REFERENCES `warehouses` (`id`),
  CONSTRAINT `user_id_transfers` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transfers`
--

LOCK TABLES `transfers` WRITE;
/*!40000 ALTER TABLE `transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `translations`
--

DROP TABLE IF EXISTS `translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `translations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `locale` varchar(191) NOT NULL,
  `key` varchar(191) NOT NULL,
  `value` text NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp(6) NULL DEFAULT NULL,
  `updated_at` timestamp(6) NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `translations_locale_key_unique` (`locale`,`key`)
) ENGINE=InnoDB AUTO_INCREMENT=22800 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `translations`
--

LOCK TABLES `translations` WRITE;
/*!40000 ALTER TABLE `translations` DISABLE KEYS */;
INSERT INTO `translations` VALUES (1,'Ind','Draft_Created_successfully','Draf berhasil dibuat',0,'2025-06-18 01:49:24.000000','2025-06-18 01:49:24.000000'),(2,'Ind','Draft_Sale_Deleted','Penjualan draf dihapus',0,'2025-06-18 01:49:24.000000','2025-06-18 01:49:24.000000'),(3,'Ind','Inventory_Valuation_Based_on_Average_Cost','Penilaian inventaris berdasarkan biaya rata-rata',0,'2025-06-18 01:49:24.000000','2025-06-18 01:49:24.000000'),(4,'Ind','Payroll','Gaji',0,'2025-06-18 01:49:24.000000','2025-06-18 01:49:24.000000'),(5,'Ind','Transfers_Money','Transfer uang',0,'2025-06-18 01:49:24.000000','2025-06-18 01:49:24.000000'),(6,'Ind','Inventory_Valuation','Penilaian inventaris',0,'2025-06-18 01:49:24.000000','2025-06-18 01:49:24.000000'),(7,'Ind','Deposits_Report','Laporan deposito',0,'2025-06-18 01:49:24.000000','2025-06-18 01:49:24.000000'),(8,'Ind','Expense_Report','Laporan pengeluaran',0,'2025-06-18 01:49:24.000000','2025-06-18 01:49:24.000000'),(9,'Ind','Deposit_Category','Kategori Deposit',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(10,'Ind','Total_Deposits','Total deposit',0,'2025-06-18 01:49:24.000000','2025-06-18 01:49:24.000000'),(11,'Ind','Expense_Category','Kategori Biaya',0,'2025-06-18 01:49:24.000000','2025-06-18 01:49:24.000000'),(12,'Ind','Total_Expenses','Total pengeluaran',0,'2025-06-18 01:49:24.000000','2025-06-18 01:49:24.000000'),(13,'Ind','ASSET_VALUE','NILAI ASET',0,'2025-06-18 01:49:24.000000','2025-06-18 01:49:24.000000'),(14,'Ind','STOCK_ON_HAND','Persediaan di tangan',0,'2025-06-18 01:49:24.000000','2025-06-18 01:49:24.000000'),(15,'Ind','Variant_NAME','Nama Variabel',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(16,'Ind','SKU','SKU',0,'2025-06-18 01:49:24.000000','2025-06-18 01:49:24.000000'),(17,'Ind','ITEM_NAME','Nama barang',0,'2025-06-18 01:49:24.000000','2025-06-18 01:49:24.000000'),(18,'Ind','From_Account','Dari akun',0,'2025-06-18 01:49:24.000000','2025-06-18 01:49:24.000000'),(19,'Ind','To_Account','Ke akun',0,'2025-06-18 01:49:24.000000','2025-06-18 01:49:24.000000'),(20,'Ind','Accounts_cannot_be_the_same','Akun tidak boleh sama',0,'2025-06-18 01:49:24.000000','2025-06-18 01:49:24.000000'),(21,'Ind','CountStock','Hitung Stok',0,'2025-06-18 01:49:24.000000','2025-06-18 01:49:24.000000'),(22,'Ind','Successfully_Generated_Count','Berhasil Membuat Perhitungan',0,'2025-06-18 01:49:24.000000','2025-06-18 01:49:24.000000'),(23,'Ind','Count','Jumlah',0,'2025-06-18 01:49:24.000000','2025-06-18 01:49:24.000000'),(24,'Ind','file','Berkas',0,'2025-06-18 01:49:24.000000','2025-06-18 01:49:24.000000'),(25,'Ind','Accounting','Akuntansi',0,'2025-06-18 01:49:24.000000','2025-06-18 01:49:24.000000'),(26,'Ind','deposit_delete','Hapus Deposit',0,'2025-06-18 01:49:24.000000','2025-06-18 01:49:24.000000'),(27,'Ind','deposit_edit','Edit Deposit',0,'2025-06-18 01:49:24.000000','2025-06-18 01:49:24.000000'),(28,'Ind','deposit_add','Tambah Deposit',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(29,'Ind','deposit_view','Lihat Deposit',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(30,'Ind','expense_add','Tambah Pengeluaran',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(31,'Ind','expense_edit','Edit Pengeluaran',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(32,'Ind','expense_delete','Hapus Pengeluaran',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(33,'Ind','List_Deposit','Daftar Deposit',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(34,'Ind','Create_deposit','Buat Deposit',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(35,'Ind','List_accounts','Daftar Akun',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(36,'Ind','Account','Akun',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(37,'Ind','Choose_Account','Pilih Akun',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(38,'Ind','Deposits','Deposit',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(39,'Ind','account_num','Nomor Akun',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(40,'Ind','Enter_account_num','Masukkan Nomor Akun',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(41,'Ind','account_name','Nama Akun',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(42,'Ind','Enter_account_name','Masukkan Nama Akun',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(43,'Ind','initial_balance','Saldo Awal',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(44,'Ind','Enter_initial_balance','Masukkan Saldo Awal',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(45,'Ind','notes','Catatan',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(46,'Ind','balance','Keseimbangan',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(47,'Ind','Receipt','Kuitansi',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(48,'Ind','Pos_Settings','Pengaturan POS',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(49,'Ind','Note_to_customer','Catatan untuk pelanggan',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(50,'Ind','Show_Note_to_customer','Tunjukkan Catatan kepada pelanggan',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(51,'Ind','Show_barcode','Tampilkan kode batang',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(52,'Ind','Show_Tax_and_Discount','Tampilkan Pajak & Diskon & Pengiriman',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(53,'Ind','Show_Customer','Tampilkan Pelanggan',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(54,'Ind','Show_Email','Tampilkan Email',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(55,'Ind','Show_Phone','Tampilkan Telepon',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(56,'Ind','Show_Address','Tampilkan Alamat',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(57,'Ind','DefaultLanguage','Bahasa Bawaan',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(58,'Ind','footer','catatan kaki',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(59,'Ind','Received_Amount','Jumlah yang Diterima',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(60,'Ind','Paying_Amount','Membayar Jumlah',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(61,'Ind','Change','Mengubah',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(62,'Ind','Paying_amount_is_greater_than_Received_amount','Jumlah pembayaran lebih besar dari jumlah yang diterima',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(63,'Ind','Paying_amount_is_greater_than_Grand_Total','Jumlah pembayaran lebih besar dari total keseluruhan',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(64,'Ind','code_must_be_not_exist_already','kode harus belum ada',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(65,'Ind','You_will_find_your_backup_on','Anda akan menemukan cadangan Anda di',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(66,'Ind','and_save_it_to_your_pc','dan simpan ke pc Anda',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(67,'Ind','Scan_your_barcode_and_select_the_correct_symbology_below','Pindai kode batang Anda dan pilih simbologi yang benar di bawah ini',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(68,'Ind','Scan_Search_Product_by_Code_Name','Pindai/Cari Produk dengan Nama Kode',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(69,'Ind','Paper_size','Ukuran kertas',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(70,'Ind','Clear_Cache','Hapus Cache',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(71,'Ind','Cache_cleared_successfully','Cache berhasil dibersihkan',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(72,'Ind','Failed_to_clear_cache','Gagal menghapus cache',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(73,'Ind','Scan_Barcode','Pemindai kode batang',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(74,'Ind','Please_use_short_name_of_unit','Silakan gunakan nama pendek unit',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(75,'Ind','DefaultCustomer','Pelanggan Default',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(76,'Ind','DefaultWarehouse','Gudang Bawaan',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(77,'Ind','Payment_Gateway','Gerbang pembayaran',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(78,'Ind','SMS_Configuration','Konfigurasi SMS',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(79,'Ind','Gateway','Payment Gateway',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(80,'Ind','Choose_Gateway','Pilih Payment Gateway',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(81,'Ind','sms_send_successfully','Pesan berhasil dikirim',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(82,'Ind','sms_config_invalid','konfigurasi sms salah tidak valid',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(83,'Ind','Remove_Stripe_Key_Secret','Hapus kunci API Stripe',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(84,'Ind','credit_card_account_not_available','Rekening kartu kredit tidak tersedia',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(85,'Ind','Credit_Card_Info','Info Kartu Kredit',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(86,'Ind','developed_by','Dikembangkan oleh',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(87,'Ind','Unit_already_linked_with_sub_unit','Unit sudah terhubung dengan sub unit',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(88,'Ind','Total_Items_Quantity','Total Item dan Kuantitas',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(89,'Ind','Value_by_Cost_and_Price','Nilai berdasarkan Biaya dan Harga',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(90,'Ind','Search_this_table','Cari tabel ini',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(91,'Ind','import_products','Produk impor',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(92,'Ind','Field_optional','Bidang opsional',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(93,'Ind','Download_exemple','Unduh contoh',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(94,'Ind','field_must_be_in_csv_format','Bidang harus dalam format csv',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(95,'Ind','Successfully_Imported','Berhasil Diimpor',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(96,'Ind','file_size_must_be_less_than_1_mega','Ukuran file harus kurang dari 1 mega',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(97,'Ind','Please_follow_the_import_instructions','Harap ikuti petunjuk impor',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(98,'Ind','must_be_exist','unit harus sudah dibuat',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(99,'Ind','Import_Customers','Impor Pelanggan',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(100,'Ind','Import_Suppliers','Pemasok Impor',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(101,'Ind','Recent_Sales','Penjualan Terbaru',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(102,'Ind','Create_Transfer','Buat Transfer',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(103,'Ind','order_products','Item pesanan',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(104,'Ind','Search_Product_by_Code_Name','Cari Produk dengan Kode atau Nama',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(105,'Ind','Reports_payments_Purchase_Return','Melaporkan Pembayaran Pengembalian Pembelian',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(106,'Ind','Reports_payments_Sale_Return','Laporan Pembayaran Retur Penjualan',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(107,'Ind','payments_Sales_Return','Pembayaran retur penjualan',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(108,'Ind','payments_Purchases_Return','Pembayaran pembelian kembali',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(109,'Ind','CreateSaleReturn','Buat Retur Penjualan',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(110,'Ind','EditSaleReturn','Edit Pengembalian Penjualan',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(111,'Ind','SalesReturn','Retur Penjualan',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(112,'Ind','CreatePurchaseReturn','Buat Pengembalian Pembelian',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(113,'Ind','EditPurchaseReturn','Edit Pengembalian Pembelian',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(114,'Ind','PurchasesReturn','Pembelian Kembali',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(115,'Ind','Due','jatuh tempo',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(116,'Ind','Profit','Keuntungan',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(117,'Ind','Revenue','Pendapatan',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(118,'Ind','Sales_today','Penjualan hari ini',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(119,'Ind','People','Orang-orang',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(120,'Ind','Successfully_Created','Berhasil Dibuat',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(121,'Ind','Successfully_Updated','Berhasil diperbaharui',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(122,'Ind','Success','sukses',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(123,'Ind','Failed','Gagal',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(124,'Ind','Warning','Peringatan',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(125,'Ind','Please_fill_the_form_correctly','Harap isi formulir dengan benar',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(126,'Ind','Field_is_required','Bidang wajib diisi',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(127,'Ind','Error','Kesalahan!',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(128,'Ind','you_are_not_authorized','Maaf! Anda tidak berwenang.',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(129,'Ind','Go_back_to_home','Kembali ke beranda',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(130,'Ind','page_not_exist','Maaf! Halaman yang Anda cari tidak ada.',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(131,'Ind','Choose_Status','Pilih status',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(132,'Ind','Choose_Method','Pilih Metode',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(133,'Ind','Choose_Symbology','Pilih simbologi',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(134,'Ind','Choose_Category','Pilih Kategori',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(135,'Ind','Choose_Customer','Pilih Pelanggan',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(136,'Ind','Choose_Supplier','Pilih Pemasok',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(137,'Ind','Choose_Unit_Purchase','Pilih Unit Pembelian',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(138,'Ind','Choose_Sub_Category','Pilih Subkategori',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(139,'Ind','Choose_Brand','Pilih Merek',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(140,'Ind','Choose_Warehouse','Pilih Gudang',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(141,'Ind','Choose_Unit_Sale','Pilih Unit Penjualan',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(142,'Ind','Enter_Product_Cost','Masukkan Biaya Produk',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(143,'Ind','Enter_Stock_alert','Masuk ke Stock alert',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(144,'Ind','Choose_Unit_Product','Pilih Unit Produk',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(145,'Ind','Enter_Product_Price','Masukkan Harga Produk',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(146,'Ind','Enter_Name_Product','Masukkan Nama Produk',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(147,'Ind','Enter_Role_Name','Masukkan Nama Peran',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(148,'Ind','Enter_Role_Description','Masukkan Deskripsi Peran',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(149,'Ind','Enter_name_category','Masukkan Nama kategori',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(150,'Ind','Enter_Code_category','Masukkan Kode kategori',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(151,'Ind','Enter_Name_Brand','Masukkan Nama Merek',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(152,'Ind','Enter_Description_Brand','Masukkan Deskripsi Merek',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(153,'Ind','Enter_Code_Currency','Masukkan Mata Uang Kode',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(154,'Ind','Enter_name_Currency','Masukkan nama Mata uang',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(155,'Ind','Enter_Symbol_Currency','Masukkan Mata Uang Simbol',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(156,'Ind','Enter_Name_Unit','Masukkan Nama Unit',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(157,'Ind','Enter_ShortName_Unit','Masukkan Unit nama pendek',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(158,'Ind','Choose_Base_Unit','Pilih Unit Dudukan',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(159,'Ind','Choose_Operator','Pilih Operator',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(160,'Ind','Enter_Operation_Value','Masukkan Nilai Operasi',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(161,'Ind','Enter_Name_Warehouse','Masukkan Nama Gudang',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(162,'Ind','Enter_Phone_Warehouse','Masukkan Telepon Gudang',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(163,'Ind','Enter_Country_Warehouse','Masukkan Negara Gudang',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(164,'Ind','Enter_City_Warehouse','Masuk kota gudang',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(165,'Ind','Enter_Email_Warehouse','Masukkan email Gudang',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(166,'Ind','Enter_ZipCode_Warehouse','Masukkan Kode Pos Gudang',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(167,'Ind','Choose_Currency','Pilih mata uang',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(168,'Ind','Thank_you_for_your_business','Terima kasih atas bisnis Anda!',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(169,'Ind','Cancel','Membatalkan',0,'2025-06-18 01:49:25.000000','2025-06-18 01:49:25.000000'),(170,'Ind','New_Customer','Pelanggan baru',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(171,'Ind','Incorrect_Login','Login Salah',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(172,'Ind','Successfully_Logged_In','Berhasil Masuk',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(173,'Ind','This_user_not_active','Pengguna ini tidak aktif',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(174,'Ind','SignIn','Masuk',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(175,'Ind','Create_an_account','Buat sebuah akun',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(176,'Ind','Forgot_Password','Tidak ingat kata sandi ?',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(177,'Ind','Email_Address','Alamat email',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(178,'Ind','SignUp','Daftar',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(179,'Ind','Already_have_an_account','Sudah memiliki akun ?',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(180,'Ind','Reset_Password','Setel Ulang Kata Sandi',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(181,'Ind','Failed_to_authenticate_on_SMTP_server','Gagal mengautentikasi di server SMTP',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(182,'Ind','We_cant_find_a_user_with_that_email_addres','Kami tidak dapat menemukan pengguna dengan alamat email itu',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(183,'Ind','We_have_emailed_your_password_reset_link','Kami telah mengirimkan email tautan pengaturan ulang kata sandi Anda',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(184,'Ind','Please_fill_the_Email_Adress','Silahkan isi Alamat Email',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(185,'Ind','Confirm_password','Setujui password',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(186,'Ind','Your_Password_has_been_changed','Kata sandi Anda telah diubah',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(187,'Ind','The_password_confirmation_does_not_match','Konfirmasi kata sandi tidak cocok',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(188,'Ind','This_password_reset_token_is_invalid','Token penyetelan ulang sandi ini tidak valid',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(189,'Ind','Warehouse_report','Laporan gudang',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(190,'Ind','All_Warehouses','Semua Gudang',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(191,'Ind','Expense_List','Daftar Biaya',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(192,'Ind','Expenses','Beban',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(193,'Ind','This_Week_Sales_Purchases','Penjualan & Pembelian Minggu Ini',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(194,'Ind','Top_Selling_Products','Produk Terlaris',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(195,'Ind','View_all','Lihat semua',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(196,'Ind','Payment_Sent_Received','Pembayaran Dikirim & Diterima',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(197,'Ind','Filter','Saring',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(198,'Ind','Invoice_POS','POS Faktur',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(199,'Ind','Invoice','Faktur',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(200,'Ind','Customer_Info','Info Pelanggan',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(201,'Ind','Company_Info','Info perusahaan',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(202,'Ind','Invoice_Info','Info Faktur',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(203,'Ind','Order_Summary','Ringkasan Pesanan',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(204,'Ind','Quote_Info','Info Kutipan',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(205,'Ind','Del','Menghapus',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(206,'Ind','SuppliersPaiementsReport','Laporan Pembayaran Pemasok',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(207,'Ind','Purchase_Info','Beli Info',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(208,'Ind','Supplier_Info','Info Pemasok',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(209,'Ind','Return_Info','info Kembali',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(210,'Ind','Create_Expense','Buat Beban',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(211,'Ind','Details','Rincian',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(212,'Ind','Discount_Method','Metode Diskon',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(213,'Ind','Net_Unit_Cost','Biaya Satuan Net',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(214,'Ind','Net_Unit_Price','Harga Satuan Bersih',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(215,'Ind','Edit_Expense','Edit Biaya',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(216,'Ind','All_Brand','Semua Merek',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(217,'Ind','All_Category','Semua Kategori',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(218,'Ind','ListExpenses','Daftar Biaya',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(219,'Ind','Create_Permission','Buat Izin',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(220,'Ind','Edit_Permission','Edit Izin',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(221,'Ind','Reports_payments_Sales','Laporan pembayaran Penjualan',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(222,'Ind','Reports_payments_Purchases','Melaporkan pembayaran Pembelian',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(223,'Ind','Reports_payments_Return_Customers','Laporan pembayaran Retur Pelanggan',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(224,'Ind','Reports_payments_Return_Suppliers','Laporan pembayaran Kembali Pemasok',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(225,'Ind','Expense_Deleted','Pengeluaran ini telah dihapus',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(226,'Ind','Expense_Updated','Biaya ini telah Diperbarui',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(227,'Ind','Expense_Created','Pengeluaran Ini Telah Dibuat',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(228,'Ind','DemoVersion','Anda tidak dapat melakukan ini di versi demo',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(229,'Ind','OrderStatistics','Statistik Penjualan',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(230,'Ind','AlreadyAdd','Produk Ini Sudah Ditambahkan !!',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(231,'Ind','AddProductToList','Silakan Tambahkan Produk Ke Daftar !!',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(232,'Ind','AddQuantity','Tambahkan jumlah Detail !!',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(233,'Ind','InvalidData','Data Tidak Valid !!',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(234,'Ind','LowStock','kuantitas melebihi kuantitas yang tersedia dalam stok',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(235,'Ind','WarehouseIdentical','Kedua gudang itu tidak mungkin sama !!',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(236,'Ind','VariantDuplicate','Varian Ini Duplikat !!',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(237,'Ind','Filesize','Ukuran file',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(238,'Ind','GenerateBackup','Hasilkan Cadangan',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(239,'Ind','BackupDatabase','Database cadangan',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(240,'Ind','Backup','Cadangan',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(241,'Ind','Paid','Dibayar',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(242,'Ind','Unpaid','Belum dibayar',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(243,'Ind','Today','Hari ini',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(244,'Ind','Income','Pendapatan',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(245,'Ind','Sale','Penjualan',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(246,'Ind','Actif','Aktif',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(247,'Ind','Inactif','Tidak aktif',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(248,'Ind','Customers','Pelanggan',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(249,'Ind','Phone','Telepon',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(250,'Ind','SearchByPhone','Cari lewat Telepon',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(251,'Ind','Suppliers','Pemasok',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(252,'Ind','Quotations','Kutipan',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(253,'Ind','Sales','Penjualan',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(254,'Ind','Purchases','Pembelian',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(255,'Ind','Returns','Kembali',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(256,'Ind','Settings','Pengaturan',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(257,'Ind','SystemSettings','Pengaturan sistem',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(258,'Ind','Users','Pengguna',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(259,'Ind','GroupPermissions','Izin Grup',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(260,'Ind','Currencies','Mata Uang',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(261,'Ind','Warehouses','Gudang',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(262,'Ind','Units','Unit',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(263,'Ind','UnitsPrchases',' Pembelian Unit',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(264,'Ind','UnitsSales','Unit Penjualan',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(265,'Ind','Reports','Laporan',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(266,'Ind','PaymentsReport','Laporan Pembayaran',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(267,'Ind','PaymentsPurchases','Pembelian Pembayaran',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(268,'Ind','PaymentsSales','Pembayaran Penjualan',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(269,'Ind','ProfitandLoss','Laba rugi',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(270,'Ind','WarehouseStockChart','Grafik Stok Gudang',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(271,'Ind','SalesReport','Laporan penjualan',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(272,'Ind','PurchasesReport','Laporan Pembelian',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(273,'Ind','CustomersReport','Laporan Pelanggan',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(274,'Ind','SuppliersReport','Laporan Pemasok',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(275,'Ind','SupplierReport','Laporan Pemasok',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(276,'Ind','DailySalesData','Data Penjualan Harian',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(277,'Ind','DailyPurchasesData','Data Pembelian Harian',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(278,'Ind','Dernièrescinqrecords','Lima rekor terakhir',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(279,'Ind','Filters','Filter',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(280,'Ind','date','tanggal',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(281,'Ind','Reference','Referensi',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(282,'Ind','Supplier','Pemasok',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(283,'Ind','PaymentStatus','Status pembayaran',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(284,'Ind','Customer','Pelanggan',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(285,'Ind','CustomerCode','Kode pelanggan',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(286,'Ind','Status','Status',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(287,'Ind','SupplierCode','Kode penyuplai',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(288,'Ind','Categorie','Kategori',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(289,'Ind','Categories','Kategori',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(290,'Ind','StockTransfers','Transfer Saham',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(291,'Ind','StockManagement','Manajemen Stok',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(292,'Ind','dashboard','Dasbor',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(293,'Ind','Products','Produk',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(294,'Ind','productsList','Daftar produk',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(295,'Ind','ProductManagement','Manajemen Produk',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(296,'Ind','ProductQuantityAlerts','Peringatan Kuantitas Produk',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(297,'Ind','CodeProduct','Kode Produk',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(298,'Ind','ProductTax','Pajak Produk',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(299,'Ind','SubCategorie','Subkategori',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(300,'Ind','Name_product','Penunjukan',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(301,'Ind','StockAlert','Peringatan Stok',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(302,'Ind','warehouse','gudang',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(303,'Ind','Tax','Pajak',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(304,'Ind','BuyingPrice','Harga beli',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(305,'Ind','SellPrice','Harga jual',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(306,'Ind','Quantity','Kuantitas',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(307,'Ind','UnitSale','Penjualan Unit',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(308,'Ind','UnitPurchase','Pembelian Unit',0,'2025-06-18 01:49:26.000000','2025-06-18 01:49:26.000000'),(309,'Ind','ManagementCurrencies','Manajemen Mata Uang',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(310,'Ind','CurrencyCode','Kode mata uang',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(311,'Ind','CurrencyName','Nama Mata Uang',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(312,'Ind','Symbol','Simbol',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(313,'Ind','All','Semua',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(314,'Ind','EditProduct','Edit Produk',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(315,'Ind','SearchByCode','Cari berdasarkan Kode',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(316,'Ind','SearchByName','Cari berdasarkan nama',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(317,'Ind','ProductDetails','Rincian Produk',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(318,'Ind','CustomerName','Nama Pelanggan',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(319,'Ind','CustomerManagement','Manajemen pelanggan',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(320,'Ind','Add','Membuat',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(321,'Ind','Edit','Edit',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(322,'Ind','Close','Menutup',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(323,'Ind','PleaseSelect','Silahkan pilih',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(324,'Ind','Action','Tindakan',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(325,'Ind','Email','Surel',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(326,'Ind','EditCustomer','Edit Pelanggan',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(327,'Ind','AddCustomer','Buat Pelanggan',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(328,'Ind','Country','Negara',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(329,'Ind','City','Kota',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(330,'Ind','Adress','Alamat',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(331,'Ind','CustomerDetails','detil pelanggan',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(332,'Ind','CustomersList','Daftar Pelanggan',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(333,'Ind','SupplierName','nama pemasok',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(334,'Ind','SuppliersManagement','Manajemen Pemasok',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(335,'Ind','SupplierDetails','Detail Pemasok',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(336,'Ind','QuotationsManagement','Manajemen Kutipan',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(337,'Ind','SubTotal','Subtotal',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(338,'Ind','MontantReste','Jumlah tersisa',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(339,'Ind','complete','lengkap',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(340,'Ind','EnAttendant','tertunda',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(341,'Ind','Recu','Diterima',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(342,'Ind','partial','Sebagian',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(343,'Ind','Retournee','Kembali',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(344,'Ind','DetailQuote','Detail kutipan',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(345,'Ind','EditQuote','Edit Kutipan',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(346,'Ind','CreateSale','Buat Penjualan',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(347,'Ind','DownloadPdf','Unduh PDF',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(348,'Ind','QuoteEmail','Kutipan Terkirim di Email',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(349,'Ind','DeleteQuote','Hapus Kutipan',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(350,'Ind','AddQuote','Buat Kutipan',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(351,'Ind','SelectProduct','Pilih Produk',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(352,'Ind','ProductCodeName','Produk (Kode - Nama)',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(353,'Ind','Price','Harga',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(354,'Ind','CurrentStock','persediaan',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(355,'Ind','Total','Total',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(356,'Ind','Num','N°',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(357,'Ind','Unitcost','Biaya unit',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(358,'Ind','to','ke',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(359,'Ind','Subject','Subyek',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(360,'Ind','Message','Pesan',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(361,'Ind','EmailCustomer','Email Pelanggan',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(362,'Ind','Sent','Terkirim',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(363,'Ind','Quote','Kutipan',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(364,'Ind','Hello','Halo',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(365,'Ind','AttachmentQuote','Silakan temukan lampiran untuk Quotation Anda',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(366,'Ind','AddProducts','Tambahkan Produk ke Daftar Pesanan',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(367,'Ind','SelectWarehouse','Pilih gudang',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(368,'Ind','SelectCustomer','silahkan Pilih Pelanggan',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(369,'Ind','SalesManagement','Manajemen penjualan',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(370,'Ind','QtyBack','Kuantitas Kembali',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(371,'Ind','TotalReturn','Total Pengembalian',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(372,'Ind','Amount','Jumlah',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(373,'Ind','SaleDetail','Detail penjualan',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(374,'Ind','EditSale','Edit Obral',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(375,'Ind','AddSale','Buat Penjualan',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(376,'Ind','ShowPayment','Tunjukkan Pembayaran',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(377,'Ind','AddPayment','Buat Pembayaran',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(378,'Ind','EditPayment','Edit Pembayaran',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(379,'Ind','EmailSale','Kirim Obral melalui Email',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(380,'Ind','DeleteSale','Hapus Obral',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(381,'Ind','ModePaiement','Dibayar oleh',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(382,'Ind','Paymentchoice','Pilihan pembayaran',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(383,'Ind','Note','Catatan',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(384,'Ind','PaymentComplete','Pembayaran selesai!',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(385,'Ind','PurchasesManagement','Manajemen Pembelian',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(386,'Ind','Ordered','Dipesan',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(387,'Ind','DeletePurchase','Hapus Pembelian',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(388,'Ind','EmailPurchase','Kirim Pembelian melalui Email',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(389,'Ind','EditPurchase','Edit Pembelian',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(390,'Ind','PurchaseDetail','Detail pembelian',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(391,'Ind','AddPurchase','Buat Pembelian',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(392,'Ind','EmailSupplier','Email Pemasok',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(393,'Ind','PurchaseInvoice','Membeli pembayaran',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(394,'Ind','PurchasesInvoicesData','Membeli data pembayaran',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(395,'Ind','SalesInvoice','Pembayaran penjualan',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(396,'Ind','SalesInvoicesData','Data pembayaran penjualan',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(397,'Ind','UserManagement','manajemen pengguna',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(398,'Ind','Firstname','Nama depan',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(399,'Ind','lastname','Nama keluarga',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(400,'Ind','username','Nama pengguna',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(401,'Ind','password','Kata sandi',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(402,'Ind','Newpassword','Kata sandi baru',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(403,'Ind','ChangeAvatar','Mengubah avatar',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(404,'Ind','LeaveBlank','Harap kosongkan bidang ini jika Anda belum mengubahnya',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(405,'Ind','type','Tipe',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(406,'Ind','UserPermissions','Izin Pengguna',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(407,'Ind','RoleName','Wewenang',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(408,'Ind','RoleDescription','Deskripsi peran',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(409,'Ind','AddPermissions','Buat Izin',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(410,'Ind','View','Melihat',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(411,'Ind','NewAdjustement','Penyesuaian Baru',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(412,'Ind','EditAdjustement','Edit Penyesuaian',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(413,'Ind','CannotSubstraction','Anda tidak dapat mengurangi produk yang memiliki stok 0',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(414,'Ind','Addition','Tambahan',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(415,'Ind','Subtraction','Pengurangan',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(416,'Ind','profil','profil',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(417,'Ind','logout','keluar',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(418,'Ind','PurchaseAlreadyPaid','Anda tidak dapat mengubah karena Pembelian ini sudah dibayar',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(419,'Ind','SaleAlreadyPaid','Anda tidak dapat mengubah karena Obral ini sudah dibayar',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(420,'Ind','ReturnAlreadyPaid','Anda tidak dapat mengubah karena Pengembalian ini sudah dibayar',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(421,'Ind','QuoteAlready','Kutipan ini sudah menghasilkan penjualan',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(422,'Ind','AddProduct','Buat produk',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(423,'Ind','QuotationComplete','Kutipan Ini Lengkap',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(424,'Ind','SiteConfiguration','Konfigurasi Situs',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(425,'Ind','Language','Bahasa',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(426,'Ind','DefaultCurrency','Mata Uang Default',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(427,'Ind','LoginCaptcha','Masuk Captcha',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(428,'Ind','DefaultEmail','Default Email',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(429,'Ind','SiteName','Nama situs',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(430,'Ind','ChangeLogo','Ubah Logo',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(431,'Ind','SMTPConfiguration','Konfigurasi SMTP',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(432,'Ind','HOST','TUAN RUMAH',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(433,'Ind','PORT','PELABUHAN',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(434,'Ind','encryption','Enkripsi',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(435,'Ind','SMTPIncorrect','Konfigurasi SMTP Salah',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(436,'Ind','PaymentsReturns','Pembayaran Kembali',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(437,'Ind','ReturnsInvoices','Mengembalikan Faktur',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(438,'Ind','ReturnsInvoicesData','Mengembalikan Data Faktur',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(439,'Ind','ShowAll','Tampilkan semua catatan dari semua Pengguna',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(440,'Ind','Discount','Diskon',0,'2025-06-18 01:49:27.000000','2025-06-18 01:49:27.000000'),(441,'Ind','OrderTax','Pajak Pesanan',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(442,'Ind','Shipping','pengiriman',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(443,'Ind','CompanyName','Nama Perusahaan',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(444,'Ind','CompanyPhone','Telepon Perusahaan',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(445,'Ind','CompanyAdress','Alamat perusahaan',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(446,'Ind','Code','Kode',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(447,'Ind','image','gambar',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(448,'Ind','Printbarcode','Cetak kode batang',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(449,'Ind','ReturnsCustomers','Mengembalikan Pelanggan',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(450,'Ind','ReturnsSuppliers','Pengembalian Pemasok',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(451,'Ind','FactureReturnCustomers','Kembalikan Faktur Pelanggan',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(452,'Ind','FactureReturnSuppliers','Faktur Pemasok Kembali',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(453,'Ind','NodataAvailable','Tidak ada data yang tersedia',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(454,'Ind','ProductImage','gambar produk',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(455,'Ind','Barcode','Barcode',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(456,'Ind','pointofsales','titik Penjualan',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(457,'Ind','CustomUpload','Unggah Ubahsuaian',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(458,'Ind','pointofsaleManagement','Point of Sale Management',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(459,'Ind','Adjustment','Pengaturan',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(460,'Ind','Updat','Memperbarui',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(461,'Ind','Reset','Setel ulang',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(462,'Ind','print','Mencetak',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(463,'Ind','SearchByEmail','Cari Melalui Email',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(464,'Ind','ChooseProduct','Choose Product',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(465,'Ind','Qty','Jml',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(466,'Ind','Items','Item',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(467,'Ind','AmountHT','Jumlah',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(468,'Ind','AmountTTC','jumlah total',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(469,'Ind','PleaseSelectSupplier','Silakan Pilih Pemasok',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(470,'Ind','PleaseSelectStatut','Silakan Pilih Status',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(471,'Ind','PayeBy','Dibayar oleh',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(472,'Ind','ChooseWarehouse','Pilih Gudang',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(473,'Ind','payNow','Bayar sekarang',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(474,'Ind','ListofCategory','Daftar Kategori',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(475,'Ind','Description','Deskripsi',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(476,'Ind','submit','Kirimkan',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(477,'Ind','ProblemCreatingThisInvoice','Terjadi masalah saat membuat Faktur ini. Silakan coba lagi',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(478,'Ind','ProblemPayment','Ada masalah pembayaran. Silakan coba lagi.',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(479,'Ind','IncomeExpenses','Pendapatan & Beban',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(480,'Ind','dailySalesPurchases','Penjualan & Pembelian Harian',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(481,'Ind','ProductsExpired','Produk Kedaluwarsa',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(482,'Ind','ListofBrand','Daftar Merek',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(483,'Ind','CreateAdjustment','Buat Penyesuaian',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(484,'Ind','Afewwords','Beberapa kata ...',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(485,'Ind','UserImage','Gambar Pengguna',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(486,'Ind','UpdateProduct','Perbarui Produk',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(487,'Ind','Brand','Merek',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(488,'Ind','BarcodeSymbology','Simbologi Barcode',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(489,'Ind','ProductCost','Biaya Produk',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(490,'Ind','ProductPrice','Harga Produk',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(491,'Ind','UnitProduct','Produk Satuan',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(492,'Ind','TaxMethod','Metode Perpajakan',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(493,'Ind','MultipleImage','Beberapa Gambar',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(494,'Ind','ProductHasMultiVariants','Produk Memiliki Banyak Varian',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(495,'Ind','ProductHasPromotion','Produk Memiliki Promosi',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(496,'Ind','PromotionStart','Promosi Mulai',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(497,'Ind','PromotionEnd','Promosi Berakhir',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(498,'Ind','PromotionPrice','Harga promosi',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(499,'Ind','Cost','Biaya',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(500,'Ind','Unit','Satuan',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(501,'Ind','ProductVariant','Variasi Produk',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(502,'Ind','Variant','Varian',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(503,'Ind','UnitPrice','Patokan harga',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(504,'Ind','CreateReturnCustomer','Buat Pelanggan Kembali',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(505,'Ind','EditReturnCustomer','Edit Pelanggan Kembali',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(506,'Ind','CreateReturnSupplier','Buat Pemasok Pengembalian',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(507,'Ind','Documentation','Dokumentasi',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(508,'Ind','EditReturnSupplier','Edit Pemasok Pengembalian',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(509,'Ind','FromWarehouse','Dari Gudang',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(510,'Ind','ToWarehouse','Ke Gudang',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(511,'Ind','EditTransfer','Edit Transfer',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(512,'Ind','TransferDetail','Transfer Detail',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(513,'Ind','Pending','tertunda',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(514,'Ind','Received','Diterima',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(515,'Ind','PermissionsManager','Manajemen Izin',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(516,'Ind','BrandManager','Merek',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(517,'Ind','BrandImage','Citra Merek',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(518,'Ind','BrandName','Nama merk',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(519,'Ind','BrandDescription','Deskripsi Merek',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(520,'Ind','BaseUnit','Unit dasar',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(521,'Ind','ManagerUnits','Manajemen Unit',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(522,'Ind','OperationValue','Nilai Operasi',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(523,'Ind','Operator','Operator',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(524,'Ind','Top5Products','Lima Produk Teratas',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(525,'Ind','Last5Sales','Lima Penjualan terakhir',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(526,'Ind','ListAdjustments','Penyesuaian Daftar',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(527,'Ind','ListTransfers','Daftar Transfer',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(528,'Ind','CreateTransfer','Buat Transfer',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(529,'Ind','OrdersManager','Manajemen Pesanan',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(530,'Ind','ListQuotations','Daftar Kutipan',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(531,'Ind','ListPurchases','Daftar Pembelian',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(532,'Ind','ListSales','Daftar Penjualan',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(533,'Ind','ListReturns','Daftar Pengembalian',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(534,'Ind','PeopleManager','Manajemen Orang',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(535,'Ind','Delete_Title','Apakah kamu yakin',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(536,'Ind','Delete_Text','Anda tidak akan dapat mengembalikan ini!',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(537,'Ind','Delete_confirmButtonText','Ya, hapus!',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(538,'Ind','Delete_cancelButtonText','Membatalkan',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(539,'Ind','Delete_Deleted','Dihapus!',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(540,'Ind','Delete_Failed','Gagal!',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(541,'Ind','Delete_Therewassomethingwronge','Ada yang salah',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(542,'Ind','SendEmail','Email Berhasil dikirim',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(543,'Ind','erroSale','penjualan ini sudah ditautkan dengan Return!',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(544,'Ind','ReturnManagement','Manajemen Pengembalian',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(545,'Ind','ReturnDetail','detail pengembalian',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(546,'Ind','EditReturn','Edit Kembali',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(547,'Ind','AddReturn','Buat Pengembalian',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(548,'Ind','EmailReturn','Kirim Pengembalian melalui Email',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(549,'Ind','DeleteReturn','Hapus Kembali',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(550,'Ind','Retoursurcharge','Biaya Tambahan Pengembalian',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(551,'Ind','Laivrison','pengiriman',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(552,'Ind','SelectSale','Pilih Sale',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(553,'Ind','ZeroPardefault','Anda dapat menghapus item atau mengatur kuantitas dikembalikan ke nol jika tidak dikembalikan',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(554,'Ind','Return','Kembali',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(555,'Ind','Purchase','Membeli',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(556,'Ind','TotalSales','Total Penjualan',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(557,'Ind','TotalPurchases','Jumlah Pembelian',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(558,'Ind','TotalReturns','Total Pengembalian',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(559,'Ind','PaiementsNet','Pembayaran Bersih',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(560,'Ind','PaiementsSent','Paiements Sent',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(561,'Ind','PaiementsReceived','Pembayaran diterima',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(562,'Ind','Recieved','Diterima',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(563,'Ind','ProductCode','Kode',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(564,'Ind','ProductName','Produk',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(565,'Ind','AlertQuantity','Kuantitas Peringatan',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(566,'Ind','TotalProducts','Total Produk',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(567,'Ind','TotalQuantity','Jumlah total',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(568,'Ind','TopCustomers','Lima Pelanggan Teratas',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(569,'Ind','TotalAmount','Jumlah total',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(570,'Ind','TotalPaid','Total Dibayar',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(571,'Ind','CustomerSalesReport','Laporan Penjualan Pelanggan',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(572,'Ind','CustomerPaiementsReport','Laporan Pembayaran Pelanggan',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(573,'Ind','CustomerQuotationsReport','Laporan Kutipan Pelanggan',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(574,'Ind','Payments','Pembayaran',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(575,'Ind','TopSuppliers','Lima Pemasok Teratas',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(576,'Ind','SupplierPurchasesReport','Laporan Pembelian Pemasok',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(577,'Ind','SupplierPaiementsReport','Laporan Pembayaran Pemasok',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(578,'Ind','Name','Nama',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(579,'Ind','ManagementWarehouse','Manajemen Gudang',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(580,'Ind','ZipCode','Kode Pos',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(581,'Ind','managementCategories','Manajemen kategori',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(582,'Ind','Codecategorie','Kategori kode',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(583,'Ind','Namecategorie','Kategori nama',0,'2025-06-18 01:49:28.000000','2025-06-18 01:49:28.000000'),(584,'Ind','Parentcategorie','Kategori Induk',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(585,'Ind','managementTax','Manajemen pajak',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(586,'Ind','TaxName','Nama Pajak',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(587,'Ind','TaxRate','Persentase pajak',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(588,'Ind','managementUnitPurchases','Pembelian Unit',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(589,'Ind','managementUnitSales','Unit penjualan',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(590,'Ind','ShortName','Nama pendek',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(591,'Ind','PleaseSelectThesebeforeaddinganyproduct','Harap Pilih Ini sebelum menambahkan produk apa pun',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(592,'Ind','StockAdjustement','Penyesuaian Stok',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(593,'Ind','PleaseSelectWarehouse','Pilih gudang sebelum memilih produk apa pun',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(594,'Ind','StockTransfer','Transfer Saham',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(595,'Ind','SelectPeriod','Pilih Periode',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(596,'Ind','ThisYear','Tahun ini',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(597,'Ind','ThisToday','Hari Ini',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(598,'Ind','ThisMonth','Bulan ini',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(599,'Ind','ThisWeek','Minggu ini',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(600,'Ind','AdjustmentDetail','Detail Penyesuaian',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(601,'Ind','ActivateUser','Pengguna Ini Telah Diaktifkan',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(602,'Ind','DisActivateUser','Pengguna Ini Telah Dinonaktifkan',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(603,'Ind','NotFound','Halaman tidak ditemukan.',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(604,'Ind','oops','kesalahan! Halaman tidak ditemukan.',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(605,'Ind','couldNotFind','Kami tidak dapat menemukan halaman yang Anda cari. Sementara itu, Anda mungkin',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(606,'Ind','ReturnDashboard','kembali ke dasbor',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(607,'Ind','hrm','HRM',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(608,'Ind','Employees','Para karyawan',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(609,'Ind','Attendance','Kehadiran',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(610,'Ind','Leave_request','Tinggalkan Permintaan',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(611,'Ind','Leave_type','Tinggalkan Jenis',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(612,'Ind','Company','Perusahaan',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(613,'Ind','Departments','Departemen',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(614,'Ind','Designations','sebutan',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(615,'Ind','Office_Shift','Pergeseran Kantor',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(616,'Ind','Holidays','Liburan',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(617,'Ind','Enter_Company_Name','Masukkan nama perusahaan',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(618,'Ind','Enter_email_address','Masukkan alamat email',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(619,'Ind','Enter_Company_Phone','Masukkan telepon perusahaan',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(620,'Ind','Enter_Company_Country','Masukkan negara perusahaan',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(621,'Ind','Created_in_successfully','Berhasil dibuat',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(622,'Ind','Updated_in_successfully','Berhasil diperbarui',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(623,'Ind','Deleted_in_successfully','Berhasil dihapus',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(624,'Ind','department','Departemen',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(625,'Ind','Enter_Department_Name','Masukkan nama departemen',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(626,'Ind','Choose_Company','Pilih Perusahaan',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(627,'Ind','Department_Head','Kepala Departemen',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(628,'Ind','Choose_Department_Head','Pilih Kepala Departemen',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(629,'Ind','Enter_Shift_name','Masukkan nama Shift',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(630,'Ind','Monday_In','Monday In',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(631,'Ind','Monday_Out','Monday Out',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(632,'Ind','Tuesday_In','Tuesday In',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(633,'Ind','tuesday_out','tuesday Out',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(634,'Ind','wednesday_in','Wednesday In',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(635,'Ind','wednesday_out','Wednesday Out',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(636,'Ind','thursday_in','Thursday In',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(637,'Ind','thursday_out','Thursday Out',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(638,'Ind','friday_in','Friday In',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(639,'Ind','friday_out','Friday Out',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(640,'Ind','saturday_in','Saturday In',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(641,'Ind','saturday_out','Saturday Out',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(642,'Ind','sunday_in','Sunday In',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(643,'Ind','sunday_out','Sunday Out',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(644,'Ind','Holiday','Liburan',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(645,'Ind','Enter_title','Masukkan judul',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(646,'Ind','title','judul',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(647,'Ind','start_date','Mulai tanggal',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(648,'Ind','Enter_Start_date','Masukkan tanggal mulai',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(649,'Ind','Finish_Date','Tanggal selesai',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(650,'Ind','Enter_Finish_date','Masukkan tanggal selesai',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(651,'Ind','Please_provide_any_details','Harap berikan detail apa pun',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(652,'Ind','Attendances','Kehadiran',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(653,'Ind','Enter_Attendance_date','Masukkan tanggal kehadiran',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(654,'Ind','Time_In','Time In',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(655,'Ind','Time_Out','Time Out',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(656,'Ind','Choose_Employee','Pilih Karyawan',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(657,'Ind','Employee','Karyawan',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(658,'Ind','Work_Duration','Lama pengerjaan',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(659,'Ind','remaining_leaves_are_insufficient','Daun yang tersisa tidak mencukupi',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(660,'Ind','Days','Hari',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(661,'Ind','Choose_leave_type','Pilih jenis cuti',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(662,'Ind','Leave_Reason','Tinggalkan Alasan',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(663,'Ind','Enter_Reason_Leave','Masuk Alasan Keluar',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(664,'Ind','Add_Employee','Tambahkan Karyawan',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(665,'Ind','Enter_FirstName','Masukkan Nama Depan',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(666,'Ind','Enter_LastName','Masukkan Nama Belakang',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(667,'Ind','Gender','Jenis kelamin',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(668,'Ind','Choose_Gender','Pilih Jenis Kelamin',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(669,'Ind','Enter_Birth_date','Masukkan tanggal lahir',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(670,'Ind','Birth_date','Tanggal lahir',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(671,'Ind','Enter_Country','Masukkan Negara',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(672,'Ind','Enter_Phone_Number','Masukkan nomor telepon',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(673,'Ind','joining_date','Tanggal Bergabung',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(674,'Ind','Enter_joining_date','Masukkan tanggal bergabung',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(675,'Ind','Choose_Designation','Pilih Penunjukan',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(676,'Ind','Designation','Penamaan',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(677,'Ind','Choose_Office_Shift','Pilih Shift Kantor',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(678,'Ind','Enter_Leaving_Date','Masukkan Tanggal Keluar',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(679,'Ind','Leaving_Date','Tanggal Keluar',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(680,'Ind','Annual_Leave','Cuti tahunan',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(681,'Ind','Enter_Annual_Leave','Masuk Cuti Tahunan',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(682,'Ind','Remaining_leave','Sisa cuti',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(683,'Ind','Employee_Details','Detail Karyawan',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(684,'Ind','Basic_Information','Informasi dasar',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(685,'Ind','Family_status','Status keluarga',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(686,'Ind','Choose_Family_status','Pilih status Keluarga',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(687,'Ind','Employment_type','Jenis Pekerjaan',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(688,'Ind','Select_Employment_type','Pilih jenis Pekerjaan',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(689,'Ind','Enter_City','Masukkan Kota',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(690,'Ind','Province','Propinsi',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(691,'Ind','Enter_Province','Masuk Provinsi',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(692,'Ind','Enter_Address','Masukkan alamat',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(693,'Ind','Enter_Zip_code','Masukkan kode pos',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(694,'Ind','Zip_code','Kode Pos',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(695,'Ind','Hourly_rate','Tarif per jam',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(696,'Ind','Enter_Hourly_rate','Masukkan tarif Per Jam',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(697,'Ind','Basic_salary','Gaji pokok',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(698,'Ind','Enter_Basic_salary','Masukkan Gaji Pokok',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(699,'Ind','Social_Media','Media sosial',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(700,'Ind','Skype','Skype',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(701,'Ind','Enter_Skype','Masuk ke Skype',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(702,'Ind','Facebook','Facebook',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(703,'Ind','Enter_Facebook','Masuk ke Facebook',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(704,'Ind','WhatsApp','WhatsApp',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(705,'Ind','Enter_WhatsApp','Masuk ke WhatsApp',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(706,'Ind','LinkedIn','LinkedIn',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(707,'Ind','Enter_LinkedIn','Masuk ke LinkedIn',0,'2025-06-18 01:49:29.000000','2025-06-18 01:49:29.000000'),(708,'Ind','Twitter','Twitter',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(709,'Ind','Enter_Twitter','Masuk ke Twitter',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(710,'Ind','Experiences','Pengalaman',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(711,'Ind','bank_account','akun bank',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(712,'Ind','Company_Name','Nama perusahaan',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(713,'Ind','Location','Lokasi',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(714,'Ind','Enter_location','Masukkan lokasi',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(715,'Ind','Enter_Description','Masukkan Deskripsi',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(716,'Ind','Bank_Name','Nama Bank',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(717,'Ind','Enter_Bank_Name','Masukkan Nama Bank',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(718,'Ind','Bank_Branch','Cabang Bank',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(719,'Ind','Enter_Bank_Branch','Masuk Cabang Bank',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(720,'Ind','Bank_Number','Nomor Bank',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(721,'Ind','Enter_Bank_Number','Masukkan Nomor Bank',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(722,'Ind','Assigned_warehouses','gudang yang ditugaskan',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(723,'Ind','Top_customers','Pelanggan teratas',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(724,'Ind','Attachment','Lampiran',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(725,'Ind','view_employee','lihat karyawan',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(726,'Ind','edit_employee','edit karyawan',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(727,'Ind','delete_employee','hapus karyawan',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(728,'Ind','Created_by','Ditambahkan oleh',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(729,'Ind','Add_product_IMEI_Serial_number','Tambahkan IMEI/Nomor Seri produk',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(730,'Ind','Product_Has_Imei_Serial_number','Produk Memiliki Imei/Nomor Seri',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(731,'Ind','IMEI_SN','IMEI/SN',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(732,'Ind','Shipments','pengiriman',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(733,'Ind','delivered_to','Dikirim ke',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(734,'Ind','shipment_ref','Referensi Pengiriman',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(735,'Ind','sale_ref','Referensi Penjualan',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(736,'Ind','Edit_Shipping','Sunting Pengiriman',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(737,'Ind','Packed','Penuh sesak',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(738,'Ind','Shipped','Dikirim',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(739,'Ind','Delivered','Terkirim',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(740,'Ind','Cancelled','Dibatalkan',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(741,'Ind','Shipping_status','Status pengiriman',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(742,'Ind','Users_Report','Laporan Pengguna',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(743,'Ind','stock_report','Laporan Stok',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(744,'Ind','Total_quotations','Jumlah Kutipan',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(745,'Ind','Total_return_sales','Jumlah penjualan retur',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(746,'Ind','Total_return_purchases','Jumlah pengembalian pembelian',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(747,'Ind','Total_transfers','Jumlah transfer',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(748,'Ind','Total_adjustments','Penyesuaian total',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(749,'Ind','User_report','Laporan Pengguna',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(750,'Ind','Current_stock','Saham saat ini',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(751,'Ind','product_name','Nama Produk',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(752,'Ind','Total_Customers_Due','Jumlah Hutang',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(753,'Ind','Total_Suppliers_Due','Jumlah Hutang',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(754,'Ind','Some_warehouses','Beberapa Gudang',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(755,'Ind','Product_Cost','Biaya Produk',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(756,'Ind','sms_settings','Pengaturan SMS',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(757,'Ind','mail_settings','Pengaturan Surat',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(758,'Ind','Nexmo_SMS','Nexmo SMS',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(759,'Ind','TWILIO_SMS','TWILIO SMS',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(760,'Ind','Default_SMS_Gateway','Gerbang SMS Standar',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(761,'Ind','module_settings','Pengaturan Modul',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(762,'Ind','Module_enabled_success','Modul berhasil diaktifkan',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(763,'Ind','Module_Disabled_success','Modul berhasil Dinonaktifkan',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(764,'Ind','update_settings','Perbarui Pengaturan',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(765,'Ind','Please_Upload_the_Correct_Module','Silakan Unggah Modul yang Benar',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(766,'Ind','Uploaded_Success','Berhasil diunggah',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(767,'Ind','Customer_details','detil pelanggan',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(768,'Ind','Edit_Customer','Sunting Pelanggan',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(769,'Ind','Delete_Customer','Hapus Pelanggan',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(770,'Ind','Pay_Due','membayar Jatuh tempo',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(771,'Ind','Paying_amount_is_greater_than_Total_Due','Jumlah pembayaran lebih besar dari Total Hutang',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(772,'Ind','Customer_Invoice','Faktur pelanggan',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(773,'Ind','This_Product_Not_For_Selling','Produk Ini Bukan Untuk Dijual',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(774,'Ind','Welcome_to_your_Dashboard','Selamat datang di Dasbor Anda',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(775,'Ind','Total_Payable','Total yang harus dibayar',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(776,'Ind','Choose_Sale_Ref','Pilih Ref Penjualan',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(777,'Ind','Please_Select_Sale','Silahkan Pilih Dijual',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(778,'Ind','list_product_returns','daftar pengembalian produk',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(779,'Ind','Qty_return','qty kembali',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(780,'Ind','Choose_Purchase_Ref','Pilih Referensi Pembelian',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(781,'Ind','Purchase_Ref','Referensi Pembelian',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(782,'Ind','please_select_purchase','Silahkan Pilih Pembelian',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(783,'Ind','qty_return_is_greater_than_qty_purchased','Qty return lebih besar dari Qty yang dibeli',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(784,'Ind','qty_return_is_greater_than_qty_sold','Qty return lebih besar dari Qty yang terjual',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(785,'Ind','Quantity_sold','Qty terjual',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(786,'Ind','qty_purchased','Qty dibeli',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(787,'Ind','Sender_Name','Nama pengirim',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(788,'Ind','The_module_must_be_uploaded_as_zip_file','Modul harus diunggah sebagai file zip',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(789,'Ind','Upload_Module','Unggah Modul',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(790,'Ind','All_Modules_Installed','Semua Modul Terpasang',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(791,'Ind','Current_Version','Versi sekarang',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(792,'Ind','You_already_have_the_latest_version','Anda sudah memiliki versi terbaru',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(793,'Ind','Update_Available','Pembaruan tersedia',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(794,'Ind','Update_Log','Perbarui Log',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(795,'Ind','Update_Now','Memperbarui sekarang',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(796,'Ind','View_Change_Log','Lihat Ubah Log',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(797,'Ind','invoice_footer','Footer faktur',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(798,'Ind','Please_Wait_for_the_update','Harap Tunggu hingga pembaruan selesai sepenuhnya. Tidak disarankan untuk menutup browser atau menghentikan proses Upgrade',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(799,'Ind','Note_update','Pastikan Anda membuat cadangan versi & basis data Anda saat ini sebelum menjalankan Peningkatan, Untuk memulihkannya jika ada kesalahan',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(800,'Ind','Time_Zone','Zona waktu',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(801,'Ind','Payment_note','catatan pembayaran',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(802,'Ind','sale_note','nota penjualan',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(803,'Ind','Total_Sale_Due','Total Penjualan hutang',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(804,'Ind','Total_Sell_Return_Due','Total Jual Kembalikan hutang',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(805,'Ind','pay_all_sell_due_at_a_time','bayar semua hutang jual sekaligus',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(806,'Ind','pay_all_sell_return_due_at_a_time','bayar semua hutang retur penjualan sekaligus',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(807,'Ind','Gross_Profit','Laba kotor',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(808,'Ind','pay_all_purchase_due_at_a_time','membayar semua utang pembelian sekaligus',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(809,'Ind','Delete_Provider','Hapus Penyedia',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(810,'Ind','Edit_Provider','Sunting Penyedia',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(811,'Ind','Provider_details','Detail penyedia',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(812,'Ind','Total_Purchase_Due','Total Pembelian jatuh tempo',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(813,'Ind','Provider_Credit_Note','Nota kredit',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(814,'Ind','Customer_Credit_Note','Nota kredit',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(815,'Ind','Sell_Return','Kembalikan penjualan',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(816,'Ind','Purchase_Return','Pengembalian Pembelian',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(817,'Ind','Tax_Number','Nomor pajak',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(818,'Ind','Please_add_return_quantity','Silakan tambahkan jumlah pengembalian',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(819,'Ind','Return_exist_for_the_Transaction','Pengembalian ada untuk Transaksi',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(820,'Ind','qty_return_is_greater_than_Quantity_Remaining','Qty return lebih besar dari Quantity Remaining',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(821,'Ind','products_refunded_alert','Produk apa pun dengan jumlah yang disetel ke 0 tidak akan dikembalikan dananya',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(822,'Ind','pay_all_purchase_return_due_at_a_time','bayar semua retur pembelian yang jatuh tempo sekaligus',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(823,'Ind','Total_Purchase_Return_Due','Total Pengembalian Pembelian yang jatuh tempo',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(824,'Ind','Purchase_return_due','Pengembalian pembelian jatuh tempo',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(825,'Ind','Sell_return_due','Jual retur jatuh tempo',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(826,'Ind','product_report','Laporan produk',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(827,'Ind','product_sales_report','laporan penjualan produk',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(828,'Ind','Product_purchases_report','laporan pembelian produk',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(829,'Ind','Qty_sold','Qty terjual',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(830,'Ind','Filter_by_warehouse','Saring menurut gudang',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(831,'Ind','Enable_Print_Invoice','Cetak Faktur secara otomatis',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(832,'Ind','Show_Warehouse','melihat gudang',0,'2025-06-18 01:49:30.000000','2025-06-18 01:49:30.000000'),(833,'Ind','Saved_Credit_Card_Info','Info Kartu Kredit Tersimpan',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(834,'Ind','Credit_card_changed_successfully','Kartu kredit berhasil diubah',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(835,'Ind','notification_template','Template Notifikasi',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(836,'Ind','email_notification','Notifikasi Email',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(837,'Ind','sms_notification','Notifikasi SMS',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(838,'Ind','Change_product_details','Ubah Detail Produk',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(839,'Ind','edit_tax_and_discount_and_shipping','Ubah Pajak, Diskon, dan Pengiriman',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(840,'Ind','Create_Quotation_with_Stock','Buat Kutipan dengan Stok',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(841,'Ind','Variant_cost','Biaya Variabel',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(842,'Ind','Variant_price','Harga Variabel',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(843,'Ind','Variant_code','Kode Variabel',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(844,'Ind','Please_wait_until_the_product_is_loaded','Harap tunggu hingga produk dimuat',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(845,'Ind','Choose_SMS_Gateway','Pilih Gateway SMS',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(846,'Ind','Notification_Client','Notifikasi Klien',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(847,'Ind','Available_Tags','Tag yang Tersedia',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(848,'Ind','Email_Subject','Subjek Email',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(849,'Ind','Email_body','Isi Email',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(850,'Ind','Notification_Supplier','Notifikasi Pemasok',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(851,'Ind','sms_body','Isi SMS',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(852,'Ind','sms_templates','SMS Templates',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(853,'Ind','email_templates','Email Templates',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(854,'Ind','Edit_Project','Edit Proyek',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(855,'Ind','Projects','Proyek',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(856,'Ind','Enter_Project_Title','Masukkan Judul Proyek',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(857,'Ind','Assigned_Employees','Karyawan yang Ditugaskan',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(858,'Ind','Choose_Team','Pilih Tim',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(859,'Ind','Create_Project','Buat Proyek',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(860,'Ind','Project_List','Daftar Proyek',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(861,'Ind','Not_Started','Belum Dimulai',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(862,'Ind','In_Progress','Sedang Berlangsung',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(863,'Ind','On_Hold','Ditahan',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(864,'Ind','Edit_Task','Edit Tugas',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(865,'Ind','Tasks','Tugas',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(866,'Ind','Enter_Task_Title','Masukkan Judul Tugas',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(867,'Ind','Choose_Project','Pilih Proyek',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(868,'Ind','Project','Proyek',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(869,'Ind','Create_Task','Buat Tugas',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(870,'Ind','Task_List','Daftar Tugas',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(871,'Ind','Import_Purchases','Impor Pembelian',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(872,'Ind','Warranty_Period','Periode Garansi',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(873,'Ind','Months','Bulan',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(874,'Ind','Years','Tahun',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(875,'Ind','WarrantyTerms','Syarat Garansi',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(876,'Ind','HasGuarantee','Memiliki Garansi',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(877,'Ind','Guarantee_Period','Masa Garansi',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(878,'Ind','OpeningStock','Stok Awal',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(879,'Ind','Warranty_Guarantee_Tracking','Pelacakan Garansi & Jaminan',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(880,'Ind','PaymentOption','Metode Pembayaran',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(881,'Ind','AddAnotherPaymentOption','Tambah Metode Pembayaran Lain',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(882,'Ind','PopularTendered','Jumlah Populer',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(883,'Ind','clear','hapus',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(884,'Ind','Pay','Bayar',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(885,'Ind','Payment','Pembayaran',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(886,'Ind','TotalPaidExceedsGrandTotalForMultiPayment','Total pembayaran melebihi total tagihan',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(887,'Ind','TotalPaying','Total Pembayaran',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(888,'Ind','ChangeReturn','Kembalian',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(889,'Ind','AmountPaying','Jumlah yang Dibayar',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(890,'Ind','Appearance_Settings','Pengaturan Tampilan',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(891,'Ind','app_name','Nama Aplikasi',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(892,'Ind','page_title_suffix','Akhiran Judul Halaman',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(893,'Ind','ChangeFavicon','Ubah Favicon',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(894,'Ind','Languages','Bahasa',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(895,'Ind','Translations','Terjemahan',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(896,'Ind','Translations for','Terjemahan untuk',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(897,'Ind','Back','Kembali',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(898,'Ind','Save All Changes','Simpan Semua Perubahan',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(899,'Ind','Add New','Tambah Baru',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(900,'Ind','Add New Translation','Tambah Terjemahan Baru',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(901,'Ind','Save','Simpan',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(902,'Ind','Delete','Hapus',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(903,'Ind','Showing','Menampilkan',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(904,'Ind','Translation added','Terjemahan berhasil ditambahkan',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(905,'Ind','Failed to add translation','Gagal menambahkan terjemahan',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(906,'Ind','Translation updated','Terjemahan berhasil diperbarui',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(907,'Ind','Failed to update','Gagal memperbarui',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(908,'Ind','No changes to save','Tidak ada perubahan untuk disimpan',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(909,'Ind','Notice','Pemberitahuan',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(910,'Ind','All changes saved successfully','Semua perubahan berhasil disimpan',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(911,'Ind','Bulk save failed','Gagal menyimpan secara massal',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(912,'Ind','Please reload the page after saving translations to apply the changes.','Silakan muat ulang halaman setelah menyimpan terjemahan untuk menerapkan perubahan.',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(913,'Ind','Action_Blocked','Aksi Diblokir',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(914,'Ind','You_cannot_delete_the_default_language','Anda tidak dapat menghapus bahasa default',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(915,'Ind','Flag','Bendera',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(916,'Ind','Locale','Lokal',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(917,'Ind','Update Language','Perbarui Bahasa',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(918,'Ind','Add Language','Tambah Bahasa',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(919,'Ind','Send_Email','Kirim Email',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(920,'Ind','Send_SMS','Kirim SMS',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(921,'Ind','total_sales','Total Penjualan',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(922,'Ind','Opening_Stock','Stok Awal',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(923,'Ind','Subscription_Product','Produk Berlangganan',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(924,'Ind','Subscriptions','Langganan',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(925,'Ind','Billing_Cycle','Siklus Penagihan',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(926,'Ind','total_cycles','Total Siklus',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(927,'Ind','remaining_cycles','Sisa Siklus',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(928,'Ind','next_billing_date','Tanggal Penagihan Berikutnya',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(929,'Ind','Failed_to_update_subscription_status','Gagal memperbarui status langganan',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(930,'Ind','Subscription_status_updated_successfully','Status langganan berhasil diperbarui',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(931,'Ind','Create_Susbscription','Buat Langganan',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(932,'Ind','Price_Per_Cycle','Harga Per Siklus',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(933,'Ind','Price_Per_Unit','Harga Per Unit',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(934,'Ind','Active','Aktif',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(935,'Ind','Canceled','Dibatalkan',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(936,'Ind','Completed','Selesai',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(937,'Ind','Subscription_details','Detail Langganan',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(938,'Ind','Dynamic_Appearance','Tampilan Dinamis',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(939,'Ind','Payment_Methods','Metode Pembayaran',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(940,'Ind','You_cant_edit_or_remove_default_payment_choices','Anda tidak dapat mengedit atau menghapus pilihan pembayaran default',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(941,'Ind','Enter_Payment_Method','Masukkan Metode Pembayaran',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(942,'Ind','Sales_by_Category','Penjualan berdasarkan Kategori',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(943,'Ind','Sales_by_Brand','Penjualan berdasarkan Merek',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(944,'Ind','Error_Logs','Log Kesalahan',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(945,'Ind','Occurred_At','Terjadi Pada',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(946,'Ind','Context','Konteks',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(947,'Ind','Report_Transactions','Laporan Transaksi',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(948,'Ind','Payment_Method','Metode Pembayaran',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(949,'Ind','Customer_Provider','Pelanggan/Penyedia',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(950,'Ind','Sale_Purchase_Ref','Referensi Penjualan/Pembelian',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(951,'ar','Draft_Created_successfully','تم إنشاء المسودة بنجاح',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(952,'ar','Draft_Sale_Deleted','تم حذف بيع المسودة',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(953,'ar','Inventory_Valuation_Based_on_Average_Cost','تقييم المخزون بناءً على التكلفة المتوسطة',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(954,'ar','Payroll','كشوف المرتبات',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(955,'ar','Transfers_Money','تحويل الأموال',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(956,'ar','Inventory_Valuation','تقييم المخزون',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(957,'ar','Deposits_Report','تقرير الإيداعات',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(958,'ar','Expense_Report','تقرير المصاريف',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(959,'ar','Deposit_Category','تصنيف الإيداع',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(960,'ar','Total_Deposits','إجمالي الإيداعات',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(961,'ar','Expense_Category','فئة المصاريف',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(962,'ar','Total_Expenses','إجمالي المصاريف',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(963,'ar','ASSET_VALUE','قيمة الأصول',0,'2025-06-18 01:49:31.000000','2025-06-18 01:49:31.000000'),(964,'ar','STOCK_ON_HAND','المخزون المتاح',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(965,'ar','Variant_NAME','اسم المتغير',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(966,'ar','SKU','رمز المنتج',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(967,'ar','ITEM_NAME','اسم المنتج',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(968,'ar','From_Account','من الحساب',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(969,'ar','To_Account','إلى الحساب',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(970,'ar','Accounts_cannot_be_the_same','لا يمكن أن تكون الحسابات هي نفسها',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(971,'ar','CountStock','عد المخزون',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(972,'ar','Successfully_Generated_Count','تم إنشاء العد بنجاح',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(973,'ar','Count','العد',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(974,'ar','file','ملف',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(975,'ar','Accounting','المحاسبة',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(976,'ar','deposit_delete','حذف الإيداع',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(977,'ar','deposit_edit','تعديل الإيداع',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(978,'ar','deposit_add','إضافة إيداع',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(979,'ar','deposit_view','عرض الإيداع',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(980,'ar','expense_add','إضافة مصاريف',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(981,'ar','expense_edit','تعديل المصاريف',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(982,'ar','expense_delete','حذف المصاريف',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(983,'ar','List_Deposit','قائمة الإيداعات',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(984,'ar','Create_deposit','إنشاء إيداع',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(985,'ar','List_accounts','قائمة الحسابات',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(986,'ar','Account','الحساب',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(987,'ar','Choose_Account','اختر الحساب',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(988,'ar','Deposits','الإيداعات',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(989,'ar','account_num','رقم الحساب',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(990,'ar','Enter_account_num','أدخل رقم الحساب',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(991,'ar','account_name','اسم الحساب',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(992,'ar','Enter_account_name','أدخل اسم الحساب',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(993,'ar','initial_balance','الرصيد الابتدائي',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(994,'ar','Enter_initial_balance','أدخل الرصيد الابتدائي',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(995,'ar','notes','ملاحظات',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(996,'ar','balance','الرصيد',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(997,'ar','Pos_Settings','إعدادات نقاط البيع',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(998,'ar','Receipt','الإيصال',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(999,'ar','Note_to_customer','ملاحظة للعميل',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1000,'ar','Show_Note_to_customer','إظهار ملاحظة للعميل',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1001,'ar','Show_barcode','إظهار الشفرة',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1002,'ar','Show_Tax_and_Discount','إظهار الضرائب والخصم والشحن',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1003,'ar','Show_Customer','إظهار العميل',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1004,'ar','Show_Email','إظهار البريد الإلكتروني',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1005,'ar','Show_Phone','إظهار الهاتف',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1006,'ar','Show_Address','إظهار العنوان',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1007,'ar','DefaultLanguage','اللغة الافتراضية',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1008,'ar','footer','تذييل',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1009,'ar','Received_Amount','المبلغ المستلم',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1010,'ar','Paying_Amount','مبلغ الدفع',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1011,'ar','Change','الصرف',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1012,'ar','Paying_amount_is_greater_than_Received_amount','مبلغ الدفع أكبر من المبلغ المستلم',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1013,'ar','Paying_amount_is_greater_than_Grand_Total','مبلغ الدفع أكبر من المبلغ الإجمالي الكلي',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1014,'ar','code_must_be_not_exist_already','يجب أن يكون الرمز غير موجود بالفعل',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1015,'ar','You_will_find_your_backup_on','سوف تجد النسخة الاحتياطية الخاصة بك على',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1016,'ar','and_save_it_to_your_pc','و قم بحفظه على جهاز الكمبيوتر الخاص بك',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1017,'ar','Scan_your_barcode_and_select_the_correct_symbology_below','امسح الرمز الشريطي ضوئيًا وحدد الترميز الصحيح أدناه',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1018,'ar','Scan_Search_Product_by_Code_Name','مسح / بحث عن المنتج حسب الاسم الرمزي',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1019,'ar','Paper_size','حجم الورق',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1020,'ar','Clear_Cache','مسح ذاكرة التخزين المؤقت',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1021,'ar','Cache_cleared_successfully','تم مسح ذاكرة التخزين المؤقت بنجاح',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1022,'ar','Failed_to_clear_cache','فشل مسح ذاكرة التخزين المؤقت',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1023,'ar','Scan_Barcode','ماسح الباركود',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1024,'ar','Please_use_short_name_of_unit','الرجاء استخدام الاسم المختصر للوحدة',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1025,'ar','DefaultCustomer','العميل الافتراضي',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1026,'ar','DefaultWarehouse','المستودع الافتراضي',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1027,'ar','Payment_Gateway','بوابة الدفع',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1028,'ar','SMS_Configuration','إعدادات الرسائل القصيرة',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1029,'ar','Gateway','بوابة الدفع',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1030,'ar','Choose_Gateway','اختر بوابة الدفع',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1031,'ar','sms_send_successfully','تم ارسال الرسالة بنجاح',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1032,'ar','sms_config_invalid','إعدادات الرسائل القصيرة غير صالحة',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1033,'ar','Remove_Stripe_Key_Secret','حذف مفاتيح Stripe API',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1034,'ar','credit_card_account_not_available','حساب بطاقة الائتمان غير متوفر',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1035,'ar','Credit_Card_Info','معلومات بطاقة الائتمان',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1036,'ar','developed_by','طورت بواسطة',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1037,'ar','Unit_already_linked_with_sub_unit','الوحدة مرتبطة بالفعل بوحدة فرعية',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1038,'ar','Total_Items_Quantity','مجموع العناصر والكمية',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1039,'ar','Value_by_Cost_and_Price','القيمة حسب التكلفة والسعر',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1040,'ar','Search_this_table','ابحث في هذا الجدول',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1041,'ar','import_products','استيراد المنتجات',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1042,'ar','Field_optional','حقل اختياري',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1043,'ar','Download_exemple','تحميل المثال',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1044,'ar','field_must_be_in_csv_format','يجب أن يكون الحقل بتنسيق csv',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1045,'ar','Successfully_Imported','تم الاستيراد بنجاح',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1046,'ar','file_size_must_be_less_than_1_mega','يجب أن يكون حجم الملف أقل من 1 ميغا',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1047,'ar','Please_follow_the_import_instructions','يرجى اتباع تعليمات الاستيراد',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1048,'ar','must_be_exist','يجب أن تكون الوحدة قد تم إنشاؤها بالفعل',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1049,'ar','Import_Customers','استيراد العملاء',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1050,'ar','Import_Suppliers','استيراد الموردين',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1051,'ar','Recent_Sales','المبيعات الأخيرة',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1052,'ar','Create_Transfer','إنشاء تحويل',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1053,'ar','order_products','طلب المنتجات',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1054,'ar','Search_Product_by_Code_Name','ابحث عن المنتج بالكود أو الاسم',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1055,'ar','Reports_payments_Purchase_Return','تقارير مدفوعات مرتجعات الشراء',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1056,'ar','Reports_payments_Sale_Return','تقارير مدفوعات مرتجعات البيع',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1057,'ar','payments_Sales_Return','مدفوعات إرجاع المبيعات',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1058,'ar','payments_Purchases_Return','مدفوعات مشتريات العودة',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1059,'ar','CreateSaleReturn','إنشاء عائد بيع',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1060,'ar','EditSaleReturn','تحرير إرجاع البيع',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1061,'ar','SalesReturn','عائد المبيعات',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1062,'ar','CreatePurchaseReturn','إنشاء إرجاع الشراء',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1063,'ar','EditPurchaseReturn','تحرير إرجاع الشراء',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1064,'ar','PurchasesReturn','عائد المشتريات',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1065,'ar','Due','دين',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1066,'ar','Profit','ربح',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1067,'ar','Revenue','دخل',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1068,'ar','Sales_today','مبيعات اليوم',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1069,'ar','People','اشخاص',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1070,'ar','Successfully_Created','تم إنشاؤه بنجاح',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1071,'ar','Successfully_Updated','تم التحديث بنجاح',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1072,'ar','Success','نجاح',0,'2025-06-18 01:49:32.000000','2025-06-18 01:49:32.000000'),(1073,'ar','Failed','باءت بالفشل',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1074,'ar','Warning','إنذار',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1075,'ar','Please_fill_the_form_correctly','يرجى ملء النموذج بشكل صحيح',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1076,'ar','Field_is_required','هذا الحقل مطلوب',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1077,'ar','Choose_Status','اختر الحالة',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1078,'ar','Choose_Method','اختر الطريقة',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1079,'ar','Choose_Symbology','اختر الترميز',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1080,'ar','Choose_Category','اختر الفئة',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1081,'ar','Choose_Customer','اختر الزبون',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1082,'ar','Choose_Supplier','اختر المورد',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1083,'ar','Choose_Unit_Purchase','اختر وحدة الشراء',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1084,'ar','Choose_Sub_Category','اختر الفئة الفرعية',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1085,'ar','Choose_Brand','اختر الماركة',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1086,'ar','Choose_Warehouse','اختر المستودع',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1087,'ar','Choose_Unit_Sale','اختر وحدة البيع',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1088,'ar','Enter_Product_Cost','أدخل تكلفة المنتج',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1089,'ar','Enter_Stock_alert','أدخل تنبيه المخزون',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1090,'ar','Choose_Unit_Product','اختر وحدة المنتج',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1091,'ar','Enter_Product_Price','أدخل سعر المنتج',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1092,'ar','Enter_Name_Product','أدخل اسم المنتج',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1093,'ar','Enter_Role_Name','أدخل اسم الدور',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1094,'ar','Enter_Role_Description','أدخل وصف الدور',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1095,'ar','Enter_name_category','أدخل اسم الفئة',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1096,'ar','Enter_Code_category','أدخل رمز الفئة',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1097,'ar','Enter_Name_Brand','أدخل اسم الماركة',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1098,'ar','Enter_Description_Brand','أدخل وصف الماركة',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1099,'ar','Enter_Code_Currency','أدخل رمز العملة',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1100,'ar','Enter_name_Currency','أدخل اسم العملة',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1101,'ar','Enter_Symbol_Currency','أدخل رمز العملة',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1102,'ar','Enter_Name_Unit','أدخل اسم وحدة',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1103,'ar','Enter_ShortName_Unit','أدخل اسمًا قصيرًا للوحدة',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1104,'ar','Choose_Base_Unit','اختر وحدة القاعدة',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1105,'ar','Choose_Operator','اختر عامل التشغيل',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1106,'ar','Enter_Operation_Value','أدخل قيمة العملية',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1107,'ar','Enter_Name_Warehouse','أدخل اسم المستودع',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1108,'ar','Enter_Phone_Warehouse','أدخل هاتف المستودع',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1109,'ar','Enter_Country_Warehouse','أدخل بلد المستودع',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1110,'ar','Enter_City_Warehouse','أدخل مدينة المستودع',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1111,'ar','Enter_Email_Warehouse','أدخل البريد الإلكتروني للمستودع',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1112,'ar','Enter_ZipCode_Warehouse','أدخل الرمز البريدي للمستودع',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1113,'ar','Choose_Currency','اختر العملة',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1114,'ar','Thank_you_for_your_business','شكرا لك على عملك !',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1115,'ar','Cancel','إلغاء',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1116,'ar','New_Customer','عميل جديد',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1117,'ar','Incorrect_Login','تسجيل الدخول غير صحيح',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1118,'ar','Successfully_Logged_In','تم تسجيل الدخول بنجاح',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1119,'ar','This_user_not_active','هذا المستخدم غير نشط',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1120,'ar','SignIn','تسجيل الدخول',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1121,'ar','Create_an_account','انشئ حساب',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1122,'ar','Forgot_Password','هل نسيت كلمة السر',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1123,'ar','Email_Address','بريد الكتروني',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1124,'ar','SignUp','اشتراك',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1125,'ar','Already_have_an_account','هل لديك حساب ؟',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1126,'ar','Reset_Password','إعادة تعيين كلمة المرور',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1127,'ar','Failed_to_authenticate_on_SMTP_server','فشل المصادقة على خادم SMTP',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1128,'ar','We_cant_find_a_user_with_that_email_addres','لا يمكننا العثور على مستخدم بعنوان البريد الإلكتروني هذا',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1129,'ar','We_have_emailed_your_password_reset_link','لقد أرسلنا رابط إعادة تعيين كلمة المرور بالبريد الإلكتروني',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1130,'ar','Please_fill_the_Email_Adress','يرجى ملء عنوان البريد الإلكتروني',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1131,'ar','Confirm_password','تأكيد كلمة المرور',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1132,'ar','Your_Password_has_been_changed','تم تغيير كلمة السر الخاصة بك',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1133,'ar','The_password_confirmation_does_not_match','تأكيد كلمة المرور غير متطابق',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1134,'ar','This_password_reset_token_is_invalid','رمز إعادة تعيين كلمة المرور هذا غير صالح',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1135,'ar','Warehouse_report','تقرير المستودع',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1136,'ar','All_Warehouses','جميع المستودعات',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1137,'ar','Expense_List','قائمة المصاريف',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1138,'ar','Expenses','المصروفات',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1139,'ar','This_Week_Sales_Purchases','مبيعات ومشتريات هذا الأسبوع',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1140,'ar','Top_Selling_Products','المنتجات الأكثر مبيعًا',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1141,'ar','View_all','مشاهدة الكل',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1142,'ar','Payment_Sent_Received','الدفع - المرسل والمستلم',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1143,'ar','Error','خطأ !',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1144,'ar','you_are_not_authorized','آسف! أنك غير مخول.',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1145,'ar','Go_back_to_home','العودة الى الصفحة الرئيسية',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1146,'ar','page_not_exist','آسف! الصفحة التي تبحث عنها غير موجودة.',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1147,'ar','Filter','فلتر',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1148,'ar','Invoice_POS','فاتورة نقاط البيع',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1149,'ar','Invoice','فاتورة',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1150,'ar','Customer_Info','معلومات العميل',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1151,'ar','Company_Info','معلومات الشركة',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1152,'ar','Invoice_Info','معلومات الفاتورة',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1153,'ar','Order_Summary','ملخص الطلب',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1154,'ar','Quote_Info','معلومات الاقتباس',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1155,'ar','Del','حذف',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1156,'ar','SuppliersPaiementsReport','تقرير مدفوعات الموردين',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1157,'ar','Purchase_Info','معلومات الشراء',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1158,'ar','Supplier_Info','معلومات المورد',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1159,'ar','Return_Info','معلومات العودة',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1160,'ar','Create_Expense','أضف المصاريف',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1161,'ar','Details','التفاصيل',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1162,'ar','Discount_Method','طريقة الخصم',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1163,'ar','Net_Unit_Cost','صافي تكلفة الوحدة',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1164,'ar','Net_Unit_Price','صافي سعر الوحدة',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1165,'ar','Edit_Expense','تحرير المصاريف',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1166,'ar','All_Brand','جميع العلامات التجارية',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1167,'ar','All_Category','كل الفئات',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1168,'ar','ListExpenses','قائمة المصروفات',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1169,'ar','Create_Permission','إنشاء إذن',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1170,'ar','Edit_Permission','تحرير إذن',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1171,'ar','Reports_payments_Sales','تقارير مدفوعات المبيعات',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1172,'ar','Reports_payments_Purchases','تقارير مشتريات المدفوعات',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1173,'ar','Reports_payments_Return_Customers','تقارير المدفوعات المرتجعة للعملاء',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1174,'ar','Reports_payments_Return_Suppliers','تقارير المدفوعات عودة الموردين',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1175,'ar','Expense_Deleted','تم حذف هذه المصاريف',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1176,'ar','Expense_Updated','تم تحديث هذه المصاريف',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1177,'ar','Expense_Created','تم إنشاء هذه المصاريف',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1178,'ar','DemoVersion','لا يمكنك القيام بذلك في النسخة التجريبية',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1179,'ar','Filesize','حجم الملف',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1180,'ar','GenerateBackup','إنشاء نسخة احتياطية',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1181,'ar','BackupDatabase','النسخ الاحتياطية',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1182,'ar','Backup','النسخ الاحتياطية',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1183,'ar','OrderStatistics','إحصائيات المبيعات',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1184,'ar','AlreadyAdd','هذا المنتج مضاف بالفعل',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1185,'ar','AddProductToList','الرجاء إضافة المنتج إلى القائمة',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1186,'ar','AddQuantity','الرجاء إضافة الكمية للمنتج',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1187,'ar','InvalidData','بيانات غير صالحة',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1188,'ar','LowStock','الكمية تتجاوز الكمية المتوفرة في المخزون',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1189,'ar','WarehouseIdentical','لا يمكن أن يكون المستودعين متطابقين',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1190,'ar','VariantDuplicate','هذا المتغير مكرر',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1191,'ar','Paid','مدفوعة',0,'2025-06-18 01:49:33.000000','2025-06-18 01:49:33.000000'),(1192,'ar','Unpaid','غير مدفوعة',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1193,'ar','IncomeExpenses','الدخل مقابل المصروفات',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1194,'ar','dailySalesPurchases','المبيعات والمشتريات اليومية',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1195,'ar','ProductsExpired','المنتجات منتهية الصلاحية',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1196,'ar','Income','الدخل',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1197,'ar','Sale','المبيعة',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1198,'ar','Actif','فعال',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1199,'ar','Inactif','غير فعال',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1200,'ar','Phone','الهاتف',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1201,'ar','SearchByPhone','البحت بالهاتف',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1202,'ar','CustomerName','اسم العميل',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1203,'ar','StockManagement','إدارة المخزون',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1204,'ar','dashboard','لوحة الإستعلام',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1205,'ar','Products','منتجات',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1206,'ar','productsList','قائمة المنتجات',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1207,'ar','StockTransfers','تحويل المخزون',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1208,'ar','Customers','الزبائن',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1209,'ar','Suppliers','الموردون',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1210,'ar','Quotations','عرض الأسعار',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1211,'ar','Sales','المبيعات',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1212,'ar','Purchases','المشتريات',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1213,'ar','Returns','العوائد',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1214,'ar','Settings','الإعدادات',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1215,'ar','SystemSettings','إعدادات النظام',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1216,'ar','Users','المستخدمين',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1217,'ar','GroupPermissions','صلاحية المجموعة',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1218,'ar','Currencies','العملات',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1219,'ar','ProductTax','ضريبة المنتج',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1220,'ar','Categories','التصنيفات',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1221,'ar','Warehouses','المستودعات',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1222,'ar','Units','الوحدات',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1223,'ar','UnitsPrchases','وحدات الشراء',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1224,'ar','UnitsSales','وحدات البيع',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1225,'ar','Reports','التقارير',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1226,'ar','PaymentsReport','تقرير المدفوعات',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1227,'ar','PaymentsPurchases','مدفوعات المشتريات',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1228,'ar','PaymentsSales','مدفوعات المبيعات',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1229,'ar','PaymentsReturns','مدفوعات المرتجعات',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1230,'ar','ProfitandLoss','الربح والخسارة',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1231,'ar','ProductQuantityAlerts','تنبيهات كمية المنتج',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1232,'ar','WarehouseStockChart','مخطط المخزون  المستودعات',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1233,'ar','SalesReport','تقرير المبيعات',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1234,'ar','PurchasesReport','تقرير المشتريات',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1235,'ar','CustomersReport','تقرير العملاء',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1236,'ar','SuppliersReport','تقرير الموردين',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1237,'ar','SupplierReport','تقرير المورد',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1238,'ar','DailySalesData','بيانات المبيعات اليومية',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1239,'ar','DailyPurchasesData','بيانات المشتريات اليومية',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1240,'ar','Dernièrescinqrecords','السجلات الخمسة الأخيرة',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1241,'ar','Filters','البحت',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1242,'ar','date','التاريخ',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1243,'ar','Reference','المرجع',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1244,'ar','Supplier','المورد',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1245,'ar','PaymentStatus','حالة الدفع',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1246,'ar','Customer','الزبون',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1247,'ar','CustomerCode','رمز الزبون',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1248,'ar','Status','الحالة',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1249,'ar','SupplierCode','رمز المورد',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1250,'ar','ProductManagement','إدارة المنتجات',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1251,'ar','CodeProduct','رمز المنتج',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1252,'ar','Categorie','التصنيف',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1253,'ar','SubCategorie','التصنيف الفرعي',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1254,'ar','Name_product','إسم المنتج',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1255,'ar','StockAlert','تنبيه المخزون',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1256,'ar','warehouse','المستودع',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1257,'ar','Tax','الضريبة',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1258,'ar','BuyingPrice','سعر الشراء',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1259,'ar','SellPrice','سعر البيع',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1260,'ar','Quantity','كمية',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1261,'ar','Action','الإجراءات',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1262,'ar','UnitSale','وحدة البيع',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1263,'ar','UnitPurchase','وحدة الشراء',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1264,'ar','ProductDetails','تفاصيل المنتج',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1265,'ar','All','الكل',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1266,'ar','EditProduct','تعديل المنتج',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1267,'ar','AddProduct','إضافة منتج',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1268,'ar','SearchByCode','البحت بالرمز',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1269,'ar','SearchByName','البحت بالاسم',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1270,'ar','Edit','تعديل',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1271,'ar','Close','أغلق',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1272,'ar','PleaseSelect','يرجى التحديد',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1273,'ar','CustomerManagement','إدارة الزبائن',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1274,'ar','Email','البريد',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1275,'ar','EditCustomer','تحرير العميل',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1276,'ar','AddCustomer','إضافة عميل',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1277,'ar','Country','البلد',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1278,'ar','City','المدينة',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1279,'ar','Adress','العنوان',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1280,'ar','CustomerDetails','تفاصيل العميل',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1281,'ar','CustomersList','قائمة الزبائن',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1282,'ar','SupplierName','اسم المورد',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1283,'ar','SuppliersManagement','إدارة الموردين',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1284,'ar','SupplierDetails','تفاصيل المورد',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1285,'ar','QuotationsManagement','إدارة التسعيرات',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1286,'ar','SubTotal','المجموع الكلي',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1287,'ar','complete','مكتملة',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1288,'ar','EnAttendant','قيد الانتظار',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1289,'ar','Recu','تم الاستلام',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1290,'ar','partial','جزئي',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1291,'ar','Retournee','مسترجعة',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1292,'ar','DetailQuote','تفاصيل عرض السعر',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1293,'ar','EditQuote','تعديل عرض السعر',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1294,'ar','CreateSale','إنشاء مبيعة',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1295,'ar','DownloadPdf','تحميل PDF',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1296,'ar','QuoteEmail','ارسال عرض السعر بالبريد الالكتروني',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1297,'ar','DeleteQuote','حذف عرض السعر',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1298,'ar','AddQuote','إضافة عرض سعر',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1299,'ar','SelectProduct','حدد المنتج',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1300,'ar','Price','السعر',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1301,'ar','CurrentStock','المخزون',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1302,'ar','Total','مجموع',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1303,'ar','Num','رقم',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1304,'ar','Unitcost','تكلفة الوحدة',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1305,'ar','to','إلى',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1306,'ar','Subject','الموضوع',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1307,'ar','Message','الرسالة',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1308,'ar','EmailCustomer','البريد الإلكتروني للعميل',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1309,'ar','Sent','المرسلة',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1310,'ar','ProductCodeName','المنتج',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1311,'ar','Quote','عرض الأسعار',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1312,'ar','Hello','أهلا',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1313,'ar','AttachmentQuote','يرجى العثور على المرفق لعرض الأسعار الخاص بك',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1314,'ar','AddProducts','إضافة منتجات إلى قائمة الطلبات',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1315,'ar','SelectWarehouse','الرجاء اختيار المستودع',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1316,'ar','SelectCustomer','اختر الزبون',0,'2025-06-18 01:49:34.000000','2025-06-18 01:49:34.000000'),(1317,'ar','SalesManagement','إدارة المبيعات',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1318,'ar','QtyBack','كمية العوائد',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1319,'ar','TotalReturn','مجموع العوائد',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1320,'ar','MontantReste','المبلغ المتبقي',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1321,'ar','SaleDetail','تفاصيل المبيعة',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1322,'ar','EditSale','تعديل المبيعة',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1323,'ar','AddSale','إضافة مبيعة',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1324,'ar','ShowPayment','إظهار المدفوعات',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1325,'ar','AddPayment','إضافة الدفع',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1326,'ar','EditPayment','تعديل الدفع',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1327,'ar','EmailSale','إرسال المبيعة في البريد الإلكتروني',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1328,'ar','DeleteSale','حذف المبيعة',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1329,'ar','Amount','المبلغ',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1330,'ar','ModePaiement','طريقة الدفع',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1331,'ar','Paymentchoice','طريقة الدفع',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1332,'ar','Note','ملحوظة',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1333,'ar','PaymentComplete','اكتمل الدفع',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1334,'ar','UserManagement','إدارة المستخدمين',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1335,'ar','Firstname','الاسم الأول',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1336,'ar','lastname','الاسم الاخير',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1337,'ar','username','اسم المستخدم',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1338,'ar','type','النوع',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1339,'ar','UserPermissions','تراخيص المستخدمين',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1340,'ar','RoleName','اسم الدور',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1341,'ar','RoleDescription','وصف الدور',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1342,'ar','AddPermissions','اضافة التراخيص',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1343,'ar','View','عرض',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1344,'ar','Add','إضافة',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1345,'ar','NewAdjustement','تعديل جديد',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1346,'ar','EditAdjustement','تحرير التعديل',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1347,'ar','CannotSubstraction','لا يمكنك طرح منتجات لها مخزون 0',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1348,'ar','Addition','إضافة',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1349,'ar','Subtraction','طرح',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1350,'ar','profil','الملف الشخصي',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1351,'ar','logout','تسجيل الخروج',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1352,'ar','PurchaseAlreadyPaid','لا يمكنك التعديل لأن هذا الشراء  مكتمل الدفع  بالفع',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1353,'ar','SaleAlreadyPaid','لا يمكنك التعديل لأن هذه المبيعة  مكتملة الدفع  بالفع',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1354,'ar','ReturnAlreadyPaid','لا يمكنك التعديل لأن هذه المرتجعة  مكتملة الدفع  بالفع',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1355,'ar','QuoteAlready',' هذه التسعيرة أدت بالفعل إلى بيع',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1356,'ar','QuotationComplete','هده التسعيرة مكتملة',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1357,'ar','password','كلمة المرور',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1358,'ar','Newpassword','كلمة المرور جديدة',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1359,'ar','ChangeAvatar','تغيير الصورة',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1360,'ar','LeaveBlank','يرجى ترك هذا الحقل فارغًا إذا لم تقم بتغييره',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1361,'ar','SiteConfiguration','اعدادات عامة',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1362,'ar','Language','اللغة',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1363,'ar','DefaultCurrency','العملة الرئيسية',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1364,'ar','LoginCaptcha','كلمة التحقق',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1365,'ar','DefaultEmail','البريد الرئيسي',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1366,'ar','SiteName','اسم الموقع',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1367,'ar','ChangeLogo','تغيير الشعار',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1368,'ar','SMTPConfiguration','اعدادات الارسال',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1369,'ar','HOST','مضيف',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1370,'ar','PORT','المنفذ',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1371,'ar','encryption','التشفير',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1372,'ar','SMTPIncorrect','اعدادات الارسال غير صحيحة',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1373,'ar','ReturnsInvoices','فواتير المرتجعات',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1374,'ar','ReturnsInvoicesData','بيانات فواتير المرتجعات',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1375,'ar','ShowAll','إظهار كافة سجلات كافة المستخدمين',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1376,'ar','Discount','الخصم',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1377,'ar','OrderTax','ضريبة الطلب',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1378,'ar','Shipping','الشحن',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1379,'ar','ManagementCurrencies','ادارة العملات',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1380,'ar','CurrencyCode','شفرة العملة',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1381,'ar','CurrencyName','اسم العملة',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1382,'ar','Symbol','رمز العملة',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1383,'ar','CompanyName','اسم الشركة',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1384,'ar','CompanyPhone','هاتف الشركة',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1385,'ar','CompanyAdress','عنوان الشركة',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1386,'ar','Code','الكود',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1387,'ar','image','صورة',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1388,'ar','Printbarcode','طباعة الباركود',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1389,'ar','ReturnsCustomers','مرتجعات العملاء',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1390,'ar','ReturnsSuppliers','مرتجعات الموردين',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1391,'ar','FactureReturnCustomers','فواتير مرتجعات العملاء',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1392,'ar','FactureReturnSuppliers','فواتير مرتجعات الموردين',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1393,'ar','NodataAvailable','لا تتوافر بيانات',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1394,'ar','ProductImage','صورة المنتج',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1395,'ar','Barcode','الباركود',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1396,'ar','pointofsales','نقطة مبيعات',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1397,'ar','CustomUpload','تحميل مخصص',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1398,'ar','pointofsaleManagement','إدارة نقاط البيع',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1399,'ar','Adjustment','تعديل',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1400,'ar','Updat','تحديث',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1401,'ar','Reset','إعادة تعيين',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1402,'ar','print','طباعة',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1403,'ar','SearchByEmail','البحث بالبريد الإلكتروني',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1404,'ar','ChooseProduct','اختر المنتج',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1405,'ar','Qty','الكمية',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1406,'ar','Items','العناصر',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1407,'ar','AmountHT','المبلغ دون ضريبة',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1408,'ar','AmountTTC','المبلغ الإجمالي',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1409,'ar','PleaseSelectSupplier','الرجاء تحديد المورد',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1410,'ar','PleaseSelectStatut','يرجى تحديد الحالة',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1411,'ar','PayeBy','الدفع عن طريق',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1412,'ar','ChooseWarehouse','اختر المستودع',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1413,'ar','payNow','ادفع الآن',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1414,'ar','ListofCategory','قائمة الفئات',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1415,'ar','Description','وصف',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1416,'ar','submit','تأكيد',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1417,'ar','ProblemCreatingThisInvoice','حدثت مشكلة في إنشاء هذه الفاتورة. حاول مرة اخرى',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1418,'ar','ProblemPayment','كانت هناك مشكلة في الدفع. حاول مرة اخرى',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1419,'ar','CreateAdjustment','إنشاء تعديل',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1420,'ar','Afewwords','... بضع كلمات عن',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1421,'ar','UserImage','صورة المستخدم',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1422,'ar','UpdateProduct','تحديث المنتج',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1423,'ar','Brand','الماركة',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1424,'ar','BarcodeSymbology','ترميز الباركود',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1425,'ar','ProductCost','تكلفة المنتج',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1426,'ar','ProductPrice','سعر المنتج',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1427,'ar','UnitProduct','منتج الوحدة',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1428,'ar','TaxMethod','الطريقة الضريبية',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1429,'ar','MultipleImage','صور متعددة',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1430,'ar','ProductHasMultiVariants','المنتج له متغيرات متعددة',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1431,'ar','ProductHasPromotion','المنتج له عرض ترويجي',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1432,'ar','PromotionStart','بدء الترويج',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1433,'ar','PromotionEnd','نهاية الترويج',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1434,'ar','PromotionPrice','سعر الترويج',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1435,'ar','Cost','كلفة',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1436,'ar','Unit','وحدة',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1437,'ar','ProductVariant','متغير المنتج',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1438,'ar','Variant','متغير',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1439,'ar','UnitPrice','سعر الوحدة',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1440,'ar','CreateReturnCustomer','إنشاء إرجاع العميل',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1441,'ar','EditReturnCustomer','تحرير إرجاع العميل',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1442,'ar','CreateReturnSupplier','إنشاء إرجاع المورد',0,'2025-06-18 01:49:35.000000','2025-06-18 01:49:35.000000'),(1443,'ar','Documentation','توثيق',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1444,'ar','EditReturnSupplier','تحرير إرجاع المورد',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1445,'ar','FromWarehouse','من المستودع',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1446,'ar','ToWarehouse','إلى المستودع',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1447,'ar','EditTransfer','تحرير النقل',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1448,'ar','TransferDetail','تفاصيل النقل',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1449,'ar','Pending','قيد الانتظار',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1450,'ar','Received','تم الاستلام',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1451,'ar','Ordered','أمر',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1452,'ar','PermissionsManager','مدير الأذونات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1453,'ar','BrandManager','العلامة التجارية',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1454,'ar','BrandImage','صورة الماركة',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1455,'ar','BrandName','اسم الماركة',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1456,'ar','BrandDescription','ةصف الماركة',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1457,'ar','BaseUnit','الوحده الأساسيه',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1458,'ar','ManagerUnits','إدارة الوحدات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1459,'ar','OperationValue','قيمة العملية',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1460,'ar','Operator','عامل',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1461,'ar','Top5Products','أفضل 5 منتجات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1462,'ar','Last5Sales','آخر 5 مبيعات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1463,'ar','ListAdjustments','قائمة التعديلات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1464,'ar','ListTransfers','قائمة التحويلات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1465,'ar','CreateTransfer','إنشاء تحويل',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1466,'ar','OrdersManager','مدير الطلبات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1467,'ar','ListQuotations','قائمة التسعيرات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1468,'ar','ListPurchases','قائمة المشتريات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1469,'ar','ListSales','قائمة المبيعات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1470,'ar','ListReturns','قائمة المرتجعات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1471,'ar','PeopleManager','إدارة الأفراد',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1472,'ar','ListofBrand','قائمة العلامة التجارية',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1473,'ar','Delete_Title','هل أنت واثق؟',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1474,'ar','Delete_Text',' !لن تتمكن من التراجع عن هذا',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1475,'ar','Delete_confirmButtonText','نعم ، احذفه!',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1476,'ar','Delete_cancelButtonText','إلغاء',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1477,'ar','Delete_Deleted','تم الحذف!',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1478,'ar','Delete_Failed','فشل',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1479,'ar','Delete_Therewassomethingwronge','كان هناك شيء خاطئ',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1480,'ar','SendEmail','تم إرسال البريد الإلكتروني بنجاح.',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1481,'ar','erroSale','هذا البيع مرتبط بالفعل بالعودة!',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1482,'ar','AlreadyLinked','هذا المنتج مرتبط بالفعل بعملية أخرى',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1483,'ar','DeletePurchase','حذف الشراء',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1484,'ar','EmailPurchase','إرسال الشراء في البريد الإلكتروني',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1485,'ar','EditPurchase','تحرير الشراء',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1486,'ar','PurchaseDetail','تفاصيل الشراء',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1487,'ar','AddPurchase','أضف شراء',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1488,'ar','EmailSupplier','البريد الإلكتروني للمورد',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1489,'ar','ReturnManagement','إدارة المرتجعات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1490,'ar','ReturnDetail','تفاصيل  المرتجعة',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1491,'ar','EditReturn','تحرير المرتجعة',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1492,'ar','AddReturn','إضافة مرتجعة',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1493,'ar','EmailReturn','إرسال المرتجعة في البريد الإلكتروني',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1494,'ar','DeleteReturn','حذف  المرتجعة',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1495,'ar','Retoursurcharge','تكلفة إضافية',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1496,'ar','Laivrison','التسليم',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1497,'ar','SelectSale','حدد المبيعة',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1498,'ar','ZeroPardefault','يمكنك حذف العنصر أو تعيين الكمية التي تم إرجاعها إلى الصفر إذا لم يتم إرجاعها',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1499,'ar','Return','مرتجعة',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1500,'ar','Purchase','شراء',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1501,'ar','PurchaseInvoice','مدفوعات المشتريات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1502,'ar','PurchasesInvoicesData','بيانات مدفوعات المشتريات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1503,'ar','SalesInvoice','مدفوعات المبيعات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1504,'ar','SalesInvoicesData','بيانات مدفوعات المبيعات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1505,'ar','TotalSales','إجمالي المبيعات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1506,'ar','TotalPurchases','إجمالي المشتريات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1507,'ar','TotalReturns','إجمالي العائدات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1508,'ar','PaiementsNet','صافي المدفوعات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1509,'ar','PaiementsSent','الدفعات المرسلة',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1510,'ar','PaiementsReceived','الدفعات المستلمة',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1511,'ar','Recieved','المستلمة',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1512,'ar','ProductCode','كود المنتج',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1513,'ar','ProductName','المنتج',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1514,'ar','AlertQuantity','كمية التنبيه',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1515,'ar','TotalProducts','إجمالي المنتجات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1516,'ar','TotalQuantity','إجمالي الكمية',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1517,'ar','TopCustomers','أفضل 5 عملاء',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1518,'ar','TotalAmount','المبلغ الإجمالي',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1519,'ar','TotalPaid','المبلغ المدفوع',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1520,'ar','CustomerSalesReport','تقرير المبيعات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1521,'ar','CustomerPaiementsReport',' تقرير المدفوعات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1522,'ar','CustomerQuotationsReport','تقرير عروض أسعار',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1523,'ar','Payments','المدفوعات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1524,'ar','TopSuppliers','أفضل 5 الموردين',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1525,'ar','SupplierPurchasesReport','تقرير المشتريات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1526,'ar','SupplierPaiementsReport','تقرير المدفوعات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1527,'ar','Name','اسم',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1528,'ar','ManagementWarehouse','إدارة المستودعات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1529,'ar','ZipCode','الرمز البريدي',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1530,'ar','managementCategories','إدارة التصنيفات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1531,'ar','Codecategorie','رمز الفئة',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1532,'ar','Namecategorie','اسم الفئة',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1533,'ar','Parentcategorie','اصل الفئة',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1534,'ar','managementTax','إدارة الضرائب',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1535,'ar','TaxName','اسم الضريبة',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1536,'ar','TaxRate','معدل الضريبة',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1537,'ar','managementUnitPurchases','إدارة وحدة المشتريات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1538,'ar','managementUnitSales','إدارة وحدة المبيعات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1539,'ar','ShortName','اسم قصير',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1540,'ar','PleaseSelectThesebeforeaddinganyproduct','يرجى تحديد هذه قبل إضافة أي منتج',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1541,'ar','StockAdjustement','تعديل المخزون',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1542,'ar','PleaseSelectWarehouse','يرجى تحديد المستودع قبل اختيار أي منتج',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1543,'ar','StockTransfer','تحويل المخزون',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1544,'ar','Today','اليوم',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1545,'ar','SelectPeriod','حدد الفترة',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1546,'ar','ThisToday','هذا اليوم',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1547,'ar','ThisYear','هذا العام',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1548,'ar','ThisMonth','هذا الشهر',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1549,'ar','ThisWeek','هذا الاسبوع',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1550,'ar','AdjustmentDetail','تفاصيل التعديل',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1551,'ar','ActivateUser','تم تنشيط هذا المستخدم',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1552,'ar','DisActivateUser','تم إلغاء تنشيط هذا المستخدم',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1553,'ar','NotFound','الصفحة غير موجودة.',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1554,'ar','oops','خطأ! الصفحة غير موجودة.',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1555,'ar','couldNotFind','لم نتمكن من العثور على الصفحة التي تبحث عنها ، وفي الوقت نفسه ، يمكنك ذلك',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1556,'ar','ReturnDashboard','العودة إلى لوحة القيادة',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1557,'ar','hrm','إدارة الموارد البشرية',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1558,'ar','Employees','الموظفين',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1559,'ar','Attendance','الحضور',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1560,'ar','Leave_request','طلب إجازة',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1561,'ar','Leave_type','نوع الإجازة',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1562,'ar','Company','الشركة',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1563,'ar','Departments','الإدارات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1564,'ar','Designations','التعيينات',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1565,'ar','Office_Shift','مكتب التحول',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1566,'ar','Holidays','العطل',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1567,'ar','Enter_Company_Name','ادخل اسم الشركة',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1568,'ar','Enter_email_address','أدخل عنوان البريد الالكتروني',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1569,'ar','Enter_Company_Phone','أدخل رقم هاتف الشركة',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1570,'ar','Enter_Company_Country','أدخل بلد الشركة',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1571,'ar','Created_in_successfully','تم إنشاؤه بنجاح',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1572,'ar','Updated_in_successfully','تم التحديث بنجاح',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1573,'ar','Deleted_in_successfully','تم الحذف بنجاح',0,'2025-06-18 01:49:36.000000','2025-06-18 01:49:36.000000'),(1574,'ar','department','إدارة',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1575,'ar','Enter_Department_Name','أدخل اسم الإدارة',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1576,'ar','Choose_Company','اختر الشركة',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1577,'ar','Department_Head','رئيس القسم',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1578,'ar','Choose_Department_Head','اختر رئيس القسم',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1579,'ar','Enter_Shift_name','أدخل اسم التحول',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1580,'ar','Monday_In','الاثنين من',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1581,'ar','Monday_Out','الاثنين الى',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1582,'ar','Tuesday_In','الثلاثاء من',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1583,'ar','tuesday_out','الثلاثاء الى',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1584,'ar','wednesday_in','الأربعاء من',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1585,'ar','wednesday_out','الأربعاء الى',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1586,'ar','thursday_in','الخميس الى',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1587,'ar','thursday_out','الخميس الى',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1588,'ar','friday_in','الجمعة من',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1589,'ar','friday_out','الجمعة الى',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1590,'ar','saturday_in','السبت من',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1591,'ar','saturday_out','السبت الى',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1592,'ar','sunday_in','الأحد من',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1593,'ar','sunday_out','الأحد الى',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1594,'ar','Holiday','الاجازة',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1595,'ar','Enter_title','أدخل العنوان',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1596,'ar','title','العنوان',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1597,'ar','start_date','تاريخ البداية',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1598,'ar','Enter_Start_date','أدخل تاريخ البدء',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1599,'ar','Finish_Date','تاريخ الانتهاء',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1600,'ar','Enter_Finish_date','أدخل تاريخ الانتهاء',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1601,'ar','Please_provide_any_details','يرجى تقديم أي تفاصيل',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1602,'ar','Attendances','الحضور',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1603,'ar','Enter_Attendance_date','أدخل تاريخ الحضور',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1604,'ar','Time_In','وقت الدخول',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1605,'ar','Time_Out','وقت الخروج',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1606,'ar','Choose_Employee','اختر الموظف',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1607,'ar','Employee','الموظف',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1608,'ar','Work_Duration','مدة العمل',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1609,'ar','remaining_leaves_are_insufficient','الإجازات المتبقية غير كافية',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1610,'ar','Days','أيام',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1611,'ar','Choose_leave_type','اختر نوع الإجازة',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1612,'ar','Leave_Reason','سبب الإجازة',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1613,'ar','Enter_Reason_Leave','أدخل سبب الإجازة',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1614,'ar','Add_Employee','اضافة موظف',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1615,'ar','Enter_FirstName','أدخل الاسم الأول',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1616,'ar','Enter_LastName','أدخل الاسم الأخير',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1617,'ar','Gender','الجنس',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1618,'ar','Choose_Gender','اختر الجنس',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1619,'ar','Enter_Birth_date','أدخل تاريخ الميلاد',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1620,'ar','Birth_date','تاريخ الولادة',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1621,'ar','Enter_Country','أدخل الدولة',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1622,'ar','Enter_Phone_Number','أدخل رقم الهاتف',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1623,'ar','joining_date','تاريخ الانضمام',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1624,'ar','Enter_joining_date','أدخل تاريخ الانضمام',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1625,'ar','Choose_Designation','اختر التعيين',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1626,'ar','Designation','التعيين',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1627,'ar','Choose_Office_Shift','اختر مكتب التحول',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1628,'ar','Enter_Leaving_Date','أدخل تاريخ المغادرة',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1629,'ar','Leaving_Date','تاريخ المغادرة',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1630,'ar','Annual_Leave','الإجازة السنوية',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1631,'ar','Enter_Annual_Leave','أدخل الإجازة السنوية',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1632,'ar','Remaining_leave','الاجازة المتبقية',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1633,'ar','Employee_Details','تفاصيل الموظف',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1634,'ar','Basic_Information','معلومات اساسية',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1635,'ar','Family_status','الوضع العائلي',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1636,'ar','Choose_Family_status','اختر الحالة العائلية',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1637,'ar','Employment_type','نوع الوظيفة',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1638,'ar','Select_Employment_type','حدد نوع التوظيف',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1639,'ar','Enter_City','أدخل المدينة',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1640,'ar','Province','مقاطعة',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1641,'ar','Enter_Province','أدخل المقاطعة',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1642,'ar','Enter_Address','أدخل العنوان',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1643,'ar','Enter_Zip_code','أدخل الرمز البريدي',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1644,'ar','Zip_code','الرمز البريدي',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1645,'ar','Hourly_rate','السعر بالساعة',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1646,'ar','Enter_Hourly_rate','أدخل سعر الساعة',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1647,'ar','Basic_salary','الراتب الاساسي',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1648,'ar','Enter_Basic_salary','أدخل الراتب الأساسي',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1649,'ar','Social_Media','وسائل التواصل الاجتماعي',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1650,'ar','Skype','سكايب',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1651,'ar','Enter_Skype','أدخل سكايب',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1652,'ar','Facebook','فيسبوك',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1653,'ar','Enter_Facebook','أدخل الفيسبوك',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1654,'ar','WhatsApp','واتس اب',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1655,'ar','Enter_WhatsApp','أدخل واتسآب',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1656,'ar','LinkedIn','لينكد إن',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1657,'ar','Enter_LinkedIn','أدخل لينكد إن',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1658,'ar','Twitter','تويتر',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1659,'ar','Enter_Twitter','أدخل تويتر',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1660,'ar','Experiences','الخبرات',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1661,'ar','bank_account','حساب البنك',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1662,'ar','Company_Name','اسم الشركة',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1663,'ar','Location','الموقع',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1664,'ar','Enter_location','أدخل الموقع',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1665,'ar','Enter_Description','أدخل الوصف',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1666,'ar','Bank_Name','اسم البنك',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1667,'ar','Enter_Bank_Name','أدخل اسم البنك',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1668,'ar','Bank_Branch','فرع البنك',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1669,'ar','Enter_Bank_Branch','أدخل فرع البنك',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1670,'ar','Bank_Number','رقم البنك',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1671,'ar','Enter_Bank_Number','أدخل رقم البنك',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1672,'ar','Assigned_warehouses','المخازن المخصصة',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1673,'ar','Top_customers','أفضل العملاء',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1674,'ar','Attachment','المرفق',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1675,'ar','view_employee','مشاهدة الموظفين',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1676,'ar','edit_employee','تحرير الموظفين',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1677,'ar','delete_employee','حذف الموظفين',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1678,'ar','Created_by','تمت الإضافة بواسطة',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1679,'ar','Add_product_IMEI_Serial_number','أضف الرقم التسلسلي للمنتج',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1680,'ar','Product_Has_Imei_Serial_number','المنتج له رقم تسلسلي',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1681,'ar','IMEI_SN','الرقم التسلسلي',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1682,'ar','Shipments','الشحنات',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1683,'ar','delivered_to','سلمت إلى',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1684,'ar','shipment_ref','مرجع الشحنة',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1685,'ar','sale_ref','مرجع البيع',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1686,'ar','Edit_Shipping','تحرير الشحن',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1687,'ar','Packed','معبأة',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1688,'ar','Shipped','تم الشحن',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1689,'ar','Delivered','تم التوصيل',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1690,'ar','Cancelled','ألغيت',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1691,'ar','Shipping_status','حالة الشحن',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1692,'ar','Users_Report','تقرير المستخدمين',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1693,'ar','stock_report','تقرير المخزون',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1694,'ar','Total_quotations','إجمالي عروض الأسعار',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1695,'ar','Total_return_sales','إجمالي عوائد المبيعات',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1696,'ar','Total_return_purchases','إجمالي عوائد المشتريات',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1697,'ar','Total_transfers','إجمالي التحويلات',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1698,'ar','Total_adjustments','إجمالي التعديلات',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1699,'ar','User_report','تقرير المستخدم',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1700,'ar','Current_stock','المخزون الحالي',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1701,'ar','product_name','اسم المنتج',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1702,'ar','Total_Customers_Due','إجمالي الديون',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1703,'ar','Total_Suppliers_Due','إجمالي الديون',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1704,'ar','Some_warehouses','بعض المستودعات',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1705,'ar','Product_Cost','تكلفة المنتج',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1706,'ar','sms_settings','إعدادات الرسائل القصيرة',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1707,'ar','mail_settings','إعدادات البريد',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1708,'ar','Nexmo_SMS','Nexmo SMS',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1709,'ar','TWILIO_SMS','TWILIO SMS',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1710,'ar','Default_SMS_Gateway','بوابة الرسائل القصيرة الافتراضية',0,'2025-06-18 01:49:37.000000','2025-06-18 01:49:37.000000'),(1711,'ar','module_settings','إعدادات الوحدة',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1712,'ar','Module_enabled_success','تم تفعيل الوحدة بنجاح',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1713,'ar','Module_Disabled_success','تم تعطيل الوحدة النمطية بنجاح',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1714,'ar','update_settings','إعدادات التحديث',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1715,'ar','Please_Upload_the_Correct_Module','يرجى تحميل الوحدة الصحيحة',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1716,'ar','Uploaded_Success','تم الرفع بنجاح',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1717,'ar','Customer_details','تفاصيل العميل',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1718,'ar','Edit_Customer','تحرير العميل',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1719,'ar','Delete_Customer','حذف العميل',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1720,'ar','Pay_Due','الدفع المستحق',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1721,'ar','Paying_amount_is_greater_than_Total_Due','مبلغ الدفع أكبر من إجمالي المبلغ المستحق',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1722,'ar','Customer_Invoice','فاتورة العميل',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1723,'ar','This_Product_Not_For_Selling','هذا المنتج ليس للبيع',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1724,'ar','Welcome_to_your_Dashboard','مرحبًا بك في لوحة التحكم',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1725,'ar','Total_Payable','إجمالي الدفع',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1726,'ar','Choose_Sale_Ref','اختر مرجع البيع',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1727,'ar','Please_Select_Sale','يرجى تحديد البيع',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1728,'ar','list_product_returns','قائمة المنتجات المرتجعة',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1729,'ar','Qty_return','إرجاع الكمية',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1730,'ar','Choose_Purchase_Ref','اختر مرجع الشراء',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1731,'ar','Purchase_Ref','مرجع الشراء',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1732,'ar','please_select_purchase','يرجى تحديد شراء',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1733,'ar','qty_return_is_greater_than_qty_purchased','الكمية المرتجعة أكبر من الكمية المشتراة',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1734,'ar','qty_return_is_greater_than_qty_sold','الكمية المرتجعة أكبر من الكمية المباعة',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1735,'ar','Quantity_sold','الكمية المباعة',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1736,'ar','qty_purchased','الكمية المشتراة',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1737,'ar','Sender_Name','اسم المرسل',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1738,'ar','Upload_Module','تحميل الوحدة',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1739,'ar','The_module_must_be_uploaded_as_zip_file','يجب تحميل الوحدة كملف مضغوط',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1740,'ar','All_Modules_Installed','جميع الوحدات المثبتة',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1741,'ar','Current_Version','النسخة الحالية',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1742,'ar','You_already_have_the_latest_version','لديك بالفعل أحدث إصدار',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1743,'ar','Update_Available','التحديث متاح',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1744,'ar','Update_Log','سجل التحديث',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1745,'ar','Update_Now','تحديث الان',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1746,'ar','View_Change_Log','مشاهدة سجل التغيير',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1747,'ar','invoice_footer','تذييل الفاتورة',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1748,'ar','Please_Wait_for_the_update','يرجى انتظار انتهاء التحديث تمامًا. لا يوصى بإغلاق المتصفح أو إيقاف عملية الترقية',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1749,'ar','Note_update','تأكد من الاحتفاظ بنسخة احتياطية من الإصدار الحالي وقاعدة البيانات قبل تشغيل الترقية ، لاستعادتها إذا كان هناك خطأ',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1750,'ar','Time_Zone','المنطقة الزمنية',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1751,'ar','Payment_note','ملاحظات الدفع',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1752,'ar','sale_note','ملاحظات البيع',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1753,'ar','Total_Sale_Due','إجمالي ديون البيع',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1754,'ar','Total_Sell_Return_Due','إجمالي الديون عائد البيع',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1755,'ar','pay_all_sell_due_at_a_time','دفع جميع ديون البيع في وقت واحد',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1756,'ar','pay_all_sell_return_due_at_a_time','دفع جميع ديون عائد البيع في وقت واحد',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1757,'ar','Gross_Profit','اجمالي الربح',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1758,'ar','pay_all_purchase_due_at_a_time','دفع جميع ديون الشراء في وقت واحد',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1759,'ar','Delete_Provider','حذف المورد',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1760,'ar','Edit_Provider','تحرير المورد',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1761,'ar','Provider_details','تفاصيل المورد',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1762,'ar','Total_Purchase_Due','إجمالي ديون الشراء',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1763,'ar','Provider_Credit_Note','إشعار ائتمان المورد',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1764,'ar','Customer_Credit_Note','إشعار ائتمان العميل',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1765,'ar','Sell_Return','عائد بيع',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1766,'ar','Purchase_Return','إرجاع الشراء',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1767,'ar','Tax_Number','الرقم الضريبي',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1768,'ar','Please_add_return_quantity','الرجاء إضافة الكمية المرتجعة',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1769,'ar','Return_exist_for_the_Transaction','العودة موجودة في هذه الصفقة',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1770,'ar','qty_return_is_greater_than_Quantity_Remaining','الكمية المرتجعة أكبر من الكمية المتبقية',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1771,'ar','products_refunded_alert','لن يتم رد أي منتجات ذات كمية محددة على 0',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1772,'ar','pay_all_purchase_return_due_at_a_time','دفع جميع ديون عوائد الشراء في وقت واحد',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1773,'ar','Total_Purchase_Return_Due','إجمالي ديون عوائد الشراء',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1774,'ar','Purchase_return_due','ديون عوائد الشراء',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1775,'ar','Sell_return_due','ديون عوائد البيع',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1776,'ar','product_report','تقرير المنتجات',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1777,'ar','product_sales_report','تقرير مبيعات المنتج',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1778,'ar','Product_purchases_report','تقرير مشتريات المنتج',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1779,'ar','Qty_sold','الكمية المباعة',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1780,'ar','Filter_by_warehouse','تصفية بالمستودع',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1781,'ar','Enable_Print_Invoice','قم بتمكين طباعة الفاتورة تلقائيًا',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1782,'ar','Show_Warehouse','عرض المستودع',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1783,'ar','Saved_Credit_Card_Info','معلومات بطاقة الائتمان المحفوظة',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1784,'ar','Credit_card_changed_successfully','تم تغيير بطاقة الائتمان بنجاح',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1785,'ar','notification_template','قالب الإشعارات',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1786,'ar','email_notification','إشعار بالبريد الإلكتروني',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1787,'ar','sms_notification','إشعار بالرسائل القصيرة (SMS)',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1788,'ar','Change_product_details','تغيير تفاصيل المنتج',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1789,'ar','edit_tax_and_discount_and_shipping','تحرير الضرائب والخصومات والشحن',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1790,'ar','Create_Quotation_with_Stock','إنشاء عرض أسعار مع الأسهم',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1791,'ar','Variant_cost','تكلفة المتغير',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1792,'ar','Variant_price','سعر المتغير',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1793,'ar','Variant_code','رمز المتغير',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1794,'ar','Please_wait_until_the_product_is_loaded','يرجى الانتظار حتى يتم تحميل المنتج',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1795,'ar','Choose_SMS_Gateway','اختر بوابة SMS',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1796,'ar','Notification_Client','إشعار العميل',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1797,'ar','Available_Tags','العلامات المتاحة',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1798,'ar','Email_Subject','عنوان البريد الإلكتروني',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1799,'ar','Email_body','محتوى البريد الإلكتروني',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1800,'ar','Notification_Supplier','إشعار المورد',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1801,'ar','sms_body','محتوى الرسالة القصيرة (SMS)',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1802,'ar','sms_templates','قوالب الرسائل القصيرة',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1803,'ar','email_templates','قوالب البريد الإلكتروني',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1804,'ar','Edit_Project','تعديل المشروع',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1805,'ar','Projects','المشاريع',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1806,'ar','Enter_Project_Title','أدخل عنوان المشروع',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1807,'ar','Assigned_Employees','الموظفون المعينون',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1808,'ar','Choose_Team','اختر الفريق',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1809,'ar','Create_Project','إنشاء مشروع',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1810,'ar','Project_List','قائمة المشاريع',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1811,'ar','Not_Started','لم يبدأ',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1812,'ar','In_Progress','قيد التقدم',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1813,'ar','On_Hold','في الانتظار',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1814,'ar','Edit_Task','تعديل المهمة',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1815,'ar','Tasks','المهام',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1816,'ar','Enter_Task_Title','أدخل عنوان المهمة',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1817,'ar','Choose_Project','اختر المشروع',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1818,'ar','Project','المشروع',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1819,'ar','Create_Task','إنشاء مهمة',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1820,'ar','Task_List','قائمة المهام',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1821,'ar','Import_Purchases','استيراد المشتريات',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1822,'ar','Warranty_Period','مدة الضمان',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1823,'ar','Months','أشهر',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1824,'ar','Years','سنوات',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1825,'ar','WarrantyTerms','شروط الضمان',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1826,'ar','HasGuarantee','يتضمن ضمان',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1827,'ar','Guarantee_Period','فترة الضمان',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1828,'ar','OpeningStock','المخزون الافتتاحي',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1829,'ar','Warranty_Guarantee_Tracking','تتبع الضمان والكفالة',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1830,'ar','PaymentOption','طريقة الدفع',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1831,'ar','AddAnotherPaymentOption','إضافة طريقة دفع أخرى',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1832,'ar','PopularTendered','المبالغ الشائعة',0,'2025-06-18 01:49:38.000000','2025-06-18 01:49:38.000000'),(1833,'ar','clear','مسح',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1834,'ar','Pay','دفع',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1835,'ar','Payment','الدفع',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1836,'ar','TotalPaidExceedsGrandTotalForMultiPayment','المبلغ المدفوع يتجاوز الإجمالي المستحق',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1837,'ar','TotalPaying','إجمالي الدفع',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1838,'ar','ChangeReturn','المبلغ المرتجع',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1839,'ar','AmountPaying','المبلغ المدفوع',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1840,'ar','Appearance_Settings','إعدادات المظهر',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1841,'ar','app_name','اسم التطبيق',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1842,'ar','page_title_suffix','لاحقة عنوان الصفحة',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1843,'ar','ChangeFavicon','تغيير الأيقونة (Favicon)',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1844,'ar','Languages','اللغات',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1845,'ar','Translations','الترجمات',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1846,'ar','Translations for','الترجمات لـ',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1847,'ar','Back','رجوع',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1848,'ar','Save All Changes','حفظ جميع التعديلات',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1849,'ar','Add New','إضافة جديد',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1850,'ar','Add New Translation','إضافة ترجمة جديدة',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1851,'ar','Save','حفظ',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1852,'ar','Delete','حذف',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1853,'ar','Showing','عرض',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1854,'ar','Translation added','تمت إضافة الترجمة',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1855,'ar','Failed to add translation','فشل في إضافة الترجمة',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1856,'ar','Translation updated','تم تحديث الترجمة',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1857,'ar','Failed to update','فشل في التحديث',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1858,'ar','No changes to save','لا توجد تغييرات لحفظها',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1859,'ar','Notice','تنبيه',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1860,'ar','All changes saved successfully','تم حفظ جميع التغييرات بنجاح',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1861,'ar','Bulk save failed','فشل حفظ التغييرات دفعة واحدة',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1862,'ar','Please reload the page after saving translations to apply the changes.','يرجى إعادة تحميل الصفحة بعد حفظ الترجمات لتطبيق التغييرات.',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1863,'ar','Action_Blocked','تم حظر العملية',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1864,'ar','You_cannot_delete_the_default_language','لا يمكنك حذف اللغة الافتراضية',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1865,'ar','Flag','العلم',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1866,'ar','Locale','الرمز المحلي',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1867,'ar','Update Language','تحديث اللغة',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1868,'ar','Add Language','إضافة لغة',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1869,'ar','Send_Email','إرسال بريد إلكتروني',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1870,'ar','Send_SMS','إرسال رسالة نصية',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1871,'ar','total_sales','إجمالي المبيعات',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1872,'ar','Opening_Stock','المخزون الافتتاحي',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1873,'ar','Subscription_Product','منتج الاشتراك',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1874,'ar','Subscriptions','الاشتراكات',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1875,'ar','Billing_Cycle','دورة الفوترة',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1876,'ar','total_cycles','إجمالي الدورات',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1877,'ar','remaining_cycles','الدورات المتبقية',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1878,'ar','next_billing_date','تاريخ الفوترة التالي',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1879,'ar','Failed_to_update_subscription_status','فشل في تحديث حالة الاشتراك',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1880,'ar','Subscription_status_updated_successfully','تم تحديث حالة الاشتراك بنجاح',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1881,'ar','Create_Susbscription','إنشاء اشتراك',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1882,'ar','Price_Per_Cycle','السعر لكل دورة',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1883,'ar','Price_Per_Unit','السعر لكل وحدة',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1884,'ar','Active','نشط',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1885,'ar','Canceled','ملغي',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1886,'ar','Completed','مكتمل',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1887,'ar','Subscription_details','تفاصيل الاشتراك',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1888,'ar','Dynamic_Appearance','مظهر ديناميكي',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1889,'ar','Payment_Methods','طرق الدفع',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1890,'ar','You_cant_edit_or_remove_default_payment_choices','لا يمكنك تعديل أو إزالة خيارات الدفع الافتراضية',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1891,'ar','Enter_Payment_Method','أدخل طريقة الدفع',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1892,'ar','Sales_by_Category','المبيعات حسب الفئة',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1893,'ar','Sales_by_Brand','المبيعات حسب العلامة التجارية',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1894,'ar','Error_Logs','سجلات الأخطاء',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1895,'ar','Occurred_At','وقت الحدوث',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1896,'ar','Context','السياق',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1897,'ar','Report_Transactions','تقرير المعاملات',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1898,'ar','Payment_Method','طريقة الدفع',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1899,'ar','Customer_Provider','العميل/المزود',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1900,'ar','Sale_Purchase_Ref','مرجع البيع/الشراء',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1901,'ba','Draft_Created_successfully','মসদি সফলভাবে তৈরি হয়েছে',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1902,'ba','Draft_Sale_Deleted','মসদি বিক্রয় মুছে ফেলা হয়েছে',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1903,'ba','Inventory_Valuation_Based_on_Average_Cost','সর্বমোট মূল্য গড় ভিত্তিতে মজুদ মূল্যায়ন',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1904,'ba','Payroll','বেতন',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1905,'ba','Transfers_Money','অর্থ স্থানান্তর',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1906,'ba','Inventory_Valuation','মজুদের মূল্যায়ন',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1907,'ba','Deposits_Report','আমানত রিপোর্ট',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1908,'ba','Expense_Report','ব্যয় রিপোর্ট',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1909,'ba','Deposit_Category','আমানত বিভাগ',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1910,'ba','Total_Deposits','মোট আমানত',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1911,'ba','Expense_Category','বিভাগ',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1912,'ba','Total_Expenses','মোট ব্যয়',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1913,'ba','ASSET_VALUE','সম্পত্তির মান',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1914,'ba','STOCK_ON_HAND','হাতে মজুদ',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1915,'ba','Variant_NAME','পণ্যের পদক্ষেপের নাম',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(1916,'ba','SKU','এসকেইউ',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1917,'ba','ITEM_NAME','পণ্যের নাম',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1918,'ba','From_Account','থেকে অ্যাকাউন্ট',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1919,'ba','To_Account','থেকে অ্যাকাউন্ট',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1920,'ba','Accounts_cannot_be_the_same','অ্যাকাউন্টগুলি একই হতে পারে না',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1921,'ba','CountStock','মূল্যায়ন স্টক',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1922,'ba','Successfully_Generated_Count','সফলভাবে মূল্যায়ন তৈরি হয়েছে',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1923,'ba','Count','গণনা',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1924,'ba','file','ফাইল',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1925,'ba','Accounting','হিসাবরক্ষণ',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1926,'ba','deposit_delete','আমানত মুছুন',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1927,'ba','deposit_edit','আমানত সম্পাদনা করুন',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1928,'ba','deposit_add','আমানত যোগ করুন',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1929,'ba','deposit_view','আমানত দেখুন',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1930,'ba','expense_add','ব্যয় যোগ করুন',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1931,'ba','expense_edit','ব্যয় সম্পাদনা করুন',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1932,'ba','expense_delete','ব্যয় মুছুন',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1933,'ba','List_Deposit','আমানতের তালিকা',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1934,'ba','Create_deposit','আমানত তৈরি করুন',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1935,'ba','List_accounts','হিসাবের তালিকা',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1936,'ba','Account','অ্যাকাউন্ট',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1937,'ba','Choose_Account','অ্যাকাউন্ট নির্বাচন করুন',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1938,'ba','Deposits','আমানত',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1939,'ba','account_num','অ্যাকাউন্ট নম্বর',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1940,'ba','Enter_account_num','অ্যাকাউন্ট নম্বর লিখুন',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1941,'ba','account_name','অ্যাকাউন্টের নাম',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1942,'ba','Enter_account_name','অ্যাকাউন্টের নাম লিখুন',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1943,'ba','initial_balance','প্রাথমিক ব্যালেন্স',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1944,'ba','Enter_initial_balance','প্রাথমিক ব্যালেন্স লিখুন',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1945,'ba','notes','মন্তব্য',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1946,'ba','balance','ভারসাম্য',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(1947,'ba','Receipt','রসিদ',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1948,'ba','Pos_Settings','POS সেটিংস',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(1949,'ba','Note_to_customer','গ্রাহককে নোট করুন',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1950,'ba','Show_Note_to_customer','গ্রাহককে নোট দেখান',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1951,'ba','Show_barcode','বারকোড দেখান',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1952,'ba','Show_Tax_and_Discount','ট্যাক্স এবং ডিসকাউন্ট এবং শিপিং দেখান',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1953,'ba','Show_Customer','গ্রাহক দেখান',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1954,'ba','Show_Email','ইমেইল দেখান',0,'2025-06-18 01:49:39.000000','2025-06-18 01:49:39.000000'),(1955,'ba','Show_Phone','ফোন দেখান',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1956,'ba','Show_Address','ঠিকানা দেখান',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1957,'ba','DefaultLanguage','নির্ধারিত ভাষা',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1958,'ba','footer','ফুটার',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1959,'ba','Received_Amount','প্রাপ্তির পরিমাণ',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1960,'ba','Paying_Amount','পরিশোধের পরিমাণ',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1961,'ba','Change','রিটার্ন পরিবর্তন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1962,'ba','Paying_amount_is_greater_than_Received_amount','পরিশোধের পরিমাণ প্রাপ্ত পরিমাণের চেয়ে বেশি',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1963,'ba','Paying_amount_is_greater_than_Grand_Total','অর্থপ্রদানের পরিমাণ গ্র্যান্ড মোটের চেয়ে বেশি',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1964,'ba','code_must_be_not_exist_already','কোড ইতিমধ্যে বিদ্যমান না থাকা আবশ্যক',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1965,'ba','You_will_find_your_backup_on','আপনি আপনার ব্যাকআপ পাবেন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1966,'ba','and_save_it_to_your_pc','এবং আপনার পিসিতে সংরক্ষণ করুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1967,'ba','Scan_your_barcode_and_select_the_correct_symbology_below','আপনার বারকোড স্ক্যান করুন এবং নীচের সঠিক সিম্বলজি নির্বাচন করুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1968,'ba','Scan_Search_Product_by_Code_Name','কোড বা নাম দ্বারা পণ্য স্ক্যান/অনুসন্ধান করুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1969,'ba','Paper_size','কাগজের আকার',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1970,'ba','Clear_Cache','ক্যাশে সাফ করুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1971,'ba','Cache_cleared_successfully','ক্যাশে সফলভাবে সাফ করা হয়েছে৷',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1972,'ba','Failed_to_clear_cache','ক্যাশে সাফ করতে ব্যর্থ হয়েছে৷',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1973,'ba','Scan_Barcode','বারকোড স্ক্যানার',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1974,'ba','Please_use_short_name_of_unit','অনুগ্রহ করে ইউনিটের সংক্ষিপ্ত নাম ব্যবহার করুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1975,'ba','DefaultCustomer','ডিফল্ট গ্রাহক',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1976,'ba','DefaultWarehouse','ডিফল্ট গুদাম',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1977,'ba','Payment_Gateway','পেমেন্ট গেটওয়ে',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(1978,'ba','SMS_Configuration','এসএমএস কনফিগারেশন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1979,'ba','Gateway','এসএমএস গেটওয়ে',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1980,'ba','Choose_Gateway','এসএমএস গেটওয়ে নির্বাচন করুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1981,'ba','sms_send_successfully','বার্তা সফলভাবে পাঠানো হয়েছে',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1982,'ba','sms_config_invalid','ভুল এসএমএস কনফিগারেশন অবৈধ',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1983,'ba','Remove_Stripe_Key_Secret','স্ট্রাইপ এপিআই কী মুছুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1984,'ba','credit_card_account_not_available','ক্রেডিট কার্ড অ্যাকাউন্ট উপলব্ধ নেই',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1985,'ba','Credit_Card_Info','ক্রেডিট কার্ড তথ্য',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(1986,'ba','developed_by','দ্বারা বিকশিত',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1987,'ba','Unit_already_linked_with_sub_unit','ইউনিট ইতিমধ্যে সাব ইউনিটের সাথে লিঙ্ক করা হয়েছে৷',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1988,'ba','Total_Items_Quantity','মোট আইটেম এবং পরিমাণ',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1989,'ba','Value_by_Cost_and_Price','খরচ এবং মূল্য',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1990,'ba','Search_this_table','এই টেবিল অনুসন্ধান করুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1991,'ba','import_products','পণ্য আমদানি করুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1992,'ba','Field_optional','ক্ষেত্র ঐচ্ছিক',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1993,'ba','Download_exemple','উদাহরণ ডাউনলোড করুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1994,'ba','field_must_be_in_csv_format','ক্ষেত্র অবশ্যই csv ফরম্যাটে হতে হবে',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1995,'ba','Successfully_Imported','সফলভাবে আমদানি করা হয়েছে',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1996,'ba','file_size_must_be_less_than_1_mega','ফাইলের আকার 1 মেগা থেকে কম হতে হবে',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1997,'ba','Please_follow_the_import_instructions','আমদানি নির্দেশাবলী অনুসরণ করুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1998,'ba','must_be_exist','ইউনিট ইতিমধ্যে তৈরি করতে হবে',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(1999,'ba','Import_Customers','গ্রাহকদের আমদানি করুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2000,'ba','Import_Suppliers','আমদানি সরবরাহকারী',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2001,'ba','Recent_Sales','সাম্প্রতিক বিক্রয়',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2002,'ba','Create_Transfer','ট্রান্সফার তৈরি করুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2003,'ba','order_products','অর্ডার আইটেম',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2004,'ba','Search_Product_by_Code_Name','কোড বা নাম দ্বারা পণ্য অনুসন্ধান করুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2005,'ba','Reports_payments_Purchase_Return','রিপোর্ট ক্রয় রিটার্ন পেমেন্ট',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2006,'ba','Reports_payments_Sale_Return','রিপোর্ট বিক্রয় রিটার্ন পেমেন্ট',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2007,'ba','payments_Sales_Return','পেমেন্ট বিক্রয় রিটার্ন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2008,'ba','payments_Purchases_Return','পেমেন্ট ক্রয় রিটার্ন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2009,'ba','CreateSaleReturn','বিক্রয় রিটার্ন তৈরি করুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2010,'ba','EditSaleReturn','বিক্রয় রিটার্ন সম্পাদনা করুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2011,'ba','SalesReturn','বিক্রয় রিটার্ন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2012,'ba','CreatePurchaseReturn','ক্রয় রিটার্ন তৈরি করুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2013,'ba','EditPurchaseReturn','ক্রয় রিটার্ন সম্পাদনা করুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2014,'ba','PurchasesReturn','ক্রয় রিটার্ন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2015,'ba','Due','বাকি',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2016,'ba','Profit','লাভ',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2017,'ba','Revenue','রাজস্ব',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2018,'ba','Sales_today','আজ সেলস',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2019,'ba','People','মানুষ',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2020,'ba','Successfully_Created','সফলভাবে তৈরি',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2021,'ba','Successfully_Updated','সফলভাবে আপডেট',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2022,'ba','Success','সফলতা',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2023,'ba','Failed','ব্যর্থ হয়েছে',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2024,'ba','Warning','সতর্কবাণী',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2025,'ba','Please_fill_the_form_correctly','অনুগ্রহ করে ফর্মটি সঠিকভাবে পূরণ করুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2026,'ba','Field_is_required','এই ক্ষেত্র প্রয়োজন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2027,'ba','Error','ত্রুটি!',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2028,'ba','you_are_not_authorized','দুঃখিত! আপনি অনুমোদিত নন।',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2029,'ba','Go_back_to_home','হোমপেজে ফিরে যান',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2030,'ba','page_not_exist','দুঃখিত! আপনি যে পৃষ্ঠাটি খুঁজছিলেন সেটি বিদ্যমান নেই৷',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2031,'ba','Choose_Status','স্ট্যাটাস বেছে নিন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2032,'ba','Choose_Method','পদ্ধতি বেছে নিন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2033,'ba','Choose_Symbology','প্রতীকবিদ্যা চয়ন করুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2034,'ba','Choose_Category','বিভাগ চয়ন করুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2035,'ba','Choose_Customer','গ্রাহক চয়ন করুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2036,'ba','Choose_Supplier','সরবরাহকারী চয়ন করুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2037,'ba','Choose_Unit_Purchase','ক্রয় ইউনিট নির্বাচন করুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2038,'ba','Choose_Sub_Category','উপশ্রেণী নির্বাচন করুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2039,'ba','Choose_Brand','ব্র্যান্ড চয়ন করুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2040,'ba','Choose_Warehouse','ওয়্যারহাউস বেছে নিন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2041,'ba','Choose_Unit_Sale','বিক্রয় ইউনিট নির্বাচন করুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2042,'ba','Enter_Product_Cost','পণ্য খরচ লিখুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2043,'ba','Enter_Stock_alert','স্টক সতর্কতা প্রবেশ করুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2044,'ba','Choose_Unit_Product','পণ্য ইউনিট চয়ন করুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2045,'ba','Enter_Product_Price','পণ্যের দাম লিখুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2046,'ba','Enter_Name_Product','পণ্যের নাম লিখুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2047,'ba','Enter_Role_Name','ভূমিকার নাম লিখুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2048,'ba','Enter_Role_Description','ভূমিকার বর্ণনা লিখুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2049,'ba','Enter_name_category','ক্যাটাগরির নাম লিখুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2050,'ba','Enter_Code_category','ক্যাটাগরি কোড লিখুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2051,'ba','Enter_Name_Brand','নাম ব্র্যান্ড লিখুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2052,'ba','Enter_Description_Brand','বিবরণ ব্র্যান্ড লিখুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2053,'ba','Enter_Code_Currency','কোড মুদ্রা লিখুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2054,'ba','Enter_name_Currency','নাম মুদ্রা লিখুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2055,'ba','Enter_Symbol_Currency','প্রতীক মুদ্রা লিখুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2056,'ba','Enter_Name_Unit','ইউনিটের নাম লিখুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2057,'ba','Enter_ShortName_Unit','সংক্ষিপ্ত নাম ইউনিট লিখুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2058,'ba','Choose_Base_Unit','বেস ইউনিট চয়ন করুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2059,'ba','Choose_Operator','অপারেটর চয়ন করুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2060,'ba','Enter_Operation_Value','অপারেশন মান লিখুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2061,'ba','Enter_Name_Warehouse','গুদাম নাম লিখুন',0,'2025-06-18 01:49:40.000000','2025-06-18 01:49:40.000000'),(2062,'ba','Enter_Phone_Warehouse','ওয়্যারহাউস ফোন লিখুন',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2063,'ba','Enter_Country_Warehouse','গুদাম দেশ লিখুন',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2064,'ba','Enter_City_Warehouse','ওয়্যারহাউস সিটিতে প্রবেশ করুন',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2065,'ba','Enter_Email_Warehouse','গুদাম ইমেল লিখুন',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2066,'ba','Enter_ZipCode_Warehouse','গুদাম জিপ কোড লিখুন',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2067,'ba','Choose_Currency','মুদ্রা পছন্দ করুন',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2068,'ba','Thank_you_for_your_business','আমাদের সাথে কেনাকাটা করার জন্য আপনাকে ধন্যবাদ . অনুগ্রহ করে আবার আসবেন',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2069,'ba','Cancel','বাতিল করুন',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2070,'ba','New_Customer','নতুন গ্রাহক',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2071,'ba','Incorrect_Login','ভুল লগইন',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2072,'ba','Successfully_Logged_In','সফলভাবে লগ ইন',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2073,'ba','This_user_not_active','এই ব্যবহারকারী সক্রিয় নয়',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2074,'ba','SignIn','সাইন ইন করুন',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2075,'ba','Create_an_account','একটি অ্যাকাউন্ট তৈরি করুন',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2076,'ba','Forgot_Password','পাসওয়ার্ড ভুলে গেছেন ?',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2077,'ba','Email_Address','ইমেইল ঠিকানা',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2078,'ba','SignUp','সাইন আপ করুন',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2079,'ba','Already_have_an_account','ইতিমধ্যে একটি একাউন্ট আছে ?',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2080,'ba','Reset_Password','পাসওয়ার্ড রিসেট করুন',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2081,'ba','Failed_to_authenticate_on_SMTP_server','মেল সার্ভারে প্রমাণীকরণ করতে ব্যর্থ হয়েছে৷',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2082,'ba','We_cant_find_a_user_with_that_email_addres','আমরা সেই ইমেল ঠিকানা সহ একজন ব্যবহারকারী খুঁজে পাচ্ছি না',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2083,'ba','We_have_emailed_your_password_reset_link','আমরা আপনার পাসওয়ার্ড রিসেট লিঙ্ক ই-মেইল করেছি',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2084,'ba','Please_fill_the_Email_Adress','অনুগ্রহ করে ইমেল ঠিকানা পূরণ করুন',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2085,'ba','Confirm_password','পাসওয়ার্ড নিশ্চিত করুন',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2086,'ba','Your_Password_has_been_changed','আপনার পাসওয়ার্ড পরিবর্তন করা হয়েছে',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2087,'ba','The_password_confirmation_does_not_match','পাসওয়ার্ড নিশ্চিতকরণ মেলে না',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2088,'ba','This_password_reset_token_is_invalid','এই পাসওয়ার্ড রিসেট টোকেন অবৈধ',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2089,'ba','Warehouse_report','গুদাম রিপোর্ট',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2090,'ba','All_Warehouses','সমস্ত গুদাম',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2091,'ba','Expense_List','সমস্ত ব্যয়',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2092,'ba','Expenses','ব্যয়',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2093,'ba','This_Week_Sales_Purchases','এই সপ্তাহে বিক্রয় এবং ক্রয়',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2094,'ba','Top_Selling_Products','শীর্ষ বিক্রয় পণ্য',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2095,'ba','View_all','সব দেখ',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2096,'ba','Payment_Sent_Received','পেমেন্ট পাঠানো এবং প্রাপ্ত',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2097,'ba','Filter','ছাঁকনি',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2098,'ba','Invoice_POS','চালান POS',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2099,'ba','Invoice','চালান',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2100,'ba','Customer_Info','গ্রাহক তথ্য',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2101,'ba','Company_Info','কোম্পানির তথ্য',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2102,'ba','Invoice_Info','চালান তথ্য',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2103,'ba','Order_Summary','অর্ডার সারাংশ',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2104,'ba','Quote_Info','কোটেশন তথ্য',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2105,'ba','Del','মুছে ফেলা',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2106,'ba','SuppliersPaiementsReport','সরবরাহকারী পেমেন্ট রিপোর্ট',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2107,'ba','Purchase_Info','ক্রয় তথ্য',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2108,'ba','Supplier_Info','সরবরাহকারীর তথ্য',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2109,'ba','Return_Info','প্রত্যাবর্তনের তথ্য',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2110,'ba','Create_Expense','ব্যয় তৈরি করুন',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2111,'ba','Details','বিস্তারিত',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2112,'ba','Discount_Method','ডিসকাউন্ট টাইপ',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2113,'ba','Net_Unit_Cost','নেট ইউনিট খরচ',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2114,'ba','Net_Unit_Price','নেট ইউনিট মূল্য',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2115,'ba','Edit_Expense','ব্যয় সম্পাদনা করুন',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2116,'ba','All_Brand','সমস্ত ব্র্যান্ড',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2117,'ba','All_Category','সমস্ত বিভাগ',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2118,'ba','ListExpenses','সমস্ত খরচ',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2119,'ba','Create_Permission','অনুমতি তৈরি করুন',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2120,'ba','Edit_Permission','সম্পাদনা অনুমতি',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2121,'ba','Reports_payments_Sales','পেমেন্ট বিক্রয় রিপোর্ট',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2122,'ba','Reports_payments_Purchases','রিপোর্ট পেমেন্ট ক্রয়',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2123,'ba','Reports_payments_Return_Customers','পেমেন্ট রিটার্ন গ্রাহকদের',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2124,'ba','Reports_payments_Return_Suppliers','পেমেন্ট রিটার্ন সরবরাহকারী',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2125,'ba','Expense_Deleted','এই ব্যয় মুছে ফেলা হয়েছে',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2126,'ba','Expense_Updated','এই ব্যয় আপডেট করা হয়েছে',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2127,'ba','Expense_Created','এই ব্যয় তৈরি করা হয়েছে',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2128,'ba','DemoVersion','আপনি ডেমো সংস্করণে এটি করতে পারবেন না',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2129,'ba','OrderStatistics','বিক্রয় পরিসংখ্যান',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2130,'ba','AlreadyAdd','এই পণ্য ইতিমধ্যে যোগ করা হয়েছে!!',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2131,'ba','AddProductToList','তালিকায় পণ্য যোগ করুন!',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2132,'ba','AddQuantity','অনুগ্রহ করে পণ্যের পরিমাণ যোগ করুন !!',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2133,'ba','InvalidData','অবৈধ তথ্য !!',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2134,'ba','LowStock','পরিমাণ স্টক উপলব্ধ পরিমাণ অতিক্রম',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2135,'ba','WarehouseIdentical','দুটি গুদাম একই হতে পারে না!!',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2136,'ba','VariantDuplicate','এই ভেরিয়েন্টটি ডুপ্লিকেট!!',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2137,'ba','Filesize','ফাইলের আকার',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2138,'ba','GenerateBackup','ব্যাকআপ জেনারেট করুন',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2139,'ba','BackupDatabase','ব্যাকআপ ডাটাবেস',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2140,'ba','Backup','ব্যাকআপ',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2141,'ba','Paid','পরিশোধিত পরিমাণ',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2142,'ba','Unpaid','অবৈতনিক',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2143,'ba','Today','আজ',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2144,'ba','Income','আয়',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2145,'ba','Sale','বিক্রয়',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2146,'ba','Actif','সক্রিয়',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2147,'ba','Inactif','নিষ্ক্রিয়',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2148,'ba','Customers','গ্রাহকদের',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2149,'ba','Phone','ফোন',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2150,'ba','SearchByPhone','ফোন দ্বারা অনুসন্ধান করুন',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2151,'ba','Suppliers','সরবরাহকারীদের',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2152,'ba','Quotations','কোটেশন',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2153,'ba','Sales','সেলস',0,'2025-06-18 01:49:41.000000','2025-06-18 01:49:41.000000'),(2154,'ba','Purchases','কেনাকাটা',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2155,'ba','Returns','প্রত্যাবর্তন',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2156,'ba','Settings','সেটিংস',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2157,'ba','SystemSettings','সিস্টেম সেটিংস',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2158,'ba','Users','ব্যবহারকারীদের',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2159,'ba','GroupPermissions','গ্রুপ অনুমতি',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2160,'ba','Currencies','কারেন্সি',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2161,'ba','Warehouses','গুদাম',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2162,'ba','Units','ইউনিট',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2163,'ba','UnitsPrchases','ক্রয় ইউনিট',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2164,'ba','UnitsSales','বিক্রয় ইউনিট',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2165,'ba','Reports','রিপোর্ট',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2166,'ba','PaymentsReport','পেমেন্ট রিপোর্ট',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2167,'ba','PaymentsPurchases','পেমেন্ট ক্রয়',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2168,'ba','PaymentsSales','পেমেন্ট বিক্রয়',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2169,'ba','ProfitandLoss','লাভ এবং ক্ষতি',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2170,'ba','WarehouseStockChart','গুদাম স্টক চার্ট',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2171,'ba','SalesReport','বিক্রয় প্রতিবেদন',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2172,'ba','PurchasesReport','Purchase Reportক্রয় প্রতিবেদন',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2173,'ba','CustomersReport','গ্রাহক রিপোর্ট',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2174,'ba','SuppliersReport','সরবরাহকারী রিপোর্ট',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2175,'ba','SupplierReport','সরবরাহকারী রিপোর্ট',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2176,'ba','DailySalesData','দৈনিক বিক্রয় ডেটা',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2177,'ba','DailyPurchasesData','দৈনিক ক্রয় ডেটা',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2178,'ba','Dernièrescinqrecords','সর্বশেষ পাঁচটি রেকর্ড',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2179,'ba','Filters','ফিল্টার',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2180,'ba','date','তারিখ',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2181,'ba','Reference','রেফারেন্স',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2182,'ba','Supplier','সরবরাহকারী',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2183,'ba','PaymentStatus','পরিশোধের হাল',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2184,'ba','Customer','গ্রাহক',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2185,'ba','CustomerCode','গ্রাহক কোড',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2186,'ba','Status','স্ট্যাটাস',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2187,'ba','SupplierCode','সরবরাহকারী কোড',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2188,'ba','Categorie','ক্যাটাগরি',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2189,'ba','Categories','ক্যাটাগরি',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2190,'ba','StockTransfers','স্থানান্তর',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2191,'ba','StockManagement','স্টক ব্যবস্থাপনা',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2192,'ba','dashboard','ড্যাশবোর্ড',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2193,'ba','Products','পণ্য',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2194,'ba','productsList','সব পণ্য',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2195,'ba','ProductManagement','পণ্য ব্যবস্থাপনা',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2196,'ba','ProductQuantityAlerts','পণ্য পরিমাণ সতর্কতা',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2197,'ba','CodeProduct','কোড পণ্য',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2198,'ba','ProductTax','গুণফল ট্যাক্স',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2199,'ba','SubCategorie','সাব ক্যাটাগরি',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2200,'ba','Name_product','নাম',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2201,'ba','StockAlert','স্টক সতর্কতা',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2202,'ba','warehouse','গুদাম',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2203,'ba','Tax','ট্যাক্স',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2204,'ba','BuyingPrice','ক্রয় মূল্য',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2205,'ba','SellPrice','বিক্রয় মূল্য',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2206,'ba','Quantity','পরিমান',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2207,'ba','UnitSale','বিক্রয় ইউনিট',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2208,'ba','UnitPurchase','ক্রয় ইউনিট',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2209,'ba','ManagementCurrencies','মুদ্রা ব্যবস্থাপনা',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2210,'ba','CurrencyCode','মুদ্রা কোড',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2211,'ba','CurrencyName','মুদ্রার নাম',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2212,'ba','Symbol','প্রতীক',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2213,'ba','All','সব',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2214,'ba','EditProduct','পণ্য সম্পাদনা করুন',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2215,'ba','SearchByCode','কোড দ্বারা অনুসন্ধান করুন',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2216,'ba','SearchByName','নাম দ্বারা অনুসন্ধান',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2217,'ba','ProductDetails','পণ্যের বিবরণ',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2218,'ba','CustomerName','গ্রাহকের নাম',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2219,'ba','CustomerManagement','গ্রাহক ব্যবস্থাপনা',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2220,'ba','Add','তৈরি করুন',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2221,'ba','Edit','সম্পাদনা',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2222,'ba','Close','ঘনিষ্ঠ',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2223,'ba','PleaseSelect','অনুগ্রহ করে নির্বাচন করুন',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2224,'ba','Action','কর্ম',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2225,'ba','Email','ইমেইল',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2226,'ba','EditCustomer','গ্রাহক সম্পাদনা করুন',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2227,'ba','AddCustomer','গ্রাহক তৈরি করুন',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2228,'ba','Country','দেশ',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2229,'ba','City','শহর',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2230,'ba','Adress','ঠিকানা',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2231,'ba','CustomerDetails','গ্রাহক বিবরণ',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2232,'ba','CustomersList','গ্রাহকদের',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2233,'ba','SupplierName','সরবরাহকারী নাম',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2234,'ba','SuppliersManagement','সরবরাহকারী ব্যবস্থাপনা',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2235,'ba','SupplierDetails','সরবরাহকারীর বিবরণ',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2236,'ba','QuotationsManagement','কোটেশন ম্যানেজমেন্ট',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2237,'ba','SubTotal','সাবটোটাল',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2238,'ba','MontantReste','পরিমাণ বাকি',0,'2025-06-18 01:49:42.000000','2025-06-18 01:49:42.000000'),(2239,'ba','complete','সম্পন্ন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2240,'ba','EnAttendant','বিচারাধীন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2241,'ba','Recu','গৃহীত',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2242,'ba','partial','আংশিক',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2243,'ba','Retournee','প্রত্যাবর্তন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2244,'ba','DetailQuote','বিস্তারিত উদ্ধৃতি',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2245,'ba','EditQuote','উদ্ধৃতি সম্পাদনা করুন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2246,'ba','CreateSale','বিক্রয় তৈরি করুন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2247,'ba','DownloadPdf','পিডিএফ ডাউনলোড করুন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2248,'ba','QuoteEmail','ইমেইলে উদ্ধৃতি পাঠান',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2249,'ba','DeleteQuote','মুছে ফেলা উদ্ধৃতাংশ',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2250,'ba','AddQuote','তৈরি করুন উদ্ধৃতাংশ',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2251,'ba','SelectProduct','পণ্য নির্বাচন করুন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2252,'ba','ProductCodeName','পণ্য (কোড - নাম)',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2253,'ba','Price','দাম',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2254,'ba','CurrentStock','স্টক',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2255,'ba','Total','গ্র্যান্ড টোটাল',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2256,'ba','Num','N°',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2257,'ba','Unitcost','ইউনিট খরচ',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2258,'ba','to','To',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2259,'ba','Subject','বিষয়',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2260,'ba','Message','বার্তা',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2261,'ba','EmailCustomer','গ্রাহককে ইমেল করুন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2262,'ba','Sent','পাঠানো হয়েছে',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2263,'ba','Quote','উদ্ধৃতাংশ',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2264,'ba','Hello','হ্যালো',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2265,'ba','AttachmentQuote','অনুগ্রহ করে আপনার উদ্ধৃতির জন্য সংযুক্তি খুঁজুন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2266,'ba','AddProducts','অর্ডার তালিকায় পণ্য যোগ করুন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2267,'ba','SelectWarehouse','অনুগ্রহ করে গুদাম নির্বাচন করুন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2268,'ba','SelectCustomer','অনুগ্রহ করে গ্রাহক নির্বাচন করুন৷',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2269,'ba','SalesManagement','বিক্রয় ব্যবস্থাপনা',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2270,'ba','QtyBack','Qty Back',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2271,'ba','TotalReturn','টোটাল রিটার্ন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2272,'ba','Amount','পরিমাণ',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2273,'ba','SaleDetail','বিক্রয় বিস্তারিত',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2274,'ba','EditSale','বিক্রয় সম্পাদনা করুন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2275,'ba','AddSale','বিক্রয় তৈরি করুন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2276,'ba','ShowPayment','পেমেন্ট দেখান',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2277,'ba','AddPayment','পেমেন্ট তৈরি করুন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2278,'ba','EditPayment','অর্থপ্রদান সম্পাদনা করুন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2279,'ba','EmailSale','ইমেইলে বিক্রয় পাঠান',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2280,'ba','DeleteSale','বিক্রয় মুছুন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2281,'ba','ModePaiement','দ্বারা পরিশোধ করা হয়',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2282,'ba','Paymentchoice','পেমেন্ট পছন্দ',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2283,'ba','Note','দ্রষ্টব্য',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2284,'ba','PaymentComplete','অর্থ প্রদান সম্পূর্ণ!',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2285,'ba','PurchasesManagement','ক্রয় ব্যবস্থাপনা',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2286,'ba','Ordered','আদেশ দিয়েছেন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2287,'ba','DeletePurchase','ক্রয় মুছুন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2288,'ba','EmailPurchase','ইমেল এ ক্রয় পাঠান',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2289,'ba','EditPurchase','ক্রয় সম্পাদনা করুন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2290,'ba','PurchaseDetail','ক্রয় বিস্তারিত',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2291,'ba','AddPurchase','ক্রয় তৈরি করুন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2292,'ba','EmailSupplier','সরবরাহকারী ইমেল',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2293,'ba','PurchaseInvoice','পেমেন্ট ক্রয়',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2294,'ba','PurchasesInvoicesData','অর্থপ্রদানের ডেটা ক্রয় করে',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2295,'ba','SalesInvoice','বিক্রয় পেমেন্ট',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2296,'ba','SalesInvoicesData','বিক্রয় অর্থপ্রদানের ডেটা',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2297,'ba','UserManagement','ব্যবহারকারী ব্যবস্থাপনা',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2298,'ba','Firstname','প্রথম নাম',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2299,'ba','lastname','নামের শেষাংশ',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2300,'ba','username','ব্যবহারকারীর নাম',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2301,'ba','password','পাসওয়ার্ড',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2302,'ba','Newpassword','নতুন পাসওয়ার্ড',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2303,'ba','ChangeAvatar','অবতার পরিবর্তন করুন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2304,'ba','LeaveBlank','আপনি যদি এটি পরিবর্তন না করে থাকেন তাহলে অনুগ্রহ করে এই ক্ষেত্রটি ফাঁকা রাখুন৷',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2305,'ba','type','টাইপ',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2306,'ba','UserPermissions','ব্যবহারকারীদের অনুমতি',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2307,'ba','RoleName','ভূমিকার নাম',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2308,'ba','RoleDescription','ভূমিকার বর্ণনা',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2309,'ba','AddPermissions','অনুমতি তৈরি করুন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2310,'ba','View','দেখুন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2311,'ba','NewAdjustement','নতুন সমন্বয়',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2312,'ba','EditAdjustement','সমন্বয় সম্পাদনা করুন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2313,'ba','CannotSubstraction','আপনি স্টক 0 আছে এমন পণ্য বিয়োগ করতে পারবেন না',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2314,'ba','Addition','সংযোজন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2315,'ba','Subtraction','বিয়োগ',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2316,'ba','profil','প্রোফাইল',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2317,'ba','logout','প্রস্থান',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2318,'ba','PurchaseAlreadyPaid','আপনি পরিবর্তন করতে পারবেন না কারণ এই ক্রয়টি ইতিমধ্যেই অর্থপ্রদান করেছে৷',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2319,'ba','SaleAlreadyPaid','আপনি পরিবর্তন করতে পারবেন না কারণ এই বিক্রয় ইতিমধ্যেই অর্থপ্রদান করেছে৷',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2320,'ba','ReturnAlreadyPaid','আপনি পরিবর্তন করতে পারবেন না কারণ এই রিটার্ন ইতিমধ্যেই পরিশোধ করা হয়েছে',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2321,'ba','QuoteAlready','এই উদ্ধৃতি ইতিমধ্যে বিক্রয় উৎপন্ন হয়েছে',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2322,'ba','AddProduct','প্রোডাক্ট তৈরি করুন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2323,'ba','QuotationComplete','এই উদ্ধৃতি সম্পূর্ণ',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2324,'ba','SiteConfiguration','সাইট কনফিগারেশন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2325,'ba','Language','ভাষা',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2326,'ba','DefaultCurrency','ডিফল্ট মুদ্রা',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2327,'ba','LoginCaptcha','লগইন ক্যাপচা',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2328,'ba','DefaultEmail','ডিফল্ট ইমেল',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2329,'ba','SiteName','সাইটের নাম',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2330,'ba','ChangeLogo','লোগো পরিবর্তন করুন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2331,'ba','SMTPConfiguration','মেইল কনফিগারেশন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2332,'ba','HOST','হোস্ট',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2333,'ba','PORT','পোর্ট',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2334,'ba','encryption','এনক্রিপশন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2335,'ba','SMTPIncorrect','কনফিগারেশন ভুল',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2336,'ba','PaymentsReturns','পেমেন্ট রিটার্ন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2337,'ba','ReturnsInvoices','চালান রিটার্ন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2338,'ba','ReturnsInvoicesData','ইনভয়েস ডেটা ফেরত দেয়',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2339,'ba','ShowAll','সমস্ত ব্যবহারকারীর সমস্ত রেকর্ড দেখুন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2340,'ba','Discount','ছাড়',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2341,'ba','OrderTax','অর্ডার ট্যাক্স',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2342,'ba','Shipping','শিপিং',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2343,'ba','CompanyName','কোমপানির নাম',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2344,'ba','CompanyPhone','কোম্পানির ফোন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2345,'ba','CompanyAdress','কোম্পানির ঠিকানা',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2346,'ba','Code','কোড',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2347,'ba','image','চিত্র',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2348,'ba','Printbarcode','বারকোড প্রিন্ট করুন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2349,'ba','ReturnsCustomers','গ্রাহক রিটার্ন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2350,'ba','ReturnsSuppliers','রিটার্ন সরবরাহকারী',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2351,'ba','FactureReturnCustomers','গ্রাহক চালান ফেরত দিন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2352,'ba','FactureReturnSuppliers','সরবরাহকারী চালান ফেরত দিন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2353,'ba','NodataAvailable','কোন তথ্য উপলব্ধ নেই',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2354,'ba','ProductImage','পণ্য ইমেজ',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2355,'ba','Barcode','বারকোড',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2356,'ba','pointofsales','বিক্রয় বিন্দু',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2357,'ba','CustomUpload','কাস্টম আপলোড',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2358,'ba','pointofsaleManagement','পয়েন্ট অফ সেল ম্যানেজমেন্ট',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2359,'ba','Adjustment','সমন্বয়',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2360,'ba','Updat','হালনাগাদ',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2361,'ba','Reset','রিসেট',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2362,'ba','print','প্রিন্ট',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2363,'ba','SearchByEmail','ইমেল দ্বারা অনুসন্ধান করুন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2364,'ba','ChooseProduct','পণ্য নির্বাচন করুন',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2365,'ba','Qty','পরিমান',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2366,'ba','Items','আইটেমগুলি',0,'2025-06-18 01:49:43.000000','2025-06-18 01:49:43.000000'),(2367,'ba','AmountHT','Amount HT',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2368,'ba','AmountTTC','Amount TTC',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2369,'ba','PleaseSelectSupplier','অনুগ্রহ করে সরবরাহকারী নির্বাচন করুন',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2370,'ba','PleaseSelectStatut','দয়া করে স্থিতি নির্বাচন করুন৷',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2371,'ba','PayeBy','দ্বারা অর্থপ্রদান',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2372,'ba','ChooseWarehouse','ওয়্যারহাউস বেছে নিন',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2373,'ba','payNow','এখন পরিশোধ করুন',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2374,'ba','ListofCategory','ক্যাটাগরির তালিকা',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2375,'ba','Description','বর্ণনা',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2376,'ba','submit','জমা দিন',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2377,'ba','ProblemCreatingThisInvoice','এই চালান তৈরিতে একটি সমস্যা হয়েছে৷ অনুগ্রহপূর্বক আবার চেষ্টা করুন',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2378,'ba','ProblemPayment','পেমেন্টে সমস্যা হয়েছে। অনুগ্রহপূর্বক আবার চেষ্টা করুন.',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2379,'ba','IncomeExpenses','আয় ও ব্যয়',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2380,'ba','dailySalesPurchases','দৈনিক বিক্রয় এবং ক্রয়',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2381,'ba','ProductsExpired','পণ্যের মেয়াদ শেষ',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2382,'ba','ListofBrand','ব্র্যান্ডস',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2383,'ba','CreateAdjustment','সমন্বয় তৈরি করুন',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2384,'ba','Afewwords','কয়েক শব্দ ...',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2385,'ba','UserImage','ব্যবহারকারীর ছবি',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2386,'ba','UpdateProduct','পণ্য আপডেট করুন',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2387,'ba','Brand','ব্র্যান্ড',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2388,'ba','BarcodeSymbology','বারকোড সিম্বোলজি',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2389,'ba','ProductCost','পণ্য খরচ',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2390,'ba','ProductPrice','পণ্য মূল্য',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2391,'ba','UnitProduct','পণ্য ইউনিট',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2392,'ba','TaxMethod','ট্যাক্স প্রকার',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2393,'ba','MultipleImage','একাধিক ছবি',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2394,'ba','ProductHasMultiVariants','এই পণ্যের মাল্টি বৈকল্পিক আছে',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2395,'ba','ProductHasPromotion','পণ্য প্রচার আছে',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2396,'ba','PromotionStart','Promotion Start',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2397,'ba','PromotionEnd','Promotion End',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2398,'ba','PromotionPrice','Promotion Price',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2399,'ba','Cost','খরচ',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2400,'ba','Unit','ইউনিট',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2401,'ba','ProductVariant','পণ্য বৈকল্পিক',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2402,'ba','Variant','বৈকল্পিক',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2403,'ba','UnitPrice','ইউনিট মূল্য',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2404,'ba','CreateReturnCustomer','রিটার্ন গ্রাহক তৈরি করুন',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2405,'ba','EditReturnCustomer','রিটার্ন গ্রাহক সম্পাদনা করুন',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2406,'ba','CreateReturnSupplier','রিটার্ন সরবরাহকারী তৈরি করুন',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2407,'ba','Documentation','ডক',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2408,'ba','EditReturnSupplier','রিটার্ন সরবরাহকারী সম্পাদনা করুন',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2409,'ba','FromWarehouse','গুদাম থেকে',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2410,'ba','ToWarehouse','গুদাম করার জন্য',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2411,'ba','EditTransfer','স্থানান্তর সম্পাদনা করুন',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2412,'ba','TransferDetail','স্থানান্তর বিবরণ',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2413,'ba','Pending','বিচারাধীন',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2414,'ba','Received','গৃহীত',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2415,'ba','PermissionsManager','অনুমতি ব্যবস্থাপনা',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2416,'ba','BrandManager','ব্র্যান্ড',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2417,'ba','BrandImage','ব্র্যান্ড ইমেজ',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2418,'ba','BrandName','ব্র্যান্ডের নাম',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2419,'ba','BrandDescription','ব্র্যান্ডের বর্ণনা',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2420,'ba','BaseUnit','বেস একক',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2421,'ba','ManagerUnits','ইউনিট ব্যবস্থাপনা',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2422,'ba','OperationValue','অপারেশন ভ্যালু',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2423,'ba','Operator','অপারেটর',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2424,'ba','Top5Products','সেরা 5টি পণ্য',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2425,'ba','Last5Sales','শেষ 5 বিক্রয়',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2426,'ba','ListAdjustments','সমস্ত সমন্বয়',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2427,'ba','ListTransfers','সমস্ত স্থানান্তর',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2428,'ba','CreateTransfer','ট্রান্সফার তৈরি করুন',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2429,'ba','OrdersManager','আদেশ ব্যবস্থাপনা',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2430,'ba','ListQuotations','সব উদ্ধৃতি',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2431,'ba','ListPurchases','সমস্ত ক্রয়',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2432,'ba','ListSales','সমস্ত বিক্রয়',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2433,'ba','ListReturns','সব রিটার্ন',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2434,'ba','PeopleManager','মানুষ ব্যবস্থাপনা',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2435,'ba','Delete_Title','তুমি কি নিশ্চিত?',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2436,'ba','Delete_Text','আপনি এটি প্রত্যাবর্তন করতে সক্ষম হবেন না!',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2437,'ba','Delete_confirmButtonText','হ্যাঁ, এটা মুছে ফেলুন!',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2438,'ba','Delete_cancelButtonText','বাতিল করুন',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2439,'ba','Delete_Deleted','মুছে ফেলা হয়েছে!',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2440,'ba','Delete_Failed','ব্যর্থ হয়েছে!',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2441,'ba','Delete_Therewassomethingwronge','কিছু ভুল ছিল',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2442,'ba','SendEmail','ইমেল সফলভাবে পাঠান',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2443,'ba','erroSale','এই বিক্রয় ইতিমধ্যে একটি রিটার্ন সঙ্গে লিঙ্ক!',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2444,'ba','ReturnManagement','রিটার্ন ম্যানেজমেন্ট',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2445,'ba','ReturnDetail','রিটার্ন বিস্তারিত',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2446,'ba','EditReturn','রিটার্ন সম্পাদনা করুন',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2447,'ba','AddReturn','রিটার্ন তৈরি করুন',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2448,'ba','EmailReturn','ইমেলে রিটার্ন পাঠান',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2449,'ba','DeleteReturn','রিটার্ন মুছুন',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2450,'ba','Retoursurcharge','রিটার্ন সারচার্জ',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2451,'ba','Laivrison','ডেলিভারি',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2452,'ba','SelectSale','বিক্রয় নির্বাচন করুন',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2453,'ba','ZeroPardefault','আপনি আইটেমটি মুছে ফেলতে পারেন বা এটি ফেরত না দিলে পরিমাণটি শূন্যে সেট করতে পারেন',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2454,'ba','Return','প্রত্যাবর্তন',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2455,'ba','Purchase','ক্রয়',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2456,'ba','TotalSales','মোট বিক্রয়',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2457,'ba','TotalPurchases','মোট ক্রয়',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2458,'ba','TotalReturns','মোট রিটার্ন',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2459,'ba','PaiementsNet','পেমেন্ট নেট',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2460,'ba','PaiementsSent','পেমেন্ট পাঠানো হয়েছে',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2461,'ba','PaiementsReceived','পেমেন্ট পেয়েছি',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2462,'ba','Recieved','গৃহীত',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2463,'ba','ProductCode','কোড',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2464,'ba','ProductName','গুণফল',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2465,'ba','AlertQuantity','সতর্কতা পরিমাণ',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2466,'ba','TotalProducts','মোট পণ্য',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2467,'ba','TotalQuantity','মোট পরিমাণ',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2468,'ba','TopCustomers','সেরা 5 গ্রাহক',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2469,'ba','TotalAmount','মোট পরিমাণ',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2470,'ba','TotalPaid','মোট দেওয়া',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2471,'ba','CustomerSalesReport','গ্রাহক বিক্রয় রিপোর্ট',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2472,'ba','CustomerPaiementsReport','গ্রাহক পেমেন্ট রিপোর্ট',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2473,'ba','CustomerQuotationsReport','গ্রাহক উদ্ধৃতি রিপোর্ট',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2474,'ba','Payments','পেমেন্ট',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2475,'ba','TopSuppliers','শীর্ষ 5 সরবরাহকারী',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2476,'ba','SupplierPurchasesReport','সরবরাহকারী ক্রয় রিপোর্ট',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2477,'ba','SupplierPaiementsReport','সরবরাহকারী পেমেন্ট রিপোর্ট',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2478,'ba','Name','নাম',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2479,'ba','ManagementWarehouse','গুদাম ব্যবস্থাপনা',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2480,'ba','ZipCode','জিপ কোড',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2481,'ba','managementCategories','বিভাগসমূহ',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2482,'ba','Codecategorie','বিভাগ কোড',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2483,'ba','Namecategorie','বিভাগ নাম',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2484,'ba','Parentcategorie','অভিভাবক শ্রেণী',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2485,'ba','managementTax','ট্যাক্স ব্যবস্থাপনা',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2486,'ba','TaxName','ট্যাক্সের নাম',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2487,'ba','TaxRate','করের হার',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2488,'ba','managementUnitPurchases','ক্রয় ইউনিট',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2489,'ba','managementUnitSales','বিক্রয় ইউনিট',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2490,'ba','ShortName','সংক্ষিপ্ত নাম',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2491,'ba','PleaseSelectThesebeforeaddinganyproduct','কোন পণ্য যোগ করার আগে এই নির্বাচন করুন',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2492,'ba','StockAdjustement','সমন্বয়',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2493,'ba','PleaseSelectWarehouse','কোনো পণ্য নির্বাচন করার আগে গুদাম নির্বাচন করুন',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2494,'ba','StockTransfer','স্টক স্থানান্তর',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2495,'ba','SelectPeriod','পিরিয়ড নির্বাচন করুন',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2496,'ba','ThisYear','এই বছর',0,'2025-06-18 01:49:44.000000','2025-06-18 01:49:44.000000'),(2497,'ba','ThisToday','এই টুডে',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2498,'ba','ThisMonth','এই মাস',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2499,'ba','ThisWeek','এই সপ্তাহ',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2500,'ba','AdjustmentDetail','সামঞ্জস্য বিস্তারিত',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2501,'ba','ActivateUser','এই ব্যবহারকারী সক্রিয় করা হয়েছে',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2502,'ba','DisActivateUser','এই ব্যবহারকারী নিষ্ক্রিয় করা হয়েছে',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2503,'ba','NotFound','পৃষ্ঠা খুঁজে পাওয়া যায়নি.',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2504,'ba','oops','উফ! পৃষ্ঠা খুঁজে পাওয়া যায়নি.',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2505,'ba','couldNotFind','আপনি যে পৃষ্ঠাটি খুঁজছিলেন তা আমরা খুঁজে পাইনি৷ এদিকে, আপনি হতে পারেন৷',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2506,'ba','ReturnDashboard','ড্যাশবোর্ডে ফিরে যান',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2507,'ba','hrm','এইচআরএম',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2508,'ba','Employees','কর্মচারীদের',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2509,'ba','Attendance','হাজিরা',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2510,'ba','Leave_request','অনুরোধ ছেড়ে দিন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2511,'ba','Leave_type','টাইপ',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2512,'ba','Company','কোম্পানি',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2513,'ba','Departments','বিভাগ',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2514,'ba','Designations','উপাধি',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2515,'ba','Office_Shift','অফিস শিফট',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2516,'ba','Holidays','ছুটির দিন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2517,'ba','Enter_Company_Name','কোম্পানির নাম লিখুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2518,'ba','Enter_email_address','ইমেইল অ্যাড্রেস দিন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2519,'ba','Enter_Company_Phone','কোম্পানির ফোন লিখুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2520,'ba','Enter_Company_Country','কোম্পানির দেশ লিখুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2521,'ba','Created_in_successfully','সফলভাবে তৈরি করা হয়েছে',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2522,'ba','Updated_in_successfully','সফলভাবে আপডেট করা হয়েছে৷',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2523,'ba','Deleted_in_successfully','সফলভাবে মুছে ফেলা হয়েছে',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2524,'ba','department','বিভাগ',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2525,'ba','Enter_Department_Name','বিভাগের নাম দিন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2526,'ba','Choose_Company','কোম্পানি চয়ন করুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2527,'ba','Department_Head','বিভাগের প্রধান',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2528,'ba','Choose_Department_Head','বিভাগীয় প্রধান নির্বাচন করুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2529,'ba','Enter_Shift_name','শিফটের নাম লিখুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2530,'ba','Monday_In','Monday In',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2531,'ba','Monday_Out','Monday Out',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2532,'ba','Tuesday_In','Tuesday In',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2533,'ba','tuesday_out','tuesday Out',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2534,'ba','wednesday_in','Wednesday In',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2535,'ba','wednesday_out','Wednesday Out',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2536,'ba','thursday_in','Thursday In',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2537,'ba','thursday_out','Thursday Out',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2538,'ba','friday_in','Friday In',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2539,'ba','friday_out','Friday Out',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2540,'ba','saturday_in','Saturday In',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2541,'ba','saturday_out','Saturday Out',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2542,'ba','sunday_in','Sunday In',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2543,'ba','sunday_out','Sunday Out',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2544,'ba','Holiday','ছুটি',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2545,'ba','Enter_title','শিরোনাম লিখুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2546,'ba','title','শিরোনাম',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2547,'ba','start_date','শুরুর তারিখ',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2548,'ba','Enter_Start_date','শুরুর তারিখ লিখুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2549,'ba','Finish_Date','শেষ তারিখ',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2550,'ba','Enter_Finish_date','সমাপ্তির তারিখ লিখুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2551,'ba','Please_provide_any_details','কোন বিবরণ প্রদান করুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2552,'ba','Attendances','উপস্থিতি',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2553,'ba','Enter_Attendance_date','উপস্থিতির তারিখ লিখুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2554,'ba','Time_In','Time In',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2555,'ba','Time_Out','Time Out',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2556,'ba','Choose_Employee','কর্মচারী নির্বাচন করুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2557,'ba','Employee','কর্মচারী',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2558,'ba','Work_Duration','কাজের সময়কাল',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2559,'ba','remaining_leaves_are_insufficient','অবশিষ্ট পাতা অপর্যাপ্ত',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2560,'ba','Days','দিন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2561,'ba','Choose_leave_type','টাইপ বেছে নিন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2562,'ba','Leave_Reason','যুক্তি',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2563,'ba','Enter_Reason_Leave','কারণ ছুটি লিখুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2564,'ba','Add_Employee','কর্মচারী যোগ করুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2565,'ba','Enter_FirstName','প্রথম নাম লিখুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2566,'ba','Enter_LastName','শেষ নাম লিখুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2567,'ba','Gender','লিঙ্গ',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2568,'ba','Choose_Gender','লিঙ্গ চয়ন করুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2569,'ba','Enter_Birth_date','জন্ম তারিখ লিখুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2570,'ba','Birth_date','জন্ম তারিখ',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2571,'ba','Enter_Country','দেশে প্রবেশ করুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2572,'ba','Enter_Phone_Number','ফোন নম্বর লিখুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2573,'ba','joining_date','যোগদানের তারিখ',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2574,'ba','Enter_joining_date','যোগদানের তারিখ লিখুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2575,'ba','Choose_Designation','পদবী চয়ন করুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2576,'ba','Designation','উপাধি',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2577,'ba','Choose_Office_Shift','অফিস শিফট নির্বাচন করুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2578,'ba','Enter_Leaving_Date','ছেড়ে যাওয়ার তারিখ লিখুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2579,'ba','Leaving_Date','তারিখ ছাড়ার',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2580,'ba','Annual_Leave','বার্ষিক ছুটি',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2581,'ba','Enter_Annual_Leave','বার্ষিক ছুটি লিখুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2582,'ba','Remaining_leave','অবশিষ্ট ছুটি',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2583,'ba','Employee_Details','কর্মচারী বিবরণ',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2584,'ba','Basic_Information','মৌলিক তথ্য',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2585,'ba','Family_status','পারিবারিক মর্যাদা',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2586,'ba','Choose_Family_status','পারিবারিক অবস্থা চয়ন করুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2587,'ba','Employment_type','কর্মসংস্থান প্রকার',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2588,'ba','Select_Employment_type','কর্মসংস্থানের ধরন নির্বাচন করুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2589,'ba','Enter_City','শহরে প্রবেশ করুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2590,'ba','Province','প্রদেশ',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2591,'ba','Enter_Province','প্রদেশে প্রবেশ করুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2592,'ba','Enter_Address','ঠিকানা লিখুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2593,'ba','Enter_Zip_code','জিপ কোড প্রবেশ',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2594,'ba','Zip_code','জিপ কোড',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2595,'ba','Hourly_rate','প্রতি ঘণ্টার হার',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2596,'ba','Enter_Hourly_rate','ঘন্টার হার লিখুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2597,'ba','Basic_salary','মূল বেতন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2598,'ba','Enter_Basic_salary','বেসিক বেতন লিখুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2599,'ba','Social_Media','সামাজিক মাধ্যম',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2600,'ba','Skype','স্কাইপ',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2601,'ba','Enter_Skype','স্কাইপ লিখুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2602,'ba','Facebook','ফেসবুক',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2603,'ba','Enter_Facebook','আপনার Facebook লিখুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2604,'ba','WhatsApp','হোয়াটসঅ্যাপ',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2605,'ba','Enter_WhatsApp','হোয়াটসঅ্যাপ লিখুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2606,'ba','LinkedIn','লিঙ্কডইন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2607,'ba','Enter_LinkedIn','লিঙ্কডইন লিখুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2608,'ba','Twitter','টুইটার',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2609,'ba','Enter_Twitter','আপনার টুইটার লিখুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2610,'ba','Experiences','অভিজ্ঞতাসমূহ',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2611,'ba','bank_account','ব্যাংক হিসাব',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2612,'ba','Company_Name','কোমপানির নাম',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2613,'ba','Location','অবস্থান',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2614,'ba','Enter_location','অবস্থান লিখুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2615,'ba','Enter_Description','বর্ণনা লিখুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2616,'ba','Bank_Name','ব্যাংকের নাম',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2617,'ba','Enter_Bank_Name','ব্যাঙ্কের নাম লিখুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2618,'ba','Bank_Branch','ব্যাংকের শাখা',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2619,'ba','Enter_Bank_Branch','ব্যাংক শাখায় প্রবেশ করুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2620,'ba','Bank_Number','ব্যাঙ্ক নম্বর',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2621,'ba','Enter_Bank_Number','ব্যাঙ্ক নম্বর লিখুন',0,'2025-06-18 01:49:45.000000','2025-06-18 01:49:45.000000'),(2622,'ba','Assigned_warehouses','অ্যাক্সেস গুদাম',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2623,'ba','Top_customers','সেরা গ্রাহকদের',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2624,'ba','Attachment','সংযুক্তি',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2625,'ba','view_employee','কর্মচারী দেখুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2626,'ba','edit_employee','কর্মচারী সম্পাদনা করুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2627,'ba','delete_employee','কর্মচারী মুছুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2628,'ba','Created_by','দ্বারা যোগ করা',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2629,'ba','Add_product_IMEI_Serial_number','পণ্যের IMEI/ক্রমিক নম্বর যোগ করুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2630,'ba','Product_Has_Imei_Serial_number','পণ্যের রয়েছে Imei/ক্রমিক নম্বর',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2631,'ba','IMEI_SN','IMEI/SN',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2632,'ba','Shipments','প্রেরণ',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2633,'ba','delivered_to','বিতরণ করা হয়েছে',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2634,'ba','shipment_ref','ডেলিভারি রেফ',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2635,'ba','sale_ref','বিক্রয় রেফ',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2636,'ba','Edit_Shipping','শিপিং সম্পাদনা করুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2637,'ba','Packed','বস্তাবন্দী',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2638,'ba','Shipped','পাঠানো',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2639,'ba','Delivered','বিতরণ করা হয়েছে',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2640,'ba','Cancelled','বাতিল',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2641,'ba','Shipping_status','শিপিং অবস্থা',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2642,'ba','Users_Report','ব্যবহারকারীদের রিপোর্ট',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2643,'ba','stock_report','স্টক রিপোর্ট',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2644,'ba','Total_quotations','মোট কোটেশন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2645,'ba','Total_return_sales','মোট রিটার্ন বিক্রয়',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2646,'ba','Total_return_purchases','মোট রিটার্ন ক্রয়',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2647,'ba','Total_transfers','মোট স্থানান্তর',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2648,'ba','Total_adjustments','মোট সমন্বয়',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2649,'ba','User_report','ব্যবহারকারীর প্রতিবেদন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2650,'ba','Current_stock','বর্তমান স্টক',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2651,'ba','product_name','পণ্যের নাম',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2652,'ba','Total_Customers_Due','মোট ঋণ',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2653,'ba','Total_Suppliers_Due','মোট ঋণ',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2654,'ba','Some_warehouses','কিছু গুদাম',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2655,'ba','Product_Cost','পণ্য খরচ',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2656,'ba','sms_settings','এসএমএস সেটিংস',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2657,'ba','mail_settings','মেল সেটিংস',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2658,'ba','Nexmo_SMS','নেক্সমো এসএমএস',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2659,'ba','TWILIO_SMS','TWILIO SMS',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2660,'ba','Default_SMS_Gateway','ডিফল্ট এসএমএস গেটওয়ে',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2661,'ba','module_settings','মডিউল সেটিংস',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2662,'ba','Module_enabled_success','মডিউল সফলভাবে সক্ষম হয়েছে৷',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2663,'ba','Module_Disabled_success','মডিউল সফলভাবে নিষ্ক্রিয় হয়েছে৷',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2664,'ba','update_settings','সেটিংস আপডেট করুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2665,'ba','Please_Upload_the_Correct_Module','অনুগ্রহ করে সঠিক মডিউলটি আপলোড করুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2666,'ba','Uploaded_Success','সফলভাবে আপলোড করা হয়েছে',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2667,'ba','Customer_details','গ্রাহক বিবরণ',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2668,'ba','Edit_Customer','গ্রাহক সম্পাদনা করুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2669,'ba','Delete_Customer','গ্রাহক মুছুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2670,'ba','Pay_Due','ক্লায়েন্ট বিশ্রামের পরিমাণ পরিশোধ করুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2671,'ba','Paying_amount_is_greater_than_Total_Due','অর্থপ্রদানের পরিমাণ মোট বিশ্রামের পরিমাণের চেয়ে বেশি৷',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2672,'ba','Customer_Invoice','গ্রাহক চালান',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2673,'ba','This_Product_Not_For_Selling','এই পণ্যটি বিক্রির জন্য নয়',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2674,'ba','Welcome_to_your_Dashboard','আপনার ড্যাশবোর্ডে স্বাগতম',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2675,'ba','Total_Payable','মোট প্রদেয়',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2676,'ba','Choose_Sale_Ref','বিক্রয় রেফ নির্বাচন করুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2677,'ba','Please_Select_Sale','বিক্রয় নির্বাচন করুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2678,'ba','list_product_returns','তালিকা পণ্য রিটার্ন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2679,'ba','Qty_return','পরিমাণ রিটার্ন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2680,'ba','Choose_Purchase_Ref','ক্রয় রেফ নির্বাচন করুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2681,'ba','Purchase_Ref','রেফ ক্রয়',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2682,'ba','please_select_purchase','ক্রয় নির্বাচন করুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2683,'ba','qty_return_is_greater_than_qty_purchased','পরিমাণ রিটার্ন ক্রয় করা পরিমাণের চেয়ে বেশি',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2684,'ba','qty_return_is_greater_than_qty_sold','পরিমাণ রিটার্ন বিক্রি করা পরিমাণের চেয়ে বেশি',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2685,'ba','Quantity_sold','পরিমাণ বিক্রি',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2686,'ba','qty_purchased','পরিমাণ ক্রয়',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2687,'ba','Sender_Name','প্রেরক নাম',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2688,'ba','Upload_Module','আপলোড মডিউল',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2689,'ba','The_module_must_be_uploaded_as_zip_file','মডিউলটি অবশ্যই জিপ ফাইল হিসাবে আপলোড করতে হবে',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2690,'ba','All_Modules_Installed','সমস্ত মডিউল ইনস্টল',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2691,'ba','Current_Version','বর্তমান সংস্করণ',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2692,'ba','You_already_have_the_latest_version','আপনি ইতিমধ্যে সর্বশেষ সংস্করণ আছে',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2693,'ba','Update_Available','আপডেট উপলব্ধ',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2694,'ba','Update_Log','আপডেট লগ',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2695,'ba','Update_Now','এখন হালনাগাদ করুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2696,'ba','View_Change_Log','পরিবর্তন লগ দেখুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2697,'ba','Please_Wait_for_the_update','অনুগ্রহ করে আপডেট সম্পূর্ণভাবে শেষ হওয়ার জন্য অপেক্ষা করুন। এটি ব্রাউজার বন্ধ বা একটি প্রক্রিয়া আপগ্রেড বন্ধ করার সুপারিশ করা হয় না',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2698,'ba','Note_update','আপগ্রেড চালানোর আগে আপনি আপনার বর্তমান সংস্করণ এবং ডাটাবেস ব্যাকআপ করেছেন তা নিশ্চিত করুন, যদি কোনও ত্রুটি থাকে তবে এটি পুনরুদ্ধার করতে',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2699,'ba','invoice_footer','চালান ফুটার',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2700,'ba','Time_Zone','সময় অঞ্চল',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2701,'ba','Payment_note','পেমেন্ট নোট',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2702,'ba','sale_note','বিক্রয় নোট',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2703,'ba','Total_Sale_Due','মোট বিক্রয় ঋণ',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2704,'ba','Total_Sell_Return_Due','মোট বিক্রি রিটার্ন ঋণ',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2705,'ba','pay_all_sell_due_at_a_time','এক সময়ে সমস্ত বিক্রয় ঋণ পরিশোধ করুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2706,'ba','pay_all_sell_return_due_at_a_time','এক সময়ে সব বিক্রি রিটার্ন ঋণ পরিশোধ',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2707,'ba','Gross_Profit','মোট মুনাফা',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2708,'ba','pay_all_purchase_due_at_a_time','এক সময়ে সমস্ত ক্রয় ঋণ পরিশোধ করুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2709,'ba','Delete_Provider','প্রদানকারী মুছুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2710,'ba','Edit_Provider','প্রদানকারী সম্পাদনা করুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2711,'ba','Provider_details','প্রদানকারীর বিবরণ',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2712,'ba','Total_Purchase_Due','মোট ক্রয় দেনা',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2713,'ba','Provider_Credit_Note','ক্রেডিট নোট',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2714,'ba','Customer_Credit_Note','ক্রেডিট নোট',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2715,'ba','Sell_Return','রিটার্ন বিক্রি করুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2716,'ba','Purchase_Return','ক্রয় রিটার্ন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2717,'ba','Tax_Number','কর নম্বর',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2718,'ba','Please_add_return_quantity','রিটার্ন পরিমাণ যোগ করুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2719,'ba','Return_exist_for_the_Transaction','লেনদেনের জন্য রিটার্ন বিদ্যমান',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2720,'ba','qty_return_is_greater_than_Quantity_Remaining','পরিমাণ রিটার্ন বাকি পরিমাণের চেয়ে বেশি',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2721,'ba','products_refunded_alert','0 তে সেটের পরিমাণ সহ যেকোন পণ্য ফেরত দেওয়া হবে না',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2722,'ba','pay_all_purchase_return_due_at_a_time','এক সময়ে সমস্ত ক্রয় রিটার্ন পরিশোধ করুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2723,'ba','Total_Purchase_Return_Due','মোট ক্রয় রিটার্ন বকেয়া',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2724,'ba','Purchase_return_due','ক্রয় রিটার্ন ঋণ',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2725,'ba','Sell_return_due','বিক্রয় ফেরত ঋণ',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2726,'ba','product_report','পণ্য রিপোর্ট',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2727,'ba','product_sales_report','পণ্য বিক্রয় রিপোর্ট',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2728,'ba','Product_purchases_report','পণ্য ক্রয় রিপোর্ট',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2729,'ba','Qty_sold','পরিমাণ বিক্রি',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2730,'ba','Filter_by_warehouse','গুদাম দ্বারা ফিল্টার',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2731,'ba','Enable_Print_Invoice','স্বয়ংক্রিয়ভাবে চালান প্রিন্ট করুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2732,'ba','Show_Warehouse','গুদাম দেখান',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2733,'ba','saved_credit_card_info','সংরক্ষিত ক্রেডিট কার্ড তথ্য',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2734,'ba','credit_card_changed_successfully','ক্রেডিট কার্ড সফলভাবে পরিবর্তিত হয়েছে',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2735,'ba','notification_template','বিজ্ঞপ্তি টেমপ্লেট',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2736,'ba','email_notification','ই-মেইল বিজ্ঞপ্তি',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2737,'ba','sms_notification','এসএমএস বিজ্ঞপ্তি',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2738,'ba','change_product_details','পণ্যের বিস্তারিত পরিবর্তন করুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2739,'ba','edit_tax_and_discount_and_shipping','কর এবং ছাড় এবং শিপিং সম্পাদনা করুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2740,'ba','create_quotation_with_stock','স্টক সহ উদ্ধৃতি তৈরি করুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2741,'ba','variant_cost','পণ্যের পদক্ষেপ খরচ',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2742,'ba','variant_price','পণ্যের পদক্ষেপ মূল্য',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2743,'ba','variant_code','পণ্যের পদক্ষেপ কোড',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2744,'ba','please_wait_until_the_product_is_loaded','পণ্য লোড হওয়া পর্যন্ত অপেক্ষা করুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2745,'ba','choose_sms_gateway','এসএমএস গেটওয়ে চয়ন করুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2746,'ba','notification_client','বিজ্ঞপ্তি ক্লায়েন্ট',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2747,'ba','available_tags','উপলব্ধ ট্যাগগুলি',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2748,'ba','email_subject','ই-মেইল বিষয়',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2749,'ba','email_body','ই-মেইল বডি',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2750,'ba','notification_supplier','বিজ্ঞপ্তি সাপ্লাইয়ার',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2751,'ba','sms_body','এসএমএস বডি',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2752,'ba','sms_templates','এসএমএস টেমপ্লেট',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2753,'ba','email_templates','ইমেল টেমপ্লেট',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2754,'ba','Edit_Project','প্রকল্প সম্পাদনা করুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2755,'ba','Projects','প্রকল্পসমূহ',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2756,'ba','Enter_Project_Title','প্রকল্পের শিরোনাম লিখুন',0,'2025-06-18 01:49:46.000000','2025-06-18 01:49:46.000000'),(2757,'ba','Assigned_Employees','নির্ধারিত কর্মচারীরা',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2758,'ba','Choose_Team','টিম নির্বাচন করুন',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2759,'ba','Create_Project','প্রকল্প তৈরি করুন',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2760,'ba','Project_List','প্রকল্পের তালিকা',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2761,'ba','Not_Started','শুরু হয়নি',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2762,'ba','In_Progress','চলমান',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2763,'ba','On_Hold','স্থগিত',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2764,'ba','Edit_Task','কাজ সম্পাদনা করুন',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2765,'ba','Tasks','কাজসমূহ',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2766,'ba','Enter_Task_Title','কাজের শিরোনাম লিখুন',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2767,'ba','Choose_Project','প্রকল্প নির্বাচন করুন',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2768,'ba','Project','প্রকল্প',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2769,'ba','Create_Task','কাজ তৈরি করুন',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2770,'ba','Task_List','কাজের তালিকা',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2771,'ba','Import_Purchases','ক্রয় আমদানি করুন',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2772,'ba','Warranty_Period','ওয়ারেন্টি সময়কাল',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2773,'ba','Months','মাস',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2774,'ba','Years','বছর',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2775,'ba','WarrantyTerms','ওয়ারেন্টির শর্তাবলী',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2776,'ba','HasGuarantee','গ্যারান্টি আছে',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2777,'ba','Guarantee_Period','গ্যারান্টি সময়কাল',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2778,'ba','OpeningStock','প্রারম্ভিক স্টক',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2779,'ba','Warranty_Guarantee_Tracking','ওয়ারেন্টি ও গ্যারান্টি ট্র্যাকিং',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2780,'ba','PaymentOption','পেমেন্ট অপশন',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2781,'ba','AddAnotherPaymentOption','আরেকটি পেমেন্ট অপশন যোগ করুন',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2782,'ba','PopularTendered','জনপ্রিয় প্রদত্ত পরিমাণ',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2783,'ba','clear','মুছে ফেলুন',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2784,'ba','Pay','পরিশোধ করুন',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2785,'ba','Payment','পেমেন্ট',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2786,'ba','TotalPaidExceedsGrandTotalForMultiPayment','মোট প্রদত্ত অর্থ মোট অর্থের চেয়ে বেশি',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2787,'ba','TotalPaying','মোট পেমেন্ট',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2788,'ba','ChangeReturn','বাকি ফেরত',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2789,'ba','AmountPaying','পেমেন্টের পরিমাণ',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2790,'ba','Appearance_Settings','চেহারা সেটিংস',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2791,'ba','app_name','অ্যাপের নাম',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2792,'ba','page_title_suffix','পেজ শিরোনামের উপসর্গ',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2793,'ba','ChangeFavicon','ফেভিকন পরিবর্তন করুন',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2794,'ba','Languages','ভাষাসমূহ',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2795,'ba','Translations','অনুবাদসমূহ',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2796,'ba','Translations for','এর জন্য অনুবাদ',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2797,'ba','Back','পেছনে যান',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2798,'ba','Save All Changes','সব পরিবর্তন সংরক্ষণ করুন',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2799,'ba','Add New','নতুন যোগ করুন',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2800,'ba','Add New Translation','নতুন অনুবাদ যোগ করুন',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2801,'ba','Save','সংরক্ষণ করুন',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2802,'ba','Delete','মুছুন',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2803,'ba','Showing','দেখানো হচ্ছে',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2804,'ba','Translation added','অনুবাদ যোগ করা হয়েছে',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2805,'ba','Failed to add translation','অনুবাদ যোগ করতে ব্যর্থ',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2806,'ba','Translation updated','অনুবাদ আপডেট করা হয়েছে',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2807,'ba','Failed to update','আপডেট করতে ব্যর্থ',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2808,'ba','No changes to save','সংরক্ষণের মতো কোনো পরিবর্তন নেই',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2809,'ba','Notice','নোটিশ',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2810,'ba','All changes saved successfully','সব পরিবর্তন সফলভাবে সংরক্ষিত হয়েছে',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2811,'ba','Bulk save failed','একসাথে সংরক্ষণ ব্যর্থ হয়েছে',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2812,'ba','Please reload the page after saving translations to apply the changes.','পরিবর্তনগুলি প্রয়োগ করতে অনুবাদ সংরক্ষণের পর পৃষ্ঠাটি রিফ্রেশ করুন।',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2813,'ba','Action_Blocked','কার্যক্রম অবরুদ্ধ',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2814,'ba','You_cannot_delete_the_default_language','আপনি ডিফল্ট ভাষা মুছতে পারবেন না',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2815,'ba','Flag','পতাকা',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2816,'ba','Locale','লোকেল',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2817,'ba','Update Language','ভাষা আপডেট করুন',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2818,'ba','Add Language','ভাষা যোগ করুন',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2819,'ba','Send_Email','ইমেইল পাঠান',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2820,'ba','Send_SMS','এসএমএস পাঠান',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2821,'ba','total_sales','মোট বিক্রয়',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2822,'ba','Opening_Stock','প্রারম্ভিক স্টক',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2823,'ba','Subscription_Product','সাবস্ক্রিপশন পণ্য',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2824,'ba','Subscriptions','সাবস্ক্রিপশনসমূহ',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2825,'ba','Billing_Cycle','বিলিং চক্র',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2826,'ba','total_cycles','মোট চক্র',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2827,'ba','remaining_cycles','বাকি চক্র',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2828,'ba','next_billing_date','পরবর্তী বিলিং তারিখ',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2829,'ba','Failed_to_update_subscription_status','সাবস্ক্রিপশন স্ট্যাটাস আপডেট ব্যর্থ হয়েছে',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2830,'ba','Subscription_status_updated_successfully','সাবস্ক্রিপশন স্ট্যাটাস সফলভাবে আপডেট হয়েছে',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2831,'ba','Create_Susbscription','সাবস্ক্রিপশন তৈরি করুন',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2832,'ba','Price_Per_Cycle','প্রতি চক্রে মূল্য',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2833,'ba','Price_Per_Unit','প্রতি ইউনিটে মূল্য',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2834,'ba','Active','সক্রিয়',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2835,'ba','Canceled','বাতিল',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2836,'ba','Completed','সম্পন্ন',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2837,'ba','Subscription_details','সাবস্ক্রিপশন বিবরণ',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2838,'ba','Dynamic_Appearance','ডাইনামিক উপস্থিতি',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2839,'ba','Payment_Methods','পেমেন্ট পদ্ধতি',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2840,'ba','You_cant_edit_or_remove_default_payment_choices','আপনি ডিফল্ট পেমেন্ট বিকল্প সম্পাদনা বা সরাতে পারবেন না',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2841,'ba','Enter_Payment_Method','পেমেন্ট পদ্ধতি লিখুন',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2842,'ba','Sales_by_Category','বিভাগ অনুযায়ী বিক্রয়',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2843,'ba','Sales_by_Brand','ব্র্যান্ড অনুযায়ী বিক্রয়',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2844,'ba','Error_Logs','ত্রুটি লগ',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2845,'ba','Occurred_At','ঘটেছে',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2846,'ba','Context','প্রসঙ্গ',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2847,'ba','Report_Transactions','লেনদেন প্রতিবেদন',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2848,'ba','Payment_Method','পেমেন্ট পদ্ধতি',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2849,'ba','Customer_Provider','গ্রাহক/সরবরাহকারী',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2850,'ba','Sale_Purchase_Ref','বিক্রয়/ক্রয় রেফারেন্স',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2851,'br','Draft_Created_successfully','Rascunho criado com sucesso',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2852,'br','Draft_Sale_Deleted','Venda de rascunho excluída',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2853,'br','Inventory_Valuation_Based_on_Average_Cost','Avaliação de inventário baseada no custo médio',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2854,'br','Payroll','Folha de pagamento',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2855,'br','Transfers_Money','Transferências de dinheiro',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2856,'br','Inventory_Valuation','Avaliação de inventário',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2857,'br','Deposits_Report','Relatório de depósitos',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2858,'br','Expense_Report','Relatório de despesas',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2859,'br','Deposit_Category','Categoria de Depósito',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2860,'br','Total_Deposits','Total de depósitos',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2861,'br','Expense_Category','Categoria de Despesa',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2862,'br','Total_Expenses','Total de despesas',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2863,'br','ASSET_VALUE','VALOR DO ATIVO',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2864,'br','STOCK_ON_HAND','ESTOQUE EM MÃOS',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2865,'br','Variant_NAME','Nome da variante',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(2866,'br','SKU','SKU',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2867,'br','ITEM_NAME','NOME DO ITEM',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2868,'br','From_Account','Da Conta',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2869,'br','To_Account','Para a Conta',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2870,'br','Accounts_cannot_be_the_same','As contas não podem ser iguais',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2871,'br','CountStock','Contar Estoque',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2872,'br','Successfully_Generated_Count','Contagem Gerada com Sucesso',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2873,'br','Count','Contagem',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2874,'br','file','Arquivo',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2875,'br','Accounting','Contabilidade',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2876,'br','deposit_delete','Excluir Depósito',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2877,'br','deposit_edit','Editar Depósito',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2878,'br','deposit_add','Adicionar Depósito',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2879,'br','deposit_view','Visualizar Depósito',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2880,'br','expense_add','Adicionar Despesa',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2881,'br','expense_edit','Editar Despesa',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2882,'br','expense_delete','Excluir Despesa',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2883,'br','List_Deposit','Lista de Depósitos',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2884,'br','Create_deposit','Criar Depósito',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2885,'br','List_accounts','Lista de Contas',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2886,'br','Account','Conta',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2887,'br','Choose_Account','Escolher Conta',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2888,'br','Deposits','Depósitos',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2889,'br','account_num','Número da Conta',0,'2025-06-18 01:49:47.000000','2025-06-18 01:49:47.000000'),(2890,'br','Enter_account_num','Digite o Número da Conta',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2891,'br','account_name','Nome da Conta',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2892,'br','Enter_account_name','Digite o Nome da Conta',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2893,'br','initial_balance','Saldo Inicial',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2894,'br','Enter_initial_balance','Digite o Saldo Inicial',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2895,'br','notes','Notas',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2896,'br','balance','Equilíbrio',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(2897,'br','Receipt','Recibo',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2898,'br','Pos_Settings','Configurações de PDV',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(2899,'br','Note_to_customer','Nota ao cliente',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2900,'br','Show_Note_to_customer','Mostrar nota ao cliente',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2901,'br','Show_barcode','Mostre o código de barras',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2902,'br','Show_Tax_and_Discount','Mostrar impostos e descontos e envios',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2903,'br','Show_Customer','Mostrar cliente',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2904,'br','Show_Email','Mostrar e-mail',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2905,'br','Show_Phone','Mostrar telefone',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2906,'br','Show_Address','Mostrar endereço',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2907,'br','DefaultLanguage','Idioma padrão',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2908,'br','footer','rodapé',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2909,'br','Received_Amount','Valor recebido',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2910,'br','Paying_Amount','Valor a pagar',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2911,'br','Change','Troco',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2912,'br','Paying_amount_is_greater_than_Received_amount','O valor pago é maior do que o valor recebido',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2913,'br','Paying_amount_is_greater_than_Grand_Total','O valor do pagamento é maior que o total geral',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2914,'br','code_must_be_not_exist_already','O código não deve existir já',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2915,'br','You_will_find_your_backup_on','Você encontrará seu backup em',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2916,'br','and_save_it_to_your_pc','e salve no seu pc',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2917,'br','Scan_your_barcode_and_select_the_correct_symbology_below','Digitalize seu código de barras e selecione a simbologia correta abaixo',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2918,'br','Scan_Search_Product_by_Code_Name','Digitalizar/pesquisar produto por código ou nome',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2919,'br','Paper_size','Tamanho do papel',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2920,'br','Clear_Cache','Limpar cache',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2921,'br','Cache_cleared_successfully','Cache limpo com sucesso',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2922,'br','Failed_to_clear_cache','Falha ao limpar o cache',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2923,'br','Scan_Barcode','Leitor de códigos de barra',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2924,'br','Please_use_short_name_of_unit','Por favor, use o nome abreviado da unidade',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2925,'br','DefaultCustomer','Cliente padrão',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2926,'br','DefaultWarehouse','Armazém padrão',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2927,'br','Payment_Gateway','Gateway de pagamento',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(2928,'br','SMS_Configuration','Configuração de SMS',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2929,'br','Gateway','Gateway SMS',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2930,'br','Choose_Gateway','Escolha o Gateway SMS',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2931,'br','sms_send_successfully','mensagem enviada com sucesso',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2932,'br','sms_config_invalid','configuração de sms errada inválida',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2933,'br','Remove_Stripe_Key_Secret','Excluir chaves da API Stripe',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2934,'br','credit_card_account_not_available','Conta de cartão de crédito não disponível',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2935,'br','Credit_Card_Info','Informações do cartão de crédito',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(2936,'br','developed_by','Desenvolvido por',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2937,'br','Unit_already_linked_with_sub_unit','Unidade já vinculada à subunidade',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2938,'br','Total_Items_Quantity','Total de Itens e Quantidade',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2939,'br','Value_by_Cost_and_Price','Valor por Custo e Preço',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2940,'br','Search_this_table','Pesquisar esta tabela',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2941,'br','import_products','Importar produtos',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2942,'br','Field_optional','Campo opcional',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2943,'br','Download_exemple','Baixar exemplo',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2944,'br','field_must_be_in_csv_format','O campo deve estar no formato csv',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2945,'br','Successfully_Imported','Importado com sucesso',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2946,'br','file_size_must_be_less_than_1_mega','O tamanho do arquivo deve ser menor que 1 mega',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2947,'br','Please_follow_the_import_instructions','Por favor, siga as instruções de importação',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2948,'br','must_be_exist','Unidade já deve ser criada',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2949,'br','Import_Customers','Importar clientes',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2950,'br','Import_Suppliers','Fornecedores de importação',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2951,'br','Recent_Sales','Vendas recentes',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2952,'br','Create_Transfer','Criar transferência',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2953,'br','order_products','Itens de ordem',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2954,'br','Search_Product_by_Code_Name','Pesquisar produto por código ou nome',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2955,'br','Reports_payments_Purchase_Return','Relatórios de pagamentos de devolução de compra',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2956,'br','Reports_payments_Sale_Return','Relatórios de Pagamentos de Devolução de Vendas',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2957,'br','payments_Sales_Return','Devolução de vendas de pagamentos',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2958,'br','payments_Purchases_Return','Pagamentos Devolução de Compras',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2959,'br','CreateSaleReturn','Criar Devolução de Venda',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2960,'br','EditSaleReturn','Editar devolução de venda',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2961,'br','SalesReturn','Retorno de vendas',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2962,'br','CreatePurchaseReturn','Criar devolução de compra',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2963,'br','EditPurchaseReturn','Editar devolução de compra',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2964,'br','PurchasesReturn','Devolução de compras',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2965,'br','Due','Vencimento',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2966,'br','Profit','Perfil',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2967,'br','Revenue','receita',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2968,'br','Sales_today','Vendas de hoje',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2969,'br','People','Pessoas',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2970,'br','Successfully_Created','Criado com sucesso',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2971,'br','Successfully_Updated','Atualizado com sucesso',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2972,'br','Success','Sucesso',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2973,'br','Failed','Fracassado',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2974,'br','Warning','Aviso',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2975,'br','Please_fill_the_form_correctly','Por favor preencha o formulário corretamente',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2976,'br','Field_is_required','Este campo é obrigatório',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2977,'br','Error','Erro!',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2978,'br','you_are_not_authorized','Desculpe! Você não está autorizado.',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2979,'br','Go_back_to_home','Voltar para a página inicial',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2980,'br','page_not_exist','Desculpe! A página que você estava procurando não existe.',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2981,'br','Choose_Status','Escolha o status',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(2982,'br','Choose_Method','Escolha o método',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2983,'br','Choose_Symbology','Escolha a simbologia',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2984,'br','Choose_Category','Escolher categoria',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2985,'br','Choose_Customer','Escolher categoria',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2986,'br','Choose_Supplier','Escolha o fornecedor',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2987,'br','Choose_Unit_Purchase','Escolha a unidade de compra',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2988,'br','Choose_Sub_Category','Escolha a subcategoria',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2989,'br','Choose_Brand','Escolha a marca',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2990,'br','Choose_Warehouse','Escolher Armazém',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2991,'br','Choose_Unit_Sale','Escolha a unidade de venda',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2992,'br','Enter_Product_Cost','Insira o custo do produto',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2993,'br','Enter_Stock_alert','Digite o alerta de estoque',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2994,'br','Choose_Unit_Product','Escolha a unidade do produto',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2995,'br','Enter_Product_Price','Insira o preço do produto',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2996,'br','Enter_Name_Product','Digite o nome do produto',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2997,'br','Enter_Role_Name','Digite o nome da função',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2998,'br','Enter_Role_Description','Digite a descrição do papel',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(2999,'br','Enter_name_category','Digite o nome da categoriae',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(3000,'br','Enter_Code_category','Digite o código da categoria',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(3001,'br','Enter_Name_Brand','Digite o nome da marca',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(3002,'br','Enter_Description_Brand','Digite Descrição Marca',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(3003,'br','Enter_Code_Currency','Digite a moeda do código',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(3004,'br','Enter_name_Currency','Digite a moeda do código',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(3005,'br','Enter_Symbol_Currency','Insira a moeda do símbolo',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(3006,'br','Enter_Name_Unit','Digite o nome da unidade',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(3007,'br','Enter_ShortName_Unit','Insira a unidade de nome abreviado',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(3008,'br','Choose_Base_Unit','Escolha a unidade básica',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(3009,'br','Choose_Operator','Escolher Operador',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(3010,'br','Enter_Operation_Value','Enter Operation Value',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(3011,'br','Enter_Name_Warehouse','Enter Warehouse Name',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(3012,'br','Enter_Phone_Warehouse','Enter Warehouse Phone',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(3013,'br','Enter_Country_Warehouse','Enter Warehouse Country',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(3014,'br','Enter_City_Warehouse','Enter Warehouse City',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(3015,'br','Enter_Email_Warehouse','Enter Warehouse Email',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(3016,'br','Enter_ZipCode_Warehouse','Enter Warehouse Zip Code',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(3017,'br','Choose_Currency','Escolha a moeda',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(3018,'br','Thank_you_for_your_business','Obrigado por comprar conosco . Por favor, volte',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(3019,'br','Cancel','Cancelar',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(3020,'br','New_Customer','Novo cliente',0,'2025-06-18 01:49:48.000000','2025-06-18 01:49:48.000000'),(3021,'br','Incorrect_Login','Login incorreto',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3022,'br','Successfully_Logged_In','Logado com sucesso',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3023,'br','This_user_not_active','Este usuário não está ativo',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3024,'br','SignIn','Entrar',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3025,'br','Create_an_account','Crie a sua conta aqui',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3026,'br','Forgot_Password','Esqueceu a senha ?',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3027,'br','Email_Address','Endereço de email',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3028,'br','SignUp','Inscrever-se',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3029,'br','Already_have_an_account','Já tem uma conta ?',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3030,'br','Reset_Password','Redefinir senha',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3031,'br','Failed_to_authenticate_on_SMTP_server','Falha ao autenticar no servidor SMTP',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3032,'br','We_cant_find_a_user_with_that_email_addres','Não conseguimos encontrar um usuário com esse endereço de e-mail',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3033,'br','We_have_emailed_your_password_reset_link','Enviamos o link de redefinição de senha por e-mail',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3034,'br','Please_fill_the_Email_Adress','Por favor, preencha o endereço de e-mail',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3035,'br','Confirm_password','Confirme a Senha',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3036,'br','Your_Password_has_been_changed','Sua senha foi mudada',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3037,'br','The_password_confirmation_does_not_match','A confirmação da senha não corresponde',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3038,'br','This_password_reset_token_is_invalid','Este token de redefinição de senha é inválido',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3039,'br','Warehouse_report','Relatório do armazém',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3040,'br','All_Warehouses','Todos os Armazéns',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3041,'br','Expense_List','Todas as despesas',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3042,'br','Expenses','Despesas',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3043,'br','This_Week_Sales_Purchases','Esta semana Vendas e compras',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3044,'br','Top_Selling_Products','Produtos mais vendidos',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3045,'br','View_all','Ver tudo',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3046,'br','Payment_Sent_Received','Pagamento enviado e recebido',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3047,'br','Filter','Filtro',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3048,'br','Invoice_POS','Fatura PDV',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3049,'br','Invoice','Fatura',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3050,'br','Customer_Info','Informação do Cliente',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3051,'br','Company_Info','Informação da companhia',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3052,'br','Invoice_Info','Informações da fatura',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3053,'br','Order_Summary','Resumo do pedido',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3054,'br','Quote_Info','Informações da cotação',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3055,'br','Del','Excluir',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3056,'br','SuppliersPaiementsReport','Relatório de Pagamentos de Fornecedores',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3057,'br','Purchase_Info','Informações de compra',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3058,'br','Supplier_Info','Informações do fornecedor',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3059,'br','Return_Info','Informações de Devolução',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3060,'br','Create_Expense','Criar Despesa',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3061,'br','Details','Detalhes',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3062,'br','Discount_Method','Tipo de desconto',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3063,'br','Net_Unit_Cost','Custo unitário líquido',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3064,'br','Net_Unit_Price','Preço unitário líquido',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3065,'br','Edit_Expense','Edit Expense',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3066,'br','All_Brand','Todas as marcas',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3067,'br','All_Category','Todas as categorias',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3068,'br','ListExpenses','Todas as despesas',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3069,'br','Create_Permission','Criar permissão',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3070,'br','Edit_Permission','Editar permissão',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3071,'br','Reports_payments_Sales','Relatórios de pagamentos Vendas',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3072,'br','Reports_payments_Purchases','Relatórios de pagamentos Compras',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3073,'br','Reports_payments_Return_Customers','Clientes de Devolução de Pagamentos',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3074,'br','Reports_payments_Return_Suppliers','Fornecedores de devolução de pagamentos',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3075,'br','Expense_Deleted','Esta despesa foi excluída',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3076,'br','Expense_Updated','Esta despesa contratada foi',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3077,'br','Expense_Created','Esta despesa foi criada',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3078,'br','DemoVersion','Você não pode fazer isso na versão demo',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3079,'br','OrderStatistics','Estatísticas de vendas',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3080,'br','AlreadyAdd','Este produto já foi adicionado !!',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3081,'br','AddProductToList','Por favor, adicione o produto à lista !!',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3082,'br','AddQuantity','Por favor, adicione a quantidade do produto !!',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3083,'br','InvalidData','Dados inválidos !!',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3084,'br','LowStock','A quantidade excede a quantidade disponível em estoque',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3085,'br','WarehouseIdentical','Os dois armazéns não podem ser idênticos !!',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3086,'br','VariantDuplicate','Esta variante é duplicada !!',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3087,'br','Filesize','Tamanho do arquivo',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3088,'br','GenerateBackup','Gerar Backup',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3089,'br','BackupDatabase','Banco de dados de backup',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3090,'br','Backup','Backup',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3091,'br','Paid','Pago',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3092,'br','Unpaid','Não pago',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3093,'br','Today','Hoje',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3094,'br','Income','Income',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3095,'br','Sale','Oferta',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3096,'br','Actif','Ativo',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3097,'br','Inactif','Inativo',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3098,'br','Customers','Cliente',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3099,'br','Phone','Telefone',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3100,'br','SearchByPhone','Pesquisar por telefone',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3101,'br','Suppliers','Fornecedores',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3102,'br','Quotations','Cotações',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3103,'br','Sales','Vendas',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3104,'br','Purchases','Compras',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3105,'br','Returns','Retornar',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3106,'br','Settings','Definições',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3107,'br','SystemSettings','Configurações de sistema',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3108,'br','Users','Usuários',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3109,'br','GroupPermissions','Permissões de grupo',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3110,'br','Currencies','Moeda',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3111,'br','Warehouses','Armazém',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3112,'br','Units','Unidade',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3113,'br','UnitsPrchases','Unidades de compras',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3114,'br','UnitsSales','Unidades de vendas',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3115,'br','Reports','Relatórios',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3116,'br','PaymentsReport','Relatório de pagamentos',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3117,'br','PaymentsPurchases','Pagamentos Compras',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3118,'br','PaymentsSales','Pagamentos Vendas',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3119,'br','ProfitandLoss','Lucros e perdas',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3120,'br','WarehouseStockChart','Gráfico de Estoque do Armazém',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3121,'br','SalesReport','Relatório de vendas',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3122,'br','PurchasesReport','Relatório de compra',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3123,'br','CustomersReport','Relatório do cliente',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3124,'br','SuppliersReport','Relatório do Fornecedor',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3125,'br','SupplierReport','Relatório do Fornecedor',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3126,'br','DailySalesData','Dados diários de vendas',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3127,'br','DailyPurchasesData','Dados de compras diárias',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3128,'br','Dernièrescinqrecords','Últimos cinco registros',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3129,'br','Filters','Filtros',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3130,'br','date','Data',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3131,'br','Reference','Referência',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3132,'br','Supplier','Fornecedor',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3133,'br','PaymentStatus','Status do pagamento',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3134,'br','Customer','Cliente',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3135,'br','CustomerCode','Código do Consumidor',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3136,'br','Status','Status',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3137,'br','SupplierCode','Código de fornecedor',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3138,'br','Categorie','Categoria',0,'2025-06-18 01:49:49.000000','2025-06-18 01:49:49.000000'),(3139,'br','Categories','Categoria',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3140,'br','StockTransfers','Transferir',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3141,'br','StockManagement','Gestão de Estoque',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3142,'br','dashboard','Dashboard',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3143,'br','Products','Produtos',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3144,'br','productsList','Todos os produtos',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3145,'br','ProductManagement','Gestão de produtos',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3146,'br','ProductQuantityAlerts','Product Quantity Alerts',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3147,'br','CodeProduct','Código do produto',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3148,'br','ProductTax','Imposto sobre produtos',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3149,'br','SubCategorie','Subcategoria',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3150,'br','Name_product','Nome',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3151,'br','StockAlert','Alerta de estoque',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3152,'br','warehouse','Armazém',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3153,'br','Tax','Imposto',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3154,'br','BuyingPrice','Preço de compra',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3155,'br','SellPrice','Preço de venda',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3156,'br','Quantity','Quantidade',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3157,'br','UnitSale','Unidade de venda',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3158,'br','UnitPurchase','Unidade de compra',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3159,'br','ManagementCurrencies','Gerenciamento de moeda',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3160,'br','CurrencyCode','Código da moeda',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3161,'br','CurrencyName','Nome da moeda',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3162,'br','Symbol','Símbolo',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3163,'br','All','Tudo',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3164,'br','EditProduct','Editar produto',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3165,'br','SearchByCode','Pesquisar por código',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3166,'br','SearchByName','Procura por nome',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3167,'br','ProductDetails','Detalhes do produto',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3168,'br','CustomerName','nome do cliente',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3169,'br','CustomerManagement','Gestão de Clientes',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3170,'br','Add','Criar',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3171,'br','Edit','Editar',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3172,'br','Close','Fechar',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3173,'br','PleaseSelect','Por favor selecione',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3174,'br','Action','Ação',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3175,'br','Email','Email',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3176,'br','EditCustomer','Editar cliente',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3177,'br','AddCustomer','Criar cliente',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3178,'br','Country','País',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3179,'br','City','Cidade',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3180,'br','Adress','Endereço',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3181,'br','CustomerDetails','Detalhes do cliente',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3182,'br','CustomersList','Clientes',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3183,'br','SupplierName','Nome do Fornecedor',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3184,'br','SuppliersManagement','Gestão de fornecedores',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3185,'br','SupplierDetails','Detalhes do fornecedor',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3186,'br','QuotationsManagement','Gerenciamento de Cotações',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3187,'br','SubTotal','Subtotal',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3188,'br','MontantReste','Quantidade restante',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3189,'br','complete','Concluído',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3190,'br','EnAttendant','Pendente',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3191,'br','Recu','Recebido',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3192,'br','partial','Parcial',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3193,'br','Retournee','Retornar',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3194,'br','DetailQuote','Cotação detalhada',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3195,'br','EditQuote','Editar cotação',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3196,'br','CreateSale','Criar venda',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3197,'br','DownloadPdf','Baixar PDF',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3198,'br','QuoteEmail','Enviar cotação no e-mail',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3199,'br','DeleteQuote','Excluir cotação',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3200,'br','AddQuote','Criar cotação',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3201,'br','SelectProduct','Selecionar produto',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3202,'br','ProductCodeName','Produto (Código - Nome)',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3203,'br','Price','Preço',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3204,'br','CurrentStock','Estoque',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3205,'br','Total','Total geral',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3206,'br','Num','N°',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3207,'br','Unitcost','Custo unitário',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3208,'br','to','Para',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3209,'br','Subject','Sujeito',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3210,'br','Message','Mensagem',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3211,'br','EmailCustomer','E-mail do cliente',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3212,'br','Sent','Enviado',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3213,'br','Quote','cotação',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3214,'br','Hello','Olá',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3215,'br','AttachmentQuote','Por favor, encontre o anexo para sua cotação',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3216,'br','AddProducts','Adicionar produtos à lista de pedidos',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3217,'br','SelectWarehouse','Selecione o armazém',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3218,'br','SelectCustomer','Por favor selecione o cliente',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3219,'br','SalesManagement','Gerenciamento de vendas',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3220,'br','QtyBack','Quantidade de volta',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3221,'br','TotalReturn','Retorno total',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3222,'br','Amount','Quantia',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3223,'br','SaleDetail','Detalhe da venda',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3224,'br','EditSale','Editar venda',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3225,'br','AddSale','Criar venda',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3226,'br','ShowPayment','Mostrar pagamentos',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3227,'br','AddPayment','Criar pagamento',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3228,'br','EditPayment','Editar pagamento',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3229,'br','EmailSale','Enviar venda por e-mail',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3230,'br','DeleteSale','Excluir venda',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3231,'br','ModePaiement','Pago pelo',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3232,'br','Paymentchoice','Opção de pagamento',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3233,'br','Note','Observação',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3234,'br','PaymentComplete','Pagamento concluído!',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3235,'br','PurchasesManagement','Gestão de compras',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3236,'br','Ordered','Encomendado',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3237,'br','DeletePurchase','Excluir compra',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3238,'br','EmailPurchase','Enviar compra por e-mail',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3239,'br','EditPurchase','Editar compra',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3240,'br','PurchaseDetail','Detalhe da compra',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3241,'br','AddPurchase','Criar compra',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3242,'br','EmailSupplier','E-mail do fornecedor',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3243,'br','PurchaseInvoice','Pagamentos de compras',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3244,'br','PurchasesInvoicesData','Dados de pagamentos de compras',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3245,'br','SalesInvoice','Pagamentos de vendas',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3246,'br','SalesInvoicesData','Dados de pagamentos de vendas',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3247,'br','UserManagement','Gerenciamento de usuários',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3248,'br','Firstname','Primeiro nome',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3249,'br','lastname','Sobrenome',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3250,'br','username','Nome de usuário',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3251,'br','password','Senha',0,'2025-06-18 01:49:50.000000','2025-06-18 01:49:50.000000'),(3252,'br','Newpassword','Nova Senha',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3253,'br','ChangeAvatar','Mudar Avatar',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3254,'br','LeaveBlank','Por favor, deixe este campo em branco se você não o alterou',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3255,'br','type','Modelo',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3256,'br','UserPermissions','Permissões de usuários',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3257,'br','RoleName','Função',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3258,'br','RoleDescription','Descrição do papel',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3259,'br','AddPermissions','Criar permissões',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3260,'br','View','Visão',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3261,'br','NewAdjustement','Novo ajuste',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3262,'br','EditAdjustement','Editar ajuste',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3263,'br','CannotSubstraction','Você não pode subtrair produtos que têm estoque 0',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3264,'br','Addition','Adição',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3265,'br','Subtraction','Subtração',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3266,'br','profil','Perfil',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3267,'br','logout','Sair',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3268,'br','PurchaseAlreadyPaid','Você não pode modificar porque esta compra já foi paga',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3269,'br','SaleAlreadyPaid','Você não pode modificar porque esta venda já foi paga',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3270,'br','ReturnAlreadyPaid','Você não pode modificar porque esta Devolução já foi paga',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3271,'br','QuoteAlready','Esta cotação já gerou venda',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3272,'br','AddProduct','Criar produto',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3273,'br','QuotationComplete','Esta cotação completa',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3274,'br','SiteConfiguration','Configuração do site',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3275,'br','Language','Linguagem',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3276,'br','DefaultCurrency','Moeda padrão',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3277,'br','LoginCaptcha','Captcha de login',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3278,'br','DefaultEmail','E-mail padrão',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3279,'br','SiteName','Nome do site',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3280,'br','ChangeLogo','Alterar logotipo',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3281,'br','SMTPConfiguration','Configuração SMTP',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3282,'br','HOST','MAIL_HOST',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3283,'br','PORT','MAIL_PORT',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3284,'br','encryption','MAIL_ENCRYPTION',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3285,'br','SMTPIncorrect','Configuração SMTP incorreta',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3286,'br','PaymentsReturns','Devoluções de pagamentos',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3287,'br','ReturnsInvoices','Devoluções de faturas',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3288,'br','ReturnsInvoicesData','Devoluções de dados de faturas',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3289,'br','ShowAll','Ver todos os registros de todos os usuários',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3290,'br','Discount','Desconto',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3291,'br','OrderTax','Imposto de pedido',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3292,'br','Shipping','Envio',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3293,'br','CompanyName','Nome da empresa',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3294,'br','CompanyPhone','Telefone da empresa',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3295,'br','CompanyAdress','Endereço da companhia',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3296,'br','Code','Código',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3297,'br','image','Imagem',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3298,'br','Printbarcode','Imprimir código de barras',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3299,'br','ReturnsCustomers','Cliente de Devoluções',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3300,'br','ReturnsSuppliers','Fornecedor de devoluções',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3301,'br','FactureReturnCustomers','Devolução da fatura do cliente',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3302,'br','FactureReturnSuppliers','Devolução de fatura do fornecedor',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3303,'br','NodataAvailable','Nenhum dado disponível',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3304,'br','ProductImage','Imagem do Produto',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3305,'br','Barcode','Código de barras',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3306,'br','pointofsales','Ponto de Vendas',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3307,'br','CustomUpload','Upload personalizado',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3308,'br','pointofsaleManagement','Gerenciamento de ponto de venda',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3309,'br','Adjustment','Ajustamento',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3310,'br','Updat','Atualizar',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3311,'br','Reset','Redefinir',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3312,'br','print','Imprimir',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3313,'br','SearchByEmail','Pesquisar por e-mail',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3314,'br','ChooseProduct','Escolha o produto',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3315,'br','Qty','Qty',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3316,'br','Items','Itens',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3317,'br','AmountHT','Quantidade HT',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3318,'br','AmountTTC','Valor TTC',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3319,'br','PleaseSelectSupplier','Selecione o fornecedorPlease Select Supplier',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3320,'br','PleaseSelectStatut','Selecione o status',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3321,'br','PayeBy','Pago pelo',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3322,'br','ChooseWarehouse','Escolher Armazém',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3323,'br','payNow','Pague agora',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3324,'br','ListofCategory','Lista de Categoria',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3325,'br','Description','Description',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3326,'br','submit','Enviar',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3327,'br','ProblemCreatingThisInvoice','Ocorreu um problema ao criar esta fatura. Por favor, tente novamente',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3328,'br','ProblemPayment','Houve um problema no pagamento. Por favor, tente novamente..',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3329,'br','IncomeExpenses','Receitas e despesas',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3330,'br','dailySalesPurchases','Vendas e compras diárias',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3331,'br','ProductsExpired','Produtos expirados',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3332,'br','ListofBrand','Marcas',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3333,'br','CreateAdjustment','Criar ajuste',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3334,'br','Afewwords','Algumas palavras ...',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3335,'br','UserImage','Imagem do usuário',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3336,'br','UpdateProduct','Atualizar produto',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3337,'br','Brand','Marca',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3338,'br','BarcodeSymbology','Simbologia do código de barras',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3339,'br','ProductCost','Custo do produto',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3340,'br','ProductPrice','Preço do produto',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3341,'br','UnitProduct','Unidade de produto',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3342,'br','TaxMethod','Tipo de imposto',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3343,'br','MultipleImage','Várias imagens',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3344,'br','ProductHasMultiVariants','Este produto tem várias variantes',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3345,'br','ProductHasPromotion','Produto Tem Promoção',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3346,'br','PromotionStart','Início da promoção',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3347,'br','PromotionEnd','Fim da promoção',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3348,'br','PromotionPrice','Preço de promoção',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3349,'br','Cost','Custo',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3350,'br','Unit','Unidade',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3351,'br','ProductVariant','Variante do produto',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3352,'br','Variant','Variante',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3353,'br','UnitPrice','Preço unitário',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3354,'br','CreateReturnCustomer','Criar cliente de devolução',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3355,'br','EditReturnCustomer','Editar cliente de retorno',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3356,'br','CreateReturnSupplier','Criar fornecedor de devolução',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3357,'br','Documentation','Doc',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3358,'br','EditReturnSupplier','Editar fornecedor de devolução',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3359,'br','FromWarehouse','Do armazém',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3360,'br','ToWarehouse','Para Armazém',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3361,'br','EditTransfer','Editar transferência',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3362,'br','TransferDetail','Detalhe da transferência',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3363,'br','Pending','Pendente',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3364,'br','Received','Recebido',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3365,'br','PermissionsManager','Gerenciamento de permissões',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3366,'br','BrandManager','Marca',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3367,'br','BrandImage','Imagem de marca',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3368,'br','BrandName','Marca',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3369,'br','BrandDescription','Descrição da marca',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3370,'br','BaseUnit','Unidade base',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3371,'br','ManagerUnits','Gestão de Unidades',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3372,'br','OperationValue','Valor da operação',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3373,'br','Operator','Operador',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3374,'br','Top5Products','5 principais produtos',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3375,'br','Last5Sales','Últimas 5 vendas',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3376,'br','ListAdjustments','Todos os ajustes',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3377,'br','ListTransfers','Todas as transferências',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3378,'br','CreateTransfer','Criar transferência',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3379,'br','OrdersManager','Gestão de Pedidos',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3380,'br','ListQuotations','Todas as Cotações',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3381,'br','ListPurchases','Todas as compras',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3382,'br','ListSales','Todas as vendas',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3383,'br','ListReturns','Todas as devoluções',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3384,'br','PeopleManager','Gestão de Pessoas',0,'2025-06-18 01:49:51.000000','2025-06-18 01:49:51.000000'),(3385,'br','Delete_Title','Tem certeza?',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3386,'br','Delete_Text','Você não poderá reverter isso!',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3387,'br','Delete_confirmButtonText','Sim, exclua!',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3388,'br','Delete_cancelButtonText','Cancelar',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3389,'br','Delete_Deleted','Excluído!',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3390,'br','Delete_Failed','Fracassado!',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3391,'br','Delete_Therewassomethingwronge','Havia algo errado',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3392,'br','SendEmail','Email enviado com sucesso',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3393,'br','erroSale','Esta venda já está vinculada a uma Devolução!',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3394,'br','ReturnManagement','Gestão de Devolução',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3395,'br','ReturnDetail','Return Detail',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3396,'br','EditReturn','Editar retorno',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3397,'br','AddReturn','Criar Devolução',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3398,'br','EmailReturn','Enviar retorno no e-mail',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3399,'br','DeleteReturn','Excluir Devolução',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3400,'br','Retoursurcharge','Sobretaxa de devolução',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3401,'br','Laivrison','Entrega',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3402,'br','SelectSale','Selecionar venda',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3403,'br','ZeroPardefault','Você pode excluir o item ou definir a quantidade devolvida para zero se não for devolvida',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3404,'br','Return','Retornar',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3405,'br','Purchase','Comprar',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3406,'br','TotalSales','Vendas totais',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3407,'br','TotalPurchases','Total de Compras',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3408,'br','TotalReturns','Devoluções totaiss',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3409,'br','PaiementsNet','Pagamentos líquidos',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3410,'br','PaiementsSent','Pagamentos enviados',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3411,'br','PaiementsReceived','Pagamentos recebidos',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3412,'br','Recieved','Recebid',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3413,'br','ProductCode','Código',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3414,'br','ProductName','Produtos',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3415,'br','AlertQuantity','Quantidade de alertas',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3416,'br','TotalProducts','Produtos totais',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3417,'br','TotalQuantity','Quantidade total',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3418,'br','TopCustomers','5 principais clientes',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3419,'br','TotalAmount','5 principais clientes',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3420,'br','TotalPaid','Total pago',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3421,'br','CustomerSalesReport','Relatório de vendas do cliente',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3422,'br','CustomerPaiementsReport','Relatório de pagamentos do cliente',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3423,'br','CustomerQuotationsReport','Relatório de Cotações de Clientes',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3424,'br','Payments','Pagamentos',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3425,'br','TopSuppliers','5 principais fornecedores',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3426,'br','SupplierPurchasesReport','Relatório de Compras de Fornecedores',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3427,'br','SupplierPaiementsReport','Relatório de Pagamentos de Fornecedores',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3428,'br','Name','Nome',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3429,'br','ManagementWarehouse','Gerenciamento de armazenagem',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3430,'br','ZipCode','Código postal',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3431,'br','managementCategories','Gerenciamento de categorias',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3432,'br','Codecategorie','Código da categoria',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3433,'br','Namecategorie','Nome da Categoria',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3434,'br','Parentcategorie','Categoria Parental',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3435,'br','managementTax','Gestão tributária',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3436,'br','TaxName','Nome Fiscal',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3437,'br','TaxRate','Taxa de imposto',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3438,'br','managementUnitPurchases','Unidade de compras',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3439,'br','managementUnitSales','Unidade de vendas',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3440,'br','ShortName','Nome curto',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3441,'br','PleaseSelectThesebeforeaddinganyproduct','Por favor, selecione estes antes de adicionar qualquer produto',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3442,'br','StockAdjustement','Ajustamento',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3443,'br','PleaseSelectWarehouse','Please Select warehouse before choose any product',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3444,'br','StockTransfer','Stock Transfer',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3445,'br','SelectPeriod','Select Period',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3446,'br','ThisYear','This Year',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3447,'br','ThisToday','This Today',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3448,'br','ThisMonth','This Month',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3449,'br','ThisWeek','This Week',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3450,'br','AdjustmentDetail','Adjustment Detail',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3451,'br','ActivateUser','This User Has been Activated',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3452,'br','DisActivateUser','This User Has been Deactivated',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3453,'br','NotFound','Page not found.',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3454,'br','oops','Ops! página não encontrada.',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3455,'br','couldNotFind','Não foi possível encontrar a página que você estava procurando. Enquanto isso, você pode',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3456,'br','ReturnDashboard','Voltar ao painel',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3457,'br','hrm','HRM',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3458,'br','Employees','Funcionários',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3459,'br','Attendance','Comparecimento',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3460,'br','Leave_request','Deixar pedido',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3461,'br','Leave_type','Tipo de licença',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3462,'br','Company','Companhia',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3463,'br','Departments','Departamentos',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3464,'br','Designations','Designações',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3465,'br','Office_Shift','Turno de escritório',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3466,'br','Holidays','Feriados',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3467,'br','Enter_Company_Name','Digite o nome da empresae',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3468,'br','Enter_email_address','Insira o endereço de e-mail',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3469,'br','Enter_Company_Phone','Digite o telefone da empresa',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3470,'br','Enter_Company_Country','Insira o país da empresa',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3471,'br','Created_in_successfully','Criado com sucesso',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3472,'br','Updated_in_successfully','Atualizado com sucesso',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3473,'br','Deleted_in_successfully','Excluído com sucesso',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3474,'br','department','Departamento',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3475,'br','Enter_Department_Name','Digite o nome do departamento',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3476,'br','Choose_Company','Escolha a empresa',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3477,'br','Department_Head','Chefe de departamento',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3478,'br','Choose_Department_Head','Escolha o chefe de departamento',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3479,'br','Enter_Shift_name','Digite o nome do turno',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3480,'br','Monday_In','Segunda-feira',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3481,'br','Monday_Out','Segunda-feira',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3482,'br','Tuesday_In','Terça-feira In',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3483,'br','tuesday_out','terça Out',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3484,'br','wednesday_in','Wednesday In',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3485,'br','wednesday_out','Wednesday Out',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3486,'br','thursday_in','Thursday In',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3487,'br','thursday_out','Thursday Out',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3488,'br','friday_in','Friday In',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3489,'br','friday_out','Friday Out',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3490,'br','saturday_in','Saturday In',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3491,'br','saturday_out','Saturday Out',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3492,'br','sunday_in','Sunday In',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3493,'br','sunday_out','Sunday Out',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3494,'br','Holiday','Feriado',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3495,'br','Enter_title','Digite o título',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3496,'br','title','título',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3497,'br','start_date','Data de início',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3498,'br','Enter_Start_date','Enter start date',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3499,'br','Finish_Date','Data de término',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3500,'br','Enter_Finish_date','Insira a data de término',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3501,'br','Please_provide_any_details','Por favor, forneça quaisquer detalhes',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3502,'br','Attendances','Presenças',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3503,'br','Enter_Attendance_date','Insira a data de atendimento',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3504,'br','Time_In','Em vez',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3505,'br','Time_Out','Tempo esgotado',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3506,'br','Choose_Employee','Escolher funcionário',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3507,'br','Employee','Empregado',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3508,'br','Work_Duration','Duração do Trabalho',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3509,'br','remaining_leaves_are_insufficient','As folhas restantes são insuficientes',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3510,'br','Days','Dias',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3511,'br','Choose_leave_type','Escolha o tipo de licença',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3512,'br','Leave_Reason','Motivo de Saída',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3513,'br','Enter_Reason_Leave','Digite o motivo da licença',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3514,'br','Add_Employee','Adicionar funcionário',0,'2025-06-18 01:49:52.000000','2025-06-18 01:49:52.000000'),(3515,'br','Enter_FirstName','Introduza o primeiro nome',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3516,'br','Enter_LastName','Insira o último nome',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3517,'br','Gender','Gênero',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3518,'br','Choose_Gender','Escolha o Gênero',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3519,'br','Enter_Birth_date','Digite a data de nascimento',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3520,'br','Birth_date','Data de nascimento',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3521,'br','Enter_Country','Digite o país',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3522,'br','Enter_Phone_Number','Digite o número de telefone',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3523,'br','joining_date','Data de ingresso',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3524,'br','Enter_joining_date','Insira a data de adesão',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3525,'br','Choose_Designation','Escolha a designação',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3526,'br','Designation','Designação',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3527,'br','Choose_Office_Shift','Escolha o turno do escritório',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3528,'br','Enter_Leaving_Date','Digite a data de saída',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3529,'br','Leaving_Date','Data partida',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3530,'br','Annual_Leave','Banco de horas',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3531,'br','Enter_Annual_Leave','Entrar férias anuais',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3532,'br','Remaining_leave','Licença restante',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3533,'br','Employee_Details','Detalhes do funcionário',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3534,'br','Basic_Information','Informação básica',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3535,'br','Family_status','Situação familiar',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3536,'br','Choose_Family_status','Escolha o status da família',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3537,'br','Employment_type','Tipo de Emprego',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3538,'br','Select_Employment_type','Selecione o tipo de emprego',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3539,'br','Enter_City','Digite a cidade',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3540,'br','Province','Província',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3541,'br','Enter_Province','Digite a Província',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3542,'br','Enter_Address','Insira o endereço',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3543,'br','Enter_Zip_code','Digite o código postal',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3544,'br','Zip_code','Código postal',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3545,'br','Hourly_rate','Taxa horária',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3546,'br','Enter_Hourly_rate','Insira a taxa por hora',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3547,'br','Basic_salary','Salário básico',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3548,'br','Enter_Basic_salary','Insira o salário base',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3549,'br','Social_Media','Mídia social',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3550,'br','Skype','Skype',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3551,'br','Enter_Skype','Enter Skype',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3552,'br','Facebook','Facebook',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3553,'br','Enter_Facebook','Enter Facebook',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3554,'br','WhatsApp','WhatsApp',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3555,'br','Enter_WhatsApp','Enter WhatsApp',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3556,'br','LinkedIn','LinkedIn',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3557,'br','Enter_LinkedIn','Enter LinkedIn',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3558,'br','Twitter','Twitter',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3559,'br','Enter_Twitter','Enter Twitter',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3560,'br','Experiences','Experiências',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3561,'br','bank_account','conta bancária',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3562,'br','Company_Name','nome da empresa',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3563,'br','Location','Location',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3564,'br','Enter_location','Enter location',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3565,'br','Enter_Description','Enter Description',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3566,'br','Bank_Name','Nome do banco',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3567,'br','Enter_Bank_Name','Digite o nome do banco',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3568,'br','Bank_Branch','Agência bancária',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3569,'br','Enter_Bank_Branch','Entrar na agência bancária',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3570,'br','Bank_Number','Número do banco',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3571,'br','Enter_Bank_Number','Digite o número do banco',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3572,'br','Assigned_warehouses','Acessar armazéns',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3573,'br','Top_customers','Melhores clientes',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3574,'br','Attachment','Acessório',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3575,'br','view_employee','ver funcionário',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3576,'br','edit_employee','Editar funcionário',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3577,'br','delete_employee','Excluir funcionário',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3578,'br','Created_by','Adicionado por',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3579,'br','Add_product_IMEI_Serial_number','Adicionar IMEI/Número de Série do produto',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3580,'br','Product_Has_Imei_Serial_number','O Produto Tem Imei/Número de Série',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3581,'br','IMEI_SN','IMEI/SN',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3582,'br','Shipments','Remessos',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3583,'br','delivered_to','Entregue a',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3584,'br','shipment_ref','Referência de remessa',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3585,'br','sale_ref','Referência de venda',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3586,'br','Edit_Shipping','Editar envio',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3587,'br','Packed','Embalado',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3588,'br','Shipped','Enviado',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3589,'br','Delivered','Entregue',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3590,'br','Cancelled','Cancelado',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3591,'br','Shipping_status','Status de envio',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3592,'br','Users_Report','Relatório de usuários',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3593,'br','stock_report','Relatório de Estoque',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3594,'br','Total_quotations','Cotações totais',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3595,'br','Total_return_sales','Vendas totais de retorno',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3596,'br','Total_return_purchases','Total de compras de devolução',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3597,'br','Total_transfers','Transferências totais',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3598,'br','Total_adjustments','Ajustes totais',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3599,'br','User_report','Relatório do usuário',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3600,'br','Current_stock','Estoque atual',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3601,'br','product_name','Nome do Produto',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3602,'br','Total_Customers_Due','Dívida total',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3603,'br','Total_Suppliers_Due','Dívida total',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3604,'br','Some_warehouses','Alguns Armazéns',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3605,'br','Product_Cost','Custo do produto',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3606,'br','sms_settings','Configurações de SMS',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3607,'br','mail_settings','Configurações de e-mail',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3608,'br','Nexmo_SMS','Nexmo SMS',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3609,'br','TWILIO_SMS','TWILIO SMS',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3610,'br','Default_SMS_Gateway','Gateway de SMS padrão',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3611,'br','module_settings','Configurações do módulo',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3612,'br','Module_enabled_success','Módulo ativado com sucesso',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3613,'br','Module_Disabled_success','Módulo desativado com sucesso',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3614,'br','update_settings','Melhoria',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3615,'br','Please_Upload_the_Correct_Module','Por favor, carregue o módulo correto',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3616,'br','Uploaded_Success','Enviado com sucesso',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3617,'br','Customer_details','Detalhes do cliente',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3618,'br','Edit_Customer','Editar cliente',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3619,'br','Delete_Customer','Excluir cliente',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3620,'br','Pay_Due','Pagamento devido',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3621,'br','Paying_amount_is_greater_than_Total_Due','O valor do pagamento é maior que o total devido',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3622,'br','Customer_Invoice','Fatura do cliente',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3623,'br','This_Product_Not_For_Selling','Este Produto Não Para Venda',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3624,'br','Welcome_to_your_Dashboard','Bem-vindo ao seu painel',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3625,'br','Total_Payable','Total a pagar',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3626,'br','Choose_Sale_Ref','Escolher referência de venda',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3627,'br','Please_Select_Sale','Selecione a venda',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3628,'br','list_product_returns','Listar devoluções de produtos',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3629,'br','Qty_return','Devolução de quantidade',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3630,'br','Choose_Purchase_Ref','Escolha a referência de compra',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3631,'br','Purchase_Ref','Referência de compra',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3632,'br','please_select_purchase','Por favor selecione a compra',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3633,'br','qty_return_is_greater_than_qty_purchased','O retorno da quantidade é maior que a quantidade comprada',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3634,'br','qty_return_is_greater_than_qty_sold','O retorno da quantidade é maior que a quantidade vendida',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3635,'br','Quantity_sold','Quantidade vendida',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3636,'br','qty_purchased','quantidade comprada',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3637,'br','Sender_Name','Nome do remetente',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3638,'br','The_module_must_be_uploaded_as_zip_file','O módulo deve ser carregado como arquivo zip',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3639,'br','Upload_Module','Módulo de upload',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3640,'br','All_Modules_Installed','Todos os módulos instalados',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3641,'br','Current_Version','Versão Atual',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3642,'br','You_already_have_the_latest_version','Você já tem a versão mais recente',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3643,'br','Update_Available','Atualização disponível',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3644,'br','Update_Log','Atualizar registro',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3645,'br','Update_Now','Atualizar agora',0,'2025-06-18 01:49:53.000000','2025-06-18 01:49:53.000000'),(3646,'br','View_Change_Log','Visualizar registro de alteração',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3647,'br','Please_Wait_for_the_update','Aguarde até que a atualização termine completamente. Não é recomendado fechar o navegador ou parar um processo Upgrade',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3648,'br','Note_update','Certifique-se de fazer backup de sua versão atual e banco de dados antes de executar a atualização, para restaurá-la se houver um erro',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3649,'br','invoice_footer','Rodapé da fatura',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3650,'br','Time_Zone','Fuso horário',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3651,'br','Payment_note','Notas de pagamento',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3652,'br','sale_note','Notas de venda',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3653,'br','Total_Sale_Due','Venda total devida',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3654,'br','Total_Sell_Return_Due','Dívida Total de Devolução de Venda',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3655,'br','pay_all_sell_due_at_a_time','pagar todas as dívidas de venda de uma só vez',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3656,'br','pay_all_sell_return_due_at_a_time','pagar todas as dívidas de retorno de venda de uma só vez',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3657,'br','Gross_Profit','Lucro bruto',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3658,'br','pay_all_purchase_due_at_a_time','pagar todas as dívidas de compra de uma só vez',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3659,'br','Delete_Provider','Excluir provedor',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3660,'br','Edit_Provider','Editar provedor',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3661,'br','Provider_details','Detalhes do provedor',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3662,'br','Total_Purchase_Due','Dívida total de compra',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3663,'br','Provider_Credit_Note','Nota de crédito',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3664,'br','Customer_Credit_Note','Nota de crédito',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3665,'br','Sell_Return','Vender Devolução',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3666,'br','Purchase_Return','Devolução de compra',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3667,'br','Tax_Number','Número fiscal',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3668,'br','Please_add_return_quantity','Adicione a quantidade de devolução',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3669,'br','Return_exist_for_the_Transaction','O retorno existe para a transação',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3670,'br','qty_return_is_greater_than_Quantity_Remaining','Qtde retorno é maior que Quantidade Restante',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3671,'br','products_refunded_alert','Quaisquer produtos com uma quantidade definida como 0 não serão reembolsados',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3672,'br','pay_all_purchase_return_due_at_a_time','pagar todas as dívidas de devolução de compra de uma só vez',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3673,'br','Total_Purchase_Return_Due','Dívida total de devolução de compra',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3674,'br','Purchase_return_due','Dívida de devolução de compra',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3675,'br','Sell_return_due','dívida de retorno de venda',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3676,'br','product_report','Relatório do produto',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3677,'br','product_sales_report','relatório de vendas de produtos',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3678,'br','Product_purchases_report','Relatório de compras de produtos',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3679,'br','Qty_sold','quantidade vendida',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3680,'br','Filter_by_warehouse','Filtrar por armazém',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3681,'br','Enable_Print_Invoice','Imprimir fatura automaticamente',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3682,'br','Show_Warehouse','Mostrar armazém',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3683,'br','Saved_Credit_Card_Info','Informações do cartão de crédito salvas',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3684,'br','Credit_card_changed_successfully','Cartão de crédito alterado com sucesso',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3685,'br','notification_template','Modelo de notificação',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3686,'br','email_notification','Notificação por e-mail',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3687,'br','sms_notification','Notificação por SMS',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3688,'br','Change_product_details','Alterar detalhes do produto',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3689,'br','edit_tax_and_discount_and_shipping','Editar impostos, descontos e envio',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3690,'br','Create_Quotation_with_Stock','Criar cotação com estoque',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3691,'br','Variant_cost','Custo da variante',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3692,'br','Variant_price','Preço da variante',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3693,'br','Variant_code','Código da variante',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3694,'br','Please_wait_until_the_product_is_loaded','Por favor, aguarde até que o produto seja carregado',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3695,'br','Choose_SMS_Gateway','Escolha um gateway SMS',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3696,'br','Notification_Client','Notificação para o cliente',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3697,'br','Available_Tags','Tags disponíveis',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3698,'br','Email_Subject','Assunto do e-mail',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3699,'br','Email_body','Corpo do e-mail',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3700,'br','Notification_Supplier','Notificação para o fornecedor',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3701,'br','sms_body','Corpo do SMS',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3702,'br','sms_templates','Modelos de SMS',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3703,'br','email_templates','Modelos de e-mail',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3704,'br','Edit_Project','Editar Projeto',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3705,'br','Projects','Projetos',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3706,'br','Enter_Project_Title','Digite o Título do Projeto',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3707,'br','Assigned_Employees','Funcionários Designados',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3708,'br','Choose_Team','Escolher Equipe',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3709,'br','Create_Project','Criar Projeto',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3710,'br','Project_List','Lista de Projetos',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3711,'br','Not_Started','Não Iniciado',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3712,'br','In_Progress','Em Progresso',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3713,'br','On_Hold','Em Espera',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3714,'br','Edit_Task','Editar Tarefa',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3715,'br','Tasks','Tarefas',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3716,'br','Enter_Task_Title','Digite o Título da Tarefa',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3717,'br','Choose_Project','Escolher Projeto',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3718,'br','Project','Projeto',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3719,'br','Create_Task','Criar Tarefa',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3720,'br','Task_List','Lista de Tarefas',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3721,'br','Import_Purchases','Importar Compras',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3722,'br','Warranty_Period','Período de Garantia',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3723,'br','Months','Meses',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3724,'br','Years','Anos',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3725,'br','WarrantyTerms','Termos de Garantia',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3726,'br','HasGuarantee','Possui Garantia',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3727,'br','Guarantee_Period','Período de Garantia',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3728,'br','OpeningStock','Estoque Inicial',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3729,'br','Warranty_Guarantee_Tracking','Controle de Garantia',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3730,'br','PaymentOption','Opção de Pagamento',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3731,'br','AddAnotherPaymentOption','Adicionar Outra Opção de Pagamento',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3732,'br','PopularTendered','Valores Comuns',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3733,'br','clear','limpar',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3734,'br','Pay','Pagar',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3735,'br','Payment','Pagamento',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3736,'br','TotalPaidExceedsGrandTotalForMultiPayment','O valor total pago excede o valor total da compra',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3737,'br','TotalPaying','Total a Pagar',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3738,'br','ChangeReturn','Troco',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3739,'br','AmountPaying','Valor a Pagar',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3740,'br','Appearance_Settings','Configurações de Aparência',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3741,'br','app_name','Nome do Aplicativo',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3742,'br','page_title_suffix','Sufixo do título da página',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3743,'br','ChangeFavicon','Alterar Favicon',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3744,'br','Languages','Idiomas',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3745,'br','Translations','Traduções',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3746,'br','Translations for','Traduções para',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3747,'br','Back','Voltar',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3748,'br','Save All Changes','Salvar Todas as Alterações',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3749,'br','Add New','Adicionar Novo',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3750,'br','Add New Translation','Adicionar Nova Tradução',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3751,'br','Save','Salvar',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3752,'br','Delete','Excluir',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3753,'br','Showing','Exibindo',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3754,'br','Translation added','Tradução adicionada',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3755,'br','Failed to add translation','Falha ao adicionar tradução',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3756,'br','Translation updated','Tradução atualizada',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3757,'br','Failed to update','Falha ao atualizar',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3758,'br','No changes to save','Nenhuma alteração para salvar',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3759,'br','Notice','Aviso',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3760,'br','All changes saved successfully','Todas as alterações foram salvas com sucesso',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3761,'br','Bulk save failed','Falha ao salvar em massa',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3762,'br','Please reload the page after saving translations to apply the changes.','Por favor, recarregue a página após salvar as traduções para aplicar as alterações.',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3763,'br','Action_Blocked','Ação Bloqueada',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3764,'br','You_cannot_delete_the_default_language','Você não pode excluir o idioma padrão',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3765,'br','Flag','Bandeira',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3766,'br','Locale','Localidade',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3767,'br','Update Language','Atualizar Idioma',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3768,'br','Add Language','Adicionar Idioma',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3769,'br','Send_Email','Enviar Email',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3770,'br','Send_SMS','Enviar SMS',0,'2025-06-18 01:49:54.000000','2025-06-18 01:49:54.000000'),(3771,'br','total_sales','Vendas Totais',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3772,'br','Opening_Stock','Estoque Inicial',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3773,'br','Subscription_Product','Produto de Assinatura',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3774,'br','Subscriptions','Assinaturas',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3775,'br','Billing_Cycle','Ciclo de Cobrança',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3776,'br','total_cycles','Ciclos Totais',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3777,'br','remaining_cycles','Ciclos Restantes',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3778,'br','next_billing_date','Próxima Data de Cobrança',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3779,'br','Failed_to_update_subscription_status','Falha ao atualizar o status da assinatura',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3780,'br','Subscription_status_updated_successfully','Status da assinatura atualizado com sucesso',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3781,'br','Create_Susbscription','Criar Assinatura',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3782,'br','Price_Per_Cycle','Preço por Ciclo',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3783,'br','Price_Per_Unit','Preço por Unidade',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3784,'br','Active','Ativa',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3785,'br','Canceled','Cancelada',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3786,'br','Completed','Concluída',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3787,'br','Subscription_details','Detalhes da Assinatura',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3788,'br','Dynamic_Appearance','Aparência Dinâmica',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3789,'br','Payment_Methods','Métodos de Pagamento',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3790,'br','You_cant_edit_or_remove_default_payment_choices','Você não pode editar ou remover opções de pagamento padrão',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3791,'br','Enter_Payment_Method','Digite o Método de Pagamento',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3792,'br','Sales_by_Category','Vendas por Categoria',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3793,'br','Sales_by_Brand','Vendas por Marca',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3794,'br','Error_Logs','Registros de Erro',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3795,'br','Occurred_At','Ocorrido em',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3796,'br','Context','Contexto',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3797,'br','Report_Transactions','Relatório de Transações',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3798,'br','Payment_Method','Método de Pagamento',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3799,'br','Customer_Provider','Cliente/Fornecedor',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3800,'br','Sale_Purchase_Ref','Ref. de Venda/Compra',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3801,'da','Draft_Created_successfully','Udkast oprettet succesfuldt',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3802,'da','Draft_Sale_Deleted','Udkast salg slettet',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3803,'da','Inventory_Valuation_Based_on_Average_Cost','Lageropgørelse baseret på gennemsnitlig omkostning',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3804,'da','Payroll','Lønliste',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3805,'da','Transfers_Money','Overfører penge',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3806,'da','Inventory_Valuation','Lageropgørelse',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3807,'da','Deposits_Report','Indbetalingsrapport',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3808,'da','Expense_Report','Udgiftsrapport',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3809,'da','Deposit_Category','Indbetalingskategori',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3810,'da','Total_Deposits','Samlede indbetalinger',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3811,'da','Expense_Category','Udgiftkategori',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3812,'da','Total_Expenses','Samlede udgifter',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3813,'da','ASSET_VALUE','EJENDELSVÆRDI',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3814,'da','STOCK_ON_HAND','Lager på hånden',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3815,'da','Variant_NAME','Variantnavn',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(3816,'da','SKU','SKU',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3817,'da','ITEM_NAME','VARENAVN',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3818,'da','From_Account','Fra konto',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3819,'da','To_Account','Til konto',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3820,'da','Accounts_cannot_be_the_same','Konti kan ikke være ens',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3821,'da','CountStock','Tæl Lager',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3822,'da','Successfully_Generated_Count','Tælling Genereret Succesfuldt',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3823,'da','Count','Antal',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3824,'da','file','Fil',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3825,'da','Accounting','Bogføring',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3826,'da','deposit_delete','Slet Indbetaling',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3827,'da','deposit_edit','Rediger Indbetaling',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3828,'da','deposit_add','Tilføj Indbetaling',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3829,'da','deposit_view','Se Indbetaling',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3830,'da','expense_add','Tilføj Udgifter',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3831,'da','expense_edit','Rediger Udgifter',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3832,'da','expense_delete','Slet Udgifter',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3833,'da','List_Deposit','Liste Over Indbetalinger',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3834,'da','Create_deposit','Opret Indbetaling',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3835,'da','List_accounts','Liste Over Konti',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3836,'da','Account','Konto',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3837,'da','Choose_Account','Vælg Konto',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3838,'da','Deposits','Indbetalinger',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3839,'da','account_num','Kontonummer',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3840,'da','Enter_account_num','Indtast Kontonummer',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3841,'da','account_name','Kontonavn',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3842,'da','Enter_account_name','Indtast Kontonavn',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3843,'da','initial_balance','Indledende Saldo',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3844,'da','Enter_initial_balance','Indtast Indledende Saldo',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3845,'da','notes','Noter',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3846,'da','balance','Balance',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(3847,'da','Receipt','Kvittering',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3848,'da','Pos_Settings','POS-indstillinger',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(3849,'da','Note_to_customer','Bemærkning til kunden',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3850,'da','Show_Note_to_customer','Vis bemærkning til kunden',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3851,'da','Show_barcode','Vis stregkode',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3852,'da','Show_Tax_and_Discount','Vis moms & rabat & levering',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3853,'da','Show_Customer','Vis kunde',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3854,'da','Show_Email','Vis e-mail',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3855,'da','Show_Phone','Vis telefon',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3856,'da','Show_Address','Vis adresse',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3857,'da','DefaultLanguage','Standardsprog',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3858,'da','footer','footer',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3859,'da','Received_Amount','Modtaget beløb',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3860,'da','Paying_Amount','Betalingsbeløb',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3861,'da','Change','Retur',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3862,'da','Paying_amount_is_greater_than_Received_amount','Betalingsbeløb er større end modtaget beløb',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3863,'da','Paying_amount_is_greater_than_Grand_Total','Betalingsbeløb er større end det samlede beløb',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3864,'da','code_must_be_not_exist_already','koden skal ikke eksistere allerede',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3865,'da','You_will_find_your_backup_on','Du finder din sikkerhedskopi på',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3866,'da','and_save_it_to_your_pc','og gem det på din pc',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3867,'da','Scan_your_barcode_and_select_the_correct_symbology_below','Scan din stregkode og vælg den korrekte symbologi nedenfor',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3868,'da','Scan_Search_Product_by_Code_Name','Scan / Søg produkt ved kode eller navn',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3869,'da','Paper_size','Papirstørrelse',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3870,'da','Clear_Cache','Ryd cache',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3871,'da','Cache_cleared_successfully','Cache ryddet med succes',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3872,'da','Failed_to_clear_cache','Mislykkedes i at rydde cache',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3873,'da','Scan_Barcode','Stregkode-scanner',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3874,'da','Please_use_short_name_of_unit','Brug venligst en kort navneform for enheden',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3875,'da','DefaultCustomer','Standardkunde',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3876,'da','DefaultWarehouse','Standardlager',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3877,'da','Payment_Gateway','Betalingsgateway',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(3878,'da','SMS_Configuration','SMS-konfiguration',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3879,'da','Gateway','SMS-gateway',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3880,'da','Choose_Gateway','Vælg SMS-gateway',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3881,'da','sms_send_successfully','Besked sendt med succes',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3882,'da','sms_config_invalid','forkert sms-konfig invalid',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3883,'da','Remove_Stripe_Key_Secret','Slet Stripe API-nøgler',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3884,'da','credit_card_account_not_available','Kreditkortkonto ikke tilgængelig',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3885,'da','Credit_Card_Info','Kreditkortoplysninger',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(3886,'da','developed_by','Udviklet af',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3887,'da','Unit_already_linked_with_sub_unit','Unit already linked with sub unit',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3888,'da','Total_Items_Quantity','Antal varer og mængde',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3889,'da','Value_by_Cost_and_Price','Værdi efter omkostninger og pris',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3890,'da','Search_this_table','Søg i denne tabel',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3891,'da','import_products','Importere produkter',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3892,'da','Field_optional','Valgfri felt',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3893,'da','Download_exemple','Download eksempel',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3894,'da','field_must_be_in_csv_format','Feltet skal være i csv-format',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3895,'da','Successfully_Imported','Importeret med succes',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3896,'da','file_size_must_be_less_than_1_mega','Filstørrelsen skal være mindre end 1 mega',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3897,'da','Please_follow_the_import_instructions','Følg venligst importvejledningen',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3898,'da','must_be_exist','enheden skal allerede være oprettet',0,'2025-06-18 01:49:55.000000','2025-06-18 01:49:55.000000'),(3899,'da','Import_Customers','Importere kunder',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3900,'da','Import_Suppliers','Importere leverandører',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3901,'da','Recent_Sales','Seneste salg',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3902,'da','Create_Transfer','Opret overførsel',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3903,'da','order_products','Bestil varer',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3904,'da','Search_Product_by_Code_Name','Søg efter produkt ved kode eller navn',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3905,'da','Reports_payments_Purchase_Return','Rapporter købsreturbetalinger',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3906,'da','Reports_payments_Sale_Return','Rapporter salgsreturbetalinger',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3907,'da','payments_Sales_Return','Betalinger salgsreturnering',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3908,'da','payments_Purchases_Return','Betalinger købsreturnering',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3909,'da','CreateSaleReturn','Opret salgsreturnering',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3910,'da','EditSaleReturn','Rediger salgsreturnering',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3911,'da','SalesReturn','Salgsreturnering',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3912,'da','CreatePurchaseReturn','Opret købsreturnering',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3913,'da','EditPurchaseReturn','Rediger købsreturnering',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3914,'da','PurchasesReturn','Købsreturnering',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3915,'da','Due','Forfalden',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3916,'da','Profit','Profit',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3917,'da','Revenue','Indtægt',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3918,'da','Sales_today','Dagens salg',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3919,'da','People','Mennesker',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3920,'da','Successfully_Created','Oprettet med succes',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3921,'da','Successfully_Updated','Opdateret med succes',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3922,'da','Success','Succes',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3923,'da','Failed','Mislykkedes',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3924,'da','Warning','Advarsel',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3925,'da','Please_fill_the_form_correctly','Udfyld venligst formularen korrekt',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3926,'da','Field_is_required','Dette felt er påkrævet',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3927,'da','Error','Fejl!',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3928,'da','you_are_not_authorized','Beklager! Du har ikke adgang.',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3929,'da','Go_back_to_home','Gå tilbage til hjemmesiden',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3930,'da','page_not_exist','Beklager! Siden du ledte efter eksisterer ikke.',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3931,'da','Choose_Status','Vælg status',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(3932,'da','Choose_Method','Vælg metode',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3933,'da','Choose_Symbology','Vælg symbolik',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3934,'da','Choose_Category','Vælg kategori',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3935,'da','Choose_Customer','Vælg kunde',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3936,'da','Choose_Supplier','Vælg leverandør',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3937,'da','Choose_Unit_Purchase','Vælg købsenhed',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3938,'da','Choose_Sub_Category','Vælg underkategori',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3939,'da','Choose_Brand','Vælg mærke',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3940,'da','Choose_Warehouse','Vælg lager',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3941,'da','Choose_Unit_Sale','Vælg salgsenhed',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3942,'da','Enter_Product_Cost','Indtast produktomkostninger',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3943,'da','Enter_Stock_alert','Indtast lageradvarsler',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3944,'da','Choose_Unit_Product','Vælg produktenhed',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3945,'da','Enter_Product_Price','Indtast produktpris',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3946,'da','Enter_Name_Product','Indtast produktnavn',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3947,'da','Enter_Role_Name','Indtast rolle navn',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3948,'da','Enter_Role_Description','Indtast rolle beskrivelse',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3949,'da','Enter_name_category','Indtast kategorinavn',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3950,'da','Enter_Code_category','Indtast kategorikode',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3951,'da','Enter_Name_Brand','Indtast mærkenavn',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3952,'da','Enter_Description_Brand','Indtast mærkebeskrivelse',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3953,'da','Enter_Code_Currency','Indtast valutakode',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3954,'da','Enter_name_Currency','Indtast valutanavn',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3955,'da','Enter_Symbol_Currency','Indtast valutasymbol',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3956,'da','Enter_Name_Unit','Indtast enhedsnavn',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3957,'da','Enter_ShortName_Unit','Indtast kort navn for enhed',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3958,'da','Choose_Base_Unit','Vælg grundenhed',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3959,'da','Choose_Operator','Vælg operatør',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3960,'da','Enter_Operation_Value','Indtast operationens værdi',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3961,'da','Enter_Name_Warehouse','Indtast lager navn',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3962,'da','Enter_Phone_Warehouse','Indtast lager telefon',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3963,'da','Enter_Country_Warehouse','Indtast lager land',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3964,'da','Enter_City_Warehouse','Indtast lager by',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3965,'da','Enter_Email_Warehouse','Indtast lager email',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3966,'da','Enter_ZipCode_Warehouse','Indtast lager postnummer',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3967,'da','Choose_Currency','Vælg valuta',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3968,'da','Thank_you_for_your_business','Tak fordi du shoppede hos os. Kom igen',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3969,'da','Cancel','Annuller',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3970,'da','New_Customer','Ny kunde',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3971,'da','Incorrect_Login','Forkert login',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3972,'da','Successfully_Logged_In','Du er nu logget ind',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3973,'da','This_user_not_active','Denne bruger er ikke aktiv',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3974,'da','SignIn','Log ind',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3975,'da','Create_an_account','Opret en konto',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3976,'da','Forgot_Password','Glemt adgangskode?',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3977,'da','Email_Address','E-mailadresse',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3978,'da','SignUp','Tilmeld dig',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3979,'da','Already_have_an_account','Har du allerede en konto?',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3980,'da','Reset_Password','Nulstil adgangskode',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3981,'da','Failed_to_authenticate_on_SMTP_server','Det lykkedes ikke at godkende på SMTP-server',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3982,'da','We_cant_find_a_user_with_that_email_addres','Vi kan ikke finde en bruger med den e-mail-adresse',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3983,'da','We_have_emailed_your_password_reset_link','Vi har sendt en e-mail med din link til nulstilling af adgangskode',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3984,'da','Please_fill_the_Email_Adress','Udfyld venligst e-mail-adressen',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3985,'da','Confirm_password','Bekræft adgangskode',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3986,'da','Your_Password_has_been_changed','Din adgangskode er blevet ændret',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3987,'da','The_password_confirmation_does_not_match','Bekræftelse af adgangskode passer ikke',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3988,'da','This_password_reset_token_is_invalid','Token til nulstilling af adgangskode er ugyldig',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3989,'da','Warehouse_report','Lagerrapport',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3990,'da','All_Warehouses','Alle lagre',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3991,'da','Expense_List','Alle udgifter',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3992,'da','Expenses','Udgifter',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3993,'da','This_Week_Sales_Purchases','Denne uges salg & køb',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3994,'da','Top_Selling_Products','Top sælgende produkter',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3995,'da','View_all','Vis alle',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3996,'da','Payment_Sent_Received','Betaling sendt & modtaget',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3997,'da','Filter','Filter',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3998,'da','Invoice_POS','Faktura POS',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(3999,'da','Invoice','Faktura',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4000,'da','Customer_Info','Kundeinfo',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4001,'da','Company_Info','Firmainfo',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4002,'da','Invoice_Info','Fakturainfo',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4003,'da','Order_Summary','Ordreoversigt',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4004,'da','Quote_Info','Tilbudsinfo',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4005,'da','Del','Slet',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4006,'da','SuppliersPaiementsReport','Rapport over leverandørbetalinger',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4007,'da','Purchase_Info','Købsinfo',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4008,'da','Supplier_Info','Leverandørinfo',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4009,'da','Return_Info','Info om returnering',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4010,'da','Create_Expense','Opret udgift',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4011,'da','Details','Detaljer',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4012,'da','Discount_Method','Rabattype',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4013,'da','Net_Unit_Cost','Netto enhedskost',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4014,'da','Net_Unit_Price','Netto enhedspris',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4015,'da','Edit_Expense','Rediger udgift',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4016,'da','All_Brand','Alle mærker',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4017,'da','All_Category','Alle kategorier',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4018,'da','ListExpenses','Alle udgifter',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4019,'da','Create_Permission','Opret tilladelse',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4020,'da','Edit_Permission','Rediger tilladelse',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4021,'da','Reports_payments_Sales','Rapporter betalinger Salg',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4022,'da','Reports_payments_Purchases','Rapporter betalinger Køb',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4023,'da','Reports_payments_Return_Customers','Betalingsretur kunder',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4024,'da','Reports_payments_Return_Suppliers','Betalingsretur leverandører',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4025,'da','Expense_Deleted','Denne udgift er blevet slettet',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4026,'da','Expense_Updated','Denne udgift er blevet opdateret',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4027,'da','Expense_Created','Denne udgift er blevet oprettet',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4028,'da','DemoVersion','Du kan ikke gøre dette i demo-versionen',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4029,'da','OrderStatistics','Salgsstatistikker',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4030,'da','AlreadyAdd','Dette produkt er allerede tilføjet !!',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4031,'da','AddProductToList','Tilføj venligst produkt til liste !!',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4032,'da','AddQuantity','Tilføj venligst mængde af produkt !!',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4033,'da','InvalidData','Ugyldige data !!',0,'2025-06-18 01:49:56.000000','2025-06-18 01:49:56.000000'),(4034,'da','LowStock','Antallet overstiger antallet, der er tilgængeligt på lageret',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4035,'da','WarehouseIdentical','De to lagre kan ikke være identiske !!',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4036,'da','VariantDuplicate','Denne variant er en duplikat !!',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4037,'da','Filesize','Filstørrelse',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4038,'da','GenerateBackup','Generer sikkerhedskopi',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4039,'da','BackupDatabase','Sikkerhedskopier database',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4040,'da','Backup','Sikkerhedskopi',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4041,'da','Paid','Betalt',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4042,'da','Unpaid','Ubetalte',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4043,'da','Today','I dag',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4044,'da','Income','Indtægt',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4045,'da','Sale','Salg',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4046,'da','Actif','Aktiv',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4047,'da','Inactif','Inaktiv',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4048,'da','Customers','Kunder',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4049,'da','Phone','Telefon',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4050,'da','SearchByPhone','Søg efter telefonnummer',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4051,'da','Suppliers','Leverandører',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4052,'da','Quotations','Tilbud',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4053,'da','Sales','Salg',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4054,'da','Purchases','Køb',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4055,'da','Returns','Returnering',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4056,'da','Settings','Indstillinger',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4057,'da','SystemSettings','Systemindstillinger',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4058,'da','Users','Brugere',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4059,'da','GroupPermissions','Gruppe tilladelser',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4060,'da','Currencies','Valuta',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4061,'da','Warehouses','Lager',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4062,'da','Units','Enhed',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4063,'da','UnitsPrchases','Køb enheder',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4064,'da','UnitsSales','Salg enheder',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4065,'da','Reports','Rapporter',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4066,'da','PaymentsReport','Betalingsrapport',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4067,'da','PaymentsPurchases','Betalinger køb',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4068,'da','PaymentsSales','Betalinger salg',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4069,'da','ProfitandLoss','Fortjeneste og tab',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4070,'da','WarehouseStockChart','Lageroversigt for Lager',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4071,'da','SalesReport','Salgsrapport',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4072,'da','PurchasesReport','Købsrapport',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4073,'da','CustomersReport','Kunderapport',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4074,'da','SuppliersReport','Leverandørrapport',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4075,'da','SupplierReport','Leverandørrapport',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4076,'da','DailySalesData','Daglige salgsdata',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4077,'da','DailyPurchasesData','Daglige købsdata',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4078,'da','Dernièrescinqrecords','Sidste fem poster',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4079,'da','Filters','Filtre',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4080,'da','date','Dato',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4081,'da','Reference','Reference',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4082,'da','Supplier','Leverandør',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4083,'da','PaymentStatus','Betalingsstatus',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4084,'da','Customer','Kunde',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4085,'da','CustomerCode','Kundekode',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4086,'da','Status','Status',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4087,'da','SupplierCode','Leverandørkode',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4088,'da','Categorie','Kategori',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4089,'da','Categories','Kategorier',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4090,'da','StockTransfers','Overførsel',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4091,'da','StockManagement','Lagerstyring',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4092,'da','dashboard','Dashboard',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4093,'da','Products','Produkter',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4094,'da','productsList','Alle produkter',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4095,'da','ProductManagement','Produktstyring',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4096,'da','ProductQuantityAlerts','Advarsler om Produktmængde',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4097,'da','CodeProduct','Produktkode',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4098,'da','ProductTax','Produktmoms',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4099,'da','SubCategorie','Underkategori',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4100,'da','Name_product','Navn',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4101,'da','StockAlert','Lageralarm',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4102,'da','warehouse','Lager',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4103,'da','Tax','Moms',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4104,'da','BuyingPrice','Indkøbspris',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4105,'da','SellPrice','Salgspris',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4106,'da','Quantity','Mængde',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4107,'da','UnitSale','Salgsenhed',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4108,'da','UnitPurchase','Indkøbsenhed',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4109,'da','ManagementCurrencies','Valutastyring',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4110,'da','CurrencyCode','Valutakode',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4111,'da','CurrencyName','Valutanavn',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4112,'da','Symbol','Symbol',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4113,'da','All','Alle',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4114,'da','EditProduct','Rediger produkt',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4115,'da','SearchByCode','Søg efter kode',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4116,'da','SearchByName','Søg efter navn',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4117,'da','ProductDetails','Produktdetaljer',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4118,'da','CustomerName','Kundenavn',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4119,'da','CustomerManagement','Kundestyring',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4120,'da','Add','Opret',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4121,'da','Edit','Rediger',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4122,'da','Close','Luk',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4123,'da','PleaseSelect','Vælg venligst',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4124,'da','Action','Handling',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4125,'da','Email','E-mail',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4126,'da','EditCustomer','Rediger kunde',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4127,'da','AddCustomer','Opret kunde',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4128,'da','Country','Land',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4129,'da','City','By',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4130,'da','Adress','Adresse',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4131,'da','CustomerDetails','Kundedetaljer',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4132,'da','CustomersList','Kunder',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4133,'da','SupplierName','Leverandørnavn',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4134,'da','SuppliersManagement','Leverandørstyring',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4135,'da','SupplierDetails','Leverandørdetaljer',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4136,'da','QuotationsManagement','Tilbudsstyring',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4137,'da','SubTotal','Subtotal',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4138,'da','MontantReste','Beløb tilbage',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4139,'da','complete','Fuldført',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4140,'da','EnAttendant','Afventer',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4141,'da','Recu','Modtaget',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4142,'da','partial','Delvist',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4143,'da','Retournee','Returneret',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4144,'da','DetailQuote','Detaljeret tilbud',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4145,'da','EditQuote','Rediger tilbud',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4146,'da','CreateSale','Opret salg',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4147,'da','DownloadPdf','Download PDF',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4148,'da','QuoteEmail','Send tilbud på e-mail',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4149,'da','DeleteQuote','Slet tilbud',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4150,'da','AddQuote','Opret tilbud',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4151,'da','SelectProduct','Vælg produkt',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4152,'da','ProductCodeName','Produkt (Kode - Navn)',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4153,'da','Price','Pris',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4154,'da','CurrentStock','Lagerbeholdning',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4155,'da','Total','Total',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4156,'da','Num','Nr.',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4157,'da','Unitcost','Enhedsomkostninger',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4158,'da','to','Til',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4159,'da','Subject','Emne',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4160,'da','Message','Besked',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4161,'da','EmailCustomer','E-mail kunde',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4162,'da','Sent','Sendt',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4163,'da','Quote','Tilbud',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4164,'da','Hello','Hej',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4165,'da','AttachmentQuote','Vedhæftning af tilbud',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4166,'da','AddProducts','Tilføj produkter til ordreliste',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4167,'da','SelectWarehouse','Vælg venligst lager',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4168,'da','SelectCustomer','Vælg venligst kunde',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4169,'da','SalesManagement','Salgsstyring',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4170,'da','QtyBack','Antal tilbage',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4171,'da','TotalReturn','Total returnering',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4172,'da','Amount','Beløb',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4173,'da','SaleDetail','Salgsdetaljer',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4174,'da','EditSale','Rediger salg',0,'2025-06-18 01:49:57.000000','2025-06-18 01:49:57.000000'),(4175,'da','AddSale','Opret salg',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4176,'da','ShowPayment','Vis betalinger',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4177,'da','AddPayment','Opret betaling',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4178,'da','EditPayment','Rediger betaling',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4179,'da','EmailSale','Send salg pr. e-mail',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4180,'da','DeleteSale','Slet salg',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4181,'da','ModePaiement','Betalingsmåde',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4182,'da','Paymentchoice','Betalingstype',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4183,'da','Note','Bemærkning',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4184,'da','PaymentComplete','Betaling fuldført!',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4185,'da','PurchasesManagement','Indkøbsstyring',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4186,'da','Ordered','Bestilt',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4187,'da','DeletePurchase','Slet køb',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4188,'da','EmailPurchase','Send køb pr. e-mail',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4189,'da','EditPurchase','Rediger køb',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4190,'da','PurchaseDetail','Købsdetaljer',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4191,'da','AddPurchase','Opret køb',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4192,'da','EmailSupplier','Leverandør e-mail',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4193,'da','PurchaseInvoice','Indkøbsbetalinger',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4194,'da','PurchasesInvoicesData','Data om indkøbsbetalinger',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4195,'da','SalesInvoice','Salgsbetalinger',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4196,'da','SalesInvoicesData','Data om salgsbetalinger',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4197,'da','UserManagement','Brugerstyring',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4198,'da','Firstname','Fornavn',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4199,'da','lastname','Efternavn',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4200,'da','username','Brugernavn',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4201,'da','password','Adgangskode',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4202,'da','Newpassword','Ny adgangskode',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4203,'da','ChangeAvatar','Skift avatar',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4204,'da','LeaveBlank','Lad dette felt være blankt, hvis du ikke har ændret det',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4205,'da','type','Type',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4206,'da','UserPermissions','Brugerrettigheder',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4207,'da','RoleName','Rolle',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4208,'da','RoleDescription','Rollebeskrivelse',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4209,'da','AddPermissions','Opret rettigheder',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4210,'da','View','Vis',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4211,'da','NewAdjustement','Nye justeringer',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4212,'da','EditAdjustement','Rediger justeringer',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4213,'da','CannotSubstraction','Du kan ikke trække produkter fra med en lagerbeholdning på 0',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4214,'da','Addition','Tilføjelse',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4215,'da','Subtraction','Fratrækning',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4216,'da','profil','Profil',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4217,'da','logout','Log ud',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4218,'da','PurchaseAlreadyPaid','Du kan ikke ændre dette, da købet allerede er betalt',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4219,'da','SaleAlreadyPaid','Du kan ikke ændre dette, da salget allerede er betalt',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4220,'da','ReturnAlreadyPaid','Du kan ikke ændre dette, da returneringen allerede er betalt',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4221,'da','QuoteAlready','Dette tilbud har allerede genereret et salg',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4222,'da','AddProduct','Opret produkt',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4223,'da','QuotationComplete','Dette tilbud er færdigt',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4224,'da','SiteConfiguration','Webstedsopsætning',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4225,'da','Language','Sprog',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4226,'da','DefaultCurrency','Standardvaluta',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4227,'da','LoginCaptcha','Login Captcha',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4228,'da','DefaultEmail','Standard-email',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4229,'da','SiteName','Webstedsnavn',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4230,'da','ChangeLogo','Skift logo',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4231,'da','SMTPConfiguration','SMTP-opsætning',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4232,'da','HOST','MAIL_HOST',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4233,'da','PORT','MAIL_PORT',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4234,'da','encryption','MAIL_ENCRYPTION',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4235,'da','SMTPIncorrect','SMTP-opsætning er forkert',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4236,'da','PaymentsReturns','Betaling og returnering',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4237,'da','ReturnsInvoices','Returner fakturaer',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4238,'da','ReturnsInvoicesData','Data for returnerede fakturaer',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4239,'da','ShowAll','Vis alle poster for alle brugere',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4240,'da','Discount','Rabat',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4241,'da','OrderTax','Moms',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4242,'da','Shipping','Forsendelse',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4243,'da','CompanyName','Firmanavn',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4244,'da','CompanyPhone','Firmaets telefon',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4245,'da','CompanyAdress','Firmaadresse',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4246,'da','Code','Kode',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4247,'da','image','Billede',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4248,'da','Printbarcode','Udskriv etiketter',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4249,'da','ReturnsCustomers','Kundeafkast',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4250,'da','ReturnsSuppliers','Leverandørafkast',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4251,'da','FactureReturnCustomers','Faktura for kundeaftale',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4252,'da','FactureReturnSuppliers','Faktura for leverandøraftale',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4253,'da','NodataAvailable','Ingen data tilgængelige',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4254,'da','ProductImage','Produktbillede',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4255,'da','Barcode','Stregkode',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4256,'da','pointofsales','Salgssted',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4257,'da','CustomUpload','Brugerdefineret upload',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4258,'da','pointofsaleManagement','Salgsstedshåndtering',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4259,'da','Adjustment','Justering',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4260,'da','Updat','Opdater',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4261,'da','Reset','Nulstil',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4262,'da','print','Udskriv',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4263,'da','SearchByEmail','Søg efter e-mail',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4264,'da','ChooseProduct','Vælg produkt',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4265,'da','Qty','Antal',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4266,'da','Items','Varer',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4267,'da','AmountHT','Beløb ekskl. moms',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4268,'da','AmountTTC','Beløb inkl. moms',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4269,'da','PleaseSelectSupplier','Vælg venligst leverandør',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4270,'da','PleaseSelectStatut','Vælg venligst status',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4271,'da','PayeBy','Betalt af',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4272,'da','ChooseWarehouse','Vælg lager',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4273,'da','payNow','Betal nu',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4274,'da','ListofCategory','Liste over kategorier',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4275,'da','Description','Beskrivelse',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4276,'da','submit','Indsend',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4277,'da','ProblemCreatingThisInvoice','Der opstod et problem med at oprette denne faktura. Prøv igen',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4278,'da','ProblemPayment','Der opstod et problem med betalingen. Prøv igen.',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4279,'da','IncomeExpenses','Indtægter og Udgifter',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4280,'da','dailySalesPurchases','Daglige Salg og Køb',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4281,'da','ProductsExpired','Udløbne Produkter',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4282,'da','ListofBrand','Mærker',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4283,'da','CreateAdjustment','Opret Justering',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4284,'da','Afewwords','Et par ord ...',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4285,'da','UserImage','Bruger Billede',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4286,'da','UpdateProduct','Opdater Produkt',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4287,'da','Brand','Mærke',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4288,'da','BarcodeSymbology','Stregkodesymbolik',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4289,'da','ProductCost','Produktomkostninger',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4290,'da','ProductPrice','Produktpris',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4291,'da','UnitProduct','Produktenhed',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4292,'da','TaxMethod','Momstype',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4293,'da','MultipleImage','Flere Billeder',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4294,'da','ProductHasMultiVariants','Dette produkt har flere varianter',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4295,'da','ProductHasPromotion','Produktet har en kampagne',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4296,'da','PromotionStart','Kampagnen starter',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4297,'da','PromotionEnd','Kampagnen slutter',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4298,'da','PromotionPrice','Kampagnepris',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4299,'da','Cost','Omkostninger',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4300,'da','Unit','Enhed',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4301,'da','ProductVariant','Produktvariant',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4302,'da','Variant','Variant',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4303,'da','UnitPrice','Enhedspris',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4304,'da','CreateReturnCustomer','Opret Tilbagevendende Kunde',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4305,'da','EditReturnCustomer','Rediger Tilbagevendende Kunde',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4306,'da','CreateReturnSupplier','Opret Tilbagevendende Leverandør',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4307,'da','Documentation','Dokumentation',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4308,'da','EditReturnSupplier','Rediger Tilbagevendende Leverandør',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4309,'da','FromWarehouse','Fra Lager',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4310,'da','ToWarehouse','Til Lager',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4311,'da','EditTransfer','Rediger Overførsel',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4312,'da','TransferDetail','Overførselsdetaljer',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4313,'da','Pending','Afventer',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4314,'da','Received','Modtaget',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4315,'da','PermissionsManager','Rettigheder',0,'2025-06-18 01:49:58.000000','2025-06-18 01:49:58.000000'),(4316,'da','BrandManager','Mærke',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4317,'da','BrandImage','Mærke Billede',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4318,'da','BrandName','Mærke Navn',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4319,'da','BrandDescription','Mærke Beskrivelse',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4320,'da','BaseUnit','Basisenhed',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4321,'da','ManagerUnits','Enhedshåndtering',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4322,'da','OperationValue','Operation Værdi',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4323,'da','Operator','Operatør',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4324,'da','Top5Products','Top 5 Produkter',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4325,'da','Last5Sales','Sidste 5 Salg',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4326,'da','ListAdjustments','Alle Justeringer',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4327,'da','ListTransfers','Alle Overførsler',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4328,'da','CreateTransfer','Opret Overførsel',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4329,'da','OrdersManager','Ordre Håndtering',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4330,'da','ListQuotations','Alle Tilbud',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4331,'da','ListPurchases','Alle Køb',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4332,'da','ListSales','Alle Salg',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4333,'da','ListReturns','Alle Returneringer',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4334,'da','PeopleManager','Personhåndtering',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4335,'da','Delete_Title','Er du sikker?',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4336,'da','Delete_Text','Du kan ikke fortryde dette!',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4337,'da','Delete_confirmButtonText','Ja, slet det!',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4338,'da','Delete_cancelButtonText','Annuller',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4339,'da','Delete_Deleted','Slettet!',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4340,'da','Delete_Failed','Mislykkedes!',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4341,'da','Delete_Therewassomethingwronge','Der var noget galt',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4342,'da','SendEmail','E-mail Sendt',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4343,'da','erroSale','Dette salg er allerede forbundet med en retur!',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4344,'da','ReturnManagement','Returhåndtering',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4345,'da','ReturnDetail','Returdetaljer',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4346,'da','EditReturn','Rediger Retur',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4347,'da','AddReturn','Opret Retur',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4348,'da','EmailReturn','Send Retur på E-mail',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4349,'da','DeleteReturn','Slet Retur',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4350,'da','Retoursurcharge','Returgebyr',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4351,'da','Laivrison','Levering',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4352,'da','SelectSale','Vælg Salg',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4353,'da','ZeroPardefault','Du kan slette varen eller sætte antallet returneret til nul, hvis den ikke er returneret',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4354,'da','Return','Retur',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4355,'da','Purchase','Køb',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4356,'da','TotalSales','Total Salg',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4357,'da','TotalPurchases','Samlede indkøb',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4358,'da','TotalReturns','Total Retur',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4359,'da','PaiementsNet','Netto Betalinger',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4360,'da','PaiementsSent','Betalinger Sendt',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4361,'da','PaiementsReceived','Betalinger Modtaget',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4362,'da','Recieved','Modtaget',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4363,'da','ProductCode','Kode',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4364,'da','ProductName','Produkt',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4365,'da','AlertQuantity','Advarsel Mængde',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4366,'da','TotalProducts','Total Produkter',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4367,'da','TotalQuantity','Total Mængde',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4368,'da','TopCustomers','Top 5 Kunder',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4369,'da','TotalAmount','Total Beløb',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4370,'da','TotalPaid','Total Betalt',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4371,'da','CustomerSalesReport','Rapport for Kundefordring',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4372,'da','CustomerPaiementsReport','Rapport for Kundebetalinger',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4373,'da','CustomerQuotationsReport','Rapport for Kundetilbud',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4374,'da','Payments','Betalinger',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4375,'da','TopSuppliers','Top 5 Leverandører',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4376,'da','SupplierPurchasesReport','Rapport for Leverandørkøb',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4377,'da','SupplierPaiementsReport','Rapport for Leverandørbetalinger',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4378,'da','Name','Navn',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4379,'da','ManagementWarehouse','Lagerstyring',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4380,'da','ZipCode','Postnummer',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4381,'da','managementCategories','Kategori styring',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4382,'da','Codecategorie','Kategori Kode',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4383,'da','Namecategorie','Kategori Navn',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4384,'da','Parentcategorie','Overordnet Kategori',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4385,'da','managementTax','Skatte styring',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4386,'da','TaxName','Skatte Navn',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4387,'da','TaxRate','Skatte Sats',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4388,'da','managementUnitPurchases','Indkøbsenhed',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4389,'da','managementUnitSales','Salgsenhed',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4390,'da','ShortName','Kort Navn',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4391,'da','PleaseSelectThesebeforeaddinganyproduct','Vælg venligst disse før du tilføjer et produkt',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4392,'da','StockAdjustement','Lagerjustering',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4393,'da','PleaseSelectWarehouse','Vælg venligst lager før du vælger et produkt',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4394,'da','StockTransfer','Lageroverførsel',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4395,'da','SelectPeriod','Vælg Periode',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4396,'da','ThisYear','Dette År',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4397,'da','ThisToday','I Dag',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4398,'da','ThisMonth','Denne Måned',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4399,'da','ThisWeek','Denne Uge',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4400,'da','AdjustmentDetail','Justering Detaljer',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4401,'da','ActivateUser','Brugeren er blevet aktiveret',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4402,'da','DisActivateUser','Brugeren er blevet deaktiveret',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4403,'da','NotFound','Siden kunne ikke findes.',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4404,'da','oops','Ups! Siden blev ikke fundet.',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4405,'da','couldNotFind','Vi kunne ikke finde den side, du ledte efter. Imens kan du',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4406,'da','ReturnDashboard','vende tilbage til oversigten',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4407,'da','hrm','HRM',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4408,'da','Employees','Medarbejdere',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4409,'da','Attendance','Tilstedeværelse',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4410,'da','Leave_request','Anmodning om orlov',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4411,'da','Leave_type','Orlovstype',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4412,'da','Company','Virksomhed',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4413,'da','Departments','Afdelinger',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4414,'da','Designations','Designationer',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4415,'da','Office_Shift','Kontor skift',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4416,'da','Holidays','Ferie',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4417,'da','Enter_Company_Name','Indtast firmanavn',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4418,'da','Enter_email_address','Indtast e-mailadresse',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4419,'da','Enter_Company_Phone','Indtast virksomhedstelefon',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4420,'da','Enter_Company_Country','Indtast land for virksomheden',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4421,'da','Created_in_successfully','Oprettet med succes',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4422,'da','Updated_in_successfully','Opdateret med succes',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4423,'da','Deleted_in_successfully','Slettet med succes',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4424,'da','department','Afdeling',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4425,'da','Enter_Department_Name','Indtast afdelingsnavn',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4426,'da','Choose_Company','Vælg virksomhed',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4427,'da','Department_Head','Afdelingsleder',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4428,'da','Choose_Department_Head','Vælg afdelingsleder',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4429,'da','Enter_Shift_name','Indtast vagtnavn',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4430,'da','Monday_In','Mandag start',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4431,'da','Monday_Out','Mandag slut',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4432,'da','Tuesday_In','Tirsdag start',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4433,'da','tuesday_out','Tirsdag slut',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4434,'da','wednesday_in','Onsdag start',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4435,'da','wednesday_out','Onsdag slut',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4436,'da','thursday_in','Torsdag start',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4437,'da','thursday_out','Torsdag slut',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4438,'da','friday_in','Fredag start',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4439,'da','friday_out','Fredag slut',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4440,'da','saturday_in','Lørdag start',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4441,'da','saturday_out','Lørdag slut',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4442,'da','sunday_in','Søndag start',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4443,'da','sunday_out','Søndag slut',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4444,'da','Holiday','Ferie',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4445,'da','Enter_title','Indtast titel',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4446,'da','title','Titel',0,'2025-06-18 01:49:59.000000','2025-06-18 01:49:59.000000'),(4447,'da','start_date','Startdato',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4448,'da','Enter_Start_date','Indtast startdato',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4449,'da','Finish_Date','Slutdato',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4450,'da','Enter_Finish_date','Indtast slutdato',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4451,'da','Please_provide_any_details','Giv venligst nogle detaljer',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4452,'da','Attendances','Tilstedeværelser',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4453,'da','Enter_Attendance_date','Indtast tilstedeværelsesdato',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4454,'da','Time_In','Tid ind',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4455,'da','Time_Out','Tid ud',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4456,'da','Choose_Employee','Vælg medarbejder',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4457,'da','Employee','Medarbejder',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4458,'da','Work_Duration','Arbejdstid',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4459,'da','remaining_leaves_are_insufficient','Resterende orlov er utilstrækkeligt',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4460,'da','Days','Dage',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4461,'da','Choose_leave_type','Vælg fraværstype',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4462,'da','Leave_Reason','Fraværsårsag',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4463,'da','Enter_Reason_Leave','Indtast fraværsårsag',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4464,'da','Add_Employee','Tilføj medarbejder',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4465,'da','Enter_FirstName','Indtast fornavn',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4466,'da','Enter_LastName','Indtast efternavn',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4467,'da','Gender','Køn',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4468,'da','Choose_Gender','Vælg køn',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4469,'da','Enter_Birth_date','Indtast fødselsdato',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4470,'da','Birth_date','Fødselsdato',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4471,'da','Enter_Country','Indtast land',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4472,'da','Enter_Phone_Number','Indtast telefonnummer',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4473,'da','joining_date','Indtrædelsesdato',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4474,'da','Enter_joining_date','Indtast indtrædelsesdato',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4475,'da','Choose_Designation','Vælg stilling',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4476,'da','Designation','Stilling',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4477,'da','Choose_Office_Shift','Vælg kontor skift',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4478,'da','Enter_Leaving_Date','Indtast fratrædelsesdato',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4479,'da','Leaving_Date','Fratrædelsesdato',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4480,'da','Annual_Leave','Årligt fravær',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4481,'da','Enter_Annual_Leave','Indtast årligt fravær',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4482,'da','Remaining_leave','Resterende fravær',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4483,'da','Employee_Details','Medarbejderoplysninger',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4484,'da','Basic_Information','Grundlæggende oplysninger',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4485,'da','Family_status','Familie status',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4486,'da','Choose_Family_status','Vælg familie status',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4487,'da','Employment_type','Ansættelsestype',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4488,'da','Select_Employment_type','Vælg ansættelsestype',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4489,'da','Enter_City','Indtast by',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4490,'da','Province','Region',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4491,'da','Enter_Province','Indtast region',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4492,'da','Enter_Address','Indtast adresse',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4493,'da','Enter_Zip_code','Indtast postnummer',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4494,'da','Zip_code','Postnummer',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4495,'da','Hourly_rate','Timeløn',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4496,'da','Enter_Hourly_rate','Indtast timeløn',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4497,'da','Basic_salary','Grundløn',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4498,'da','Enter_Basic_salary','Indtast grundløn',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4499,'da','Social_Media','Sociale medier',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4500,'da','Skype','Skype',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4501,'da','Enter_Skype','Indtast Skype',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4502,'da','Facebook','Facebook',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4503,'da','Enter_Facebook','Indtast Facebook',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4504,'da','WhatsApp','WhatsApp',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4505,'da','Enter_WhatsApp','Indtast WhatsApp',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4506,'da','LinkedIn','LinkedIn',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4507,'da','Enter_LinkedIn','Indtast LinkedIn',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4508,'da','Twitter','Twitter',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4509,'da','Enter_Twitter','Indtast Twitter',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4510,'da','Experiences','Erfaringer',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4511,'da','bank_account','Bankkonto',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4512,'da','Company_Name','Firmanavn',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4513,'da','Location','Placering',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4514,'da','Enter_location','Indtast placering',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4515,'da','Enter_Description','Indtast beskrivelse',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4516,'da','Bank_Name','Banknavn',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4517,'da','Enter_Bank_Name','Indtast banknavn',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4518,'da','Bank_Branch','Bankfilial',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4519,'da','Enter_Bank_Branch','Indtast bankfilial',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4520,'da','Bank_Number','Banknummer',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4521,'da','Enter_Bank_Number','Indtast banknummer',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4522,'da','Assigned_warehouses','Adgang til lagre',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4523,'da','Top_customers','Bedste kunder',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4524,'da','Attachment','Vedhæftning',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4525,'da','view_employee','Se medarbejder',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4526,'da','edit_employee','Rediger medarbejder',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4527,'da','delete_employee','Slet medarbejder',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4528,'da','Created_by','Tilføjet af',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4529,'da','Add_product_IMEI_Serial_number','Tilføj produkt IMEI/serienummer',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4530,'da','Product_Has_Imei_Serial_number','Produkt har IMEI/serienummer',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4531,'da','IMEI_SN','IMEI/SN',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4532,'da','Shipments','Forsendelser',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4533,'da','delivered_to','Leveret til',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4534,'da','shipment_ref','Forsendelsesreferance',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4535,'da','sale_ref','Salgsreference',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4536,'da','Edit_Shipping','Rediger forsendelse',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4537,'da','Packed','Pakket',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4538,'da','Shipped','Afsendt',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4539,'da','Delivered','Leveret',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4540,'da','Cancelled','Annulleret',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4541,'da','Shipping_status','Forsendelsesstatus',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4542,'da','Users_Report','Bruger rapport',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4543,'da','stock_report','Lager rapport',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4544,'da','Total_quotations','Samlede tilbud',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4545,'da','Total_return_sales','Samlet tilbagesalg',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4546,'da','Total_return_purchases','Samlet tilbagekøb',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4547,'da','Total_transfers','Samlede overførsler',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4548,'da','Total_adjustments','Samlede justeringer',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4549,'da','User_report','Brugerrapport',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4550,'da','Current_stock','Nuværende lagerbeholdning',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4551,'da','product_name','Produktnavn',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4552,'da','Total_Customers_Due','Total gæld (kunder)',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4553,'da','Total_Suppliers_Due','Total gæld (leverandører)',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4554,'da','Some_warehouses','Nogle lagre',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4555,'da','Product_Cost','Produktomkostninger',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4556,'da','sms_settings','SMS-indstillinger',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4557,'da','mail_settings','Mail-indstillinger',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4558,'da','Nexmo_SMS','Nexmo SMS',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4559,'da','TWILIO_SMS','TWILIO SMS',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4560,'da','Default_SMS_Gateway','Standard-SMS-gateway',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4561,'da','module_settings','Modulindstillinger',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4562,'da','Module_enabled_success','Modul aktiveret med succes',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4563,'da','Module_Disabled_success','Modul deaktiveret med succes',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4564,'da','update_settings','Opdatering',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4565,'da','Please_Upload_the_Correct_Module','Upload venligst det korrekte modul',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4566,'da','Uploaded_Success','Uploadet med succes',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4567,'da','Customer_details','Kundedetaljer',0,'2025-06-18 01:50:00.000000','2025-06-18 01:50:00.000000'),(4568,'da','Edit_Customer','Rediger kunde',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4569,'da','Delete_Customer','Slet kunde',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4570,'da','Pay_Due','Betal skyld',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4571,'da','Paying_amount_is_greater_than_Total_Due','Betalt beløb er større end samlet skyld',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4572,'da','Customer_Invoice','Kundefaktura',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4573,'da','This_Product_Not_For_Selling','Dette produkt er ikke til salg',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4574,'da','Welcome_to_your_Dashboard','Velkommen til dit kontrolpanel',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4575,'da','Total_Payable','Total betalbart',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4576,'da','Choose_Sale_Ref','Vælg salgsreference',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4577,'da','Please_Select_Sale','Vælg venligst salg',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4578,'da','list_product_returns','Liste over produktreturneringer',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4579,'da','Qty_return','Antal returner',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4580,'da','Choose_Purchase_Ref','Vælg købsreference',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4581,'da','Purchase_Ref','Købsreference',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4582,'da','please_select_purchase','Vælg venligst køb',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4583,'da','qty_return_is_greater_than_qty_purchased','Antal returneringer er større end antal købt',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4584,'da','qty_return_is_greater_than_qty_sold','Antal returneringer er større end antal solgt',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4585,'da','Quantity_sold','Antal solgt',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4586,'da','qty_purchased','Antal købt',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4587,'da','Sender_Name','Afsenderens navn',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4588,'da','The_module_must_be_uploaded_as_zip_file','Modulet skal uploades som en zip-fil',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4589,'da','Upload_Module','Upload modul',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4590,'da','All_Modules_Installed','Alle moduler installeret',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4591,'da','Current_Version','Nuværende version',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4592,'da','You_already_have_the_latest_version','Du har allerede den nyeste version',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4593,'da','Update_Available','Opdatering tilgængelig',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4594,'da','Update_Log','Opdateringslog',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4595,'da','Update_Now','Opdater nu',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4596,'da','View_Change_Log','Se ændringslog',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4597,'da','Please_Wait_for_the_update','Vent venligst, indtil opdateringen er fuldstændig færdig. Det anbefales ikke at lukke browseren eller stoppe en opgraderingsproces',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4598,'da','Note_update','Sørg for at tage en sikkerhedskopi af din nuværende version og database, inden du kører opgraderingen, så du kan gendanne det, hvis der opstår en fejl',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4599,'da','invoice_footer','Faktura fodnote',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4600,'da','Time_Zone','Tidszone',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4601,'da','Payment_note','Betalingsnoter',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4602,'da','sale_note','Salgsnoter',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4603,'da','Total_Sale_Due','Totalt salg skyldigt',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4604,'da','Total_Sell_Return_Due','Totalt salgsretur skyldigt',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4605,'da','pay_all_sell_due_at_a_time','Betal alle salg skyldige på én gang',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4606,'da','pay_all_sell_return_due_at_a_time','Betal alle salgsretur skyldige på én gang',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4607,'da','Gross_Profit','Bruttogevinst',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4608,'da','pay_all_purchase_due_at_a_time','Betal alle købs skyldige på én gang',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4609,'da','Delete_Provider','Slet leverandør',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4610,'da','Edit_Provider','Rediger leverandør',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4611,'da','Provider_details','Leverandørdetaljer',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4612,'da','Total_Purchase_Due','Totalt køb skyldigt',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4613,'da','Provider_Credit_Note','Leverandør kreditnota',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4614,'da','Customer_Credit_Note','Kunde kreditnota',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4615,'da','Sell_Return','Salgsretur',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4616,'da','Purchase_Return','Købsretur',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4617,'da','Tax_Number','CVR-nummer',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4618,'da','Please_add_return_quantity','Tilføj venligst antal returneringer',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4619,'da','Return_exist_for_the_Transaction','Der findes en returnering for transaktionen',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4620,'da','qty_return_is_greater_than_Quantity_Remaining','Antal returneringer er større end resterende antal',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4621,'da','products_refunded_alert','Eventuelle produkter med en mængde på 0 vil ikke blive refunderet',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4622,'da','pay_all_purchase_return_due_at_a_time','Betal alle købsretur skyldige på én gang',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4623,'da','Total_Purchase_Return_Due','Totalt købsretur skyldigt',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4624,'da','Purchase_return_due','Købsretur skyldigt',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4625,'da','Sell_return_due','Salgsreturnering skyldig',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4626,'da','product_report','Produktrapport',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4627,'da','product_sales_report','Produktsalgsrapport',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4628,'da','Product_purchases_report','Produktkøbsrapport',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4629,'da','Qty_sold','Antal solgt',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4630,'da','Filter_by_warehouse','Filtrer efter lager',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4631,'da','Enable_Print_Invoice','Udskriv faktura automatisk',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4632,'da','Saved_Credit_Card_Info','Gemte kreditkortoplysninger',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4633,'da','Credit_card_changed_successfully','Kreditkort ændret med succes',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4634,'da','notification_template','Notifikationsskabelon',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4635,'da','email_notification','E-mail notifikation',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4636,'da','sms_notification','SMS notifikation',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4637,'da','Change_product_details','Ændre produkt detaljer',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4638,'da','edit_tax_and_discount_and_shipping','Rediger skat, rabat og forsendelse',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4639,'da','Create_Quotation_with_Stock','Opret tilbud med lagerbeholdning',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4640,'da','Variant_cost','Variantomkostninger',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4641,'da','Variant_price','Variantpris',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4642,'da','Variant_code','Variantkode',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4643,'da','Please_wait_until_the_product_is_loaded','Vent venligst indtil produktet er indlæst',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4644,'da','Choose_SMS_Gateway','Vælg SMS-gateway',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4645,'da','Notification_Client','Notifikation til kunden',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4646,'da','Available_Tags','Tilgængelige tags',0,'2025-06-18 01:50:01.000000','2025-06-18 01:50:01.000000'),(4647,'da','Email_Subject','Emne i e-mail',0,'2025-06-18 01:50:02.000000','2025-06-18 01:50:02.000000'),(4648,'da','Email_body','E-mail indhold',0,'2025-06-18 01:50:02.000000','2025-06-18 01:50:02.000000'),(4649,'da','Notification_Supplier','Notifikation til leverandøren',0,'2025-06-18 01:50:02.000000','2025-06-18 01:50:02.000000'),(4650,'da','sms_body','SMS indhold',0,'2025-06-18 01:50:02.000000','2025-06-18 01:50:02.000000'),(4651,'da','sms_templates','SMS skabeloner',0,'2025-06-18 01:50:02.000000','2025-06-18 01:50:02.000000'),(4652,'da','email_templates','Email skabeloner',0,'2025-06-18 01:50:02.000000','2025-06-18 01:50:02.000000'),(4653,'da','Edit_Project','Rediger Projekt',0,'2025-06-18 01:50:02.000000','2025-06-18 01:50:02.000000'),(4654,'da','Projects','Projekter',0,'2025-06-18 01:50:02.000000','2025-06-18 01:50:02.000000'),(4655,'da','Enter_Project_Title','Indtast Projekttitel',0,'2025-06-18 01:50:02.000000','2025-06-18 01:50:02.000000'),(4656,'da','Assigned_Employees','Tildelte Medarbejdere',0,'2025-06-18 01:50:02.000000','2025-06-18 01:50:02.000000'),(4657,'da','Choose_Team','Vælg Team',0,'2025-06-18 01:50:02.000000','2025-06-18 01:50:02.000000'),(4658,'da','Create_Project','Opret Projekt',0,'2025-06-18 01:50:02.000000','2025-06-18 01:50:02.000000'),(4659,'da','Project_List','Projektliste',0,'2025-06-18 01:50:02.000000','2025-06-18 01:50:02.000000'),(4660,'da','Not_Started','Ikke Startet',0,'2025-06-18 01:50:02.000000','2025-06-18 01:50:02.000000'),(4661,'da','In_Progress','I Gang',0,'2025-06-18 01:50:02.000000','2025-06-18 01:50:02.000000'),(4662,'da','On_Hold','På Hold',0,'2025-06-18 01:50:02.000000','2025-06-18 01:50:02.000000'),(4663,'da','Edit_Task','Rediger Opgave',0,'2025-06-18 01:50:02.000000','2025-06-18 01:50:02.000000'),(4664,'da','Tasks','Opgaver',0,'2025-06-18 01:50:02.000000','2025-06-18 01:50:02.000000'),(4665,'da','Enter_Task_Title','Indtast Opgavetitel',0,'2025-06-18 01:50:02.000000','2025-06-18 01:50:02.000000'),(4666,'da','Choose_Project','Vælg Projekt',0,'2025-06-18 01:50:02.000000','2025-06-18 01:50:02.000000'),(4667,'da','Project','Projekt',0,'2025-06-18 01:50:02.000000','2025-06-18 01:50:02.000000'),(4668,'da','Create_Task','Opret Opgave',0,'2025-06-18 01:50:02.000000','2025-06-18 01:50:02.000000'),(4669,'da','Task_List','Opgaveliste',0,'2025-06-18 01:50:02.000000','2025-06-18 01:50:02.000000'),(4670,'da','Import_Purchases','Importér Køb',0,'2025-06-18 01:50:02.000000','2025-06-18 01:50:02.000000'),(4671,'da','Warranty_Period','Garantiperiode',0,'2025-06-18 01:50:02.000000','2025-06-18 01:50:02.000000'),(4672,'da','Months','Måneder',0,'2025-06-18 01:50:02.000000','2025-06-18 01:50:02.000000'),(4673,'da','Years','År',0,'2025-06-18 01:50:02.000000','2025-06-18 01:50:02.000000'),(4674,'da','WarrantyTerms','Garantibetingelser',0,'2025-06-18 01:50:02.000000','2025-06-18 01:50:02.000000'),(4675,'da','HasGuarantee','Har garanti',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4676,'da','Guarantee_Period','Garantiens varighed',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4677,'da','OpeningStock','Åbningslager',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4678,'da','Warranty_Guarantee_Tracking','Garanti- og garantisporing',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4679,'da','PaymentOption','Betalingsmetode',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4680,'da','AddAnotherPaymentOption','Tilføj en anden betalingsmetode',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4681,'da','PopularTendered','Populære beløb',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4682,'da','clear','ryd',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4683,'da','Pay','Betal',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4684,'da','Payment','Betaling',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4685,'da','TotalPaidExceedsGrandTotalForMultiPayment','Det samlede betalte beløb overstiger den samlede pris',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4686,'da','TotalPaying','Samlet betaling',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4687,'da','ChangeReturn','Tilbagebetaling',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4688,'da','AmountPaying','Beløb der betales',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4689,'da','Appearance_Settings','Udseendeindstillinger',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4690,'da','app_name','Appnavn',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4691,'da','page_title_suffix','Sidetitelsuffiks',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4692,'da','ChangeFavicon','Skift Favicon',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4693,'da','Languages','Sprog',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4694,'da','Translations','Oversættelser',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4695,'da','Translations for','Oversættelser for',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4696,'da','Back','Tilbage',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4697,'da','Save All Changes','Gem alle ændringer',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4698,'da','Add New','Tilføj ny',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4699,'da','Add New Translation','Tilføj ny oversættelse',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4700,'da','Save','Gem',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4701,'da','Delete','Slet',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4702,'da','Showing','Viser',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4703,'da','Translation added','Oversættelse tilføjet',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4704,'da','Failed to add translation','Kunne ikke tilføje oversættelse',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4705,'da','Translation updated','Oversættelse opdateret',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4706,'da','Failed to update','Kunne ikke opdatere',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4707,'da','No changes to save','Ingen ændringer at gemme',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4708,'da','Notice','Besked',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4709,'da','All changes saved successfully','Alle ændringer blev gemt',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4710,'da','Bulk save failed','Massegemning mislykkedes',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4711,'da','Please reload the page after saving translations to apply the changes.','Genindlæs siden efter at have gemt oversættelser for at anvende ændringerne.',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4712,'da','Action_Blocked','Handling blokeret',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4713,'da','You_cannot_delete_the_default_language','Du kan ikke slette standardsproget',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4714,'da','Flag','Flag',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4715,'da','Locale','Lokalitet',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4716,'da','Update Language','Opdater sprog',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4717,'da','Add Language','Tilføj sprog',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4718,'da','Send_Email','Send Email',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4719,'da','Send_SMS','Send SMS',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4720,'da','total_sales','Samlede salg',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4721,'da','Opening_Stock','Åbningslager',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4722,'da','Subscription_Product','Abonnementsprodukt',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4723,'da','Subscriptions','Abonnementer',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4724,'da','Billing_Cycle','Faktureringscyklus',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4725,'da','total_cycles','Samlede cyklusser',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4726,'da','remaining_cycles','Resterende cyklusser',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4727,'da','next_billing_date','Næste faktureringsdato',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4728,'da','Failed_to_update_subscription_status','Kunne ikke opdatere abonnementsstatus',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4729,'da','Subscription_status_updated_successfully','Abonnementsstatus opdateret med succes',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4730,'da','Create_Susbscription','Opret abonnement',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4731,'da','Price_Per_Cycle','Pris pr. cyklus',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4732,'da','Price_Per_Unit','Pris pr. enhed',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4733,'da','Active','Aktiv',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4734,'da','Canceled','Annulleret',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4735,'da','Completed','Afsluttet',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4736,'da','Subscription_details','Abonnementsdetaljer',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4737,'da','Dynamic_Appearance','Dynamisk udseende',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4738,'da','Payment_Methods','Betalingsmetoder',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4739,'da','You_cant_edit_or_remove_default_payment_choices','Du kan ikke redigere eller fjerne standardbetalingsvalg',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4740,'da','Enter_Payment_Method','Indtast betalingsmetode',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4741,'da','Sales_by_Category','Salg efter kategori',0,'2025-06-18 01:50:03.000000','2025-06-18 01:50:03.000000'),(4742,'da','Sales_by_Brand','Salg efter mærke',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4743,'da','Error_Logs','Fejllogs',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4744,'da','Occurred_At','Forekom på',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4745,'da','Context','Kontekst',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4746,'da','Report_Transactions','Rapportér transaktioner',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4747,'da','Payment_Method','Betalingsmetode',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4748,'da','Customer_Provider','Kunde/Leverandør',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4749,'da','Sale_Purchase_Ref','Salg/Køb Ref.',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4750,'de','Draft_Created_successfully','Entwurf erfolgreich erstellt',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4751,'de','Draft_Sale_Deleted','Entwurf Verkauf gelöscht',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4752,'de','Inventory_Valuation_Based_on_Average_Cost','Inventarbewertung basierend auf durchschnittlichen Kosten',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4753,'de','Payroll','Lohnabrechnung',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4754,'de','Transfers_Money','Geldüberweisungen',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4755,'de','Inventory_Valuation','Inventarbewertung',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4756,'de','Deposits_Report','Einzahlungsbericht',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4757,'de','Expense_Report','Ausgabenbericht',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4758,'de','Deposit_Category','Einzahlungskategorie',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4759,'de','Total_Deposits','Gesamte Einzahlungen',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4760,'de','Expense_Category','Ausgabenkategorie',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4761,'de','Total_Expenses','Gesamtausgaben',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4762,'de','ASSET_VALUE','WERT DES VERMÖGENSWERTS',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4763,'de','STOCK_ON_HAND','Lagerbestand',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4764,'de','Variant_NAME','Variantenname',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(4765,'de','SKU','SKU',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4766,'de','ITEM_NAME','ARTIKELNAME',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4767,'de','From_Account','Von Konto',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4768,'de','To_Account','Zu Konto',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4769,'de','Accounts_cannot_be_the_same','Konten können nicht gleich sein',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4770,'de','CountStock','Bestand zählen',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4771,'de','Successfully_Generated_Count','Zählung erfolgreich generiert',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4772,'de','Count','Anzahl',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4773,'de','file','Datei',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4774,'de','Accounting','Buchhaltung',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4775,'de','deposit_delete','Einzahlung löschen',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4776,'de','deposit_edit','Einzahlung bearbeiten',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4777,'de','deposit_add','Einzahlung hinzufügen',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4778,'de','deposit_view','Einzahlung anzeigen',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4779,'de','expense_add','Ausgabe hinzufügen',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4780,'de','expense_edit','Ausgabe bearbeiten',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4781,'de','expense_delete','Ausgabe löschen',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4782,'de','List_Deposit','Liste der Einzahlungen',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4783,'de','Create_deposit','Einzahlung erstellen',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4784,'de','List_accounts','Kontenliste',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4785,'de','Account','Konto',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4786,'de','Choose_Account','Konto wählen',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4787,'de','Deposits','Einzahlungen',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4788,'de','account_num','Kontonummer',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4789,'de','Enter_account_num','Kontonummer eingeben',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4790,'de','account_name','Kontoname',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4791,'de','Enter_account_name','Kontoname eingeben',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4792,'de','initial_balance','Anfangssaldo',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4793,'de','Enter_initial_balance','Anfangssaldo eingeben',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4794,'de','notes','Notizen',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4795,'de','balance','Balance',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(4796,'de','Receipt','Erhalt',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4797,'de','Pos_Settings','POS-Einstellungen',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(4798,'de','Note_to_customer','Hinweis an den Kunden',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4799,'de','Show_Note_to_customer','Hinweis für Kunden anzeigen',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4800,'de','Show_barcode','Strichcode vorzeigen',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4801,'de','Show_Tax_and_Discount','Steuern & Rabatt & Versand anzeigen',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4802,'de','Show_Customer','Kunden anzeigen',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4803,'de','Show_Email','E-Mail anzeigen',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4804,'de','Show_Phone','Telefon anzeigen',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4805,'de','Show_Address','Adresse anzeigen',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4806,'de','DefaultLanguage','Standardsprache',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4807,'de','footer','Fusszeile',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4808,'de','Received_Amount','Erhaltener Betrag',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4809,'de','Paying_Amount','Zahlungsbetrag',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4810,'de','Change','Veränderung',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4811,'de','Paying_amount_is_greater_than_Received_amount','Der Zahlungsbetrag ist höher als der erhaltene Betrag',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4812,'de','Paying_amount_is_greater_than_Grand_Total','Der Zahlungsbetrag ist höher als die Gesamtsumme',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4813,'de','code_must_be_not_exist_already','Code darf noch nicht vorhanden sein',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4814,'de','You_will_find_your_backup_on','Sie finden Ihr Backup auf',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4815,'de','and_save_it_to_your_pc','und speichere es auf deinem PC',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4816,'de','Scan_your_barcode_and_select_the_correct_symbology_below','Scannen Sie Ihren Barcode und wählen Sie unten die richtige Symbologie aus',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4817,'de','Scan_Search_Product_by_Code_Name','Produkt nach Codename scannen/durchsuchen',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4818,'de','Paper_size','Papier größe',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4819,'de','Clear_Cache','Cache leeren',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4820,'de','Cache_cleared_successfully','Cache erfolgreich geleert',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4821,'de','Failed_to_clear_cache','Cache konnte nicht gelöscht werden',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4822,'de','Scan_Barcode','Barcodelesegerät',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4823,'de','Please_use_short_name_of_unit','Bitte verwenden Sie die Kurzbezeichnung der Einheit',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4824,'de','DefaultCustomer','Standardkunde',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4825,'de','DefaultWarehouse','Standardlager',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4826,'de','Payment_Gateway','Zahlungs-Gateways',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(4827,'de','SMS_Configuration','SMS-Konfiguration',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4828,'de','Gateway','Zahlungs-Gateways',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4829,'de','Choose_Gateway','Wählen Sie Zahlungs-Gateways',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4830,'de','sms_send_successfully','Nachricht erfolgreich gesendet',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4831,'de','sms_config_invalid','falsche SMS-Konfiguration ungültig',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4832,'de','Remove_Stripe_Key_Secret','Löschen Sie die Stripe-API-Schlüssel',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4833,'de','credit_card_account_not_available','Kreditkartenkonto nicht verfügbar',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4834,'de','Credit_Card_Info','Kreditkarteninformationen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(4835,'de','developed_by','Entwickelt von',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4836,'de','Unit_already_linked_with_sub_unit','Einheit bereits mit Untereinheit verbunden',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4837,'de','Total_Items_Quantity','Gesamtartikel und Menge',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4838,'de','Value_by_Cost_and_Price','Wert nach Kosten und Preis',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4839,'de','Search_this_table','Durchsuchen Sie diese Tabelle',0,'2025-06-18 01:50:04.000000','2025-06-18 01:50:04.000000'),(4840,'de','import_products','Produkte importieren',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4841,'de','Field_optional','Feld optional',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4842,'de','Download_exemple','Beispiel herunterladen',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4843,'de','field_must_be_in_csv_format','Das Feld muss im CSV-Format vorliegen',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4844,'de','Successfully_Imported','Erfolgreich importiert',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4845,'de','file_size_must_be_less_than_1_mega','Die Dateigröße muss weniger als 1 Mega betragen',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4846,'de','Please_follow_the_import_instructions','Bitte folgen Sie den Importanweisungen',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4847,'de','must_be_exist','Einheit muss bereits angelegt sein',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4848,'de','Import_Customers','Kunden importieren',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4849,'de','Import_Suppliers','Lieferanten importieren',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4850,'de','Recent_Sales','Letzte Verkäufe',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4851,'de','Create_Transfer','Übertragung erstellen',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4852,'de','order_products','Auftragspositionen',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4853,'de','Search_Product_by_Code_Name','Suchen Sie das Produkt nach Code oder Name',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4854,'de','Reports_payments_Purchase_Return','Meldet Kaufrückzahlungen',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4855,'de','Reports_payments_Sale_Return','Berichte Verkauf Rückzahlungen',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4856,'de','payments_Sales_Return','Zahlungen Verkäufe Rückgabe',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4857,'de','payments_Purchases_Return','Zahlungen Einkäufe Rückgabe',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4858,'de','CreateSaleReturn','Verkaufsrendite erstellen',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4859,'de','EditSaleReturn','Verkaufsrückgabe bearbeiten',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4860,'de','SalesReturn','Umsatzrendite',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4861,'de','CreatePurchaseReturn','Kaufretoure erstellen',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4862,'de','EditPurchaseReturn','Kaufretoure bearbeiten',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4863,'de','PurchasesReturn','Käufe zurück',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4864,'de','Due','fällig',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4865,'de','Profit','Profitieren',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4866,'de','Revenue','Einnahmen',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4867,'de','Sales_today','Verkauf heute',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4868,'de','People','Menschen',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4869,'de','Successfully_Created','Erfolgreich erstellt',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4870,'de','Successfully_Updated','Erfolgreich aktualisiert',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4871,'de','Success','Erfolg',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4872,'de','Failed','Gescheitert',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4873,'de','Warning','Warnung',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4874,'de','Please_fill_the_form_correctly','Bitte füllen Sie das Formular korrekt aus',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4875,'de','Field_is_required','Feld ist erforderlich',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4876,'de','Error','Error!',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4877,'de','you_are_not_authorized','Es tut uns leid! Sie sind nicht berechtigt.',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4878,'de','Go_back_to_home','Gehen Sie zurück zur Homepage',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4879,'de','page_not_exist','Es tut uns leid! Die gesuchte Seite existiert nicht.',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4880,'de','Choose_Status','Wählen Sie den Status',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(4881,'de','Choose_Method','Wählen Sie Methode',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4882,'de','Choose_Symbology','Wählen Sie Symbologie',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4883,'de','Choose_Category','Kategorie auswählen',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4884,'de','Choose_Customer','Wählen Sie Kunde',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4885,'de','Choose_Supplier','Wählen Sie Lieferant',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4886,'de','Choose_Unit_Purchase','Wählen Sie Kaufeinheit',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4887,'de','Choose_Sub_Category','Wählen Sie Unterkategorie',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4888,'de','Choose_Brand','Wählen Sie Marke',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4889,'de','Choose_Warehouse','Wählen Sie Lager',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4890,'de','Choose_Unit_Sale','Wählen Sie Verkaufseinheit',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4891,'de','Enter_Product_Cost','Produktkosten eingeben',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4892,'de','Enter_Stock_alert','Bestandswarnung eingeben',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4893,'de','Choose_Unit_Product','Wählen Sie Produkteinheit',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4894,'de','Enter_Product_Price','Produktpreis eingeben',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4895,'de','Enter_Name_Product','Geben Sie den Namen Produkt ein',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4896,'de','Enter_Role_Name','Geben Sie den Rollennamen ein',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4897,'de','Enter_Role_Description','Geben Sie die Rollenbeschreibung ein',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4898,'de','Enter_name_category','Geben Sie den Kategorienamen ein',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4899,'de','Enter_Code_category','Geben Sie den Kategoriecode ein',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4900,'de','Enter_Name_Brand','Geben Sie die Namensmarke ein',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4901,'de','Enter_Description_Brand','Geben Sie Beschreibung Marke ein',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4902,'de','Enter_Code_Currency','Geben Sie die Codewährung ein',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4903,'de','Enter_name_Currency','Geben Sie den Namen Währung ein',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4904,'de','Enter_Symbol_Currency','Geben Sie die Symbolwährung ein',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4905,'de','Enter_Name_Unit','Geben Sie den Einheitennamen ein',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4906,'de','Enter_ShortName_Unit','Geben Sie den Kurznamen Unit ein',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4907,'de','Choose_Base_Unit','Wählen Sie Basiseinheit',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4908,'de','Choose_Operator','Wählen Sie den Operator',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4909,'de','Enter_Operation_Value','Geben Sie den Betriebswert ein',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4910,'de','Enter_Name_Warehouse','Geben Sie den Lagernamen ein',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4911,'de','Enter_Phone_Warehouse','Geben Sie das Lagertelefon ein',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4912,'de','Enter_Country_Warehouse','Geben Sie das Lagerland ein',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4913,'de','Enter_City_Warehouse','Geben Sie die Lagerstadt ein',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4914,'de','Enter_Email_Warehouse','Geben Sie die Lager E-Mail ein',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4915,'de','Enter_ZipCode_Warehouse','Geben Sie die Postleitzahl des Lagers ein',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4916,'de','Choose_Currency','Währung wählen',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4917,'de','Thank_you_for_your_business','Vielen Dank für Ihr Geschäft!',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4918,'de','Cancel','Stornieren',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4919,'de','New_Customer','Neukunde',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4920,'de','Incorrect_Login','Falsche Anmeldedaten',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4921,'de','Successfully_Logged_In','Erfolgreich angemeldet',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4922,'de','This_user_not_active','Dieser Benutzer ist nicht aktiv',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4923,'de','SignIn','Einloggen',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4924,'de','Create_an_account','Ein Konto erstellen',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4925,'de','Forgot_Password','Passwort vergessen ?',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4926,'de','Email_Address','E-Mail-Addresse',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4927,'de','SignUp','Anmeldung',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4928,'de','Already_have_an_account','Sie haben bereits ein Konto ?',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4929,'de','Reset_Password','Passwort zurücksetzen',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4930,'de','Failed_to_authenticate_on_SMTP_server','Fehler beim Authentifizieren auf dem SMTP-Server',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4931,'de','We_cant_find_a_user_with_that_email_addres','Wir können keinen Benutzer mit dieser E-Mail-Adresse finden',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4932,'de','We_have_emailed_your_password_reset_link','Wir haben Ihren Link zum Zurücksetzen Ihres Passworts per E-Mail gesendet',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4933,'de','Please_fill_the_Email_Adress','Bitte geben Sie die E-Mail-Adresse ein',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4934,'de','Confirm_password','Kennwort bestätigen',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4935,'de','Your_Password_has_been_changed','Ihr Passwort wurde geändert',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4936,'de','The_password_confirmation_does_not_match','Die Passwortbestätigung stimmt nicht überein',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4937,'de','This_password_reset_token_is_invalid','Dieses Token zum Zurücksetzen des Passworts ist ungültig',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4938,'de','Warehouse_report','Lagerbericht',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4939,'de','All_Warehouses','Alle Lager',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4940,'de','Expense_List','Spesenliste',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4941,'de','Expenses','Kosten',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4942,'de','This_Week_Sales_Purchases','Diese Woche Verkäufe & Käufe',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4943,'de','Top_Selling_Products','Meistverkaufte Produkte',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4944,'de','View_all','Alle ansehen',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4945,'de','Payment_Sent_Received','Zahlung gesendet und erhalten',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4946,'de','Filter','Filter',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4947,'de','Invoice_POS','Rechnung POS',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4948,'de','Invoice','Rechnung',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4949,'de','Customer_Info','Kundeninformation',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4950,'de','Company_Info','Firmeninfo',0,'2025-06-18 01:50:05.000000','2025-06-18 01:50:05.000000'),(4951,'de','Invoice_Info','Rechnungsinfo',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4952,'de','Order_Summary','Bestellübersicht',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4953,'de','Quote_Info','Angebotsinfo',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4954,'de','Del','Löschen',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4955,'de','SuppliersPaiementsReport','Lieferantenzahlungsbericht',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4956,'de','Purchase_Info','Kaufinfo',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4957,'de','Supplier_Info','Lieferanteninfo',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4958,'de','Return_Info','Infos zur Rücksendung',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4959,'de','Create_Expense','Kosten erstellen',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4960,'de','Details','Einzelheiten',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4961,'de','Discount_Method','Rabattmethode',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4962,'de','Net_Unit_Cost','Netto-Stückkosten',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4963,'de','Net_Unit_Price','Netto-Stückpreis',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4964,'de','Edit_Expense','Kosten bearbeiten',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4965,'de','All_Brand','Alle Marke',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4966,'de','All_Category','Alle Kategorie',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4967,'de','ListExpenses','Ausgaben auflisten',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4968,'de','Create_Permission','Berechtigung erstellen',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4969,'de','Edit_Permission','Berechtigung bearbeiten',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4970,'de','Reports_payments_Sales','Meldet Zahlungen Verkäufe',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4971,'de','Reports_payments_Purchases','Meldet Zahlungen Einkäufe',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4972,'de','Reports_payments_Return_Customers','Berichte Zahlungen Kunden zurückgeben',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4973,'de','Reports_payments_Return_Suppliers','Berichte Zahlungen Rücklieferanten',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4974,'de','Expense_Deleted','Diese Ausgabe wurde gelöscht',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4975,'de','Expense_Updated','Diese Ausgabe wurde aktualisiert',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4976,'de','Expense_Created','Diese Ausgabe wurde erstellt',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4977,'de','DemoVersion','Dies ist in der Demoversion nicht möglich',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4978,'de','OrderStatistics','Verkaufsstatistik',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4979,'de','AlreadyAdd','Dieses Produkt ist bereits hinzugefügt',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4980,'de','AddProductToList','Bitte fügen Sie das Produkt der Liste hinzu',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4981,'de','AddQuantity','Bitte addieren Sie die Menge',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4982,'de','InvalidData','Ungültige Daten',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4983,'de','LowStock','Menge übersteigt die auf Lager verfügbare Menge',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4984,'de','WarehouseIdentical','Die beiden Repositorys können nicht identisch sein',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4985,'de','VariantDuplicate','Diese Variable ist redundant',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4986,'de','Filesize','Dateigröße',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4987,'de','GenerateBackup','Backup generieren',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4988,'de','BackupDatabase','Backup-Datenbank',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4989,'de','Backup','Backup-Datenbank',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4990,'de','Paid','Bezahlt',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4991,'de','Unpaid','Unbezahlt',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4992,'de','IncomeExpenses','Einnahmen & Ausgaben',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4993,'de','dailySalesPurchases','tägliche Verkäufe und Einkäufe',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4994,'de','ProductsExpired','Produkt abgelaufen',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4995,'de','Today','heute',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4996,'de','Income','Einkommen',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4997,'de','Sale','Verkauf',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4998,'de','Actif','Aktiv',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(4999,'de','Inactif','Inaktiv',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5000,'de','Customers','Kunden',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5001,'de','Phone','Telefon',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5002,'de','SearchByPhone','Suche per Telefon',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5003,'de','Suppliers','Lieferanten',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5004,'de','Quotations','Zitate',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5005,'de','Sales','Der Umsatz',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5006,'de','Purchases','Einkäufe',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5007,'de','Returns','Kehrt zurück',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5008,'de','Settings','die Einstellungen',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5009,'de','SystemSettings','Systemeinstellungen',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5010,'de','Users','Benutzer',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5011,'de','GroupPermissions','Gruppenberechtigungen',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5012,'de','Currencies','Währungen',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5013,'de','Warehouses','Lagerhäuser',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5014,'de','Units','Einheiten',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5015,'de','UnitsPrchases','Kauf von Einheiten',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5016,'de','UnitsSales','Einheiten Vertrieb',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5017,'de','Reports','Berichte',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5018,'de','PaymentsReport','Zahlungsbericht',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5019,'de','PaymentsPurchases','Zahlungen Einkäufe',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5020,'de','PaymentsSales','Zahlungen Verkäufe',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5021,'de','PaymentsReturns','Zahlung Rückgabe',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5022,'de','ReturnsInvoices','Gibt Rechnungen zurück',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5023,'de','ReturnsInvoicesData','Rechnungsdaten zurücksenden',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5024,'de','ShowAll','Alle Datensätze aller Benutzer anzeigen',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5025,'de','ProfitandLoss','Gewinn-und Verlust',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5026,'de','WarehouseStockChart','Inventardiagramm',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5027,'de','SalesReport','Verkaufsbericht',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5028,'de','PurchasesReport','Kaufbericht',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5029,'de','CustomersReport','Kundenbericht',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5030,'de','SuppliersReport','Lieferantenbericht',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5031,'de','SupplierReport','Lieferantenbericht',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5032,'de','DailySalesData','Tägliche Verkaufsdaten',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5033,'de','DailyPurchasesData','Tägliche Kaufdaten',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5034,'de','Dernièrescinqrecords','Letzte fünf Datensätze',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5035,'de','Filters','Filter',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5036,'de','date','Datum',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5037,'de','ManagementCurrencies','Management Währungen',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5038,'de','CurrencyCode','Währungscode',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5039,'de','CurrencyName','Währungsname',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5040,'de','Symbol','Symbol',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5041,'de','Reference','Referenz',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5042,'de','Supplier','Lieferant',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5043,'de','PaymentStatus','Zahlungsstatus',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5044,'de','Customer','Kunde',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5045,'de','CustomerCode','Kundennummer',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5046,'de','Status','Status',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5047,'de','SupplierCode','Lieferantencode',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5048,'de','Categorie','Kategorie',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5049,'de','Categories','Kategorien',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5050,'de','StockTransfers','Umlagerung',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5051,'de','StockManagement','Lagerverwaltung',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5052,'de','dashboard','Instrumententafel',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5053,'de','Products','Produkte',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5054,'de','productsList','Produktliste',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5055,'de','ProductManagement','Produkt Management',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5056,'de','ProductQuantityAlerts','Warnung vor Produktmengen',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5057,'de','CodeProduct','Code Produkt',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5058,'de','ProductTax','Produktsteuer',0,'2025-06-18 01:50:06.000000','2025-06-18 01:50:06.000000'),(5059,'de','SubCategorie','Unterkategorie',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5060,'de','Name_product','Bezeichnung',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5061,'de','StockAlert','Lagerwarnung',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5062,'de','warehouse','Warenhaus',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5063,'de','Tax','MwSt',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5064,'de','BuyingPrice','Kaufpreis',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5065,'de','SellPrice','Verkaufspreis',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5066,'de','Quantity','Quantität',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5067,'de','UnitSale','Einheiten verkaufen',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5068,'de','UnitPurchase','Stückkauf',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5069,'de','All','Alles',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5070,'de','EditProduct','Produkt bearbeiten',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5071,'de','AddProduct','Produkt hinzufügen',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5072,'de','SearchByCode','Suche nach Code',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5073,'de','SearchByName','Suche mit Name',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5074,'de','ProductDetails','Produktdetails',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5075,'de','CustomerName','Kundenname',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5076,'de','CustomerManagement','Kundenmanagement',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5077,'de','Add','Hinzufügen',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5078,'de','Edit','Bearbeiten',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5079,'de','Close','Schließen',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5080,'de','PleaseSelect','Bitte auswählen',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5081,'de','Action','Aktion',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5082,'de','Email','Email',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5083,'de','EditCustomer','Kunden bearbeiten',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5084,'de','AddCustomer','Kunden hinzufügen',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5085,'de','Country','Land',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5086,'de','City','Stadt',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5087,'de','Adress','Adresse',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5088,'de','CustomerDetails','Kundendetails',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5089,'de','CustomersList','Kundenliste',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5090,'de','SupplierName','Name des Anbieters',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5091,'de','SuppliersManagement','Lieferantenmanagement',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5092,'de','SupplierDetails','Lieferantendetails',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5093,'de','QuotationsManagement','Zitate management',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5094,'de','SubTotal','Zwischensumme',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5095,'de','MontantReste','Restbetrag',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5096,'de','complete','Komplett',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5097,'de','EnAttendant','steht aus',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5098,'de','Recu','Empfangen',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5099,'de','partial','Teilweise',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5100,'de','Retournee','Rückkehr',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5101,'de','DetailQuote','Detaillierte Zita',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5102,'de','EditQuote','bearbeiten zitat',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5103,'de','CreateSale','Verkauf erstellen',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5104,'de','DownloadPdf','PDF Herunterladen',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5105,'de','QuoteEmail','zitat per E-Mail senden',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5106,'de','DeleteQuote',' Löschen zitat',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5107,'de','AddQuote','hinzufügen zitat',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5108,'de','SelectProduct','Ausgewähltes Produkt',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5109,'de','ProductCodeName','Produkt (Code - Name)',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5110,'de','Price','Preis',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5111,'de','CurrentStock','Lagerbestand',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5112,'de','Total','Gesamt',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5113,'de','Num','N°',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5114,'de','Unitcost','Kosten pro Einheit',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5115,'de','to','zu',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5116,'de','Subject','Gegenstand',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5117,'de','Message','Nachricht',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5118,'de','EmailCustomer','E-Mail an den Kunden',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5119,'de','Sent','senden',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5120,'de','Quote','Zitat',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5121,'de','Hello','Hallo',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5122,'de','AttachmentQuote','Sie finden den Anhang zu Ihrem Zitat',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5123,'de','AddProducts','Produkte zur Bestellliste hinzufügen',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5124,'de','SelectWarehouse','Bitte Lager auswählen',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5125,'de','SelectCustomer','Wählen Sie Kunde',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5126,'de','SalesManagement','Verkaufsleitung',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5127,'de','QtyBack','Mengenrückgabe',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5128,'de','TotalReturn','Gesamtrendite',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5129,'de','Amount','Menge',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5130,'de','SaleDetail','Verkaufsdetail',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5131,'de','EditSale','Verkauf bearbeiten',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5132,'de','AddSale','Verkauf hinzufügen',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5133,'de','ShowPayment','Zahlungen anzeigen',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5134,'de','AddPayment','Zahlung hinzufügen',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5135,'de','EditPayment','Zahlung bearbeiten',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5136,'de','EmailSale','Verkauf per E-Mail senden',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5137,'de','DeleteSale','Verkauf löschen',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5138,'de','ModePaiement','Bezahlverfahren',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5139,'de','Paymentchoice','Wahl der Zahlung',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5140,'de','Note','Hinweis',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5141,'de','PaymentComplete','Zahlung abgeschlossen!',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5142,'de','PurchasesManagement','Einkaufsmanagement',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5143,'de','Ordered','Bestellt',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5144,'de','DeletePurchase','Kauf löschen',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5145,'de','EmailPurchase','Kauf per E-Mail senden',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5146,'de','EditPurchase','Kauf bearbeiten',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5147,'de','PurchaseDetail','Kaufdetail',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5148,'de','AddPurchase','Kauf hinzufügen',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5149,'de','EmailSupplier','Lieferanten-E-Mail',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5150,'de','PurchaseInvoice','Kauft Zahlungen',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5151,'de','PurchasesInvoicesData','Kauft Zahlungsdaten',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5152,'de','SalesInvoice','Verkaufszahlungen',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5153,'de','SalesInvoicesData','Verkaufszahlungsdaten',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5154,'de','UserManagement','Benutzerverwaltung',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5155,'de','Firstname','Vorname',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5156,'de','lastname','Nachname',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5157,'de','username','NUTZERNAME',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5158,'de','password','PASSWORT',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5159,'de','Newpassword','Neues Kennwort',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5160,'de','ChangeAvatar','Avatar ändern',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5161,'de','LeaveBlank','Bitte lassen Sie dieses Feld leer, wenn Sie es nicht geändert haben',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5162,'de','type','Typ',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5163,'de','UserPermissions','Benutzerberechtigungen',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5164,'de','RoleName','Rollenname',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5165,'de','RoleDescription','Rollenbeschreibung',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5166,'de','AddPermissions','Berechtigungen hinzufügen',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5167,'de','View','ansehen',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5168,'de','NewAdjustement','Neue Anpassung',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5169,'de','EditAdjustement','Anpassung bearbeiten',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5170,'de','CannotSubstraction','Sie können keine Produkte mit Lagerbestand 0 subtrahieren',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5171,'de','Addition','Zusatz',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5172,'de','Subtraction','Subtraktion',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5173,'de','profil','profil',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5174,'de','logout','Ausloggen',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5175,'de','PurchaseAlreadyPaid','Sie können keine Änderungen vornehmen, da dieser Kauf bereits bezahlt wurde',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5176,'de','SaleAlreadyPaid','Sie können nicht ändern, da dieser Verkauf bereits bezahlt wurde',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5177,'de','ReturnAlreadyPaid','Sie können keine Änderungen vornehmen, da diese Rücksendung bereits bezahlt wurde',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5178,'de','QuoteAlready','Dieses Angebot hat bereits einen Verkauf generiert',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5179,'de','QuotationComplete','Dieses Angebot ist abgeschlossen',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5180,'de','SiteConfiguration','Standortkonfiguration',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5181,'de','Language','Sprache',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5182,'de','DefaultCurrency','Standardwährung',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5183,'de','LoginCaptcha','Anmeldung Captcha',0,'2025-06-18 01:50:07.000000','2025-06-18 01:50:07.000000'),(5184,'de','DefaultEmail','Standard-E-Mail',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5185,'de','SiteName','Site-Name',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5186,'de','ChangeLogo','Logo ändern',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5187,'de','SMTPConfiguration','SMTP-Konfiguration',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5188,'de','HOST','GASTGEBER',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5189,'de','PORT','HAFEN',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5190,'de','encryption','Verschlüsselung',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5191,'de','SMTPIncorrect','SMTP-Konfiguration falsch',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5192,'de','Discount','Rabatt',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5193,'de','OrderTax','Bestellsteuer',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5194,'de','Shipping','Versand',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5195,'de','CompanyName','Name der Firma',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5196,'de','CompanyPhone','Firmentelefon',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5197,'de','CompanyAdress','Firmenanschrift',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5198,'de','Code','Code',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5199,'de','image','Bild',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5200,'de','Printbarcode','Strichcode drucken',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5201,'de','ReturnsCustomers','Gibt Kunden zurück',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5202,'de','ReturnsSuppliers','Gibt Lieferanten zurück',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5203,'de','FactureReturnCustomers','Rechnungen Gibt Verkäufe zurück',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5204,'de','FactureReturnSuppliers','Rechnungen Gibt Einkäufe zurück',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5205,'de','NodataAvailable','Keine Daten verfügbar',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5206,'de','ProductImage','Produkt bild',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5207,'de','Barcode','Strichcode',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5208,'de','pointofsales','Verkaufsstelle',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5209,'de','CustomUpload','Benutzerdefinierter Upload',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5210,'de','pointofsaleManagement','Kasse Management',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5211,'de','Adjustment','Änderung',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5212,'de','Updat','Aktualisieren',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5213,'de','Reset','Zurücksetzen',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5214,'de','print','drucken',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5215,'de','SearchByEmail','Suche per E-Mail',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5216,'de','ChooseProduct','Wählen Sie Produkt',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5217,'de','Qty','Menge',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5218,'de','Items','Artikel',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5219,'de','AmountHT','Betrag HT',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5220,'de','AmountTTC','Betrag TTC',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5221,'de','PleaseSelectSupplier','Bitte wählen Sie Lieferant',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5222,'de','PleaseSelectStatut','Bitte wählen Sie Statut',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5223,'de','PayeBy','bezahlt mit',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5224,'de','ChooseWarehouse','Wählen Sie Lager',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5225,'de','payNow','Zahlen Sie jetzt',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5226,'de','ListofCategory','Liste der Kategorien',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5227,'de','Description','Beschreibung',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5228,'de','submit','einreichen',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5229,'de','ProblemCreatingThisInvoice','Beim Erstellen dieser Rechnung ist ein Problem aufgetreten. Bitte versuche es erneut',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5230,'de','ProblemPayment','Es gab ein Problem bei der Zahlung. Bitte versuche es erneut.',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5231,'de','CreateAdjustment','Anpassung erstellen',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5232,'de','Afewwords','ein paar Worte über ...',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5233,'de','UserImage','Benutzerbild',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5234,'de','UpdateProduct','Produkt aktualisieren',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5235,'de','Brand','Marke',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5236,'de','BarcodeSymbology','Barcode-Symbologie',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5237,'de','ProductCost','Produktkosten',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5238,'de','ProductPrice','Produktpreis',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5239,'de','UnitProduct','Einheit Produkt',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5240,'de','TaxMethod','Steuermethode',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5241,'de','MultipleImage','Mehrfachbild',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5242,'de','ProductHasMultiVariants','Produkt hat mehrere Varianten',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5243,'de','ProductHasPromotion','Produkt hat Werbung',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5244,'de','PromotionStart','Promotion Start',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5245,'de','PromotionEnd','Promotion-Ende',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5246,'de','PromotionPrice','Aktionspreis',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5247,'de','Cost','Kosten',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5248,'de','Unit','Einheit',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5249,'de','ProductVariant','Produktvariante',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5250,'de','Variant','Variante',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5251,'de','UnitPrice','Stückpreis',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5252,'de','CreateReturnCustomer','Rückgabekunden erstellen',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5253,'de','EditReturnCustomer','Kundenretouren aktualisieren',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5254,'de','CreateReturnSupplier','Rücklieferanten anlegen',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5255,'de','Documentation','Dokumentation',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5256,'de','EditReturnSupplier','Lieferantenrückgabe aktualisieren',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5257,'de','FromWarehouse','Aus dem Lager',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5258,'de','ToWarehouse','Zum Lager',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5259,'de','EditTransfer','Übertragung bearbeiten',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5260,'de','TransferDetail','Detail übertragen',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5261,'de','Pending','steht aus',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5262,'de','Received','Empfangen',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5263,'de','PermissionsManager','Berechtigungsmanagement',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5264,'de','BrandManager','Markenführung',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5265,'de','BrandImage','Markenzeichen',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5266,'de','BrandName','Markenname',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5267,'de','BrandDescription','Markenbeschreibung',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5268,'de','BaseUnit','Grundeinheit',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5269,'de','ManagerUnits','Verwaltungseinheiten',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5270,'de','OperationValue','Betriebswert',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5271,'de','Operator','Operator',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5272,'de','Top5Products','Top 5 Produkte',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5273,'de','Last5Sales','Letzte 5 Verkäufe',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5274,'de','ListAdjustments','Anpassungslisten',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5275,'de','ListTransfers','Übertragungen auflisten',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5276,'de','CreateTransfer','Übertragung erstellen',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5277,'de','OrdersManager','Auftragsverwaltung',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5278,'de','ListQuotations','Zitate auflisten',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5279,'de','ListPurchases','Einkäufe auflisten',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5280,'de','ListSales','Liste Verkäufe',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5281,'de','ListReturns','Liste zurück',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5282,'de','PeopleManager','Management Leute',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5283,'de','ListofBrand','Markenliste',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5284,'de','Delete_Title','Bist du sicher?',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5285,'de','Delete_Text','Sie können dies nicht rückgängig machen!',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5286,'de','Delete_confirmButtonText','Ja, lösche es!',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5287,'de','Delete_cancelButtonText','Stornieren',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5288,'de','Delete_Deleted','Gelöscht!',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5289,'de','Delete_Failed','Gescheitert!',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5290,'de','Delete_Therewassomethingwronge','Etwas war falsch',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5291,'de','SendEmail','E-Mail Erfolgreich einsenden',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5292,'de','erroSale','Dieser Verkauf ist bereits mit einer Rückgabe verbunden!',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5293,'de','ReturnManagement','Rückgabeverwaltung',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5294,'de','ReturnDetail','Detail zurückgeben',0,'2025-06-18 01:50:08.000000','2025-06-18 01:50:08.000000'),(5295,'de','EditReturn','Rückgabe bearbeiten',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5296,'de','AddReturn','Return hinzufügen',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5297,'de','EmailReturn','Senden Sie die Rücksendung per E-Mail',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5298,'de','DeleteReturn','Rückgabe löschen',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5299,'de','Retoursurcharge','Rücknahmegebühr',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5300,'de','Laivrison','Lieferung',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5301,'de','SelectSale','Wählen Sie Verkauf',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5302,'de','ZeroPardefault','Sie können den Artikel löschen oder den zurückgegebenen Betrag auf Null setzen, wenn er nicht zurückgegeben wird',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5303,'de','Return','Rückkehr',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5304,'de','Purchase','Kauf',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5305,'de','TotalSales','Gesamtumsatz',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5306,'de','TotalPurchases','Gesamteinkäufe',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5307,'de','TotalReturns','Gesamtrendite',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5308,'de','PaiementsNet','Zahlung netto',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5309,'de','PaiementsSent','Zahlung senden',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5310,'de','PaiementsReceived','Zahlung erhalten',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5311,'de','Recieved','Empfangen',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5312,'de','ProductCode','Produktcode',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5313,'de','ProductName','Produktname',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5314,'de','AlertQuantity','Warnung Menge',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5315,'de','TotalProducts','Produkte insgesamt',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5316,'de','TotalQuantity','Gesamtmenge',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5317,'de','TopCustomers','Top 5 Kunden',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5318,'de','TotalAmount','Gesamtmenge',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5319,'de','TotalPaid','Ganz bezahlt',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5320,'de','CustomerSalesReport','Kunden Verkaufsbericht',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5321,'de','CustomerPaiementsReport','Kundenzahlungsbericht',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5322,'de','CustomerQuotationsReport','KundenangeboteBericht',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5323,'de','Payments','Zahlungen',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5324,'de','TopSuppliers','Top 5 Lieferanten',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5325,'de','SupplierPurchasesReport','Lieferanten Einkaufsbericht',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5326,'de','SupplierPaiementsReport','Lieferanten Zahlungsbericht',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5327,'de','Name','Name',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5328,'de','ManagementWarehouse','Lagerverwaltung',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5329,'de','ZipCode','Postleitzahl',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5330,'de','managementCategories','Kategorienverwaltung',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5331,'de','Codecategorie','Codekategorie',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5332,'de','Namecategorie','Namenskategorie',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5333,'de','Parentcategorie','Eltern-Kategorie',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5334,'de','managementTax','Steuermanagement',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5335,'de','TaxName','Steuername',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5336,'de','TaxRate','Steuersatz',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5337,'de','managementUnitPurchases','Käufe Einheitenverwaltung',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5338,'de','managementUnitSales','Verkaufseinheit Management',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5339,'de','ShortName','Kurzer Name',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5340,'de','PleaseSelectThesebeforeaddinganyproduct','Bitte wählen Sie diese aus, bevor Sie ein Produkt hinzufügen',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5341,'de','StockAdjustement','Bestandskorrektur',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5342,'de','PleaseSelectWarehouse','Bitte wählen Sie das Lager aus, bevor Sie ein Produkt auswählen',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5343,'de','StockTransfer','Umlagerung',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5344,'de','SelectPeriod','Wählen Sie Periode',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5345,'de','ThisYear','Dieses Jahr',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5346,'de','ThisToday','Das heute',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5347,'de','ThisMonth','Diesen Monat',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5348,'de','ThisWeek','Diese Woche',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5349,'de','AdjustmentDetail','Anpassungsdetail',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5350,'de','ActivateUser','Dieser Benutzer wurde aktiviert',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5351,'de','DisActivateUser','Dieser Benutzer wurde deaktiviert',0,'2025-06-18 01:50:09.000000','2025-06-18 01:50:09.000000'),(5352,'de','NotFound','Seite nicht gefunden.',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5353,'de','oops','Error! Seite nicht gefunden.',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5354,'de','couldNotFind','Wir konnten die gesuchte Seite nicht finden. In der Zwischenzeit können Sie',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5355,'de','ReturnDashboard','Zurück zum Dashboard',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5356,'de','hrm','HRM',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5357,'de','Employees','Mitarbeiter',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5358,'de','Attendance','Anwesenheit',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5359,'de','Leave_request','Anfrage hinterlassen',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5360,'de','Leave_type','Typ verlassen',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5361,'de','Company','Gesellschaft',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5362,'de','Departments','Abteilungen',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5363,'de','Designations','Bezeichnungen',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5364,'de','Office_Shift','Büroschicht',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5365,'de','Holidays','Ferien',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5366,'de','Enter_Company_Name','Geben Sie den Firmennamen ein',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5367,'de','Enter_email_address','E-Mail Adresse eingeben',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5368,'de','Enter_Company_Phone','Firmentelefon eingeben',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5369,'de','Enter_Company_Country','Firmenland eingeben',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5370,'de','Created_in_successfully','Wurde erfolgreich erstellt',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5371,'de','Updated_in_successfully','Wurde erfolgreich aktualisiert',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5372,'de','Deleted_in_successfully','Gelöscht in erfolgreich',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5373,'de','department','Abteilung',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5374,'de','Enter_Department_Name','Abteilungsname eingeben',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5375,'de','Choose_Company','Wählen Sie Unternehmen',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5376,'de','Department_Head','Abteilungsleiterin',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5377,'de','Choose_Department_Head','Wählen Sie Abteilungsleiter',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5378,'de','Enter_Shift_name','Geben Sie den Schichtnamen ein',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5379,'de','Monday_In','Monday In',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5380,'de','Monday_Out','Monday Out',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5381,'de','Tuesday_In','Tuesday In',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5382,'de','tuesday_out','tuesday Out',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5383,'de','wednesday_in','Wednesday In',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5384,'de','wednesday_out','Wednesday Out',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5385,'de','thursday_in','Thursday In',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5386,'de','thursday_out','Thursday Out',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5387,'de','friday_in','Friday In',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5388,'de','friday_out','Friday Out',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5389,'de','saturday_in','Saturday In',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5390,'de','saturday_out','Saturday Out',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5391,'de','sunday_in','Sunday In',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5392,'de','sunday_out','Sunday Out',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5393,'de','Holiday','Ferien',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5394,'de','Enter_title','Titel eingeben',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5395,'de','title','Titel',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5396,'de','start_date','Startdatum',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5397,'de','Enter_Start_date','Startdatum eingeben',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5398,'de','Finish_Date','Endtermin',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5399,'de','Enter_Finish_date','Geben Sie das Enddatum ein',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5400,'de','Please_provide_any_details','Bitte geben Sie alle Details an',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5401,'de','Attendances','Anwesenheiten',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5402,'de','Enter_Attendance_date','Anwesenheitsdatum eingeben',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5403,'de','Time_In','Time In',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5404,'de','Time_Out','Time Out',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5405,'de','Choose_Employee','Wählen Angestellter',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5406,'de','Employee','Angestellter',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5407,'de','Work_Duration','Arbeitsdauer',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5408,'de','remaining_leaves_are_insufficient','Die verbleibenden Blätter sind unzureichend',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5409,'de','Days','Tage',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5410,'de','Choose_leave_type','Urlaubsart wählen',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5411,'de','Leave_Reason','Verlassen Sie die Vernunft',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5412,'de','Enter_Reason_Leave','Geben Sie den Grund für das Verlassen ein',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5413,'de','Add_Employee','Mitarbeiter hinzufügen',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5414,'de','Enter_FirstName','Bitte Vornamen eingeben',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5415,'de','Enter_LastName','Nachnamen eingeben',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5416,'de','Gender','Geschlecht',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5417,'de','Choose_Gender','Wählen Sie Geschlecht',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5418,'de','Enter_Birth_date','Geburtsdatum eingeben',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5419,'de','Birth_date','Geburtstag',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5420,'de','Enter_Country','Land eingeben',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5421,'de','Enter_Phone_Number','Telefonnummer eingeben',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5422,'de','joining_date','Beitrittsdatum',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5423,'de','Enter_joining_date','Beitrittsdatum eingeben',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5424,'de','Choose_Designation','Wählen Sie Bezeichnung',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5425,'de','Designation','Bezeichnung',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5426,'de','Choose_Office_Shift','Wählen Sie Büroschicht',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5427,'de','Enter_Leaving_Date','Geben Sie das Austrittsdatum ein',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5428,'de','Leaving_Date','Austrittsdatum',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5429,'de','Annual_Leave','Jährlicher Urlaub',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5430,'de','Enter_Annual_Leave','Geben Sie den Jahresurlaub ein',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5431,'de','Remaining_leave','Resturlaub',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5432,'de','Employee_Details','Mitarbeiterdetails',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5433,'de','Basic_Information','Grundlegende Informationen',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5434,'de','Family_status','Familienstatus',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5435,'de','Choose_Family_status','Wählen Sie Familienstatus',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5436,'de','Employment_type','Beschäftigungsart',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5437,'de','Select_Employment_type','Wählen Sie Beschäftigungsart aus',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5438,'de','Enter_City','Stadt betreten',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5439,'de','Province','Provinz',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5440,'de','Enter_Province','Geben Sie die Provinz ein',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5441,'de','Enter_Address','Geben Sie die Adresse ein',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5442,'de','Enter_Zip_code','Bitte Postleitzahl eingeben',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5443,'de','Zip_code','Postleitzahl',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5444,'de','Hourly_rate','Stundensatz',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5445,'de','Enter_Hourly_rate','Geben Sie den Stundensatz ein',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5446,'de','Basic_salary','Grundgehalt',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5447,'de','Enter_Basic_salary','Geben Sie das Grundgehalt ein',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5448,'de','Social_Media','Sozialen Medien',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5449,'de','Skype','Skypen',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5450,'de','Enter_Skype','Geben Sie Skype ein',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5451,'de','Facebook','Facebook',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5452,'de','Enter_Facebook','Geben Sie Facebook ein',0,'2025-06-18 01:50:10.000000','2025-06-18 01:50:10.000000'),(5453,'de','WhatsApp','Whats App',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5454,'de','Enter_WhatsApp','Geben Sie WhatsApp ein',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5455,'de','LinkedIn','LinkedIn',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5456,'de','Enter_LinkedIn','Geben Sie LinkedIn ein',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5457,'de','Twitter','Twitter',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5458,'de','Enter_Twitter','Geben Sie Twitter ein',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5459,'de','Experiences','Erfahrungen',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5460,'de','bank_account','Bankkonto',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5461,'de','Company_Name','Name der Firma',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5462,'de','Location','Standort',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5463,'de','Enter_location','Ort eingeben',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5464,'de','Enter_Description','Beschreibung eingeben',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5465,'de','Bank_Name','Name der Bank',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5466,'de','Enter_Bank_Name','Geben Sie den Banknamen ein',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5467,'de','Bank_Branch','Bankfiliale',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5468,'de','Enter_Bank_Branch','Geben Sie die Bankfiliale ein',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5469,'de','Bank_Number','Bank Nummer',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5470,'de','Enter_Bank_Number','Geben Sie die Banknummer ein',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5471,'de','Assigned_warehouses','Zugewiesene Lager',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5472,'de','Top_customers','Top-Kunden',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5473,'de','Attachment','Anhang',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5474,'de','view_employee','Mitarbeiter ansehen',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5475,'de','edit_employee','Mitarbeiter bearbeiten',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5476,'de','delete_employee','Mitarbeiter löschen',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5477,'de','Created_by','Hinzugefügt von',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5478,'de','Add_product_IMEI_Serial_number','Produkt-IMEI/Seriennummer hinzufügen',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5479,'de','Product_Has_Imei_Serial_number','Produkt hat IMEI/Seriennummer',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5480,'de','IMEI_SN','IMEI/SN',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5481,'de','Shipments','Sendungen',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5482,'de','delivered_to','Geliefert an',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5483,'de','shipment_ref','Sendungsnummer',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5484,'de','sale_ref','Verkauf Ref',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5485,'de','Edit_Shipping','Versand bearbeiten',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5486,'de','Packed','Verpackt',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5487,'de','Shipped','Versendet',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5488,'de','Delivered','Geliefert',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5489,'de','Cancelled','Annulliert',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5490,'de','Shipping_status','Versandstatus',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5491,'de','Users_Report','Benutzerbericht',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5492,'de','stock_report','Bestandsbericht',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5493,'de','Total_quotations','Gesamtzitate',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5494,'de','Total_return_sales','Gesamtretourenverkäufe',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5495,'de','Total_return_purchases','Total Return-Käufe',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5496,'de','Total_transfers','Gesamtüberweisungen',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5497,'de','Total_adjustments','Gesamtanpassungen',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5498,'de','User_report','Benutzerbericht',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5499,'de','Current_stock','Aktueller Lagerbestand',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5500,'de','product_name','Produktname',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5501,'de','Total_Customers_Due','Gesamtschulden',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5502,'de','Total_Suppliers_Due','Gesamtschulden',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5503,'de','Some_warehouses','Einige Lager',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5504,'de','Product_Cost','Produktkosten',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5505,'de','sms_settings','SMS-Einstellungen',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5506,'de','mail_settings','E-Mail-Einstellungen',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5507,'de','Nexmo_SMS','Nexmo SMS',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5508,'de','TWILIO_SMS','TWILIO SMS',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5509,'de','Default_SMS_Gateway','Standard-SMS-Gateway',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5510,'de','module_settings','Moduleinstellungen',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5511,'de','Module_enabled_success','Modul erfolgreich aktiviert',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5512,'de','Module_Disabled_success','Modul erfolgreich deaktiviert',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5513,'de','update_settings','Update Einstellungen',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5514,'de','Please_Upload_the_Correct_Module','Bitte laden Sie das richtige Modul hoch',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5515,'de','Uploaded_Success','Erfolgreich hochgeladen',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5516,'de','Customer_details','Kundendetails',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5517,'de','Edit_Customer','Kunde bearbeiten',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5518,'de','Delete_Customer','Kunde löschen',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5519,'de','Pay_Due','alle Fälligen bezahlen',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5520,'de','Paying_amount_is_greater_than_Total_Due','Der Zahlungsbetrag ist größer als der fällige Gesamtbetrag',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5521,'de','Customer_Invoice','Kundenrechnung',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5522,'de','This_Product_Not_For_Selling','Dieses Produkt ist nicht zum Verkauf bestimmt',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5523,'de','Welcome_to_your_Dashboard','Willkommen auf Ihrem Dashboard',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5524,'de','Total_Payable','Gesamtzahlbar',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5525,'de','Choose_Sale_Ref','Wählen Sie Verkaufsreferenz',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5526,'de','Please_Select_Sale','Bitte wählen Sie Verkauf',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5527,'de','list_product_returns','Produktrückgaben auflisten',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5528,'de','Qty_return','Menge zurück',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5529,'de','Choose_Purchase_Ref','Wählen Sie Kauf-Ref',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5530,'de','Purchase_Ref','Kauf-Ref',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5531,'de','please_select_purchase','Bitte Kauf auswählen',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5532,'de','qty_return_is_greater_than_qty_purchased','Die zurückgegebene Menge ist größer als die gekaufte Menge',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5533,'de','qty_return_is_greater_than_qty_sold','Die zurückgegebene Menge ist größer als die verkaufte Menge',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5534,'de','Quantity_sold','Menge verkauft',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5535,'de','qty_purchased','Menge gekauft',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5536,'de','Sender_Name','Absendername',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5537,'de','The_module_must_be_uploaded_as_zip_file','Das Modul muss als Zip-Datei hochgeladen werden',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5538,'de','Upload_Module','Modul hochladen',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5539,'de','All_Modules_Installed','Alle Module installiert',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5540,'de','Current_Version','Aktuelle Version',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5541,'de','You_already_have_the_latest_version','Sie haben bereits die neueste Version',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5542,'de','Update_Available','Update verfügbar',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5543,'de','Update_Log','Protokoll aktualisieren',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5544,'de','Update_Now','Jetzt aktualisieren',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5545,'de','View_Change_Log','Änderungsprotokoll anzeigen',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5546,'de','invoice_footer','Rechnung Fußzeile',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5547,'de','Please_Wait_for_the_update','Bitte warten Sie, bis das Update vollständig abgeschlossen ist. Es wird nicht empfohlen, den Browser zu schließen oder ein Prozess-Upgrade zu stoppen',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5548,'de','Note_update','Stellen Sie sicher, dass Sie Ihre aktuelle Version und Datenbank sichern, bevor Sie das Upgrade ausführen, um sie wiederherzustellen, wenn ein Fehler auftritt',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5549,'de','Time_Zone','Zeitzone',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5550,'de','Payment_note','Zahlungshinweis',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5551,'de','sale_note','Verkaufsnotizen',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5552,'de','Total_Sale_Due','Gesamtverkaufsschulden',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5553,'de','Total_Sell_Return_Due','Total Sell Return Debt',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5554,'de','pay_all_sell_due_at_a_time','alle Verkaufsschulden auf einmal bezahlen',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5555,'de','pay_all_sell_return_due_at_a_time','Bezahlen Sie alle Verkaufsrenditeschulden auf einmal',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5556,'de','Gross_Profit','Bruttogewinn',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5557,'de','pay_all_purchase_due_at_a_time','Bezahlen Sie alle fälligen Einkäufe auf einmal',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5558,'de','Delete_Provider','Anbieter löschen',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5559,'de','Edit_Provider','Anbieter bearbeiten',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5560,'de','Provider_details','Anbieterdetails',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5561,'de','Total_Purchase_Due','Gesamtschulden beim Kauf',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5562,'de','Provider_Credit_Note','Gutschrift',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5563,'de','Customer_Credit_Note','Gutschrift',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5564,'de','Sell_Return','Rückgabe verkaufen',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5565,'de','Purchase_Return','Kaufrückgabe',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5566,'de','Tax_Number','Steuernummer',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5567,'de','Please_add_return_quantity','Bitte Retourenmenge hinzufügen',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5568,'de','Return_exist_for_the_Transaction','Rückgabe existiert für die Transaktion',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5569,'de','qty_return_is_greater_than_Quantity_Remaining','Die zurückgegebene Menge ist größer als die verbleibende Menge',0,'2025-06-18 01:50:11.000000','2025-06-18 01:50:11.000000'),(5570,'de','products_refunded_alert','Alle Produkte mit einer auf 0 gesetzten Menge werden nicht erstattet',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5571,'de','pay_all_purchase_return_due_at_a_time','alle fälligen Kaufrückgaben auf einmal bezahlen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5572,'de','Total_Purchase_Return_Due','Gesamtkauf Retouren fällig',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5573,'de','Purchase_return_due','Kaufrückgabe fällig',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5574,'de','Sell_return_due','Verkaufe Rückgabe fällig',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5575,'de','product_report','Produktbericht',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5576,'de','product_sales_report','Produktverkaufsbericht',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5577,'de','Product_purchases_report','Bericht über Produktkäufe',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5578,'de','Qty_sold','Menge verkauft',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5579,'de','Filter_by_warehouse','Nach Lager filtern',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5580,'de','Enable_Print_Invoice','Rechnung automatisch drucken',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5581,'de','Show_Warehouse','Lager ansehen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5582,'de','Saved_Credit_Card_Info','Gespeicherte Kreditkarteninformationen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5583,'de','Credit_card_changed_successfully','Kreditkarte erfolgreich geändert',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5584,'de','notification_template','Benachrichtigungsvorlage',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5585,'de','email_notification','E-Mail Benachrichtigung',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5586,'de','sms_notification','SMS-Benachrichtigung',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5587,'de','Change_product_details','Produktdetails ändern',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5588,'de','edit_tax_and_discount_and_shipping','Steuern, Rabatte und Versand bearbeiten',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5589,'de','Create_Quotation_with_Stock','Angebot mit Lagerbestand erstellen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5590,'de','Variant_cost','Variantenkosten',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5591,'de','Variant_price','Variantenpreis',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5592,'de','Variant_code','Variantencode',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5593,'de','Please_wait_until_the_product_is_loaded','Bitte warten Sie, bis das Produkt geladen ist',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5594,'de','Choose_SMS_Gateway','SMS-Gateway auswählen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5595,'de','Notification_Client','Benachrichtigung an den Kunden',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5596,'de','Available_Tags','Verfügbare Tags',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5597,'de','Email_Subject','E-Mail Betreff',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5598,'de','Email_body','E-Mail Inhalt',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5599,'de','Notification_Supplier','Benachrichtigung an den Lieferanten',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5600,'de','sms_body','SMS-Inhalt',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5601,'de','sms_templates','SMS-Vorlagen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5602,'de','email_templates','E-Mail-Vorlagen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5603,'de','Edit_Project','Projekt Bearbeiten',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5604,'de','Projects','Projekte',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5605,'de','Enter_Project_Title','Projekttitel Eingeben',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5606,'de','Assigned_Employees','Zugewiesene Mitarbeiter',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5607,'de','Choose_Team','Team Wählen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5608,'de','Create_Project','Projekt Erstellen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5609,'de','Project_List','Projektliste',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5610,'de','Not_Started','Nicht Gestartet',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5611,'de','In_Progress','In Arbeit',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5612,'de','On_Hold','In Wartestellung',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5613,'de','Edit_Task','Aufgabe Bearbeiten',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5614,'de','Tasks','Aufgaben',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5615,'de','Enter_Task_Title','Aufgabentitel Eingeben',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5616,'de','Choose_Project','Projekt Wählen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5617,'de','Project','Projekt',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5618,'de','Create_Task','Aufgabe Erstellen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5619,'de','Task_List','Aufgabenliste',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5620,'de','Import_Purchases','Einkäufe Importieren',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5621,'de','Warranty_Period','Garantiezeitraum',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5622,'de','Months','Monate',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5623,'de','Years','Jahre',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5624,'de','WarrantyTerms','Garantiebedingungen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5625,'de','HasGuarantee','Hat Garantie',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5626,'de','Guarantee_Period','Garantiezeit',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5627,'de','OpeningStock','Anfangsbestand',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5628,'de','Warranty_Guarantee_Tracking','Garantieverfolgung',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5629,'de','PaymentOption','Zahlungsoption',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5630,'de','AddAnotherPaymentOption','Weitere Zahlungsoption hinzufügen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5631,'de','PopularTendered','Beliebte Beträge',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5632,'de','clear','löschen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5633,'de','Pay','Bezahlen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5634,'de','Payment','Zahlung',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5635,'de','TotalPaidExceedsGrandTotalForMultiPayment','Gesamtzahlung übersteigt Gesamtsumme',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5636,'de','TotalPaying','Gesamtbetrag',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5637,'de','ChangeReturn','Wechselgeld',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5638,'de','AmountPaying','Zu zahlender Betrag',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5639,'de','Appearance_Settings','Erscheinungsbild-Einstellungen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5640,'de','app_name','App-Name',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5641,'de','page_title_suffix','Seitentitel-Suffix',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5642,'de','ChangeFavicon','Favicon ändern',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5643,'de','Languages','Sprachen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5644,'de','Translations','Übersetzungen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5645,'de','Translations for','Übersetzungen für',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5646,'de','Back','Zurück',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5647,'de','Save All Changes','Alle Änderungen speichern',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5648,'de','Add New','Neu hinzufügen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5649,'de','Add New Translation','Neue Übersetzung hinzufügen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5650,'de','Save','Speichern',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5651,'de','Delete','Löschen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5652,'de','Showing','Anzeigen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5653,'de','Translation added','Übersetzung hinzugefügt',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5654,'de','Failed to add translation','Übersetzung konnte nicht hinzugefügt werden',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5655,'de','Translation updated','Übersetzung aktualisiert',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5656,'de','Failed to update','Aktualisierung fehlgeschlagen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5657,'de','No changes to save','Keine Änderungen zum Speichern',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5658,'de','Notice','Hinweis',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5659,'de','All changes saved successfully','Alle Änderungen wurden erfolgreich gespeichert',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5660,'de','Bulk save failed','Massenspeicherung fehlgeschlagen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5661,'de','Please reload the page after saving translations to apply the changes.','Bitte laden Sie die Seite nach dem Speichern der Übersetzungen neu, um die Änderungen anzuwenden.',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5662,'de','Action_Blocked','Aktion blockiert',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5663,'de','You_cannot_delete_the_default_language','Sie können die Standardsprache nicht löschen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5664,'de','Flag','Flagge',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5665,'de','Locale','Gebietsschema',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5666,'de','Update Language','Sprache aktualisieren',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5667,'de','Add Language','Sprache hinzufügen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5668,'de','Send_Email','E-Mail senden',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5669,'de','Send_SMS','SMS senden',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5670,'de','total_sales','Gesamtumsatz',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5671,'de','Opening_Stock','Anfangsbestand',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5672,'de','Subscription_Product','Abonnement-Produkt',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5673,'de','Subscriptions','Abonnements',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5674,'de','Billing_Cycle','Abrechnungszyklus',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5675,'de','total_cycles','Gesamtzyklen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5676,'de','remaining_cycles','Verbleibende Zyklen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5677,'de','next_billing_date','Nächstes Abrechnungsdatum',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5678,'de','Failed_to_update_subscription_status','Aktualisierung des Abonnementstatus fehlgeschlagen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5679,'de','Subscription_status_updated_successfully','Abonnementstatus erfolgreich aktualisiert',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5680,'de','Create_Susbscription','Abonnement erstellen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5681,'de','Price_Per_Cycle','Preis pro Zyklus',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5682,'de','Price_Per_Unit','Preis pro Einheit',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5683,'de','Active','Aktiv',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5684,'de','Canceled','Storniert',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5685,'de','Completed','Abgeschlossen',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5686,'de','Subscription_details','Abonnementdetails',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5687,'de','Dynamic_Appearance','Dynamisches Erscheinungsbild',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5688,'de','Payment_Methods','Zahlungsmethoden',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5689,'de','You_cant_edit_or_remove_default_payment_choices','Standard-Zahlungsoptionen können nicht bearbeitet oder entfernt werden',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5690,'de','Enter_Payment_Method','Zahlungsmethode eingeben',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5691,'de','Sales_by_Category','Verkäufe nach Kategorie',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5692,'de','Sales_by_Brand','Verkäufe nach Marke',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5693,'de','Error_Logs','Fehlerprotokolle',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5694,'de','Occurred_At','Aufgetreten am',0,'2025-06-18 01:50:12.000000','2025-06-18 01:50:12.000000'),(5695,'de','Context','Kontext',0,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5696,'de','Report_Transactions','Transaktionen melden',0,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5697,'de','Payment_Method','Zahlungsmethode',0,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5698,'de','Customer_Provider','Kunde/Lieferant',0,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5699,'de','Sale_Purchase_Ref','Verkaufs-/Kaufsreferenz',0,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5700,'en','Draft_Created_successfully','Draft Created successfully',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5701,'en','Draft_Sale_Deleted','Draft Sale Deleted',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5702,'en','Inventory_Valuation_Based_on_Average_Cost','Inventory Valuation Based on Average Cost',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5703,'en','Payroll','Payroll',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5704,'en','Transfers_Money','Transfers Money',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5705,'en','Inventory_Valuation','Inventory Valuation',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5706,'en','Deposits_Report','Deposits Report',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5707,'en','Expense_Report','Expense Report',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5708,'en','Deposit_Category','Deposit category',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5709,'en','Total_Deposits','Total Deposits',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5710,'en','Expense_Category','Expense Category',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5711,'en','Total_Expenses','Total Expenses',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5712,'en','ASSET_VALUE','ASSET VALUE',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5713,'en','STOCK_ON_HAND','STOCK ON HAND',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5714,'en','Variant_NAME','Variant Name',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(5715,'en','SKU','SKU',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5716,'en','ITEM_NAME','ITEM NAME',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5717,'en','From_Account','From Account',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5718,'en','To_Account','To Account',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5719,'en','Accounts_cannot_be_the_same','Accounts cannot be the same',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5720,'en','CountStock','Count Stock',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5721,'en','Successfully_Generated_Count','Successfully Generated',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5722,'en','Count','Count',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5723,'en','file','file',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5724,'en','Accounting','Accounting',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5725,'en','deposit_delete','delete deposit',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5726,'en','deposit_edit','edit deposit',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5727,'en','deposit_add','add deposit',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5728,'en','deposit_view','view deposit',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5729,'en','expense_add','add expense',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5730,'en','expense_edit','edit expense',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5731,'en','expense_delete','delete expense',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5732,'en','List_Deposit','List Deposit',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5733,'en','Create_deposit','Create deposit',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5734,'en','List_accounts','List accounts',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5735,'en','Account','Account',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5736,'en','Choose_Account','Choose Account',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5737,'en','Deposits','Deposits',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5738,'en','account_num','Account num',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5739,'en','Enter_account_num','Enter account num',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5740,'en','account_name','Account name',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5741,'en','Enter_account_name','Enter account name',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5742,'en','initial_balance','Initial balance',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5743,'en','Enter_initial_balance','Enter initial balance',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5744,'en','notes','notes',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5745,'en','balance','Balance',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5746,'en','Receipt','Receipt',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5747,'en','Pos_Settings','POS Settings',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(5748,'en','Note_to_customer','Note to customer',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5749,'en','Show_Note_to_customer','Show Note to customer',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5750,'en','Show_barcode','Show barcode',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5751,'en','Show_Tax_and_Discount','Show Tax & Discount & Shipping',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5752,'en','Show_Customer','Show Customer',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5753,'en','Show_Email','Show Email',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5754,'en','Show_Phone','Show Phone',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5755,'en','Show_Address','Show Address',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5756,'en','DefaultLanguage','Default Language',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5757,'en','footer','footer',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5758,'en','Received_Amount','Received Amount',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5759,'en','Paying_Amount','Paying Amount',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5760,'en','Change','Change Return',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5761,'en','Paying_amount_is_greater_than_Received_amount','Paying amount is greater than received amount',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5762,'en','Paying_amount_is_greater_than_Grand_Total','Paying amount is greater than Grand Total',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5763,'en','code_must_be_not_exist_already','code must be not exist already',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5764,'en','You_will_find_your_backup_on','You will find your backup on',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5765,'en','and_save_it_to_your_pc','and save it to your pc',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5766,'en','Scan_your_barcode_and_select_the_correct_symbology_below','Scan your barcode and select the correct symbology below',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5767,'en','Scan_Search_Product_by_Code_Name','Scan/Search Product by Code Or Name',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5768,'en','Paper_size','Paper size',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5769,'en','Clear_Cache','Clear Cache',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5770,'en','Cache_cleared_successfully','Cache cleared successfully',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5771,'en','Failed_to_clear_cache','Failed to clear cache',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5772,'en','Scan_Barcode','Barcode Scanner',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5773,'en','Please_use_short_name_of_unit','Please use short name of unit',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5774,'en','DefaultCustomer','Default Customer',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5775,'en','DefaultWarehouse','Default Warehouse',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5776,'en','Payment_Gateway','Payment Gateway',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(5777,'en','SMS_Configuration','SMS Configuration',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5778,'en','Gateway','SMS Gateway',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5779,'en','Choose_Gateway','Choose SMS Gateway',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5780,'en','sms_send_successfully','Message sent successfully',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5781,'en','sms_config_invalid','wrong sms config invalid',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5782,'en','Remove_Stripe_Key_Secret','Delete Stripe API keys',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5783,'en','credit_card_account_not_available','Credit card account not available',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5784,'en','Credit_Card_Info','Credit card info',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(5785,'en','developed_by','Developed by',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5786,'en','Unit_already_linked_with_sub_unit','Unit already linked with sub unit',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5787,'en','Total_Items_Quantity','Total Items & Quantity',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5788,'en','Value_by_Cost_and_Price','Value by Cost and Price',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5789,'en','Search_this_table','Search this table',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5790,'en','import_products','Import products',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5791,'en','Field_optional','Field optional',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5792,'en','Download_exemple','Download example',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5793,'en','field_must_be_in_csv_format','Field must be in csv format',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5794,'en','Successfully_Imported','Successfully Imported',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5795,'en','file_size_must_be_less_than_1_mega','File size must be less than 1 mega',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5796,'en','Please_follow_the_import_instructions','Please follow the import instructions',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5797,'en','must_be_exist','unit must already be created',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5798,'en','Import_Customers','Import Customers',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5799,'en','Import_Suppliers','Import Suppliers',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5800,'en','Recent_Sales','Recent Sales',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5801,'en','Create_Transfer','Create Transfer',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5802,'en','order_products','Order items',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5803,'en','Search_Product_by_Code_Name','Search Product by code or name',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5804,'en','Reports_payments_Purchase_Return','Reports Purchase Return Payments',1,'2025-06-18 01:50:13.000000','2025-06-18 01:50:13.000000'),(5805,'en','Reports_payments_Sale_Return','Reports Sale Return Payments',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5806,'en','payments_Sales_Return','Payments Sales Return',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5807,'en','payments_Purchases_Return','Payments Purchases Return',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5808,'en','CreateSaleReturn','Create Sale Return',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5809,'en','EditSaleReturn','Edit Sale Return',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5810,'en','SalesReturn','Sales Return',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5811,'en','CreatePurchaseReturn','Create Purchase Return',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5812,'en','EditPurchaseReturn','Edit Purchase Return',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5813,'en','PurchasesReturn','Purchases Return',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5814,'en','Due','Due',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5815,'en','Profit','Profit',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5816,'en','Revenue','Revenue',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5817,'en','Sales_today','Today Sales',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5818,'en','People','People',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5819,'en','Successfully_Created','Successfully Created',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5820,'en','Successfully_Updated','Successfully Updated',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5821,'en','Success','Success',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5822,'en','Failed','Failed',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5823,'en','Warning','Warning',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5824,'en','Please_fill_the_form_correctly','Please fill the form correctly',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5825,'en','Field_is_required','This Field is required',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5826,'en','Error','Error!',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5827,'en','you_are_not_authorized','Sorry! you are not authorized.',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5828,'en','Go_back_to_home','Go back to homepage',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5829,'en','page_not_exist','Sorry! The page you were looking for doesn\'t exist.',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5830,'en','Choose_Status','Choose status',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(5831,'en','Choose_Method','Choose Method',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5832,'en','Choose_Symbology','Choose symbology',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5833,'en','Choose_Category','Choose Category',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5834,'en','Choose_Customer','Choose Customer',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5835,'en','Choose_Supplier','Choose Supplier',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5836,'en','Choose_Unit_Purchase','Choose Purchase Unit',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5837,'en','Choose_Sub_Category','Choose SubCategory',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5838,'en','Choose_Brand','Choose Brand',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5839,'en','Choose_Warehouse','Choose Warehouse',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5840,'en','Choose_Unit_Sale','Choose Sale Unit',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5841,'en','Enter_Product_Cost','Enter Product Cost',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5842,'en','Enter_Stock_alert','Enter Stock alert',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5843,'en','Choose_Unit_Product','Choose Product Unit',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5844,'en','Enter_Product_Price','Enter Product Price',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5845,'en','Enter_Name_Product','Enter Name Product',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5846,'en','Enter_Role_Name','Enter Role Name',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5847,'en','Enter_Role_Description','Enter Role Description',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5848,'en','Enter_name_category','Enter category Name',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5849,'en','Enter_Code_category','Enter category Code',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5850,'en','Enter_Name_Brand','Enter Name Brand',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5851,'en','Enter_Description_Brand','Enter Description Brand',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5852,'en','Enter_Code_Currency','Enter Code Currency',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5853,'en','Enter_name_Currency','Enter name Currency',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5854,'en','Enter_Symbol_Currency','Enter Symbol Currency',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5855,'en','Enter_Name_Unit','Enter Unit Name',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5856,'en','Enter_ShortName_Unit','Enter shortname Unit',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5857,'en','Choose_Base_Unit','Choose Base Unit',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5858,'en','Choose_Operator','Choose Operator',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5859,'en','Enter_Operation_Value','Enter Operation Value',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5860,'en','Enter_Name_Warehouse','Enter Warehouse Name',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5861,'en','Enter_Phone_Warehouse','Enter Warehouse Phone',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5862,'en','Enter_Country_Warehouse','Enter Warehouse Country',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5863,'en','Enter_City_Warehouse','Enter Warehouse City',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5864,'en','Enter_Email_Warehouse','Enter Warehouse Email',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5865,'en','Enter_ZipCode_Warehouse','Enter Warehouse Zip Code',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5866,'en','Choose_Currency','Choose Currency',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5867,'en','Thank_you_for_your_business','Thank you for shopping with us . Please come again',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5868,'en','Cancel','Cancel',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5869,'en','New_Customer','New Customer',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5870,'en','Incorrect_Login','Incorrect Login',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5871,'en','Successfully_Logged_In','Successfully Logged In',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5872,'en','This_user_not_active','This user not active',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5873,'en','SignIn','Sign In',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5874,'en','Create_an_account','Create an account',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5875,'en','Forgot_Password','Forgot Password ?',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5876,'en','Email_Address','Email Address',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5877,'en','SignUp','Sign Up',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5878,'en','Already_have_an_account','Already have an account ?',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5879,'en','Reset_Password','Reset Password',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5880,'en','Failed_to_authenticate_on_SMTP_server','Failed to authenticate on SMTP server',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5881,'en','We_cant_find_a_user_with_that_email_addres','We can\'t find a user with that email addres',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5882,'en','We_have_emailed_your_password_reset_link','We have e-mailed your password reset link',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5883,'en','Please_fill_the_Email_Adress','Please fill the Email Address',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5884,'en','Confirm_password','Confirm password',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5885,'en','Your_Password_has_been_changed','Your Password has been changed',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5886,'en','The_password_confirmation_does_not_match','The password confirmation does not match',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5887,'en','This_password_reset_token_is_invalid','This password reset token is invalid',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5888,'en','Warehouse_report','Warehouses report',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5889,'en','All_Warehouses','All Warehouses',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5890,'en','Expense_List','All Expenses',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5891,'en','Expenses','Expenses',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5892,'en','This_Week_Sales_Purchases','This Week Sales & Purchases',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5893,'en','Top_Selling_Products','Top Selling Products',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5894,'en','View_all','View all',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5895,'en','Payment_Sent_Received','Payment Sent & Received',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5896,'en','Filter','Filter',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5897,'en','Invoice_POS','Invoice POS',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5898,'en','Invoice','Invoice',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5899,'en','Customer_Info','Customer Info',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5900,'en','Company_Info','Company Info',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5901,'en','Invoice_Info','Invoice Info',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5902,'en','Order_Summary','Order Summary',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5903,'en','Quote_Info','Quotation Info',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5904,'en','Del','Delete',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5905,'en','SuppliersPaiementsReport','Suppliers Payments Report',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5906,'en','Purchase_Info','Purchase Info',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5907,'en','Supplier_Info','Supplier Info',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5908,'en','Return_Info','Info of Return',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5909,'en','Create_Expense','Create Expense',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5910,'en','Details','Details',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5911,'en','Discount_Method','Discount Type',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5912,'en','Net_Unit_Cost','Net Unit Cost',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5913,'en','Net_Unit_Price','Net Unit Price',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5914,'en','Edit_Expense','Edit Expense',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5915,'en','All_Brand','All Brand',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5916,'en','All_Category','All Category',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5917,'en','ListExpenses','All Expenses',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5918,'en','Create_Permission','Create Permission',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5919,'en','Edit_Permission','Edit Permission',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5920,'en','Reports_payments_Sales','Reports payments Sales',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5921,'en','Reports_payments_Purchases','Reports payments Purchases',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5922,'en','Reports_payments_Return_Customers','Payments Return Customers',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5923,'en','Reports_payments_Return_Suppliers','Payments Return Suppliers',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5924,'en','Expense_Deleted','This Expense has been deleted',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5925,'en','Expense_Updated','This Expense has been Updated',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5926,'en','Expense_Created','This Expense has been Created',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5927,'en','DemoVersion','You cannot do this in the demo version',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5928,'en','OrderStatistics','Sales Statistics',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5929,'en','AlreadyAdd','This Product Already Added !!',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5930,'en','AddProductToList','Please Add Product To List !!',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5931,'en','AddQuantity','Please Add quantity of product !!',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5932,'en','InvalidData','Something went wrong',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5933,'en','LowStock','Quantity exceeds quantity available in stock',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5934,'en','WarehouseIdentical','The two warehouses cannot be identical !!',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5935,'en','VariantDuplicate','This Variant Is Duplicate !!',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5936,'en','Filesize','File size',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5937,'en','GenerateBackup','Generate Backup',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5938,'en','BackupDatabase','Backup Database',1,'2025-06-18 01:50:14.000000','2025-06-18 01:50:14.000000'),(5939,'en','Backup','Backup',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5940,'en','Paid','Paid',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5941,'en','Unpaid','Unpaid',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5942,'en','Today','Today',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5943,'en','Income','Income',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5944,'en','Sale','Sale',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5945,'en','Actif','Active',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5946,'en','Inactif','Inactive',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5947,'en','Customers','Customers',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5948,'en','Phone','Phone',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5949,'en','SearchByPhone','Search by Phone',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5950,'en','Suppliers','Suppliers',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5951,'en','Quotations','Quotations',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5952,'en','Sales','Sales',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5953,'en','Purchases','Purchases',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5954,'en','Returns','Return',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5955,'en','Settings','Settings',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5956,'en','SystemSettings','System Settings',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5957,'en','Users','Users',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5958,'en','GroupPermissions','Group Permissions',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5959,'en','Currencies','Currency',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5960,'en','Warehouses','Warehouse',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5961,'en','Units','Unit',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5962,'en','UnitsPrchases','Purchases Units',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5963,'en','UnitsSales','Sales Units',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5964,'en','Reports','Reports',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5965,'en','PaymentsReport','Payments Report',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5966,'en','PaymentsPurchases','Payments Purchases',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5967,'en','PaymentsSales','Payments Sales',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5968,'en','ProfitandLoss','Profit and Loss',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5969,'en','WarehouseStockChart','Warehouse Stock Chart',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5970,'en','SalesReport','Sales Report',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5971,'en','PurchasesReport','Purchases Report',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5972,'en','CustomersReport','Customers Report',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5973,'en','SuppliersReport','Suppliers Report',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5974,'en','SupplierReport','Supplier Report',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5975,'en','DailySalesData','Daily Sales Data',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5976,'en','DailyPurchasesData','Daily Purchases Data',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5977,'en','Dernièrescinqrecords','Last five records',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5978,'en','Filters','Filters',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5979,'en','date','Date',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5980,'en','Reference','Reference',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5981,'en','Supplier','Supplier',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5982,'en','PaymentStatus','Payment Status',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5983,'en','Customer','Customer',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5984,'en','CustomerCode','Customer Code',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5985,'en','Status','Status',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5986,'en','SupplierCode','Supplier Code',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5987,'en','Categorie','Category',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5988,'en','Categories','Category',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5989,'en','StockTransfers','Transfer',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5990,'en','StockManagement','Stock Management',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5991,'en','dashboard','Dashboard',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5992,'en','Products','Products',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5993,'en','productsList','All Products',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5994,'en','ProductManagement','Product Management',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5995,'en','ProductQuantityAlerts','Product Quantity Alerts',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5996,'en','CodeProduct','Code Product',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5997,'en','ProductTax','Product Tax',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5998,'en','SubCategorie','Sub Category',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(5999,'en','Name_product','Name',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6000,'en','StockAlert','Stock Alert',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6001,'en','warehouse','Warehouse',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6002,'en','Tax','Tax',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6003,'en','BuyingPrice','Buying price',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6004,'en','SellPrice','Sell price',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6005,'en','Quantity','Quantity',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6006,'en','UnitSale','Sale Unit',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6007,'en','UnitPurchase','Purchase Unit',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6008,'en','ManagementCurrencies','Currency Management',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6009,'en','CurrencyCode','Currency Code',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6010,'en','CurrencyName','Currency Name',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6011,'en','Symbol','Symbol',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6012,'en','All','All',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6013,'en','EditProduct','Edit Product',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6014,'en','SearchByCode','Search by Code',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6015,'en','SearchByName','Search by Name',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6016,'en','ProductDetails','Product Details',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6017,'en','CustomerName','Customer Name',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6018,'en','CustomerManagement','Customer Management',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6019,'en','Add','Create',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6020,'en','Edit','Edit',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6021,'en','Close','Close',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6022,'en','PleaseSelect','Please Select',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6023,'en','Action','Action',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6024,'en','Email','Email',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6025,'en','EditCustomer','Edit Customer',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6026,'en','AddCustomer','Create Customer',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6027,'en','Country','Country',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6028,'en','City','City',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6029,'en','Adress','Address',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6030,'en','CustomerDetails','Customer Details',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6031,'en','CustomersList','Customers',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6032,'en','SupplierName','Supplier Name',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6033,'en','SuppliersManagement','Suppliers Management',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6034,'en','SupplierDetails','Supplier Details',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6035,'en','QuotationsManagement','Quotations Management',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6036,'en','SubTotal','Subtotal',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6037,'en','MontantReste','Amount left',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6038,'en','complete','Completed',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6039,'en','EnAttendant','Pending',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6040,'en','Recu','Received',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6041,'en','partial','Partial',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6042,'en','Retournee','Return',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6043,'en','DetailQuote','Detail Quotation',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6044,'en','EditQuote','Edit Quotation',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6045,'en','CreateSale','Create Sale',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6046,'en','DownloadPdf','Download Pdf',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6047,'en','QuoteEmail','Send Quotation on Email',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6048,'en','DeleteQuote','Delete Quotation',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6049,'en','AddQuote','Create Quotation',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6050,'en','SelectProduct','Select Product',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6051,'en','ProductCodeName','Product (Code - Name)',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6052,'en','Price','Price',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6053,'en','CurrentStock','Stock',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6054,'en','Total','Grand Total',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6055,'en','Num','N°',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6056,'en','Unitcost','Unit cost',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6057,'en','to','To',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6058,'en','Subject','Subject',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6059,'en','Message','Message',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6060,'en','EmailCustomer','Email Customer',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6061,'en','Sent','Sent',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6062,'en','Quote','Quotation',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6063,'en','Hello','Hello',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6064,'en','AttachmentQuote','Please find the attachment for your Quotation',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6065,'en','AddProducts','Add Products to the Order List',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6066,'en','SelectWarehouse','Please Select warehouse',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6067,'en','SelectCustomer','please Select Customer',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6068,'en','SalesManagement','Sales Management',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6069,'en','QtyBack','Qty Back',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6070,'en','TotalReturn','Total Return',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6071,'en','Amount','Amount',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6072,'en','SaleDetail','Sale Detail',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6073,'en','EditSale','Edit Sale',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6074,'en','AddSale','Create Sale',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6075,'en','ShowPayment','Show Payments',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6076,'en','AddPayment','Create Payment',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6077,'en','EditPayment','Edit Payment',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6078,'en','EmailSale','Send Sale on Email',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6079,'en','DeleteSale','Delete Sale',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6080,'en','ModePaiement','Paid by',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6081,'en','Paymentchoice','Payment choice',1,'2025-06-18 01:50:15.000000','2025-06-18 01:50:15.000000'),(6082,'en','Note','Note',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6083,'en','PaymentComplete','Payment complete!',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6084,'en','PurchasesManagement','Purchases Management',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6085,'en','Ordered','Ordered',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6086,'en','DeletePurchase','Delete Purchase',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6087,'en','EmailPurchase','Send Purchase on Email',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6088,'en','EditPurchase','Edit Purchase',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6089,'en','PurchaseDetail','Purchase Detail',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6090,'en','AddPurchase','Create Purchase',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6091,'en','EmailSupplier','Supplier Email',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6092,'en','PurchaseInvoice','Purchases payments',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6093,'en','PurchasesInvoicesData','Purchases payments data',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6094,'en','SalesInvoice','Sales payments',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6095,'en','SalesInvoicesData','Sales payments data',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6096,'en','UserManagement','Users management',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6097,'en','Firstname','First Name',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6098,'en','lastname','Last Name',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6099,'en','username','Username',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6100,'en','password','Password',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6101,'en','Newpassword','New password',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6102,'en','ChangeAvatar','Change Avatar',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6103,'en','LeaveBlank','Please leave this field blank if you haven\'t changed it',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6104,'en','type','Type',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6105,'en','UserPermissions','Users Permissions',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6106,'en','RoleName','Role',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6107,'en','RoleDescription','Role Description',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6108,'en','AddPermissions','Create Permissions',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6109,'en','View','View',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6110,'en','NewAdjustement','New Adjustement',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6111,'en','EditAdjustement','Edit Adjustement',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6112,'en','CannotSubstraction','You cannot subtraction products which have stock 0',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6113,'en','Addition','Addition',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6114,'en','Subtraction','Subtraction',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6115,'en','profil','Profile',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6116,'en','logout','Logout',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6117,'en','PurchaseAlreadyPaid','You cannot modify because this Purchase already paid',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6118,'en','SaleAlreadyPaid','You cannot modify because this Sale already paid',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6119,'en','ReturnAlreadyPaid','You cannot modify because this Return already paid',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6120,'en','QuoteAlready','This quote already has generate sale',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6121,'en','AddProduct','Create product',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6122,'en','QuotationComplete','This Quotation Complete',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6123,'en','SiteConfiguration','Site Configuration',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6124,'en','Language','Language',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6125,'en','DefaultCurrency','Default Currency',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6126,'en','LoginCaptcha','Login Captcha',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6127,'en','DefaultEmail','Default Email',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6128,'en','SiteName','Site Name',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6129,'en','ChangeLogo','Change Logo',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6130,'en','SMTPConfiguration','SMTP Configuration',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6131,'en','HOST','MAIL_HOST',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6132,'en','PORT','MAIL_PORT',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6133,'en','encryption','MAIL_ENCRYPTION',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6134,'en','SMTPIncorrect','SMTP Configuration Incorrect',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6135,'en','PaymentsReturns','Payments Returns',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6136,'en','ReturnsInvoices','Returns Invoices',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6137,'en','ReturnsInvoicesData','Returns Invoices Data',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6138,'en','ShowAll','View all records of all Users',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6139,'en','Discount','Discount',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6140,'en','OrderTax','Order Tax',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6141,'en','Shipping','Shipping',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6142,'en','CompanyName','Company Name',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6143,'en','CompanyPhone','Company Phone',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6144,'en','CompanyAdress','Company Address',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6145,'en','Code','Code',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6146,'en','image','Image',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6147,'en','Printbarcode','Print Labels',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6148,'en','ReturnsCustomers','Returns Customer',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6149,'en','ReturnsSuppliers','Returns Supplier',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6150,'en','FactureReturnCustomers','Return Customer Invoice',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6151,'en','FactureReturnSuppliers','Return Supplier Invoice',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6152,'en','NodataAvailable','No data Available',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6153,'en','ProductImage','Product Image',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6154,'en','Barcode','Barcode',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6155,'en','pointofsales','Point of Sales',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6156,'en','CustomUpload','Custom Upload',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6157,'en','pointofsaleManagement','Point of Sale Management',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6158,'en','Adjustment','Adjustment',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6159,'en','Updat','Update',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6160,'en','Reset','Reset',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6161,'en','print','Print',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6162,'en','SearchByEmail','Search By Email',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6163,'en','ChooseProduct','Choose Product',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6164,'en','Qty','Qty',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6165,'en','Items','Items',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6166,'en','AmountHT','Amount HT',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6167,'en','AmountTTC','Amount TTC',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6168,'en','PleaseSelectSupplier','Please Select Supplier',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6169,'en','PleaseSelectStatut','Please Select Status',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6170,'en','PayeBy','Paid By',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6171,'en','ChooseWarehouse','Choose Warehouse',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6172,'en','payNow','Pay Now',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6173,'en','ListofCategory','List of Category',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6174,'en','Description','Description',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6175,'en','submit','Submit',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6176,'en','ProblemCreatingThisInvoice','There was a problem creating this Invoice. Please try again',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6177,'en','ProblemPayment','There was a problem Payment. Please try again.',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6178,'en','IncomeExpenses','Income & Expenses',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6179,'en','dailySalesPurchases','Daily Sales & Purchases',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6180,'en','ProductsExpired','Products Expired',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6181,'en','ListofBrand','Brands',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6182,'en','CreateAdjustment','Create Adjustment',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6183,'en','Afewwords','A few words ...',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6184,'en','UserImage','User Image',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6185,'en','UpdateProduct','Update Product',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6186,'en','Brand','Brand',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6187,'en','BarcodeSymbology','Barcode Symbology',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6188,'en','ProductCost','Product Cost',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6189,'en','ProductPrice','Product Price',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6190,'en','UnitProduct','Product Unit',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6191,'en','TaxMethod','Tax Type',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6192,'en','MultipleImage','Multiple Image',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6193,'en','ProductHasMultiVariants','This Product Has Multi Variants',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6194,'en','ProductHasPromotion','Product Has Promotion',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6195,'en','PromotionStart','Promotion Start',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6196,'en','PromotionEnd','Promotion End',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6197,'en','PromotionPrice','Promotion Price',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6198,'en','Cost','Cost',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6199,'en','Unit','Unit',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6200,'en','ProductVariant','Product Variant',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6201,'en','Variant','Variant',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6202,'en','UnitPrice','Unit Price',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6203,'en','CreateReturnCustomer','Create Return Customer',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6204,'en','EditReturnCustomer','Edit Return Customer',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6205,'en','CreateReturnSupplier','Create Return Supplier',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6206,'en','Documentation','Doc',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6207,'en','EditReturnSupplier','Edit Return Supplier',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6208,'en','FromWarehouse','From Warehouse',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6209,'en','ToWarehouse','To Warehouse',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6210,'en','EditTransfer','Edit Transfer',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6211,'en','TransferDetail','Transfer Detail',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6212,'en','Pending','Pending',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6213,'en','Received','Received',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6214,'en','PermissionsManager','Permissions Management',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6215,'en','BrandManager','Brand',1,'2025-06-18 01:50:16.000000','2025-06-18 01:50:16.000000'),(6216,'en','BrandImage','Brand Image',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6217,'en','BrandName','Brand Name',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6218,'en','BrandDescription','Brand Description',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6219,'en','BaseUnit','Base Unit',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6220,'en','ManagerUnits','Units Management',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6221,'en','OperationValue','Operation Value',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6222,'en','Operator','Operator',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6223,'en','Top5Products','Top 5 Products',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6224,'en','Last5Sales','Last 5 Sales',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6225,'en','ListAdjustments','All Adjustments',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6226,'en','ListTransfers','All Transfers',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6227,'en','CreateTransfer','Create Transfer',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6228,'en','OrdersManager','Orders Management',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6229,'en','ListQuotations','All Quotations',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6230,'en','ListPurchases','All Purchases',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6231,'en','ListSales','All Sales',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6232,'en','ListReturns','All Returns',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6233,'en','PeopleManager','People Management',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6234,'en','Delete_Title','Are you sure?',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6235,'en','Delete_Text','You won\'t be able to revert this!',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6236,'en','Delete_confirmButtonText','Yes, delete it!',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6237,'en','Delete_cancelButtonText','Cancel',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6238,'en','Delete_Deleted','Deleted!',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6239,'en','Delete_Failed','Failed!',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6240,'en','Delete_Therewassomethingwronge','There was something wronge',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6241,'en','SendEmail','Email Send in successfully',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6242,'en','erroSale','This sale already linked with a Return!',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6243,'en','ReturnManagement','Return Management',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6244,'en','ReturnDetail','Return Detail',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6245,'en','EditReturn','Edit Return',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6246,'en','AddReturn','Create Return',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6247,'en','EmailReturn','Send Return on Email',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6248,'en','DeleteReturn','Delete Return',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6249,'en','Retoursurcharge','Return Surcharge',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6250,'en','Laivrison','Delivery',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6251,'en','SelectSale','Select Sale',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6252,'en','ZeroPardefault','You can delete the item or set the quantity returned to zero if it is not returned',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6253,'en','Return','Return',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6254,'en','Purchase','Purchase',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6255,'en','TotalSales','Total Sales',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6256,'en','TotalPurchases','Total Purchases',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6257,'en','TotalReturns','Total Returns',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6258,'en','PaiementsNet','Payments Net',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6259,'en','PaiementsSent','Payments Sent',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6260,'en','PaiementsReceived','Payments Received',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6261,'en','Recieved','Recieved',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6262,'en','ProductCode','Code',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6263,'en','ProductName','Product',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6264,'en','AlertQuantity','Alert Quantity',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6265,'en','TotalProducts','Total Products',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6266,'en','TotalQuantity','Total Quantity',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6267,'en','TopCustomers','Top 5 Customers',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6268,'en','TotalAmount','Total Amount',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6269,'en','TotalPaid','Total Paid',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6270,'en','CustomerSalesReport','Customer Sales Report',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6271,'en','CustomerPaiementsReport','Customer Payments Report',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6272,'en','CustomerQuotationsReport','Customer Quotations Report',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6273,'en','Payments','Payments',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6274,'en','TopSuppliers','Top 5 Suppliers',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6275,'en','SupplierPurchasesReport','Supplier Purchases Report',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6276,'en','SupplierPaiementsReport','Supplier Payments Report',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6277,'en','Name','Name',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6278,'en','ManagementWarehouse','Warehouse Management',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6279,'en','ZipCode','Zip Code',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6280,'en','managementCategories','Categories management',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6281,'en','Codecategorie','Category Code',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6282,'en','Namecategorie','Category Name',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6283,'en','Parentcategorie','Parent category',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6284,'en','managementTax','Tax management',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6285,'en','TaxName','Tax Name',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6286,'en','TaxRate','Tax Rate',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6287,'en','managementUnitPurchases','Purchases Unit',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6288,'en','managementUnitSales','Sales Unit',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6289,'en','ShortName','Short Name',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6290,'en','PleaseSelectThesebeforeaddinganyproduct','Please Select These before adding any product',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6291,'en','StockAdjustement','Adjustment',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6292,'en','PleaseSelectWarehouse','Please Select warehouse before choose any product',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6293,'en','StockTransfer','Stock Transfer',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6294,'en','SelectPeriod','Select Period',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6295,'en','ThisYear','This Year',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6296,'en','ThisToday','This Today',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6297,'en','ThisMonth','This Month',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6298,'en','ThisWeek','This Week',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6299,'en','AdjustmentDetail','Adjustment Detail',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6300,'en','ActivateUser','This User Has been Activated',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6301,'en','DisActivateUser','This User Has been Deactivated',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6302,'en','NotFound','Page not found.',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6303,'en','oops','Oops! Page not found.',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6304,'en','couldNotFind','We could not find the page you were looking for.Meanwhile, you may',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6305,'en','ReturnDashboard','Return to dashboard',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6306,'en','hrm','HRM',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6307,'en','Employees','Employees',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6308,'en','Attendance','Attendance',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6309,'en','Leave_request','Leave Request',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6310,'en','Leave_type','Leave Type',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6311,'en','Company','Company',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6312,'en','Departments','Departments',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6313,'en','Designations','Designations',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6314,'en','Office_Shift','Office Shift',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6315,'en','Holidays','Holidays',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6316,'en','Enter_Company_Name','Enter company name',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6317,'en','Enter_email_address','Enter email address',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6318,'en','Enter_Company_Phone','Enter company phone',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6319,'en','Enter_Company_Country','Enter company country',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6320,'en','Created_in_successfully','Created in successfully',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6321,'en','Updated_in_successfully','Updated in successfully',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6322,'en','Deleted_in_successfully','Deleted in successfully',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6323,'en','department','Department',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6324,'en','Enter_Department_Name','Enter department name',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6325,'en','Choose_Company','Choose Company',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6326,'en','Department_Head','Department Head',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6327,'en','Choose_Department_Head','Choose Department Head',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6328,'en','Enter_Shift_name','Enter Shift name',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6329,'en','Monday_In','Monday In',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6330,'en','Monday_Out','Monday Out',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6331,'en','Tuesday_In','Tuesday In',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6332,'en','tuesday_out','tuesday Out',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6333,'en','wednesday_in','Wednesday In',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6334,'en','wednesday_out','Wednesday Out',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6335,'en','thursday_in','Thursday In',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6336,'en','thursday_out','Thursday Out',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6337,'en','friday_in','Friday In',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6338,'en','friday_out','Friday Out',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6339,'en','saturday_in','Saturday In',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6340,'en','saturday_out','Saturday Out',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6341,'en','sunday_in','Sunday In',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6342,'en','sunday_out','Sunday Out',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6343,'en','Holiday','Holiday',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6344,'en','Enter_title','Enter title',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6345,'en','title','title',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6346,'en','start_date','Start date',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6347,'en','Enter_Start_date','Enter start date',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6348,'en','Finish_Date','Finish date',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6349,'en','Enter_Finish_date','Enter finish date',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6350,'en','Please_provide_any_details','Please provide any details',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6351,'en','Attendances','Attendances',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6352,'en','Enter_Attendance_date','Enter attendance date',1,'2025-06-18 01:50:17.000000','2025-06-18 01:50:17.000000'),(6353,'en','Time_In','Time In',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6354,'en','Time_Out','Time Out',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6355,'en','Choose_Employee','Choose Employee',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6356,'en','Employee','Employee',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6357,'en','Work_Duration','Work Duration',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6358,'en','remaining_leaves_are_insufficient','Remaining leaves are insufficient',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6359,'en','Days','Days',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6360,'en','Choose_leave_type','Choose leave type',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6361,'en','Leave_Reason','Leave Reason',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6362,'en','Enter_Reason_Leave','Enter Reason Leave',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6363,'en','Add_Employee','Add Employee',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6364,'en','Enter_FirstName','Enter First Name',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6365,'en','Enter_LastName','Enter Last Name',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6366,'en','Gender','Gender',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6367,'en','Choose_Gender','Choose Gender',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6368,'en','Enter_Birth_date','Enter birth date',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6369,'en','Birth_date','Birth date',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6370,'en','Enter_Country','Enter Country',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6371,'en','Enter_Phone_Number','Enter Phone Number',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6372,'en','joining_date','Joining date',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6373,'en','Enter_joining_date','Enter joining date',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6374,'en','Choose_Designation','Choose Designation',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6375,'en','Designation','Designation',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6376,'en','Choose_Office_Shift','Choose Office Shift',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6377,'en','Enter_Leaving_Date','Enter Leaving Date',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6378,'en','Leaving_Date','Leaving Date',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6379,'en','Annual_Leave','Annual Leave',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6380,'en','Enter_Annual_Leave','Enter Annual Leave',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6381,'en','Remaining_leave','Remaining leave',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6382,'en','Employee_Details','Employee Details',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6383,'en','Basic_Information','Basic Information',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6384,'en','Family_status','Family Status',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6385,'en','Choose_Family_status','Choose Family status',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6386,'en','Employment_type','Employment type',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6387,'en','Select_Employment_type','Select Employment type',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6388,'en','Enter_City','Enter City',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6389,'en','Province','Province',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6390,'en','Enter_Province','Enter Province',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6391,'en','Enter_Address','Enter Address',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6392,'en','Enter_Zip_code','Enter Zip code',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6393,'en','Zip_code','Zip code',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6394,'en','Hourly_rate','Hourly rate',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6395,'en','Enter_Hourly_rate','Enter Hourly rate',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6396,'en','Basic_salary','Basic salary',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6397,'en','Enter_Basic_salary','Enter Basic salary',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6398,'en','Social_Media','Social Media',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6399,'en','Skype','Skype',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6400,'en','Enter_Skype','Enter Skype',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6401,'en','Facebook','Facebook',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6402,'en','Enter_Facebook','Enter Facebook',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6403,'en','WhatsApp','WhatsApp',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6404,'en','Enter_WhatsApp','Enter WhatsApp',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6405,'en','LinkedIn','LinkedIn',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6406,'en','Enter_LinkedIn','Enter LinkedIn',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6407,'en','Twitter','Twitter',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6408,'en','Enter_Twitter','Enter Twitter',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6409,'en','Experiences','Experiences',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6410,'en','bank_account','bank account',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6411,'en','Company_Name','Company Name',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6412,'en','Location','Location',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6413,'en','Enter_location','Enter location',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6414,'en','Enter_Description','Enter Description',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6415,'en','Bank_Name','Bank Name',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6416,'en','Enter_Bank_Name','Enter Bank Name',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6417,'en','Bank_Branch','Bank Branch',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6418,'en','Enter_Bank_Branch','Enter Bank Branch',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6419,'en','Bank_Number','Bank Number',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6420,'en','Enter_Bank_Number','Enter Bank Number',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6421,'en','Assigned_warehouses','Access warehouses',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6422,'en','Top_customers','Best customers',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6423,'en','Attachment','Attachment',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6424,'en','view_employee','view employee',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6425,'en','edit_employee','Edit employee',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6426,'en','delete_employee','Delete employee',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6427,'en','Created_by','Added by',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6428,'en','Add_product_IMEI_Serial_number','Add product IMEI/Serial Number',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6429,'en','Product_Has_Imei_Serial_number','Product Has Imei/Serial Number',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6430,'en','IMEI_SN','IMEI/SN',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6431,'en','Shipments','Shipments',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6432,'en','delivered_to','Delivered To',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6433,'en','shipment_ref','Shipment Ref',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6434,'en','sale_ref','Sale Ref',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6435,'en','Edit_Shipping','Edit Shipping',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6436,'en','Packed','Packed',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6437,'en','Shipped','Shipped',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6438,'en','Delivered','Delivered',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6439,'en','Cancelled','Cancelled',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6440,'en','Shipping_status','Shipping Status',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6441,'en','Users_Report','Users Report',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6442,'en','stock_report','Stock Report',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6443,'en','Total_quotations','Total Quotations',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6444,'en','Total_return_sales','Total return sales',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6445,'en','Total_return_purchases','Total return purchases',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6446,'en','Total_transfers','Total transfers',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6447,'en','Total_adjustments','Total adjustments',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6448,'en','User_report','User Report',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6449,'en','Current_stock','Current Stock',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6450,'en','product_name','Product Name',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6451,'en','Total_Customers_Due','Total Debt',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6452,'en','Total_Suppliers_Due','Total Debt',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6453,'en','Some_warehouses','Some Warehouses',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6454,'en','Product_Cost','Product Cost',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6455,'en','sms_settings','Sms Settings',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6456,'en','mail_settings','Mail Settings',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6457,'en','Nexmo_SMS','Nexmo SMS',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6458,'en','TWILIO_SMS','TWILIO SMS',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6459,'en','Default_SMS_Gateway','Default SMS Gateway',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6460,'en','module_settings','Module Settings',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6461,'en','Module_enabled_success','Module enabled successfully',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6462,'en','Module_Disabled_success','Module Disabled successfully',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6463,'en','update_settings','Upgrade',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6464,'en','Please_Upload_the_Correct_Module','Please Upload the Correct Module',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6465,'en','Uploaded_Success','Uploaded in successfully',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6466,'en','Customer_details','Customer Details',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6467,'en','Edit_Customer','Edit Customer',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6468,'en','Delete_Customer','Delete Customer',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6469,'en','Pay_Due','Pay Due',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6470,'en','Paying_amount_is_greater_than_Total_Due','Paying amount is greater than Total Due',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6471,'en','Customer_Invoice','Customer Invoice',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6472,'en','This_Product_Not_For_Selling','This Product Not For Selling',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6473,'en','Welcome_to_your_Dashboard','Welcome to your Dashboard',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6474,'en','Total_Payable','Total Payable',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6475,'en','Choose_Sale_Ref','Choose Sale Ref',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6476,'en','Please_Select_Sale','Please Select Sale',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6477,'en','list_product_returns','list product returns',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6478,'en','Qty_return','Qty return',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6479,'en','Choose_Purchase_Ref','Choose Purchase Ref',1,'2025-06-18 01:50:18.000000','2025-06-18 01:50:18.000000'),(6480,'en','Purchase_Ref','Purchase Ref',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6481,'en','please_select_purchase','Please Select Purchase',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6482,'en','qty_return_is_greater_than_qty_purchased','Qty return is greater than Qty purchased',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6483,'en','qty_return_is_greater_than_qty_sold','Qty return is greater than Qty sold',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6484,'en','Quantity_sold','Qty sold',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6485,'en','qty_purchased','Qty purchased',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6486,'en','Sender_Name','Sender Name',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6487,'en','The_module_must_be_uploaded_as_zip_file','The module must be uploaded as zip file',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6488,'en','Upload_Module','Upload Module',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6489,'en','All_Modules_Installed','All Modules Installed',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6490,'en','Current_Version','Current Version',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6491,'en','You_already_have_the_latest_version','You already have the latest version',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6492,'en','Update_Available','Update Available',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6493,'en','Update_Log','Update Log',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6494,'en','Update_Now','Update Now',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6495,'en','View_Change_Log','View Change Log',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6496,'en','Please_Wait_for_the_update','Please Wait for the update to finish completely. It is not recommended to close the browser or stop a process Upgrade',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6497,'en','Note_update','Make sure you backup your Current version & database before you run the Upgrade , To restore it if there is an error',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6498,'en','invoice_footer','Invoice footer',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6499,'en','Time_Zone','Time Zone',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6500,'en','Payment_note','Payment notes',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6501,'en','sale_note','Sale notes',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6502,'en','Total_Sale_Due','Total Sale Due',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6503,'en','Total_Sell_Return_Due','Total Sell Return Due',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6504,'en','pay_all_sell_due_at_a_time','pay all sell due at a time',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6505,'en','pay_all_sell_return_due_at_a_time','pay all sell return due at a time',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6506,'en','Gross_Profit','Gross Profit',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6507,'en','pay_all_purchase_due_at_a_time','pay all purchase due at a time',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6508,'en','Delete_Provider','Delete Provider',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6509,'en','Edit_Provider','Edit Provider',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6510,'en','Provider_details','Provider details',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6511,'en','Total_Purchase_Due','Total Purchase Due',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6512,'en','Provider_Credit_Note','Provider Credit Note',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6513,'en','Customer_Credit_Note','Customer Credit Note',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6514,'en','Sell_Return','Sell Return',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6515,'en','Purchase_Return','Purchase Return',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6516,'en','Tax_Number','Tax Number',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6517,'en','Please_add_return_quantity','Please add return quantity',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6518,'en','Return_exist_for_the_Transaction','Return exist for the Transaction',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6519,'en','qty_return_is_greater_than_Quantity_Remaining','Qty return is greater than Quantity Remaining',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6520,'en','products_refunded_alert','Any products with a quantity set to 0 won\'t be refunded',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6521,'en','pay_all_purchase_return_due_at_a_time','pay all purchase return due at a time',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6522,'en','Total_Purchase_Return_Due','Total Purchase Return Due',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6523,'en','Purchase_return_due','Purchase return due',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6524,'en','Sell_return_due','Sell return due',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6525,'en','product_report','Products report',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6526,'en','product_sales_report','Product sales report',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6527,'en','Product_purchases_report','Product purchases report',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6528,'en','Qty_sold','Qty sold',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6529,'en','Filter_by_warehouse','Filter by warehouse',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6530,'en','Enable_Print_Invoice','Print Invoice automatically',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6531,'en','Show_Warehouse','Show warehouse',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6532,'en','Saved_Credit_Card_Info','Saved Credit Card Info',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6533,'en','Credit_card_changed_successfully','Credit card changed successfully',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6534,'en','notification_template','Notification Template',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6535,'en','email_notification','Email notification',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6536,'en','sms_notification','SMS notification',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6537,'en','Change_product_details','Change product details',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6538,'en','edit_tax_and_discount_and_shipping','edit tax and discount and shipping',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6539,'en','Create_Quotation_with_Stock','Create Quotation with Stock',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6540,'en','Variant_cost','Variant cost',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6541,'en','Variant_price','Variant price',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6542,'en','Variant_code','Variant code',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6543,'en','Please_wait_until_the_product_is_loaded','Please wait until the product is loaded',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6544,'en','Choose_SMS_Gateway','Choose SMS Gateway',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6545,'en','Notification_Client','Notification Client',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6546,'en','Available_Tags','Available Tags',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6547,'en','Email_Subject','Email Subject',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6548,'en','Email_body','Email body',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6549,'en','Notification_Supplier','Notification Supplier',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6550,'en','sms_body','SMS body',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6551,'en','sms_templates','SMS Templates',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6552,'en','email_templates','Email Templates',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6553,'en','Edit_Project','Edit Project',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6554,'en','Projects','Projects',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6555,'en','Enter_Project_Title','Enter Project Title',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6556,'en','Assigned_Employees','Assigned Employees',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6557,'en','Choose_Team','Choose Team',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6558,'en','Create_Project','Create Project',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6559,'en','Project_List','Project List',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6560,'en','Not_Started','Not Started',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6561,'en','In_Progress','In Progress',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6562,'en','On_Hold','On Hold',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6563,'en','Edit_Task','Edit Task',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6564,'en','Tasks','Tasks',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6565,'en','Enter_Task_Title','Enter Task Title',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6566,'en','Choose_Project','Choose Project',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6567,'en','Project','Project',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6568,'en','Create_Task','Create Task',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6569,'en','Task_List','Task List',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6570,'en','Import_Purchases','Import Purchases',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6571,'en','Warranty_Period','Warranty Period',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6572,'en','Months','Months',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6573,'en','Years','Years',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6574,'en','WarrantyTerms','Warranty Terms',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6575,'en','HasGuarantee','Has Guarantee',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6576,'en','Guarantee_Period','Guarantee Period',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6577,'en','OpeningStock','Opening Stock',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6578,'en','Warranty_Guarantee_Tracking','Warranty & Guarantee Tracking',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6579,'en','PaymentOption','Payment Option',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6580,'en','AddAnotherPaymentOption','Add Another Payment Option',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6581,'en','PopularTendered','Popular Tendered',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6582,'en','clear','clear',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6583,'en','Pay','Pay',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6584,'en','Payment','Payment',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6585,'en','TotalPaidExceedsGrandTotalForMultiPayment','Total Paid Exceeds Grand Total',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6586,'en','TotalPaying','Total Paying',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6587,'en','ChangeReturn','Change Return',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6588,'en','AmountPaying','Amount Paying',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6589,'en','Appearance_Settings','Appearance Settings',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6590,'en','app_name','App Name',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6591,'en','page_title_suffix','Page title suffix',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6592,'en','ChangeFavicon','Change Favicon',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6593,'en','Languages','Languages',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6594,'en','Translations','Translations',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6595,'en','Translations for','Translations for',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6596,'en','Back','Back',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6597,'en','Save All Changes','Save All Changes',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6598,'en','Add New','Add New',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6599,'en','Add New Translation','Add New Translation',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6600,'en','Save','Save',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6601,'en','Delete','Delete',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6602,'en','Showing','Showing',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6603,'en','Translation added','Translation added',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6604,'en','Failed to add translation','Failed to add translation',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6605,'en','Translation updated','Translation updated',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6606,'en','Failed to update','Failed to update',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6607,'en','No changes to save','No changes to save',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6608,'en','Notice','Notice',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6609,'en','All changes saved successfully','All changes saved successfully',1,'2025-06-18 01:50:19.000000','2025-06-18 01:50:19.000000'),(6610,'en','Bulk save failed','Bulk save failed',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6611,'en','Please reload the page after saving translations to apply the changes.','Please reload the page after saving translations to apply the changes.',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6612,'en','Action_Blocked','Action Blocked',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6613,'en','You_cannot_delete_the_default_language','You cannot delete the default language',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6614,'en','Flag','Flag',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6615,'en','Locale','Locale',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6616,'en','Update Language','Update Language',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6617,'en','Add Language','Add Language',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6618,'en','Send_Email','Send Email',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6619,'en','Send_SMS','Send SMS',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6620,'en','total_sales','Total sales',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6621,'en','Opening_Stock','Opening Stock',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6622,'en','Subscription_Product','Subscription Product',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6623,'en','Subscriptions','Subscriptions',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6624,'en','Billing_Cycle','Billing Cycle',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6625,'en','total_cycles','total cycles',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6626,'en','remaining_cycles','remaining cycles',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6627,'en','next_billing_date','next billing date',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6628,'en','Failed_to_update_subscription_status','Failed to update subscription status',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6629,'en','Subscription_status_updated_successfully','Subscription status updated successfully',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6630,'en','Create_Susbscription','Create Susbscription',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6631,'en','Price_Per_Cycle','Price Per Cycle',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6632,'en','Price_Per_Unit','Price Per Unit',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6633,'en','Active','Active',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6634,'en','Canceled','Canceled',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6635,'en','Completed','Completed',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6636,'en','Subscription_details','Subscription details',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6637,'en','Dynamic_Appearance','Dynamic Appearance',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6638,'en','Payment_Methods','Payment Methods',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6639,'en','You_cant_edit_or_remove_default_payment_choices','You can\'t edit or remove default payment choices',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6640,'en','Enter_Payment_Method','Enter Payment Method',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6641,'en','Sales_by_Category','Sales by Category',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6642,'en','Sales_by_Brand','Sales by Brand',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6643,'en','Error_Logs','Error Logs',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6644,'en','Occurred_At','Occurred At',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6645,'en','Context','Context',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6646,'en','Report_Transactions','Report Transactions',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6647,'en','Payment_Method','Payment Method',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6648,'en','Customer_Provider','Customer/Provider',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6649,'en','Sale_Purchase_Ref','Sale/Purchase Ref',1,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6650,'es','Draft_Created_successfully','Borrador creado exitosamente',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6651,'es','Draft_Sale_Deleted','Venta de borrador eliminada',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6652,'es','Inventory_Valuation_Based_on_Average_Cost','Valoración de inventario basada en el costo promedio',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6653,'es','Payroll','Nómina',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6654,'es','Transfers_Money','Transferencias de dinero',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6655,'es','Inventory_Valuation','Valoración de inventario',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6656,'es','Deposits_Report','Informe de depósitos',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6657,'es','Expense_Report','Informe de gastos',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6658,'es','Deposit_Category','Categoría de Depósito',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6659,'es','Total_Deposits','Total de depósitos',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6660,'es','Expense_Category','Categoría de gastos',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6661,'es','Total_Expenses','Total de gastos',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6662,'es','ASSET_VALUE','VALOR DEL ACTIVO',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6663,'es','STOCK_ON_HAND','Stock en mano',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6664,'es','Variant_NAME','Nombre de variante',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(6665,'es','SKU','SKU',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6666,'es','ITEM_NAME','NOMBRE DEL ARTÍCULO',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6667,'es','From_Account','Desde la cuenta',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6668,'es','To_Account','Hacia la cuenta',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6669,'es','Accounts_cannot_be_the_same','Las cuentas no pueden ser iguales',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6670,'es','CountStock','Contar Inventario',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6671,'es','Successfully_Generated_Count','Conteo Generado Exitosamente',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6672,'es','Count','Cantidad',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6673,'es','file','Archivo',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6674,'es','Accounting','Contabilidad',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6675,'es','deposit_delete','Eliminar Depósito',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6676,'es','deposit_edit','Editar Depósito',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6677,'es','deposit_add','Agregar Depósito',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6678,'es','deposit_view','Ver Depósito',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6679,'es','expense_add','Agregar Gasto',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6680,'es','expense_edit','Editar Gasto',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6681,'es','expense_delete','Eliminar Gasto',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6682,'es','List_Deposit','Lista de Depósitos',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6683,'es','Create_deposit','Crear Depósito',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6684,'es','List_accounts','Lista de Cuentas',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6685,'es','Account','Cuenta',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6686,'es','Choose_Account','Seleccionar Cuenta',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6687,'es','Deposits','Depósitos',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6688,'es','account_num','Número de Cuenta',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6689,'es','Enter_account_num','Ingrese Número de Cuenta',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6690,'es','account_name','Nombre de la Cuenta',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6691,'es','Enter_account_name','Ingrese Nombre de la Cuenta',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6692,'es','initial_balance','Saldo Inicial',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6693,'es','Enter_initial_balance','Ingrese Saldo Inicial',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6694,'es','notes','Notas',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6695,'es','balance','saldo',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(6696,'es','Receipt','Recibo',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6697,'es','Pos_Settings','Ajustes de POS',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(6698,'es','Note_to_customer','Nota al cliente',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6699,'es','Show_Note_to_customer','Mostrar nota al cliente',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6700,'es','Show_barcode','Mostrar código de barras',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6701,'es','Show_Tax_and_Discount','Mostrar impuestos, descuentos y envío',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6702,'es','Show_Customer','Mostrar cliente',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6703,'es','Show_Email','Mostrar correo electrónico',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6704,'es','Show_Phone','Mostrar teléfono',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6705,'es','Show_Address','Mostrar dirección',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6706,'es','DefaultLanguage','Idioma predeterminado',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6707,'es','footer','pie de página',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6708,'es','Received_Amount','Cantidad recibida',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6709,'es','Paying_Amount','Monto de pago',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6710,'es','Change','cambiar',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6711,'es','Paying_amount_is_greater_than_Received_amount','El monto a pagar es mayor que el monto recibido',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6712,'es','Paying_amount_is_greater_than_Grand_Total','El monto a pagar es mayor que el total general',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6713,'es','code_must_be_not_exist_already','el código no debe existir ya',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6714,'es','You_will_find_your_backup_on','Encontrarás tu copia de seguridad en',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6715,'es','and_save_it_to_your_pc','y guárdalo en tu pc',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6716,'es','Scan_your_barcode_and_select_the_correct_symbology_below','Escanee su código de barras y seleccione la simbología correcta a continuación',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6717,'es','Scan_Search_Product_by_Code_Name','Escanear / Buscar producto por nombre de código',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6718,'es','Paper_size','Tamaño de papel',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6719,'es','Clear_Cache','limpiar cache',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6720,'es','Cache_cleared_successfully','Caché borrada con éxito',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6721,'es','Failed_to_clear_cache','No se pudo borrar la caché',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6722,'es','Scan_Barcode','Escáner de código de barras',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6723,'es','Please_use_short_name_of_unit','Utilice el nombre corto de la unidad',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6724,'es','DefaultCustomer','Cliente predeterminado',0,'2025-06-18 01:50:20.000000','2025-06-18 01:50:20.000000'),(6725,'es','DefaultWarehouse','Almacén predeterminado',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6726,'es','Payment_Gateway','Pasarela de pago',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(6727,'es','SMS_Configuration','Configuración de SMS',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6728,'es','Gateway','Pasarela de pago',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6729,'es','Choose_Gateway','Elija la pasarela de pago',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6730,'es','sms_send_successfully','Mensaje enviado con éxito',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6731,'es','sms_config_invalid','configuración de sms incorrecta no válida',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6732,'es','Remove_Stripe_Key_Secret','Eliminar claves de API de Stripe',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6733,'es','credit_card_account_not_available','Cuenta de tarjeta de crédito no disponible',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6734,'es','Credit_Card_Info','Información de tarjeta de crédito',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(6735,'es','developed_by','Desarrollado por',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6736,'es','Unit_already_linked_with_sub_unit','Unidad ya vinculada con la subunidad',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6737,'es','Total_Items_Quantity','Total de artículos y cantidad',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6738,'es','Value_by_Cost_and_Price','Valor por costo y precio',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6739,'es','Search_this_table','Buscar esta tabla',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6740,'es','import_products','Importar productos',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6741,'es','Field_optional','Campo opcional',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6742,'es','Download_exemple','Descargar ejemplo',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6743,'es','field_must_be_in_csv_format','El campo debe estar en formato csv',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6744,'es','Successfully_Imported','Importada exitosamente',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6745,'es','file_size_must_be_less_than_1_mega','El tamaño del archivo debe ser inferior a 1 mega',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6746,'es','Please_follow_the_import_instructions','Siga las instrucciones de importación.',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6747,'es','must_be_exist','la unidad ya debe estar creada',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6748,'es','Import_Customers','Importar clientes',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6749,'es','Import_Suppliers','Proveedores de importación',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6750,'es','Recent_Sales','Ventas recientes',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6751,'es','Create_Transfer','Crear transferencia',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6752,'es','order_products','encargar artículos',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6753,'es','Search_Product_by_Code_Name','Buscar producto por código o nombre',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6754,'es','Reports_payments_Purchase_Return','Informes Pagos de devolución de compra',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6755,'es','Reports_payments_Sale_Return','Informes Pagos de devolución de venta',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6756,'es','payments_Sales_Return','pagos ventas Devolución',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6757,'es','payments_Purchases_Return','pagos compras Devolución',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6758,'es','CreateSaleReturn','Crear devolución de venta',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6759,'es','EditSaleReturn','Editar devolución de venta Sale Return',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6760,'es','SalesReturn','Devolución de ventas',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6761,'es','CreatePurchaseReturn','Crear devolución de compra',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6762,'es','EditPurchaseReturn','Editar devolución de compra',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6763,'es','PurchasesReturn','Devolución de compras',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6764,'es','Due','debido',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6765,'es','Profit','Lucro',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6766,'es','Revenue','Ingresos',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6767,'es','Sales_today','Ventas hoy',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6768,'es','People','Gente',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6769,'es','Successfully_Created','Creado con éxito',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6770,'es','Successfully_Updated','Actualizado exitosamente',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6771,'es','Success','Éxito',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6772,'es','Failed','fallido',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6773,'es','Warning','Advertencia',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6774,'es','Please_fill_the_form_correctly','Por favor complete el formulario correctamente',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6775,'es','Field_is_required','Se requiere campo',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6776,'es','Error','Error!',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6777,'es','you_are_not_authorized','¡Perdón! usted no está autorizado.',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6778,'es','Go_back_to_home','Volver a la página principal',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6779,'es','page_not_exist','¡Perdón! La página que buscaba no existe.',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6780,'es','Choose_Status','elegir estado',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(6781,'es','Choose_Method','Elija el método',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6782,'es','Choose_Symbology','Elija simbología',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6783,'es','Choose_Category','Elegir la categoría',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6784,'es','Choose_Customer','Elija cliente',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6785,'es','Choose_Supplier','Elija proveedor',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6786,'es','Choose_Unit_Purchase','Elija unidad de compra',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6787,'es','Choose_Sub_Category','Elija subcategoría',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6788,'es','Choose_Brand','Elija marca',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6789,'es','Choose_Warehouse','Elija Almacén',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6790,'es','Choose_Unit_Sale','Elija la unidad de venta',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6791,'es','Enter_Product_Cost','Ingrese el costo del producto',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6792,'es','Enter_Stock_alert','Entrar alerta de stock',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6793,'es','Choose_Unit_Product','Elija la unidad de producto',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6794,'es','Enter_Product_Price','Ingrese el precio del producto',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6795,'es','Enter_Name_Product','Ingrese el nombre del producto',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6796,'es','Enter_Role_Name','Ingrese el nombre del rol',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6797,'es','Enter_Role_Description','Ingrese la descripción del rol',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6798,'es','Enter_name_category','Ingrese el nombre de la categoría',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6799,'es','Enter_Code_category','Ingrese el código de la categoría',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6800,'es','Enter_Name_Brand','Ingrese el nombre de la marca',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6801,'es','Enter_Description_Brand','Ingrese la descripción de la marca',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6802,'es','Enter_Code_Currency','Ingrese la moneda del código',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6803,'es','Enter_name_Currency','Ingrese el nombre Moneda',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6804,'es','Enter_Symbol_Currency','Ingrese la moneda del símbolo',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6805,'es','Enter_Name_Unit','Ingrese el nombre de la unidad',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6806,'es','Enter_ShortName_Unit','Introduzca la unidad de nombre corto',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6807,'es','Choose_Base_Unit','Elija la unidad base',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6808,'es','Choose_Operator','Elegir Operadora',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6809,'es','Enter_Operation_Value','Ingrese el valor de la operación',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6810,'es','Enter_Name_Warehouse','Ingrese el nombre del almacén',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6811,'es','Enter_Phone_Warehouse','Ingrese el teléfono del almacén',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6812,'es','Enter_Country_Warehouse','Ingrese el país del almacén',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6813,'es','Enter_City_Warehouse','Ingrese la ciudad del almacén',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6814,'es','Enter_Email_Warehouse','Ingrese el correo electrónico del almacén',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6815,'es','Enter_ZipCode_Warehouse','Ingrese el código postal del almacén',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6816,'es','Choose_Currency','Elegir Moneda',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6817,'es','Thank_you_for_your_business','¡Gracias por su negocios!',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6818,'es','Cancel','Cancelar',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6819,'es','New_Customer','Nueva cliente',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6820,'es','Incorrect_Login','Inicio de sesión incorrecto',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6821,'es','Successfully_Logged_In','Inicio de sesión exitoso',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6822,'es','This_user_not_active','Esta usuaria no activa',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6823,'es','SignIn','Registrarse',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6824,'es','Create_an_account','Crea una cuenta',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6825,'es','Forgot_Password','Has olvidado tu contraseña ?',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6826,'es','Email_Address','Dirección de correo electrónico',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6827,'es','SignUp','Inscribirse',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6828,'es','Already_have_an_account','Ya tienes una cuenta ?',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6829,'es','Reset_Password','Restablecer la contraseña',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6830,'es','Failed_to_authenticate_on_SMTP_server','No se pudo autenticar en el servidor SMTP',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6831,'es','We_cant_find_a_user_with_that_email_addres','No podemos encontrar un usuario con esa dirección de correo electrónico',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6832,'es','We_have_emailed_your_password_reset_link','Hemos enviado su enlace de restablecimiento de contraseña por correo electrónico',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6833,'es','Please_fill_the_Email_Adress','Por favor complete la dirección de correo electrónico',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6834,'es','Confirm_password','Confirmar Contraseña',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6835,'es','Your_Password_has_been_changed','Tu contraseña ha sido cambiada',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6836,'es','The_password_confirmation_does_not_match','La confirmación de la contraseña no coincide',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6837,'es','This_password_reset_token_is_invalid','Este token de restablecimiento de contraseña no es válido',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6838,'es','Warehouse_report','Informe de almacén',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6839,'es','All_Warehouses','Todos los Almacenes',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6840,'es','Expense_List','Lista de gastos',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6841,'es','Expenses','Gastos',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6842,'es','This_Week_Sales_Purchases','Ventas y compras de esta semana',0,'2025-06-18 01:50:21.000000','2025-06-18 01:50:21.000000'),(6843,'es','Top_Selling_Products','Productos más vendidos',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6844,'es','View_all','Ver todo',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6845,'es','Payment_Sent_Received','Pago enviado y recibido',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6846,'es','Filter','Filtrar',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6847,'es','Invoice_POS','Factura POS',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6848,'es','Invoice','Factura',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6849,'es','Customer_Info','Información del cliente',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6850,'es','Company_Info','Información de la compañía',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6851,'es','Invoice_Info','Información de la factura',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6852,'es','Order_Summary','Resumen del pedido',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6853,'es','Quote_Info','Información de cotización',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6854,'es','Del','Eliminar',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6855,'es','SuppliersPaiementsReport','Informe de pagos a proveedores',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6856,'es','Purchase_Info','Información de compra',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6857,'es','Supplier_Info','Información del proveedor',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6858,'es','Return_Info','info de devolución',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6859,'es','Create_Expense','Crear gasto',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6860,'es','Details','Detalles',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6861,'es','Discount_Method','Método de descuento',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6862,'es','Net_Unit_Cost','Costo unitario neto',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6863,'es','Net_Unit_Price','Precio unitario neto',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6864,'es','Edit_Expense','Editar gasto',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6865,'es','All_Brand','Toda la marca',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6866,'es','All_Category','Todas las categorías',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6867,'es','ListExpenses','Lista de gastos',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6868,'es','Create_Permission','Crear permiso',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6869,'es','Edit_Permission','Editar permiso',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6870,'es','Reports_payments_Sales','Reportes pagos Ventas',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6871,'es','Reports_payments_Purchases','Reporta pagos Compras',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6872,'es','Reports_payments_Return_Customers','Informes pagos Clientes devueltos',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6873,'es','Reports_payments_Return_Suppliers','Proveedores de vuelta de los pagos de los informes',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6874,'es','stockyVersion','No puede hacer esto en la versión de stockystración',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6875,'es','Expense_Deleted','Este gasto ha sido eliminado',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6876,'es','Expense_Updated','Este gasto se ha actualizado',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6877,'es','Expense_Created','Este gasto ha sido creado',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6878,'es','Filesize','Tamaño del archivo',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6879,'es','GenerateBackup','Generar respaldo',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6880,'es','BackupDatabase','Base de datos de respaldo',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6881,'es','Backup','Base de datos de respaldo',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6882,'es','OrderStatistics','Estadísticas de ventas',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6883,'es','AlreadyAdd','Este producto ya ha sido agregado',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6884,'es','AddProductToList','Agregue un producto a la lista',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6885,'es','AddQuantity','Agregue la cantidad',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6886,'es','InvalidData','Fecha inválida',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6887,'es','LowStock','la cantidad excede la cantidad disponible en stock',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6888,'es','WarehouseIdentical','Los almacenes no pueden ser iguales',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6889,'es','VariantDuplicate','Esta variante está duplicada',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6890,'es','Paid','Pagado',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6891,'es','Unpaid','No pagado',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6892,'es','IncomeExpenses','Ingresos y gastos',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6893,'es','dailySalesPurchases','Ventas y Compras diarias',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6894,'es','ProductsExpired','Productos caducados',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6895,'es','Today','hoy',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6896,'es','Income','Ingresos',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6897,'es','Sale','rebaja',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6898,'es','Actif','Activo',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6899,'es','Inactif','Inactivo',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6900,'es','Customers','Clientes',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6901,'es','Phone','Teléfono',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6902,'es','SearchByPhone','Buscar por teléfono',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6903,'es','Suppliers','Proveedores',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6904,'es','Quotations','Citas',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6905,'es','Sales','Ventas',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6906,'es','Purchases','Compras',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6907,'es','Returns','Devoluciones',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6908,'es','Settings','Configuraciones',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6909,'es','SystemSettings','Ajustes del sistema',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6910,'es','Users','Los usuarios',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6911,'es','GroupPermissions','Permisos de grupo',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6912,'es','Currencies','Monedas',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6913,'es','Warehouses','Almacenes',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6914,'es','Units','Unidades',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6915,'es','UnitsPrchases',' Compra de unidades',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6916,'es','UnitsSales','Ventas de unidades',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6917,'es','Reports','Informes',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6918,'es','PaymentsReport','Informe de pagos',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6919,'es','PaymentsPurchases','Compras de pagos',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6920,'es','PaymentsSales','Venta de pagos',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6921,'es','PaymentsReturns','Devolución de pagos',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6922,'es','ProfitandLoss','Ganancia y perdida',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6923,'es','WarehouseStockChart','Gráfico de acciones de almacén',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6924,'es','SalesReport','Reporte de ventas',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6925,'es','PurchasesReport','Informe de compras',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6926,'es','CustomersReport','Informe de clientes',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6927,'es','SuppliersReport','Informe de proveedores',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6928,'es','SupplierReport','Informe del proveedor',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6929,'es','DailySalesData','Datos de ventas diarias',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6930,'es','DailyPurchasesData','Datos de compras diarias',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6931,'es','Dernièrescinqrecords','Últimos cinco registros',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6932,'es','Filters','Filtros',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6933,'es','date','fecha',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6934,'es','Reference','Referencia',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6935,'es','Supplier','Proveedor',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6936,'es','PaymentStatus','Estado de pago',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6937,'es','Customer','Cliente',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6938,'es','CustomerCode','Código de cliente',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6939,'es','Status','Estado',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6940,'es','SupplierCode','Código de proveedor',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6941,'es','Categorie','Categoría',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6942,'es','Categories','Categorias',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6943,'es','StockTransfers','Transferencias de stock',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6944,'es','StockManagement','Gestion de Stocks',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6945,'es','dashboard','Tablero',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6946,'es','Products','Productos',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6947,'es','productsList','lista de productos',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6948,'es','ProductManagement','Gestion de producto',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6949,'es','ProductQuantityAlerts','Alertas de cantidad de producto',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6950,'es','CodeProduct','Código de producto',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6951,'es','ProductTax','Impuesto de producto',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6952,'es','SubCategorie','Subcategoría',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6953,'es','Name_product','Designacion',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6954,'es','StockAlert','Alerta de stock',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6955,'es','warehouse','almacén',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6956,'es','Tax','Impuesto',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6957,'es','BuyingPrice','Precio de compra',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6958,'es','SellPrice','Precio de venta',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6959,'es','Quantity','Cantidad',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6960,'es','UnitSale','Venta de unidades',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6961,'es','UnitPurchase','Compra de unidad',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6962,'es','All','todos',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6963,'es','EditProduct','Editar producto',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6964,'es','AddProduct','Añadir Producto',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6965,'es','SearchByCode','Buscar por código',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6966,'es','SearchByName','Buscar por nombre',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6967,'es','ProductDetails','Detalles de producto',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6968,'es','CustomerName','Nombre del cliente',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6969,'es','CustomerManagement','Gestión de clientes',0,'2025-06-18 01:50:22.000000','2025-06-18 01:50:22.000000'),(6970,'es','Add','Añadir',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(6971,'es','Edit','Editar',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(6972,'es','Close','Cerrar',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(6973,'es','PleaseSelect','Por favor seleccione',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(6974,'es','Action','Acción',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(6975,'es','Email','Email',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(6976,'es','EditCustomer','Editar cliente',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(6977,'es','AddCustomer','Agregar cliente',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(6978,'es','Country','País',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(6979,'es','City','Ciudad',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(6980,'es','Adress','Dirección',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(6981,'es','CustomerDetails','Detalles del cliente',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(6982,'es','CustomersList','Lista de clientes',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(6983,'es','SupplierName','Nombre del proveedor',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(6984,'es','SuppliersManagement','Gerencia de Proveedores',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(6985,'es','SupplierDetails','Detalles del proveedor',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(6986,'es','QuotationsManagement','Gestión de cotizaciones',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(6987,'es','SubTotal','Total parcial',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(6988,'es','MontantReste','Cantidad restante',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(6989,'es','complete','completar',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(6990,'es','EnAttendant','pendiente',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(6991,'es','Recu','Recibido',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(6992,'es','partial','Parcial',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(6993,'es','Retournee','Regreso',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(6994,'es','DetailQuote','Cotización detallada',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(6995,'es','EditQuote','Editar cotización',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(6996,'es','CreateSale','Crear venta',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(6997,'es','DownloadPdf','Descargar PDF',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(6998,'es','QuoteEmail','Presupuesto enviado por correo electrónico',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(6999,'es','DeleteQuote','Eliminar cotización',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7000,'es','AddQuote','Agregar cotización',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7001,'es','SelectProduct','Seleccionar producto',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7002,'es','ProductCodeName','Producto (Código - Nombre)',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7003,'es','Price','Precio',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7004,'es','CurrentStock','Stock',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7005,'es','Total','Total',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7006,'es','Num','N°',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7007,'es','Unitcost','Costo unitario',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7008,'es','to','a',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7009,'es','Subject','Sujeto',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7010,'es','Message','Mensaje',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7011,'es','EmailCustomer','Cliente de correo electrónico',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7012,'es','Sent','Expedido',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7013,'es','Quote','cotización',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7014,'es','Hello','Hola',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7015,'es','AttachmentQuote','Encuentra el archivo adjunto para tu cotización',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7016,'es','AddProducts','Agregar productos a la lista de pedidos',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7017,'es','SelectWarehouse','Por favor seleccione almacén',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7018,'es','SelectCustomer','Seleccionar cliente',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7019,'es','SalesManagement','Gestión de ventas',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7020,'es','QtyBack','regreso cantidad',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7021,'es','TotalReturn','Regreso total',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7022,'es','Amount','monto',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7023,'es','SaleDetail','Detalle de venta',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7024,'es','EditSale','Editar venta',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7025,'es','AddSale','Añadir venta',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7026,'es','ShowPayment','Mostrar pagos',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7027,'es','AddPayment','Agregar pago',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7028,'es','EditPayment','Editar pago',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7029,'es','EmailSale','Enviar venta en correo electrónico',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7030,'es','DeleteSale','Eliminar venta',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7031,'es','ModePaiement','Modo de pago',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7032,'es','Paymentchoice','Opción de pago',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7033,'es','Note','Nota',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7034,'es','PaymentComplete','¡Pago completo!',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7035,'es','PurchasesManagement','Gestión de compras',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7036,'es','Ordered','Ordenado',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7037,'es','DeletePurchase','Eliminar compra',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7038,'es','EmailPurchase','Enviar compra por correo electrónico',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7039,'es','EditPurchase','Editar compra',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7040,'es','PurchaseDetail','Detalle de compra',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7041,'es','AddPurchase','Añadir compra',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7042,'es','EmailSupplier','Correo electrónico del proveedor',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7043,'es','PurchaseInvoice','Compras pagos',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7044,'es','PurchasesInvoicesData','Datos de pagos de compras',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7045,'es','SalesInvoice','Pagos de ventas',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7046,'es','SalesInvoicesData','Datos de pagos de ventas',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7047,'es','UserManagement','gestión de usuarios',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7048,'es','Firstname','Primer nombre',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7049,'es','lastname','Apellido',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7050,'es','username','NOMBRE DE USUARIO',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7051,'es','password','CONTRASEÑA',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7052,'es','Newpassword','Nueva contraseña',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7053,'es','ChangeAvatar','Cambiar avatar',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7054,'es','LeaveBlank','Deje este campo en blanco si no lo ha cambiado.',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7055,'es','type','tipo',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7056,'es','UserPermissions','Permisos de usuarios',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7057,'es','RoleName','Nombre de rol',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7058,'es','RoleDescription','Descripción del rol',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7059,'es','AddPermissions','Agregar permisos',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7060,'es','View','Ver',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7061,'es','NewAdjustement','Nuevo ajuste',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7062,'es','EditAdjustement','Editar ajuste',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7063,'es','CannotSubstraction','No puede restar productos que tienen stock 0',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7064,'es','Addition','Adición',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7065,'es','Subtraction','Sustracción',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7066,'es','profil','perfil',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7067,'es','logout','cerrar sesión',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7068,'es','PurchaseAlreadyPaid','no puede modificar porque esta compra ya ha pagado',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7069,'es','SaleAlreadyPaid','no puede modificar porque esta venta ya pagó',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7070,'es','ReturnAlreadyPaid','no se puede modificar porque esta devolución ya ha pagado',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7071,'es','QuoteAlready','Este cotización ya ha generado ventas',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7072,'es','QuotationComplete','Esta cita completa',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7073,'es','SiteConfiguration','Configuración del sitio',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7074,'es','Language','Idioma',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7075,'es','DefaultCurrency','Moneda predeterminada',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7076,'es','LoginCaptcha','Captcha de inicio de sesión',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7077,'es','DefaultEmail','Email predeterminado',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7078,'es','SiteName','Nombre del sitio',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7079,'es','ChangeLogo','Cambiar logo',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7080,'es','SMTPConfiguration','Configuración SMTP',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7081,'es','HOST','hueste',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7082,'es','PORT','PUERTO',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7083,'es','encryption','Cifrado',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7084,'es','SMTPIncorrect','Configuración SMTP incorrecta',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7085,'es','ReturnsInvoices','Devolver facturas',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7086,'es','ReturnsInvoicesData','Devolver datos de factura',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7087,'es','ShowAll','Mostrar todos los registros de todos los usuarios',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7088,'es','Discount','Descuento',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7089,'es','OrderTax','Impuesto de orden',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7090,'es','Shipping','Envío',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7091,'es','ManagementCurrencies','Monedas de gestión',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7092,'es','CurrencyCode','Código de moneda',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7093,'es','CurrencyName','Nombre de moneda',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7094,'es','Symbol','Símbolo',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7095,'es','CompanyName','Nombre de empresa',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7096,'es','CompanyPhone','Teléfono de la empresa',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7097,'es','CompanyAdress','Dirección de la empresa',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7098,'es','Code','Código',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7099,'es','image','imagen',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7100,'es','Printbarcode','Imprimir código de barras',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7101,'es','ReturnsCustomers','Devuelve ventas',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7102,'es','ReturnsSuppliers','Devoluciones de compras',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7103,'es','FactureReturnCustomers','facturas Ventas devolución',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7104,'es','FactureReturnSuppliers','facturas devoluciones compras',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7105,'es','NodataAvailable','Datos no disponibles',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7106,'es','ProductImage','Imagen del producto',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7107,'es','Barcode','Código de barras',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7108,'es','pointofsales','puntos de venta',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7109,'es','CustomUpload','Subida personalizada',0,'2025-06-18 01:50:23.000000','2025-06-18 01:50:23.000000'),(7110,'es','pointofsaleManagement','gestión punto de venta',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7111,'es','Adjustment','Ajustamiento',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7112,'es','Updat','Actualizar',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7113,'es','Reset','Reiniciar',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7114,'es','print','impresión',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7115,'es','SearchByEmail','Buscar por correo ',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7116,'es','ChooseProduct','Elegir producto',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7117,'es','Qty','Cantidad',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7118,'es','Items','Artículos',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7119,'es','AmountHT','monto HT',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7120,'es','AmountTTC','monto TTC',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7121,'es','PleaseSelectSupplier','Seleccione Proveedor',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7122,'es','PleaseSelectStatut','seleccione estado',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7123,'es','PayeBy','Pagado con',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7124,'es','ChooseWarehouse','Elija Almacén',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7125,'es','payNow','Pagar ahora',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7126,'es','ListofCategory','Lista de categoría',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7127,'es','Description','Descripción',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7128,'es','submit','guardar',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7129,'es','ProblemCreatingThisInvoice','Hubo un problema al crear esta factura. Inténtalo de nuevo',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7130,'es','ProblemPayment','Hubo un problema con el pago. Inténtalo de nuevo',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7131,'es','CreateAdjustment','Crear ajuste',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7132,'es','Afewwords','unas palabras sobre ...',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7133,'es','UserImage','Imagen de usuario',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7134,'es','UpdateProduct','Actualizar producto',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7135,'es','Brand','Marca',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7136,'es','BarcodeSymbology','Simbología de códigos de barras',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7137,'es','ProductCost','Costo del producto',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7138,'es','ProductPrice','Precio del producto',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7139,'es','UnitProduct','Producto unitario',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7140,'es','TaxMethod','Método de impuestos',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7141,'es','MultipleImage','Imagen múltiple',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7142,'es','ProductHasMultiVariants','El producto tiene múltiples variantes',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7143,'es','ProductHasPromotion','El producto tiene promoción',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7144,'es','PromotionStart','Inicio de promoción',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7145,'es','PromotionEnd','Fin de la promoción',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7146,'es','PromotionPrice','Precio de promoción',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7147,'es','Cost','Costo',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7148,'es','Unit','Unidad',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7149,'es','ProductVariant','Variante de producto',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7150,'es','Variant','Variante',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7151,'es','UnitPrice','Precio unitario',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7152,'es','CreateReturnCustomer','Crear devolución de cliente',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7153,'es','EditReturnCustomer','Editar devolución de cliente',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7154,'es','CreateReturnSupplier','Crear devolución de proveedor',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7155,'es','Documentation','Documentación',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7156,'es','EditReturnSupplier','Editar devolución de proveedor',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7157,'es','FromWarehouse','De almacén',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7158,'es','ToWarehouse','Al almacén',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7159,'es','EditTransfer','Editar transferencia',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7160,'es','TransferDetail','Detalle de transferencia',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7161,'es','Pending','Pendiente',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7162,'es','Received','Recibido',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7163,'es','PermissionsManager','Administrador de permisos',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7164,'es','BrandManager','Gerente de marca',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7165,'es','BrandImage','Imagen de marca',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7166,'es','BrandName','Nombre de la marca',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7167,'es','BrandDescription','Descripción de marca',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7168,'es','BaseUnit','Unidad base',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7169,'es','ManagerUnits','Unidades gestoras',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7170,'es','OperationValue','Valor de operación',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7171,'es','Operator','Operador',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7172,'es','Top5Products','Los 5 mejores productos',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7173,'es','Last5Sales','Últimas 5 ventas',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7174,'es','ListAdjustments','Lista de ajustes',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7175,'es','ListTransfers','Lista de transferencias',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7176,'es','CreateTransfer','Crear transferencia',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7177,'es','OrdersManager','Gerente de pedidos',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7178,'es','ListQuotations','List Quotations',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7179,'es','ListPurchases','Lista de compras',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7180,'es','ListSales','Lista de ventas',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7181,'es','ListReturns','Lista de devoluciones',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7182,'es','PeopleManager','Gerente de personas',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7183,'es','ListofBrand','Lista de marcas',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7184,'es','Delete_Title','Estas seguro ?',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7185,'es','Delete_Text','¡No podrás revertir esto!',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7186,'es','Delete_confirmButtonText','Sí, bórralo!',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7187,'es','Delete_cancelButtonText','Cancelar',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7188,'es','Delete_Deleted','Eliminado!',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7189,'es','Delete_Failed','¡Ha fallado!',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7190,'es','Delete_Therewassomethingwronge','Algo andaba mal',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7191,'es','SendEmail','Enviar por correo electrónico con éxito',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7192,'es','erroSale','¡Esta venta ya está vinculada con una devolución!',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7193,'es','ReturnManagement','Gestión de retorno',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7194,'es','ReturnDetail','Detalle de retorno',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7195,'es','EditReturn','Editar retorno',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7196,'es','AddReturn','Agregar retorno',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7197,'es','EmailReturn','Enviar retorno en correo electrónico',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7198,'es','DeleteReturn','Eliminar retorno',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7199,'es','Retoursurcharge','Recargo de retorno',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7200,'es','Laivrison','entrega',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7201,'es','SelectSale','Seleccionar venta',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7202,'es','ZeroPardefault','Puede eliminar el artículo o establecer la cantidad devuelta a cero si no se devuelve',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7203,'es','Return','retorno',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7204,'es','Purchase','Compra',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7205,'es','TotalSales','Ventas totales',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7206,'es','TotalPurchases','Compras totales',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7207,'es','TotalReturns','Devoluciones totales',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7208,'es','PaiementsNet','Pagos Netos',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7209,'es','PaiementsSent','Pagos enviados',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7210,'es','PaiementsReceived','Pagos recibidos',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7211,'es','Recieved','Recibido',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7212,'es','ProductCode','Código de producto',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7213,'es','ProductName','nombre del producto',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7214,'es','AlertQuantity','Cantidad de alerta',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7215,'es','TotalProducts','Productos totales',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7216,'es','TotalQuantity','Cantidad total',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7217,'es','TopCustomers','Los 5 mejores clientes',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7218,'es','TotalAmount','monto total ',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7219,'es','TotalPaid','Total pagado',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7220,'es','CustomerSalesReport','Informe de ventas del cliente',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7221,'es','CustomerPaiementsReport','Informe de pagos del cliente',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7222,'es','CustomerQuotationsReport','Informe de cotizaciones de clientes',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7223,'es','Payments','Pagos',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7224,'es','TopSuppliers','Los 5 mejores proveedores',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7225,'es','SupplierPurchasesReport','Informe de compras del proveedor',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7226,'es','SupplierPaiementsReport','Informe de pagos a proveedores',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7227,'es','Name','Nombre',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7228,'es','ManagementWarehouse','Gestion de almacenes',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7229,'es','ZipCode','Código postal',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7230,'es','managementCategories','Gestión de categorías',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7231,'es','Codecategorie','Categoría de código',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7232,'es','Namecategorie','Categoría de nombre',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7233,'es','Parentcategorie','Categoría principal',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7234,'es','managementTax','Gestión fiscal',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7235,'es','TaxName','Nombre fiscal',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7236,'es','TaxRate','Tasa de impuesto',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7237,'es','managementUnitPurchases','Gestión de la Unidad de Compras',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7238,'es','managementUnitSales','Gerencia de Unidad de Ventas',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7239,'es','ShortName','Nombre corto',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7240,'es','PleaseSelectThesebeforeaddinganyproduct','Seleccione estos antes de agregar cualquier producto',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7241,'es','StockAdjustement','Ajuste de Stock',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7242,'es','PleaseSelectWarehouse','Seleccione almacén antes de elegir cualquier producto',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7243,'es','StockTransfer','Transferencia de acciones',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7244,'es','SelectPeriod','Seleccionar periodo',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7245,'es','ThisYear','Este año',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7246,'es','ThisToday','hoy',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7247,'es','ThisMonth','Este mes',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7248,'es','ThisWeek','Esta semana',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7249,'es','AdjustmentDetail','Detalle de ajuste',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7250,'es','ActivateUser','Esta usuaria ha sido activada',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7251,'es','DisActivateUser','Esta usuaria ha sido desactivada',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7252,'es','NotFound','Página no encontrada.',0,'2025-06-18 01:50:24.000000','2025-06-18 01:50:24.000000'),(7253,'es','oops','¡error! Página no encontrada.',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7254,'es','couldNotFind','No pudimos encontrar la página que estaba buscando.',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7255,'es','ReturnDashboard','volver al tablero',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7256,'es','hrm','HRM',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7257,'es','Employees','Empleados',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7258,'es','Attendance','Asistencia',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7259,'es','Leave_request','Dejar petición',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7260,'es','Leave_type','Tipo de licencia',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7261,'es','Company','Compañía',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7262,'es','Departments','Departamentos',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7263,'es','Designations','Designaciones',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7264,'es','Office_Shift','Turno de oficina',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7265,'es','Holidays','Días festivos',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7266,'es','Enter_Company_Name','Introduzca el nombre de la empresa',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7267,'es','Enter_email_address','Introduzca la dirección de correo electrónico',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7268,'es','Enter_Company_Phone','Introduce el teléfono de la empresa',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7269,'es','Enter_Company_Country','Introduzca el país de la empresa',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7270,'es','Created_in_successfully','Creado en con éxito',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7271,'es','Updated_in_successfully','Actualizado en con éxito',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7272,'es','Deleted_in_successfully','Eliminado en con éxito',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7273,'es','department','Departamento',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7274,'es','Enter_Department_Name','Ingrese el nombre del departamento',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7275,'es','Choose_Company','Elija empresa',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7276,'es','Department_Head','Jefe de departamento',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7277,'es','Choose_Department_Head','Elegir jefe de departamento',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7278,'es','Enter_Shift_name','Ingrese el nombre del turno',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7279,'es','Monday_In','Monday In',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7280,'es','Monday_Out','Monday Out',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7281,'es','Tuesday_In','Tuesday In',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7282,'es','tuesday_out','tuesday Out',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7283,'es','wednesday_in','Wednesday In',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7284,'es','wednesday_out','Wednesday Out',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7285,'es','thursday_in','Thursday In',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7286,'es','thursday_out','Thursday Out',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7287,'es','friday_in','Friday In',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7288,'es','friday_out','Friday Out',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7289,'es','saturday_in','Saturday In',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7290,'es','saturday_out','Saturday Out',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7291,'es','sunday_in','Sunday In',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7292,'es','sunday_out','Sunday Out',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7293,'es','Holiday','Fiesta',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7294,'es','Enter_title','Introduce el título',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7295,'es','title','título',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7296,'es','start_date','Fecha de inicio',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7297,'es','Enter_Start_date','Introduce la fecha de inicio',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7298,'es','Finish_Date','Fecha de finalización',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7299,'es','Enter_Finish_date','Introduzca la fecha de finalización',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7300,'es','Please_provide_any_details','Proporcione cualquier detalle',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7301,'es','Attendances','asistencias',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7302,'es','Enter_Attendance_date','Ingrese la fecha de asistencia',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7303,'es','Time_In','Time In',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7304,'es','Time_Out','Time Out',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7305,'es','Choose_Employee','Elegir empleado',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7306,'es','Employee','Empleado',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7307,'es','Work_Duration','Duración del trabajo',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7308,'es','remaining_leaves_are_insufficient','Las hojas restantes son insuficientes',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7309,'es','Days','Días',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7310,'es','Choose_leave_type','Elija el tipo de licencia',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7311,'es','Leave_Reason','Razón de dejar',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7312,'es','Enter_Reason_Leave','Ingrese el motivo de la licencia',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7313,'es','Add_Employee','Agregar empleado',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7314,'es','Enter_FirstName','Ingrese el nombre',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7315,'es','Enter_LastName','Introduzca el apellido',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7316,'es','Gender','Género',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7317,'es','Choose_Gender','Elija género',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7318,'es','Enter_Birth_date','Ingrese la fecha de nacimiento',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7319,'es','Birth_date','Fecha de nacimiento',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7320,'es','Enter_Country','Introducir país',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7321,'es','Enter_Phone_Number','Ingresa número telefónico',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7322,'es','joining_date','Dia de ingreso',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7323,'es','Enter_joining_date','Introduce la fecha de incorporación',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7324,'es','Choose_Designation','Elija Designación',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7325,'es','Designation','Designacion',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7326,'es','Choose_Office_Shift','Elija turno de oficina',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7327,'es','Enter_Leaving_Date','Ingrese la fecha de salida',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7328,'es','Leaving_Date','Fecha de salida',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7329,'es','Annual_Leave','Vacaciones anuales',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7330,'es','Enter_Annual_Leave','Ingresar vacaciones anuales',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7331,'es','Remaining_leave','Licencia restante',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7332,'es','Employee_Details','Detalles del empleado',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7333,'es','Basic_Information','Información básica',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7334,'es','Family_status','Estado familiar',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7335,'es','Choose_Family_status','Elija el estado de la familia',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7336,'es','Employment_type','Tipo de empleo',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7337,'es','Select_Employment_type','Seleccionar tipo de empleo',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7338,'es','Enter_City','Ingresar ciudad',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7339,'es','Province','Provincia',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7340,'es','Enter_Province','Entrar Provincia',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7341,'es','Enter_Address','Ingresa la direccion',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7342,'es','Enter_Zip_code','Ingresa tu código postal',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7343,'es','Zip_code','Código postal',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7344,'es','Hourly_rate','Tarifa por hora',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7345,'es','Enter_Hourly_rate','Ingrese la tarifa por hora',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7346,'es','Basic_salary','Salario base',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7347,'es','Enter_Basic_salary','Ingrese salario base',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7348,'es','Social_Media','Medios de comunicación social',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7349,'es','Skype','Skype',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7350,'es','Enter_Skype','Ingresa a Skype',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7351,'es','Facebook','Facebook',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7352,'es','Enter_Facebook','Ingresa a Facebook',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7353,'es','WhatsApp','WhatsApp',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7354,'es','Enter_WhatsApp','Ingresa a WhatsApp',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7355,'es','LinkedIn','LinkedIn',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7356,'es','Enter_LinkedIn','Ingresa a LinkedIn',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7357,'es','Twitter','Twitter',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7358,'es','Enter_Twitter','Ingresa a Twitter',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7359,'es','Experiences','Experiencias',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7360,'es','bank_account','cuenta bancaria',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7361,'es','Company_Name','nombre de empresa',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7362,'es','Location','Ubicación',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7363,'es','Enter_location','Introduce la ubicación',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7364,'es','Enter_Description','Ingrese la descripción',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7365,'es','Bank_Name','Nombre del banco',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7366,'es','Enter_Bank_Name','Ingrese el nombre del banco',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7367,'es','Bank_Branch','Sucursal bancaria',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7368,'es','Enter_Bank_Branch','Ingresar Sucursal Bancaria',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7369,'es','Bank_Number','Número de banco',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7370,'es','Enter_Bank_Number','Ingrese el número de banco',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7371,'es','Assigned_warehouses','Almacenes asignados',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7372,'es','Top_customers','mejores clientes',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7373,'es','Attachment','Adjunto archivo',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7374,'es','view_employee','ver empleados',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7375,'es','edit_employee','editar empleados',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7376,'es','delete_employee','eliminar empleados',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7377,'es','Created_by','Añadido por',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7378,'es','Add_product_IMEI_Serial_number','Añadir producto IMEI/número de serie',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7379,'es','Product_Has_Imei_Serial_number','El producto tiene Imei/Número de serie',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7380,'es','IMEI_SN','IMEI/SN',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7381,'es','Shipments','Envíos',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7382,'es','delivered_to','Entregado a',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7383,'es','shipment_ref','Referencia de envío',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7384,'es','sale_ref','Referencia de venta',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7385,'es','Edit_Shipping','Editar envío',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7386,'es','Packed','Lleno',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7387,'es','Shipped','Enviado',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7388,'es','Delivered','Entregado',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7389,'es','Cancelled','Cancelado',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7390,'es','Shipping_status','Estado del envío',0,'2025-06-18 01:50:25.000000','2025-06-18 01:50:25.000000'),(7391,'es','Users_Report','Informe de usuarios',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7392,'es','stock_report','Informe de existencias',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7393,'es','Total_quotations','Cotizaciones totales',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7394,'es','Total_return_sales','Ventas de devolución total',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7395,'es','Total_return_purchases','Compras de devolución total',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7396,'es','Total_transfers','Transferencias totales',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7397,'es','Total_adjustments','Ajustes totales',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7398,'es','User_report','Informe de usuario',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7399,'es','Current_stock','Stock actual',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7400,'es','product_name','nombre del producto',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7401,'es','Total_Customers_Due','Deuda total',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7402,'es','Total_Suppliers_Due','Deuda total',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7403,'es','Some_warehouses','algunos almacenes',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7404,'es','Product_Cost','Costo del producto',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7405,'es','sms_settings','Configuraciones de SMS',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7406,'es','mail_settings','Configuración de correo',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7407,'es','Nexmo_SMS','Nexmo SMS',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7408,'es','TWILIO_SMS','TWILIO SMS',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7409,'es','Default_SMS_Gateway','Puerta de enlace de SMS predeterminada',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7410,'es','module_settings','Configuración del módulo',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7411,'es','Module_enabled_success','Módulo habilitado con éxito',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7412,'es','Module_Disabled_success','Módulo deshabilitado con éxito',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7413,'es','update_settings','Ajustes de actualización',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7414,'es','Please_Upload_the_Correct_Module','Por favor, suba el módulo correcto',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7415,'es','Uploaded_Success','Cargado correctamente',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7416,'es','Customer_details','Detalles del cliente',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7417,'es','Edit_Customer','Editar cliente',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7418,'es','Delete_Customer','Eliminar cliente',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7419,'es','Pay_Due','Pagar adeudado',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7420,'es','Paying_amount_is_greater_than_Total_Due','El monto a pagar es mayor que el total adeudado',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7421,'es','Customer_Invoice','Factura del cliente',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7422,'es','This_Product_Not_For_Selling','Este producto no para la venta',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7423,'es','Welcome_to_your_Dashboard','Bienvenido a tu Tablero',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7424,'es','Total_Payable','Total por Pagar',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7425,'es','Choose_Sale_Ref','Elija Ref. de venta',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7426,'es','Please_Select_Sale','Seleccione Venta',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7427,'es','list_product_returns','enumerar las devoluciones de productos',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7428,'es','Qty_return','devolución de cantidad',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7429,'es','Choose_Purchase_Ref','Elija la referencia de compra',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7430,'es','Purchase_Ref','Referencia de compra',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7431,'es','please_select_purchase','Por favor seleccione Compra',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7432,'es','qty_return_is_greater_than_qty_purchased','La cantidad devuelta es mayor que la cantidad comprada',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7433,'es','qty_return_is_greater_than_qty_sold','La cantidad devuelta es mayor que la cantidad vendida',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7434,'es','Quantity_sold','Cantidad vendida',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7435,'es','qty_purchased','cantidad comprada',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7436,'es','Sender_Name','Nombre del remitente',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7437,'es','The_module_must_be_uploaded_as_zip_file','El módulo debe cargarse como archivo zip',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7438,'es','Upload_Module','Subir módulo',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7439,'es','All_Modules_Installed','Todos los módulos instalados',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7440,'es','Current_Version','Versión actual',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7441,'es','You_already_have_the_latest_version','Ya tienes la última versión',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7442,'es','Update_Available','Actualización disponible',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7443,'es','Update_Log','Registro de actualización',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7444,'es','Update_Now','Actualizar ahora',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7445,'es','View_Change_Log','Ver registro de cambios',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7446,'es','invoice_footer','Pie de página de la factura',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7447,'es','Please_Wait_for_the_update','Espere a que la actualización finalice por completo. No se recomienda cerrar el navegador o detener un proceso Actualizar',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7448,'es','Note_update','asegúrese de hacer una copia de seguridad de su versión y base de datos actuales antes de ejecutar la actualización, para restaurarla si hay un error',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7449,'es','Time_Zone','Zona horaria',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7450,'es','Payment_note','Nota de pago',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7451,'es','sale_note','notas de venta',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7452,'es','Total_Sale_Due','Deuda total de venta',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7453,'es','Total_Sell_Return_Due','Deuda total de devolución de venta',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7454,'es','pay_all_sell_due_at_a_time','pagar todas las deudas de venta a la vez',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7455,'es','pay_all_sell_return_due_at_a_time','pagar toda la deuda de devolución de venta a la vez',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7456,'es','Gross_Profit','Beneficio bruto',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7457,'es','pay_all_purchase_due_at_a_time','pagar toda la deuda de compra a la vez',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7458,'es','Delete_Provider','Eliminar proveedor',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7459,'es','Edit_Provider','Editar proveedor',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7460,'es','Provider_details','Detalles del proveedor',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7461,'es','Total_Purchase_Due','Deuda total de compra',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7462,'es','Provider_Credit_Note','Nota de crédito',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7463,'es','Customer_Credit_Note','Nota de crédito',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7464,'es','Sell_Return','Vender Retorno',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7465,'es','Purchase_Return','Devolución de compra',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7466,'es','Tax_Number','Número de impuesto',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7467,'es','Please_add_return_quantity','Por favor agregue la cantidad de devolución',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7468,'es','Return_exist_for_the_Transaction','Existe devolución para la Transacción',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7469,'es','qty_return_is_greater_than_Quantity_Remaining','La devolución de cantidad es mayor que la cantidad restante',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7470,'es','products_refunded_alert','Cualquier producto con una cantidad establecida en 0 no será reembolsado',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7471,'es','pay_all_purchase_return_due_at_a_time','pagar todas las devoluciones de compra adeudadas a la vez',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7472,'es','Total_Purchase_Return_Due','Deuda total de devolución de compra',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7473,'es','Purchase_return_due','Deuda de devolución de compra',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7474,'es','Sell_return_due','deuda de devolución de venta',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7475,'es','product_report','informe de producto',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7476,'es','product_sales_report','informe de ventas de productos',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7477,'es','Product_purchases_report','informe de compras de productos',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7478,'es','Qty_sold','Cantidad vendida',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7479,'es','Filter_by_warehouse','Filtrar por almacén',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7480,'es','Enable_Print_Invoice','Imprimir factura automáticamente',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7481,'es','Show_Warehouse','ver almacén',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7482,'es','Saved_Credit_Card_Info','Información de tarjeta de crédito guardada',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7483,'es','Credit_card_changed_successfully','Tarjeta de crédito cambiada exitosamente',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7484,'es','notification_template','Plantilla de notificación',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7485,'es','email_notification','Notificación por correo electrónico',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7486,'es','sms_notification','Notificación por SMS',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7487,'es','Change_product_details','Cambiar detalles del producto',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7488,'es','edit_tax_and_discount_and_shipping','Editar impuestos, descuentos y envío',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7489,'es','Create_Quotation_with_Stock','Crear cotización con stock',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7490,'es','Variant_cost','Costo de variante',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7491,'es','Variant_price','Precio de variante',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7492,'es','Variant_code','Código de variante',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7493,'es','Please_wait_until_the_product_is_loaded','Por favor, espere hasta que el producto se cargue',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7494,'es','Choose_SMS_Gateway','Elegir gateway de SMS',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7495,'es','Notification_Client','Notificación al cliente',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7496,'es','Available_Tags','Etiquetas disponibles',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7497,'es','Email_Subject','Asunto del correo electrónico',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7498,'es','Email_body','Contenido del correo electrónico',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7499,'es','Notification_Supplier','Notificación al proveedor',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7500,'es','sms_body','Contenido del SMS',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7501,'es','sms_templates','Plantillas SMS',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7502,'es','email_templates','Plantillas de correo electrónico',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7503,'es','Edit_Project','Editar Proyecto',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7504,'es','Projects','Proyectos',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7505,'es','Enter_Project_Title','Ingresar Título del Proyecto',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7506,'es','Assigned_Employees','Empleados Asignados',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7507,'es','Choose_Team','Elegir Equipo',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7508,'es','Create_Project','Crear Proyecto',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7509,'es','Project_List','Lista de Proyectos',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7510,'es','Not_Started','No Iniciado',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7511,'es','In_Progress','En Progreso',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7512,'es','On_Hold','En Espera',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7513,'es','Edit_Task','Editar Tarea',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7514,'es','Tasks','Tareas',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7515,'es','Enter_Task_Title','Ingresar Título de la Tarea',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7516,'es','Choose_Project','Elegir Proyecto',0,'2025-06-18 01:50:26.000000','2025-06-18 01:50:26.000000'),(7517,'es','Project','Proyecto',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7518,'es','Create_Task','Crear Tarea',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7519,'es','Task_List','Lista de Tareas',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7520,'es','Import_Purchases','Importar Compras',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7521,'es','Warranty_Period','Período de garantía',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7522,'es','Months','Meses',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7523,'es','Years','Años',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7524,'es','WarrantyTerms','Términos de la garantía',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7525,'es','HasGuarantee','Tiene garantía',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7526,'es','Guarantee_Period','Duración de la garantía',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7527,'es','OpeningStock','Inventario inicial',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7528,'es','Warranty_Guarantee_Tracking','Seguimiento de garantía',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7529,'es','PaymentOption','Método de pago',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7530,'es','AddAnotherPaymentOption','Agregar otro método de pago',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7531,'es','PopularTendered','Montos comunes',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7532,'es','clear','limpiar',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7533,'es','Pay','Pagar',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7534,'es','Payment','Pago',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7535,'es','TotalPaidExceedsGrandTotalForMultiPayment','El total pagado excede el monto total',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7536,'es','TotalPaying','Total a pagar',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7537,'es','ChangeReturn','Cambio a devolver',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7538,'es','AmountPaying','Monto a pagar',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7539,'es','Appearance_Settings','Configuración de Apariencia',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7540,'es','app_name','Nombre de la Aplicación',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7541,'es','page_title_suffix','Sufijo del título de la página',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7542,'es','ChangeFavicon','Cambiar Favicon',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7543,'es','Languages','Idiomas',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7544,'es','Translations','Traducciones',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7545,'es','Translations for','Traducciones para',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7546,'es','Back','Volver',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7547,'es','Save All Changes','Guardar todos los cambios',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7548,'es','Add New','Agregar nuevo',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7549,'es','Add New Translation','Agregar nueva traducción',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7550,'es','Save','Guardar',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7551,'es','Delete','Eliminar',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7552,'es','Showing','Mostrando',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7553,'es','Translation added','Traducción añadida',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7554,'es','Failed to add translation','Error al añadir la traducción',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7555,'es','Translation updated','Traducción actualizada',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7556,'es','Failed to update','Error al actualizar',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7557,'es','No changes to save','No hay cambios para guardar',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7558,'es','Notice','Aviso',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7559,'es','All changes saved successfully','Todos los cambios se han guardado correctamente',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7560,'es','Bulk save failed','Error al guardar en bloque',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7561,'es','Please reload the page after saving translations to apply the changes.','Por favor, recarga la página después de guardar las traducciones para aplicar los cambios.',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7562,'es','Action_Blocked','Acción bloqueada',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7563,'es','You_cannot_delete_the_default_language','No puedes eliminar el idioma predeterminado',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7564,'es','Flag','Bandera',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7565,'es','Locale','Localización',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7566,'es','Update Language','Actualizar idioma',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7567,'es','Add Language','Agregar idioma',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7568,'es','Send_Email','Enviar correo electrónico',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7569,'es','Send_SMS','Enviar SMS',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7570,'es','total_sales','Ventas totales',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7571,'es','Opening_Stock','Stock inicial',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7572,'es','Subscription_Product','Producto de suscripción',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7573,'es','Subscriptions','Suscripciones',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7574,'es','Billing_Cycle','Ciclo de facturación',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7575,'es','total_cycles','Ciclos totales',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7576,'es','remaining_cycles','Ciclos restantes',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7577,'es','next_billing_date','Próxima fecha de facturación',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7578,'es','Failed_to_update_subscription_status','Error al actualizar el estado de la suscripción',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7579,'es','Subscription_status_updated_successfully','Estado de suscripción actualizado con éxito',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7580,'es','Create_Susbscription','Crear suscripción',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7581,'es','Price_Per_Cycle','Precio por ciclo',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7582,'es','Price_Per_Unit','Precio por unidad',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7583,'es','Active','Activo',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7584,'es','Canceled','Cancelado',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7585,'es','Completed','Completado',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7586,'es','Subscription_details','Detalles de la suscripción',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7587,'es','Dynamic_Appearance','Apariencia dinámica',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7588,'es','Payment_Methods','Métodos de pago',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7589,'es','You_cant_edit_or_remove_default_payment_choices','No puedes editar o eliminar las opciones de pago predeterminadas',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7590,'es','Enter_Payment_Method','Ingresar método de pago',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7591,'es','Sales_by_Category','Ventas por categoría',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7592,'es','Sales_by_Brand','Ventas por marca',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7593,'es','Error_Logs','Registros de errores',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7594,'es','Occurred_At','Ocurrido en',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7595,'es','Context','Contexto',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7596,'es','Report_Transactions','Reportar transacciones',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7597,'es','Payment_Method','Método de pago',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7598,'es','Customer_Provider','Cliente/Proveedor',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7599,'es','Sale_Purchase_Ref','Ref. de venta/compra',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7600,'et','Draft_Created_successfully','ረቂቅ በተሳካ ሁኔታ ተፈጠረ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7601,'et','Draft_Sale_Deleted','የረቂቅ ሽያጭ ተሰረዘ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7602,'et','Inventory_Valuation_Based_on_Average_Cost','የቁጥጥር ግምገማ በአማካይ ዋጋ ላይ የተመሰረተ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7603,'et','Payroll','የደመወዝ ክፍያ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7604,'et','Transfers_Money','ገንዘብ ማስተላለፊያዎች',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7605,'et','Inventory_Valuation','የእቃ ግምገማ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7606,'et','Deposits_Report','የተቀማጭ ገንዘብ ሪፖርት',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7607,'et','Expense_Report','የወጪ ሪፖርት',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7608,'et','Deposit_Category','የተቀማጭ ምድብ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7609,'et','Total_Deposits','ጠቅላላ ተቀማጭ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7610,'et','Expense_Category','የወጪ ምድብ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7611,'et','Total_Expenses','ጠቅላላ ወጪ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7612,'et','ASSET_VALUE','የንብረት እሴት',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7613,'et','STOCK_ON_HAND','ቀሪ እቃ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7614,'et','Variant_NAME','የቅድመ አቀማመጥ ስም',0,'2025-06-18 01:50:33.000000','2025-06-18 01:50:33.000000'),(7615,'et','SKU','SKU',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7616,'et','ITEM_NAME','የእቃ ስም',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7617,'et','From_Account','ከመለያ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7618,'et','To_Account','ወደ መለያ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7619,'et','Accounts_cannot_be_the_same','መለያዎች ተመሳሳይ ሊሆኑ አይችሉም',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7620,'et','CountStock','እቃ መቆጣጠሪያ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7621,'et','Successfully_Generated_Count','በተሳካ ሁኔታ ተፈጥሯል',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7622,'et','Count','ብዛት',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7623,'et','file','ፋይል',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7624,'et','Accounting','የሒሳብ አስተዳደር',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7625,'et','deposit_delete','ተቀማጭ ሰርዝ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7626,'et','deposit_edit','ተቀማጭ አርትዕ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7627,'et','deposit_add','ተቀማጭ አክል',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7628,'et','deposit_view','ተቀማጭ አሳይ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7629,'et','expense_add','ወጪ አክል',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7630,'et','expense_edit','ወጪ አርትዕ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7631,'et','expense_delete','ወጪ ሰርዝ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7632,'et','List_Deposit','የተቀማጭ ዝርዝር',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7633,'et','Create_deposit','ተቀማጭ ፍጠር',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7634,'et','List_accounts','የመለያዎች ዝርዝር',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7635,'et','Account','መለያ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7636,'et','Choose_Account','መለያ ይምረጡ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7637,'et','Deposits','ተቀማጮች',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7638,'et','account_num','የመለያ ቁጥር',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7639,'et','Enter_account_num','የመለያ ቁጥር ያስገቡ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7640,'et','account_name','የመለያ ስም',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7641,'et','Enter_account_name','የመለያ ስም ያስገቡ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7642,'et','initial_balance','የመጀመሪያ ሚዛን',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7643,'et','Enter_initial_balance','የመጀመሪያ ሚዛን ያስገቡ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7644,'et','notes','ማስታወሻዎች',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7645,'et','balance','ሚዛን',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7646,'et','Receipt','ደረሰኝ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7647,'et','Pos_Settings','የPOS ቅንብር',0,'2025-06-18 01:50:33.000000','2025-06-18 01:50:33.000000'),(7648,'et','Note_to_customer','ለደንበኛ ማስታወሻ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7649,'et','Show_Note_to_customer','ማስታወሻውን ለደንበኛ አሳይ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7650,'et','Show_barcode','ባርኮድ አሳይ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7651,'et','Show_Tax_and_Discount','ታክስ፣ ቅናሽ እና መላኪያ አሳይ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7652,'et','Show_Customer','ደንበኛ አሳይ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7653,'et','Show_Email','ኢሜይል አሳይ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7654,'et','Show_Phone','ስልክ አሳይ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7655,'et','Show_Address','አድራሻ አሳይ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7656,'et','DefaultLanguage','ነባሪ ቋንቋ',0,'2025-06-18 01:50:27.000000','2025-06-18 01:50:27.000000'),(7657,'et','footer','ግርጌ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7658,'et','Received_Amount','የተቀበለው መጠን',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7659,'et','Paying_Amount','የሚከፈል መጠን',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7660,'et','Change','ቀሪ ትክክል',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7661,'et','Paying_amount_is_greater_than_Received_amount','የሚከፈለው ከተቀበለው ይበልጣል',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7662,'et','Paying_amount_is_greater_than_Grand_Total','የሚከፈለው ከአጠቃላይ ድምር ይበልጣል',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7663,'et','code_must_be_not_exist_already','ኮዱ ቀደም ሲል መኖሩ አይቻልም',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7664,'et','You_will_find_your_backup_on','ባከለ እቃዎን እዚህ ያግኙት',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7665,'et','and_save_it_to_your_pc','እና በኮምፒውተርዎ ላይ ያስቀምጡት',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7666,'et','Scan_your_barcode_and_select_the_correct_symbology_below','ባርኮዱን ይስካን አድርጉ እና ትክክለኛውን ምልክት ይምረጡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7667,'et','Scan_Search_Product_by_Code_Name','በኮድ ወይም በስም የምርት ፍለጋ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7668,'et','Paper_size','የወረቀት መጠን',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7669,'et','Clear_Cache','ካሽን አጥፋ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7670,'et','Cache_cleared_successfully','ካሽ በተሳካ ሁኔታ ተጠፋ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7671,'et','Failed_to_clear_cache','ካሽ መናፈስ አልተሳካም',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7672,'et','Scan_Barcode','ባርኮድ ስካነር',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7673,'et','Please_use_short_name_of_unit','እባኮትን የአካል አቃላዊ ስም ይጠቀሙ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7674,'et','DefaultCustomer','ነባሪ ደንበኛ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7675,'et','DefaultWarehouse','ነባሪ ማከማቻ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7676,'et','Payment_Gateway','የክፍያ መንገድ',0,'2025-06-18 01:50:33.000000','2025-06-18 01:50:33.000000'),(7677,'et','SMS_Configuration','የSMS ማስተካከያ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7678,'et','Gateway','SMS በረከት',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7679,'et','Choose_Gateway','SMS በረከት ይምረጡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7680,'et','sms_send_successfully','መልዕክት ተልኳል',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7681,'et','sms_config_invalid','የSMS ቅንብር ልክ አይደለም',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7682,'et','Remove_Stripe_Key_Secret','Stripe API ቁልፎችን ሰርዝ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7683,'et','credit_card_account_not_available','የክሬዲት ካርድ መለያ አልተገኘም',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7684,'et','Credit_Card_Info','የክሬዲት ካርድ መረጃ',0,'2025-06-18 01:50:33.000000','2025-06-18 01:50:33.000000'),(7685,'et','developed_by','በተንዳኝ የተገነባ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7686,'et','Unit_already_linked_with_sub_unit','አካል ከንዑስ አካል ጋር ተገናኝቷል',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7687,'et','Total_Items_Quantity','አጠቃላይ እቃዎችና ብዛት',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7688,'et','Value_by_Cost_and_Price','በወጪና ዋጋ የተመደበ እሴት',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7689,'et','Search_this_table','በዚህ ታች ፍለጋ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7690,'et','import_products','ምርቶችን አስመጣ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7691,'et','Field_optional','ሜዳ (አማራጭ)',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7692,'et','Download_exemple','ናሙና አውርድ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7693,'et','field_must_be_in_csv_format','ሜዳው በCSV ቅርጸት መሆን አለበት',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7694,'et','Successfully_Imported','በተሳካ ሁኔታ ተመጣ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7695,'et','file_size_must_be_less_than_1_mega','የፋይሉ መጠን ከ1 ሜጋ በታች መሆን አለበት',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7696,'et','Please_follow_the_import_instructions','እባኮትን የአስመጣ መመሪያዎችን ይከተሉ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7697,'et','must_be_exist','አካሉ ቀደም ሲል መፍጠር አለበት',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7698,'et','Import_Customers','ደንበኞችን አስመጣ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7699,'et','Import_Suppliers','አቅራቢዎችን አስመጣ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7700,'et','Recent_Sales','የቅርብ ጊዜ ሽያጮች',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7701,'et','Create_Transfer','ዝውውር ፍጠር',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7702,'et','order_products','የትእዛዝ እቃዎች',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7703,'et','Search_Product_by_Code_Name','በኮድ ወይም በስም ምርት ፍለጋ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7704,'et','Reports_payments_Purchase_Return','የግዢ መመለስ ክፍያዎች ሪፖርት',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7705,'et','Reports_payments_Sale_Return','የሽያጭ መመለስ ክፍያዎች ሪፖርት',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7706,'et','payments_Sales_Return','የሽያጭ መመለስ ክፍያዎች',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7707,'et','payments_Purchases_Return','የግዢ መመለስ ክፍያዎች',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7708,'et','CreateSaleReturn','የሽያጭ መመለስ ፍጠር',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7709,'et','EditSaleReturn','የሽያጭ መመለስ አርትዕ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7710,'et','SalesReturn','የሽያጭ መመለስ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7711,'et','CreatePurchaseReturn','የግዢ መመለስ ፍጠር',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7712,'et','EditPurchaseReturn','የግዢ መመለስ አርትዕ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7713,'et','PurchasesReturn','የግዢ መመለስ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7714,'et','Due','ክፍያ የሚኖረው',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7715,'et','Profit','ትርፍ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7716,'et','Revenue','ገቢ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7717,'et','Sales_today','ዛሬ የተሽየጠ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7718,'et','People','ሰዎች',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7719,'et','Successfully_Created','በተሳካ ሁኔታ ተፈጠረ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7720,'et','Successfully_Updated','በተሳካ ሁኔታ ተዘምኗል',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7721,'et','Success','ስኬት',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7722,'et','Failed','አልተሳካም',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7723,'et','Warning','ማስጠንቀቂያ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7724,'et','Please_fill_the_form_correctly','እባክዎን ቅፅውን ትክክለኛ ይሙሉ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7725,'et','Field_is_required','ይህ መስክ አስፈላጊ ነው',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7726,'et','Error','ስህተት!',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7727,'et','you_are_not_authorized','ይቅርታ! ፈቃድ የለዎትም።',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7728,'et','Go_back_to_home','ወደ መነሻ ገፅ ተመለሱ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7729,'et','page_not_exist','ይቅርታ! የተፈለገው ገፅ አልተገኘም።',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7730,'et','Choose_Status','ሁኔታ ይምረጡ',0,'2025-06-18 01:50:32.000000','2025-06-18 01:50:32.000000'),(7731,'et','Choose_Method','ዘዴ ይምረጡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7732,'et','Choose_Symbology','ምልክት ይምረጡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7733,'et','Choose_Category','ምድብ ይምረጡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7734,'et','Choose_Customer','ደንበኛ ይምረጡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7735,'et','Choose_Supplier','አቅራቢ ይምረጡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7736,'et','Choose_Unit_Purchase','የግዢ መለኪያ ይምረጡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7737,'et','Choose_Sub_Category','ንዑስ ምድብ ይምረጡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7738,'et','Choose_Brand','አምራች ይምረጡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7739,'et','Choose_Warehouse','መጋዘን ይምረጡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7740,'et','Choose_Unit_Sale','የሽያጭ መለኪያ ይምረጡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7741,'et','Enter_Product_Cost','የእቃ ዋጋ ያስገቡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7742,'et','Enter_Stock_alert','የአክሲዮን ማንቂያ ያስገቡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7743,'et','Choose_Unit_Product','የእቃ መለኪያ ይምረጡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7744,'et','Enter_Product_Price','የእቃ ዋጋ ያስገቡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7745,'et','Enter_Name_Product','የእቃ ስም ያስገቡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7746,'et','Enter_Role_Name','የሚኖሩ ስም ያስገቡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7747,'et','Enter_Role_Description','የሚኖሩ መግለጫ ያስገቡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7748,'et','Enter_name_category','የምድብ ስም ያስገቡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7749,'et','Enter_Code_category','የምድብ ኮድ ያስገቡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7750,'et','Enter_Name_Brand','የአምራች ስም ያስገቡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7751,'et','Enter_Description_Brand','የአምራች መግለጫ ያስገቡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7752,'et','Enter_Code_Currency','የቀንድ ኮድ ያስገቡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7753,'et','Enter_name_Currency','የቀንድ ስም ያስገቡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7754,'et','Enter_Symbol_Currency','የቀንድ ምልክት ያስገቡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7755,'et','Enter_Name_Unit','የመለኪያ ስም ያስገቡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7756,'et','Enter_ShortName_Unit','የመለኪያ አነስተኛ ስም ያስገቡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7757,'et','Choose_Base_Unit','መሠረታዊ መለኪያ ይምረጡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7758,'et','Choose_Operator','ኦፕሬተር ይምረጡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7759,'et','Enter_Operation_Value','የስራ ዋጋ ያስገቡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7760,'et','Enter_Name_Warehouse','የመጋዘን ስም ያስገቡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7761,'et','Enter_Phone_Warehouse','የመጋዘን ስልክ ያስገቡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7762,'et','Enter_Country_Warehouse','የመጋዘን አገር ያስገቡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7763,'et','Enter_City_Warehouse','የመጋዘን ከተማ ያስገቡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7764,'et','Enter_Email_Warehouse','የመጋዘን ኢሜል ያስገቡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7765,'et','Enter_ZipCode_Warehouse','የመጋዘን ዚፕ ኮድ ያስገቡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7766,'et','Choose_Currency','ቀንድ ይምረጡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7767,'et','Thank_you_for_your_business','ከእኛ ጋር የገበያ ግንኙነት ስለነበረ እናመሰግናለን። እባክዎ እንደገና ይመለሱ።',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7768,'et','Cancel','ይቅር',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7769,'et','New_Customer','አዲስ ደንበኛ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7770,'et','Incorrect_Login','የተሳሳተ መግቢያ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7771,'et','Successfully_Logged_In','በተሳካ ሁኔታ ገብተዋል',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7772,'et','This_user_not_active','ይህ ተጠቃሚ አንቀሳቃሽ አይደለም',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7773,'et','SignIn','ግባ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7774,'et','Create_an_account','መለያ ፍጠር',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7775,'et','Forgot_Password','የይለፍ ቃል ረስተዋል?',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7776,'et','Email_Address','ኢሜይል አድራሻ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7777,'et','SignUp','መዝግብ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7778,'et','Already_have_an_account','መለያ አለዎት?',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7779,'et','Reset_Password','የይለፍ ቃል ዳግም አዘጋጅ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7780,'et','Failed_to_authenticate_on_SMTP_server','በSMTP አገልጋይ ላይ ማረጋገጥ አልተሳካም',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7781,'et','We_cant_find_a_user_with_that_email_addres','በዚህ ኢሜይል የተመዘገበ ተጠቃሚ አልተገኘም',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7782,'et','We_have_emailed_your_password_reset_link','የይለፍ ቃል ማደስ አገናኝን በኢሜይል ልከናል',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7783,'et','Please_fill_the_Email_Adress','እባኮትን የኢሜይል አድራሻ ያስገቡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7784,'et','Confirm_password','የይለፍ ቃል ያረጋግጡ',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7785,'et','Your_Password_has_been_changed','የይለፍ ቃልዎ ተቀይሯል',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7786,'et','The_password_confirmation_does_not_match','የይለፍ ቃል ማረጋገጫው አይመሳሰልም',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7787,'et','This_password_reset_token_is_invalid','ይህ የይለፍ ቃል ዳግም አዘጋጅ ምልክት ልክ አይደለም',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7788,'et','Warehouse_report','የመጋዘን ሪፖርት',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7789,'et','All_Warehouses','ሁሉም መጋዘኖች',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7790,'et','Expense_List','የወጪ ዝርዝር',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7791,'et','Expenses','ወጪዎች',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7792,'et','This_Week_Sales_Purchases','የዚህ ሳምንት ሽያጭና ግዢዎች',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7793,'et','Top_Selling_Products','በጣም የሚሽጡ እቃዎች',0,'2025-06-18 01:50:28.000000','2025-06-18 01:50:28.000000'),(7794,'et','View_all','ሁሉንም ይመልከቱ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7795,'et','Payment_Sent_Received','ክፍያ ተልኳ እና ተቀብሏል',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7796,'et','Filter','ማጣሪያ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7797,'et','Invoice_POS','የተመደበ ደረሰኝ (POS)',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7798,'et','Invoice','ደረሰኝ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7799,'et','Customer_Info','የደንበኛ መረጃ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7800,'et','Company_Info','የኩባንያ መረጃ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7801,'et','Invoice_Info','የደረሰኝ መረጃ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7802,'et','Order_Summary','የትእዛዝ ማጠቃለያ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7803,'et','Quote_Info','የጥያቄ መረጃ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7804,'et','Del','ሰርዝ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7805,'et','SuppliersPaiementsReport','የአቅራቢዎች ክፍያ ሪፖርት',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7806,'et','Purchase_Info','የግዢ መረጃ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7807,'et','Supplier_Info','የአቅራቢ መረጃ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7808,'et','Return_Info','የመመለሻ መረጃ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7809,'et','Create_Expense','ወጪ ፍጠር',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7810,'et','Details','ዝርዝሮች',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7811,'et','Discount_Method','የቅናሽ ዘዴ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7812,'et','Net_Unit_Cost','የነት ዩኒት ወጪ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7813,'et','Net_Unit_Price','የነት የእቃ ዋጋ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7814,'et','Edit_Expense','ወጪን አርትዕ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7815,'et','All_Brand','ሁሉም አምራቾች',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7816,'et','All_Category','ሁሉም ምድቦች',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7817,'et','ListExpenses','የወጪ ዝርዝር',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7818,'et','Create_Permission','ፍቃድ ፍጠር',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7819,'et','Edit_Permission','ፍቃድ አርትዕ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7820,'et','Reports_payments_Sales','የክፍያ እና ሽያጭ ሪፖርቶች',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7821,'et','Reports_payments_Purchases','የክፍያ እና ግዢ ሪፖርቶች',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7822,'et','Reports_payments_Return_Customers','የመመለሻ ደንበኞች ክፍያዎች',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7823,'et','Reports_payments_Return_Suppliers','የመመለሻ አቅራቢዎች ክፍያዎች',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7824,'et','Expense_Deleted','ይህ ወጪ ተሰርዟል',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7825,'et','Expense_Updated','ይህ ወጪ ተዘምኗል',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7826,'et','Expense_Created','ይህ ወጪ ተፈጥሯል',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7827,'et','DemoVersion','በዚህ የማሳያ ስሪት ላይ ማድረግ አትችሉም',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7828,'et','OrderStatistics','የሽያጭ ስታቲስቲክስ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7829,'et','AlreadyAdd','ይህ እቃ አስቀድመው ታክሏል!',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7830,'et','AddProductToList','እባኮትን እቃውን ዝርዝር ውስጥ ያክሉ!',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7831,'et','AddQuantity','እባኮትን ብዛቱን ያክሉ!',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7832,'et','InvalidData','ስህተት ተፈጥሯል',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7833,'et','LowStock','የተያዙ እቃዎች ብዛት ከመደበኛው በላይ ነው',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7834,'et','WarehouseIdentical','ሁለቱ መጋዘኖች አንደኛ ሊሆኑ አይችሉም!',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7835,'et','VariantDuplicate','ይህ ቅድመ አቀማመጥ ተደጋጋሚ ነው!',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7836,'et','Filesize','የፋይል መጠን',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7837,'et','GenerateBackup','መተከል ማስጀመር',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7838,'et','BackupDatabase','መረጃ ቋት መተከል',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7839,'et','Backup','መተከል',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7840,'et','Paid','ተከፍሏል',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7841,'et','Unpaid','አልተከፈለም',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7842,'et','Today','ዛሬ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7843,'et','Income','ገቢ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7844,'et','Sale','ሽያጭ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7845,'et','Actif','ንቁ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7846,'et','Inactif','ዝም ብሎ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7847,'et','Customers','ደንበኞች',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7848,'et','Phone','ስልክ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7849,'et','SearchByPhone','በስልክ ፈልግ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7850,'et','Suppliers','አቅራቢዎች',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7851,'et','Quotations','ጥያቄዎች',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7852,'et','Sales','ሽያጮች',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7853,'et','Purchases','ግዢዎች',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7854,'et','Returns','መመለሻዎች',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7855,'et','Settings','ቅንብሮች',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7856,'et','SystemSettings','የሲስተም ቅንብሮች',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7857,'et','Users','ተጠቃሚዎች',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7858,'et','GroupPermissions','የቡድን ፍቃዶች',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7859,'et','Currencies','ቀንዶች',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7860,'et','Warehouses','መጋዘኖች',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7861,'et','Units','መለኪያዎች',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7862,'et','UnitsPrchases','የግዢ መለኪያዎች',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7863,'et','UnitsSales','የሽያጭ መለኪያዎች',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7864,'et','Reports','ሪፖርቶች',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7865,'et','PaymentsReport','የክፍያ ሪፖርት',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7866,'et','PaymentsPurchases','የክፍያ ግዢዎች',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7867,'et','PaymentsSales','የክፍያ ሽያጮች',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7868,'et','ProfitandLoss','ትርፍ እና ኪያ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7869,'et','WarehouseStockChart','የመጋዘን እቃ ግምገማ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7870,'et','SalesReport','የሽያጭ ሪፖርት',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7871,'et','PurchasesReport','የግዢ ሪፖርት',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7872,'et','CustomersReport','የደንበኞች ሪፖርት',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7873,'et','SuppliersReport','የአቅራቢዎች ሪፖርት',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7874,'et','SupplierReport','የአቅራቢ ሪፖርት',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7875,'et','DailySalesData','ዕለታዊ የሽያጭ መረጃ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7876,'et','DailyPurchasesData','ዕለታዊ የግዢ መረጃ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7877,'et','Dernièrescinqrecords','አምስት መጨረሻ መዝገቦች',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7878,'et','Filters','ማጣሪያዎች',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7879,'et','date','ቀን',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7880,'et','Reference','ማጣቀሻ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7881,'et','Supplier','አቅራቢ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7882,'et','PaymentStatus','የክፍያ ሁኔታ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7883,'et','Customer','ደንበኛ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7884,'et','CustomerCode','የደንበኛ ኮድ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7885,'et','Status','ሁኔታ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7886,'et','SupplierCode','የአቅራቢ ኮድ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7887,'et','Categorie','ምድብ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7888,'et','Categories','ምድቦች',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7889,'et','StockTransfers','ዕቃ ማስተላለፊያ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7890,'et','StockManagement','የእቃ አስተዳደር',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7891,'et','dashboard','ዳሽቦርድ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7892,'et','Products','እቃዎች',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7893,'et','productsList','ሁሉም እቃዎች',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7894,'et','ProductManagement','የእቃ አስተዳደር',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7895,'et','ProductQuantityAlerts','የእቃ ብዛት ማንቂያ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7896,'et','CodeProduct','የእቃ ኮድ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7897,'et','ProductTax','የእቃ ታክስ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7898,'et','SubCategorie','ንዑስ ምድብ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7899,'et','Name_product','ስም',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7900,'et','StockAlert','የእቃ ማንቂያ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7901,'et','warehouse','መጋዘን',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7902,'et','Tax','ታክስ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7903,'et','BuyingPrice','የግዢ ዋጋ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7904,'et','SellPrice','የሽያጭ ዋጋ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7905,'et','Quantity','ብዛት',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7906,'et','UnitSale','የሽያጭ መለኪያ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7907,'et','UnitPurchase','የግዢ መለኪያ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7908,'et','ManagementCurrencies','የቀንድ አስተዳደር',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7909,'et','CurrencyCode','የቀንድ ኮድ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7910,'et','CurrencyName','የቀንድ ስም',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7911,'et','Symbol','ምልክት',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7912,'et','All','ሁሉም',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7913,'et','EditProduct','እቃን አርትዕ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7914,'et','SearchByCode','በኮድ ፈልግ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7915,'et','SearchByName','በስም ፈልግ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7916,'et','ProductDetails','ዝርዝር መረጃ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7917,'et','CustomerName','የደንበኛ ስም',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7918,'et','CustomerManagement','የደንበኞች አስተዳደር',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7919,'et','Add','ፍጠር',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7920,'et','Edit','አርትዕ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7921,'et','Close','ዝጋ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7922,'et','PleaseSelect','እባክዎን ይምረጡ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7923,'et','Action','ተግባር',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7924,'et','Email','ኢሜይል',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7925,'et','EditCustomer','ደንበኛን አርትዕ',0,'2025-06-18 01:50:29.000000','2025-06-18 01:50:29.000000'),(7926,'et','AddCustomer','ደንበኛ ፍጠር',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7927,'et','Country','አገር',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7928,'et','City','ከተማ',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7929,'et','Adress','አድራሻ',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7930,'et','CustomerDetails','የደንበኛ መረጃ',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7931,'et','CustomersList','ደንበኞች',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7932,'et','SupplierName','የአቅራቢ ስም',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7933,'et','SuppliersManagement','የአቅራቢዎች አስተዳደር',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7934,'et','SupplierDetails','የአቅራቢ መረጃ',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7935,'et','QuotationsManagement','የጥያቄዎች አስተዳደር',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7936,'et','SubTotal','አጠቃላይ ድምር',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7937,'et','MontantReste','የቀረ መጠን',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7938,'et','complete','ተጠናቋል',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7939,'et','EnAttendant','በመጠባበቅ ላይ',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7940,'et','Recu','ተቀብሏል',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7941,'et','partial','ከፊል',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7942,'et','Retournee','ተመልሷል',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7943,'et','DetailQuote','ዝርዝር ጥያቄ',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7944,'et','EditQuote','ጥያቄን አርትዕ',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7945,'et','CreateSale','ሽያጭ ፍጠር',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7946,'et','DownloadPdf','PDF አውርድ',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7947,'et','QuoteEmail','ጥያቄን በኢሜይል ላክ',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7948,'et','DeleteQuote','ጥያቄን ሰርዝ',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7949,'et','AddQuote','ጥያቄ ፍጠር',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7950,'et','SelectProduct','እቃ ይምረጡ',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7951,'et','ProductCodeName','እቃ (ኮድ - ስም)',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7952,'et','Price','ዋጋ',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7953,'et','CurrentStock','ያለው አክሲዮን',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7954,'et','Total','ጠቅላላ ድምር',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7955,'et','Num','ቁጥር',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7956,'et','Unitcost','የአንድ ነጥብ ዋጋ',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7957,'et','to','ለ',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7958,'et','Subject','ርዕስ',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7959,'et','Message','መልእክት',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7960,'et','EmailCustomer','ኢሜይል ደንበኛ',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7961,'et','Sent','ተልኳል',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7962,'et','Quote','ጥያቄ',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7963,'et','Hello','ሰላም',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7964,'et','AttachmentQuote','እባክዎ ጥያቄዎን ከተያዘ ፋይል ጋር ያገኙ',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7965,'et','AddProducts','እቃዎችን ወደ ዝርዝር ያክሉ',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7966,'et','SelectWarehouse','መጋዘን ይምረጡ',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7967,'et','SelectCustomer','ደንበኛ ይምረጡ',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7968,'et','SalesManagement','የሽያጭ አስተዳደር',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7969,'et','QtyBack','የተመለሰ ብዛት',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7970,'et','TotalReturn','ጠቅላላ መመለሻ',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7971,'et','Amount','መጠን',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7972,'et','SaleDetail','ዝርዝር ሽያጭ',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7973,'et','EditSale','ሽያጭን አርትዕ',0,'2025-06-18 01:50:30.000000','2025-06-18 01:50:30.000000'),(7